// 与业主关系
export const RELATION_SHIP = [
  {label: '本人', value: 'self'},
  {label: '租户', value: 'tenant'},
  {label: '亲人', value: 'relative'},
  {label: '朋友', value: 'friend'},
  {label: '其他', value: 'other'}
]

// 紧急程度
export const URGENT_DEGREE = [
  {label: '一般', value: 'usual'},
  {label: '紧急', value: 'urgent'}
]

// 是否定时发布
export const SCHEDULED_RELEASE = [
  {label: '是', value: 1},
  {label: '否', value: 0}
]

// 公告状态
export const NOTICE_STATUS = [
  {label: '已发布', value: 'published'},
  {label: '待发布', value: 'waitPublish'}
]

// 报修工单状态
export const REPAIR_STATUS = [
  {label: '报单待审核', value: 'initiateWaitAudit'},
  {label: '报单审核驳回', value: 'initiateRefuse'},
  {label: '待派单', value: 'waitDispatch'},
  {label: '待接收', value: 'waitReceive'},
  {label: '维修中', value: 'inRepair'},
  {label: '回单待审核', value: 'finishWaitAudit'},
  {label: '回单审核驳回', value: 'finishRefuse'},
  {label: '已完成', value: 'finishAuditPass'}
]

// 费用计算公式
export const DESIGN_FORMULAS = [
  {label: '固定金额', value: 1},
  {label: '建筑面积 × 单价', value: 2},
  {label: '（本期度数 - 上期度数） × 单价', value: 3}
]

// 缴费状态
export const PAYMENT_STATUS = [
  {label: '待缴费', value: 'unPaid'},
  {label: '已缴费', value: 'paid'}
]

// 投诉状态
export const COMPLAINT_STATUS = [
  {label: '待处理', value: 'waitPending'},
  {label: '处理中', value: 'pending'},
  {label: '处理完成', value: 'finish'}
]

/**
 * 翻译字段值对应的文本
 * @param children
 * @returns string
 */
export function filterDictTextByStatic(dictList, value) {
  if(!dictList || dictList.length === 0){
    return;
  }
  let row = dictList.find(item=>item.value === value)
  return row ? row.label : ''
}