import {loginUrlCheck} from '@/api/api'
import { getFileAccessHttpUrl } from '@/api/manage'
const enhance = {
  state: {
    isPageUrlTrue: true,
    pageTitle: '湖北汉江之星科技有限公司',
    pageImage: ''
  },
  mutations: {
    SET_PAGE_URL_FLAG: (state, flag) => {
      state.isPageUrlTrue = flag
    },
    SET_PAGE_TITLE: (state, name) => {
      state.pageTitle = name
    },
    SET_PAGE_IMAGE: (state, image) => {
      state.pageImage = image
    }
  },
  actions: {
    onLoginUrlCheck({ commit }, record) {
      loginUrlCheck({platformType: 'councils'}).then(res=> {
        if(res.result && res.result.logoUrl) {
          commit('SET_PAGE_TITLE', res.result.name)
          commit('SET_PAGE_IMAGE', getFileAccessHttpUrl(res.result.logoUrl))
        } else {
          commit('SET_PAGE_URL_FLAG', false)
        }
      })
    }
  }
}
export default enhance