import Vue from 'vue'
import Vuex from 'vuex'
Vue.use(Vuex)
import {
	customerWxToken,
	getUserInfo
} from "@/config/api.js"
const store = new Vuex.Store({
    state: {
        hasLogin: false,
		userName: '',            //用户名称
        userBtnPerms: []        // 用户按钮权限
	},
	 //mutations定义同步操作的方法
    mutations: {
		// 登录
		setTokenInfo(state, message){
		//登录状态为已登录
			state.hasLogin = true
			state.userName = message.userName
            state.userBtnPerms = message.userBtnPerms
			//储存用户数据到本地
			uni.setStorageSync('token', message.token);
			uni.setStorageSync('userName', message.userName);
			uni.setStorageSync('userBtnPerms', JSON.stringify(message.userBtnPerms));
		}
	},
    actions: {
        async getToken({ commit }, userInfo) {
            const {content} = await customerWxToken(userInfo)
            const res = JSON.parse(content.token)
            const user = await getUserInfo({
                params: {
                    token: res.token
                }
            })
            const message = {"token": content.token, "userName": user.content.userInfo.customerName, "userBtnPerms": user.content.userBtnPerms}
            commit('setTokenInfo', message)
        }
	},
    getters:{
        // hasLogin: () => { //用户是否登录
        //     let token = uni.getStorageSync('token')
        //     return !!token
        // }
    }
})
export default store
