/* 节流函数封装 */
export const throttle = (fn, gapTime)=> {
    if (gapTime == null || gapTime == undefined) {
        gapTime = 1500
    }
    let _lastTime = null
    // 返回新的函数
    return function () {
        let _nowTime = +new Date()
        if (_nowTime - _lastTime > gapTime || !_lastTime) {
            fn.apply(this, arguments) //将this和参数传给原函数
            _lastTime = _nowTime
        }
    }
}

/* 防抖函数封装 */
export const debounce = function(fn, interval) {
    let timer;
    let delay = interval || 1000; // 间隔的时间，如果interval不传，则默认1秒
    return function() {
        let args = arguments; // 保存此处的arguments，因为setTimeout是全局的，arguments不是防抖函数需要的。
        if (timer) {
            clearTimeout(timer);
        }
        timer = setTimeout(()=> {
            fn.apply(this, args); // 用apply指向调用debounce的对象，相当于this.fn(args);
        }, delay);
    };
}

/* 用于处理按钮权限 */
export const hasPerm = perm=> {
    const btnPermList = JSON.parse(uni.getStorageSync('userBtnPerms')) || [];
    const hasExsit = perm ? btnPermList.includes(perm) : true;
    return hasExsit
}

/* 是否电话号码 */
export const isMoble = phone=> {
    const reg = /^1(3|4|5|6|7|8|9)\d{9}$/
    return reg.test(phone)
}

/* 是否身份证号 */
export const isValidIDCard = idCard=> {
    const reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
    return reg.test(idCard)
}

/* 是否护照 */
export const isValidPassport = passport=> {
    const reg= /(^[EeKkGgDdSsPpHh]\d{8}$)|(^(([Ee][a-fA-F])|([DdSsPp][Ee])|([Kk][Jj])|([Mm][Aa])|(1[45]))\d{7}$)/;  //护照（包括香港和澳门）
    return reg.test(passport)
}

/* 是否港澳通行证 */
export const isValidPermit = permit=> {
    const reg = /^[HMhm]{1}([0-9]{10}|[0-9]{8})$/;   //港澳通行证
    return reg.test(permit)
}