
module.exports = {
    methods: {
        mixinCheckLogin() {
            return new Promise((resolve, reject)=> {
                try {
                    const value = uni.getStorageSync('token');
                    if (value) {
                        resolve()
                    } else {
                        reject()
                    }
                } catch (e) {
                    reject(e)
                }
            })
        }
    },
	onShareAppMessage(res) {
        return {
            title: this.share?.title || '首页',
            path: this.share?.path || '/pages/home/index',
            imageUrl: this.share?.imageUrl || '',
            desc: this.share?.desc || '',
            content: this.share?.content || '',
            success(res){
                uni.showToast({
                    title:'分享成功'
                })
            },
            fail(res){
                uni.showToast({
                    title:'分享失败',
                    icon:'none'
                })
            }
        }
    }
}
