import { http } from '@/config/index.js'
/*
* params 参数 <object>
*config 配置项 <object> 可传 {header: {}, custom: {load: false}}
*/

// 获取首页轮播图 
export const getPropertyAdvApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-central/wechat/propertyAdv/list',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 登录前获取key
export const getPropertyLoginApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/wxUser/login',
        {
            data: {
                ...params,
                type: 'owner'
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取手机号
export const analysisMobileApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/wxUser/phone',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 绑定用户
export const bindingUserInfoApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/wxUser/bindingUserInfo',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查物业
export const getSettledListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-central/wechat/propertySettled/settledList',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查小区
export const getCompanyListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-company/wechat/companyCommunity/companyList',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查楼栋
export const getBuildingListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityBuilding/buildingList',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查单元
export const getCommunityUnitListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityBuilding/queryCommunityUnitListByMainId',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查房号
export const getCommunityRoomListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityBuilding/queryCommunityRoomByUnitId',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查数据字典
export const getDictItemsApi = (dictCode, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityUser/getDictItems',
        {
            data: { dictCode },
            ...config,
            custom: {load: false}
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 新增房屋认证
export const postcommunityOwnerAddApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityOwner/add',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 编辑房屋认证
export const postcommunityOwnerEditApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityOwner/edit',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 编辑房屋认证
export const editIsAuditApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityOwner/editIsAudit',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取用户信息
export const queryCommunityRoomByUnitIdApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityUser/queryByOpenId',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取小区详情
export const queryByOpenIddApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityOwner/queryById',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 编辑小区详情
export const editByOpenIdApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityOwner/edit',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 删除小区详情
export const deleteByOpenIdApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityOwner/delete',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 登录后获取首页详情
export const getCommunityInfoApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityUser/getCommunityInfo',
        {
            data: {
                ...params,
                residentPhone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code'),
                openId: uni.getStorageSync('openid')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 登录后获取首页详情
export const getAdvertisementApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-company/wechat/companyCommunity/queryList',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 消息通知列表
export const getUserNoticeListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/userNotice/list',
        {
            data: {
                ...params,
                noticeUserId: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 更新消息已读状态
export const updateStatusApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/userNotice/edit',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 维修上报列表
export const getCommunityRepairListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityRepair/list',
        {
            data: {
                ...params,
                ownerId: uni.getStorageSync('openid'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 维修上报详情
export const getCommunityRepairDetailApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityRepair/queryById',
        {
            data: {
                ...params,
                ownerId: uni.getStorageSync('openid'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 新增维修上报
export const addCommunityRepairApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityRepair/add',
            { 
                ...params,
                ownerId: uni.getStorageSync('openid'),
                platformCode: uni.getStorageSync('platform_code')
            },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 修改维修上报
export const editCommunityRepairApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityRepair/edit',
            { 
                ...params,
                ownerId: uni.getStorageSync('openid'),
                platformCode: uni.getStorageSync('platform_code')
            },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 删除维修上报
export const deleteCommunityRepairApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityRepair/delete',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 投诉列表
export const getCommunityComplaintListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityComplaint/list',
        {
            data: {
                ...params,
                userId: uni.getStorageSync('openid'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 投诉详情
export const getCommunityComplaintDetailApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityComplaint/queryById',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 新增投诉
export const addCommunityComplaintApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityComplaint/add',
            {
                ...params,
                userId: uni.getStorageSync('openid'),
                platformCode: uni.getStorageSync('platform_code')
            },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 维修员的维修列表列表
export const getommunityRepairApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityRepair/list',
        {
            data: {
                ...params,
                maintenancePhone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 维修转单
export const getEmployeeListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-company/wechat/companyEmployee/employeeList',
        {
            data: {
                ...params,
                communityCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 维修转单
export const editCommunityComplaintApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityRepair/edit',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取个人信息
export const getUserInfoApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityUser/queryById',
        {
            data: {
                ...params,
                openId: uni.getStorageSync('openid'),
                phone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 修改个人信息
export const editOwnerApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityUser/editOwner',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取我的房屋列表
export const getHouseListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityOwner/list',
        {
            data: {
                ...params,
                openId: uni.getStorageSync('openid'),
                residentPhone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取房屋详情
export const getHouseDetailApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityOwner/queryById',
        {
            data: { ...params},
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取维修员房屋列表
export const getCompanyEmployeeApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/companyEmployee/queryEmployeeVo',
        {
            data: {
                ...params,
                employeePhone: uni.getStorageSync('user_phone')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取新闻详情
export const getNoticeDetailApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-company/wechat/companyCommunity/queryNoticeById',
        {
            data: {
                ...params,
                openId: uni.getStorageSync('openid')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取公告公示列表
export const queryNoticePageApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-company/wechat/companyCommunity/queryNoticePage',
        {
            data: {
                ...params,
                pageSize: 10,
                communityCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取种类列表
export const queryChargeApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityPayment/queryCharge',
        {
            data: {
                ...params,
                residentPhone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取缴费列表
export const communityPaymentApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityPayment/list',
        {
            data: {
                ...params,
                residentPhone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取缴费详情
export const communityPaymentDetailApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-community/wechat/communityPayment/queryById',
        {
            data: {
                ...params
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 上传
export const uploadFile = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.upload('/wechat/common/upload',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 支付
export const payOrderApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityPayment/payOrder',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查询业主可用积分
export const queryIntegralByOwnerIdApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-central/wechat/integral/queryIntegralByPhone',
        {
            data: {
                ...params,
                phone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 支付物业费
export const payPropertyFeeApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/property-community/wechat/communityPayment/payPropertyFee',
            { 
                ...params,
                platformCode: uni.getStorageSync('platform_code')
            },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查询业主积分列表
export const getOwnerIntegralApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-central/wechat/integral/getOwnerIntegral',
        {
            data: {
                ...params,
                phone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查询业主积分近30天明细
export const ownerIntegralListApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-central/wechat/integral/ownerIntegralList',
        {
            data: {
                ...params,
                pageSize: 10,
                phone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 查询业主全部积分明细
export const ownerIntegralRecordsApi = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/property-central/wechat/integral/ownerIntegralRecords',
        {
            data: {
                ...params,
                pageSize: 10,
                phone: uni.getStorageSync('user_phone'),
                platformCode: uni.getStorageSync('platform_code')
            },
            ...config
        })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}