import { http } from '@/config/index.js'
/*
* params 参数 <object>
*config 配置项 <object> 可传 {header: {}, custom: {load: false}}
*/

// 登录、获取token
export const customerWxToken = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/jwt/customerWxToken',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 登录、获取token
export const customerToken = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/jwt/customerToken',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 刷新token
export const refreshToken = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/jwt/refreshCustomerWxToken',
            { ...params},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取user信息
export const getUserInfo = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/jwt/user',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取企业信息
export const getOneself = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/api/customer/customer/getOneself',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 首页获取数据
export const getHomeData = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/portal/pass/home/homeData',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取自营商城数据
export const getPageData = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/portal/pass/platformProduct/self/pageData',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 加入购物车
export const addCartPost = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/cart/addCart',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 购物车删除
export const deleteCartGet = (id, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/order/cart/deleteCartById/${id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取购物车
export const getCartList = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/api/order/cart/getCartList',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取选中的购物车数据
export const findByIds = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/cart/findByIds',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取新闻详情
export const getNewsDetail = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post(`/api/portal/pass/news/detail/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取自营商城筛选条件
export const getScreenList = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/portal/pass/platformProduct/self/searchCriteria',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 下单时获取isCreditFacilities
export const getIsCreditUser = (params = {}, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/customer/customerCreditFacilities/isCreditUser',
            {...params},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 下单时获取订单详情
export const getSearchById = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post(`/api/portal/pass/platformProduct/self/searchById?id=${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 下单时获取订单地址
export const getInfoForCart = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/customer/customerExtra/infoForCart',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 立即购买提交订单
export const submitOrder = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/selforder/save',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 待办列表
export const getBuyerList = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/order/getBuyerList',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 购物车提交订单
export const generateOrder = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/cart/generateOrder',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 取消订单
export const cancelById = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/order/cancelOrder',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 关闭订单
export const closeById = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/order/closeOrder',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 删除订单
export const deleteByIds = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/order/deleteByIds',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 订单详情
export const getOrderDetail = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/order/order/getById/${params.id}`,
            {...config})
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 订单流程
export const getOrderProcessList = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/order/orderProcess/getOrderProcessList/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取合同列表
export const getContractList = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/contract/getContractList',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 删除合同
export const deleteContract = (id, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/order/orderProcess/getOrderProcessList/${id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 上传pdf
export const uploadFile = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.upload('/api/file/file/upload/uploadFile',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 保存合同
export const uploadSaveContract = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/contract/uploadSaveContract',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 保存合同
export const contractConfirmation = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/contract/contractConfirmation',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 订单流程
export const getOrderMarginInfo = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/business/margin/getOrderMarginInfo/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 订单流程
export const getOrderMarginRecords = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/business/margin/getOrderMarginRecords/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 缴纳定金
export const PayDeposit = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/business/margin/save',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 地址列表
export const getAddressList = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/customer/customerReceiveInfo/getReceiveList',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 定金删除
export const deleteMargin = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/business/margin/deleteMargin/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 定金确认提交
export const depositConfirmSubmit = (id, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/order/order/submitMargin/${id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取收货数量记录
export const getGoodsCountByOrderId = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/logistics/sendGoods/getGoodsCountByOrderId/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 根据订单id查询付尾款记录
export const getFnalPayment = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/logistics/finalPayment/getByOrderId/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 支付尾款
export const finalPayment = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/finalPayment/create',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 提交尾款
export const normalConfirmPay = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/finalPayment/normalConfirmPay',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 新增自提信息
export const addDelivery = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/billLading/create',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 更新自提信息
export const updateSelf = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/billLading/update',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 新增配送地址
export const saveDelivery = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/customer/customerReceiveInfo/save',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 更新配送地址
export const updateDelivery = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/order/updateDelivery',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 根据订单id和商品配送类型查看提货单，以此判断是否可以修改地址
export const getByOrderIdAndType = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/billLading/getByOrderIdAndType',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取对账信息
export const getAccountStatementByOrderId = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/reconcilationRecords/getAccountStatementByOrderId',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 更改订单状态
export const updateStatusStage = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/order/rpc/order/updateStatusStage',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取收货记录
export const getSendGoodsByOrder = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/sendGoods/getSendGoodsByOrder',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取收货记录
// export const receiveGoods = (params, config = {})=> {
//     return new Promise((resolve, reject)=> {
//         http.post('/api/logistics/sendGoods/receiveGoods',
//             { ...params },
//             { ...config })
//         .then(res=> { resolve(res) })
//         .catch(err=> { reject(err) })
//     })
// }

// 获取收货记录
export const receiveGoods = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/deliveryNotice/takeGoods',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取物理发票
export const getCustomerInvoive = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/api/customer/customer/getCustomerInvoive',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取未对账单
export const getNoAccountStatement = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/reconcilationRecords/getNoAccountStatement',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 删除发票
export const deleteInvoiceInfo = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/customer/customerInvoiceInfo/delete/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取发票详情
export const getInvoiceInfo = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/customer/customerInvoiceInfo/getOne/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 新增发票
export const saveInvoiceInfo = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/customer/customerInvoiceInfo/save',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取商品发票记录
export const getProductInvoiceByOrderId = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/productInvoice/getProductInvoiceByOrderId',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 物理发票添加或列表
export const getInvoiceInfoByOrderId = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/logistics/invoiceInfo/getInvoiceInfoByOrderId/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 选择物理发票
export const choseInvoice = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/invoiceInfo/saveInvoice',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 删除物理发票
export const deletePhysicalInvoiceInfo = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/logistics/invoiceInfo/delete/${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 保存或者修改物理发票
export const saveProductInvoiceInfo = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/invoiceInfo/batchUpdate',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 对账驳回
export const rejectAccountStatement = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/reconcilationRecords/rejectAccountStatement',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 对账同意
export const agreeAccountStatement = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/reconcilationRecords/agreeAccountStatement',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 提交物理发票
export const batchSaveInvoice = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/productInvoice/batchSaveInvoice',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 删除商品发票
export const deleteProductInvoiceInfo = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get(`/api/logistics/productInvoice/delete${params.id}`,
            {},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 退出登录
export const logout = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.get('/jwt/logout',
            {...params},
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取购物车数量
export const getCartNumApi = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/portal/pass/cart/getCartNum',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 提收货通知列表
export const getDeliveryNoticeApi = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/deliveryNotice/page',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 获取收货列表
export const getNoticeNeedList = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/deliveryNotice/getNoticeNeedByOrder',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 提发货通知单详情
export const getOrderDetailByDelivery = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/deliveryNotice/getOrderDetailByDelivery',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}

// 更新提发货通知单数量
export const updateReceiveCount = (params, config = {})=> {
    return new Promise((resolve, reject)=> {
        http.post('/api/logistics/sendGoods/updateReceiveCount',
            { ...params },
            { ...config })
        .then(res=> { resolve(res) })
        .catch(err=> { reject(err) })
    })
}