package cn.iocoder.mall.product.api.dto;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * Product 规格值添加 DTO
 */
public class ProductAttrValueAddDTO {

    /**
     * 规格编号
     */
    @NotNull(message = "规格编号不能为空")
    private Integer attrId;
    /**
     * 名称
     */
    @NotEmpty(message = "规格值名不能为空")
    private String name;

    public Integer getAttrId() {
        return attrId;
    }

    public ProductAttrValueAddDTO setAttrId(Integer attrId) {
        this.attrId = attrId;
        return this;
    }

    public String getName() {
        return name;
    }

    public ProductAttrValueAddDTO setName(String name) {
        this.name = name;
        return this;
    }

}