/*
 Navicat Premium Data Transfer

 Source Server         : 127.0.0.1 MySQL
 Source Server Type    : MySQL
 Source Server Version : 80026
 Source Host           : localhost:3306
 Source Schema         : ruoyi-vue-pro

 Target Server Type    : MySQL
 Target Server Version : 80026
 File Encoding         : 65001

 Date: 17/01/2023 23:50:17
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for mp_account
-- ----------------------------
DROP TABLE IF EXISTS `mp_account`;
CREATE TABLE `mp_account`  (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '公众号名称',
  `account` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '公众号账号',
  `app_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '公众号appid',
  `app_secret` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '公众号密钥',
  `url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '公众号url',
  `token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '公众号token',
  `aes_key` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '加密密钥',
  `qr_code_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '二维码图片URL',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '备注',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT 0 COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '公众号账号表';

-- ----------------------------
-- Records of mp_account
-- ----------------------------
BEGIN;
INSERT INTO `mp_account` (`id`, `name`, `account`, `app_id`, `app_secret`, `url`, `token`, `aes_key`, `qr_code_url`, `remark`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (2, '1', '2', '3', '4', NULL, '5', NULL, NULL, NULL, '1', '2023-01-07 17:30:30', '1', '2023-01-07 10:05:49', b'1', 1), (3, '1', '2', '3', '4', NULL, '5', NULL, NULL, NULL, '1', '2023-01-08 00:34:35', '1', '2023-01-14 01:15:56', b'1', 1);
COMMIT;

-- ----------------------------
-- Table structure for mp_auto_reply
-- ----------------------------
DROP TABLE IF EXISTS `mp_auto_reply`;
CREATE TABLE `mp_auto_reply`  (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `account_id` bigint NOT NULL COMMENT '公众号账号的编号',
  `app_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公众号 appId',
  `type` tinyint NOT NULL COMMENT '回复类型',
  `request_keyword` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求的关键字',
  `request_match` tinyint NULL DEFAULT NULL COMMENT '请求的关键字的匹配',
  `request_message_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求的消息类型',
  `response_message_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '回复的消息类型',
  `response_content` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的消息内容',
  `response_media_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的媒体文件 id',
  `response_media_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的媒体文件 URL',
  `response_title` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的标题',
  `response_description` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的描述',
  `response_thumb_media_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的缩略图的媒体 id',
  `response_thumb_media_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的缩略图的媒体 URL',
  `response_articles` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的图文消息数组',
  `response_music_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的音乐链接',
  `response_hq_music_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的高质量音乐链接',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT 0 COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 53 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '公众号消息自动回复表';

-- ----------------------------
-- Records of mp_auto_reply
-- ----------------------------
BEGIN;
INSERT INTO `mp_auto_reply` (`id`, `account_id`, `app_id`, `type`, `request_keyword`, `request_match`, `request_message_type`, `response_message_type`, `response_content`, `response_media_id`, `response_media_url`, `response_title`, `response_description`, `response_thumb_media_id`, `response_thumb_media_url`, `response_articles`, `response_music_url`, `response_hq_music_url`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (44, 1, 'wx5b23ba7a5589ecbb', 3, '你猜', 1, 'text', 'voice', '', 't1E3ss-niBf29tpzShjljxwaiBoXV_61ln2hzZGDlvAcT3hqLbC9dvl39YwiBWg9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '2023-01-04 04:40:55', '', '2023-01-16 16:55:48', b'1', 1);
COMMIT;

-- ----------------------------
-- Table structure for mp_material
-- ----------------------------
DROP TABLE IF EXISTS `mp_material`;
CREATE TABLE `mp_material`  (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `account_id` bigint NOT NULL COMMENT '公众号账号的编号',
  `app_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公众号 appId',
  `media_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '公众号素材 id',
  `type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '文件类型',
  `permanent` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否永久',
  `url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件服务器的 URL',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名字',
  `mp_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公众号文件 URL',
  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '视频素材的标题',
  `introduction` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '视频素材的描述',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT 0 COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 98 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '公众号素材表';

-- ----------------------------
-- Records of mp_material
-- ----------------------------
BEGIN;
INSERT INTO `mp_material` (`id`, `account_id`, `app_id`, `media_id`, `type`, `permanent`, `url`, `name`, `mp_url`, `title`, `introduction`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (80, 1, 'wx5b23ba7a5589ecbb', 'r6ryvl6LrxBU0miaST4Y-tlQmcl3RdC-Jcgns6IQtf7zenGy3b86WLT7GzUcrb1T', 'image', b'1', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-tlQmcl3RdC-Jcgns6IQtf7zenGy3b86WLT7GzUcrb1T.png', 'file', 'http://mmbiz.qpic.cn/mmbiz_png/btUmCVHwbJUoicwBiacjVeQbu6QxgBVrukfSJXz509boa21SpH8OVHAqXCJiaiaAaHQJNxwwsa0gHRXVr0G5EZYamw/0?wx_fmt=png', '', '', '1', '2023-01-14 00:56:06', '1', '2023-01-14 07:45:41', b'1', 1), (81, 1, 'wx5b23ba7a5589ecbb', 'r6ryvl6LrxBU0miaST4Y-pWqXoCgpdNp1fvSv7c6zoTnCsW6BGAVFNJ-E9hkAIXO', 'image', b'1', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pWqXoCgpdNp1fvSv7c6zoTnCsW6BGAVFNJ-E9hkAIXO.jpg', 'file', 'http://mmbiz.qpic.cn/mmbiz_jpg/btUmCVHwbJUoicwBiacjVeQbu6QxgBVrukzCJPJRkia5cQviaDTbLMc614uobiblN4Au4UApLYOShXNDNjdndjPVswg/0?wx_fmt=jpeg', '', '', '1', '2023-01-14 01:30:49', '1', '2023-01-14 07:31:02', b'1', 1), (82, 1, 'wx5b23ba7a5589ecbb', 'r6ryvl6LrxBU0miaST4Y-vNzhGc_1b37nxAvj0Zt8iuGACe-mC9_a5OhVFIzt0DX', 'image', b'1', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-vNzhGc_1b37nxAvj0Zt8iuGACe-mC9_a5OhVFIzt0DX.png', 'file', 'http://mmbiz.qpic.cn/mmbiz_png/btUmCVHwbJVkZaoiatUmOpaGalzHIVxhUNOGPaZfZUSfKzpS8bPShaicSyErHn2mEzthXochM7GE3tIDAt5FNrUg/0?wx_fmt=png', NULL, NULL, '1', '2023-01-14 08:20:53', '1', '2023-01-14 07:30:59', b'1', 1), (88, 4, 'wx01b971b269525c69', 'rdp2FpJLZJb_Z771EZCE0sdggkEkJ9BXy1wIiory8puv2L0sRYeBBVztrxmjjT_P', 'voice', b'1', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0sdggkEkJ9BXy1wIiory8puv2L0sRYeBBVztrxmjjT_P.amr', 'file', NULL, '', '', '1', '2023-01-14 16:28:53', '1', '2023-01-14 08:29:36', b'1', 1), (89, 4, 'wx01b971b269525c69', 'rdp2FpJLZJb_Z771EZCE0jlwnElym7bDUZUQI6t36O9xlh-wQWZpdDEVNHj_-Zo3', 'video', b'1', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0jlwnElym7bDUZUQI6t36O9xlh-wQWZpdDEVNHj_-Zo3.mp4', 'file', NULL, '1', '2', '1', '2023-01-14 16:53:53', '1', '2023-01-14 08:54:45', b'1', 1), (90, 4, 'wx01b971b269525c69', 'rdp2FpJLZJb_Z771EZCE0nKJFlsOPjLkDApXEgRjaGydiFVTsC0zMq8-x5V6-rG4', 'video', b'1', 'http://test.yudao.iocoder.cn/rdp2FpJLZJb_Z771EZCE0nKJFlsOPjLkDApXEgRjaGydiFVTsC0zMq8-x5V6-rG4.mp4', 'file', NULL, '12', '34', '1', '2023-01-14 16:55:02', '1', '2023-01-14 08:55:06', b'1', 1);
COMMIT;

-- ----------------------------
-- Table structure for mp_menu
-- ----------------------------
DROP TABLE IF EXISTS `mp_menu`;
CREATE TABLE `mp_menu`  (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `account_id` bigint NOT NULL COMMENT '微信公众号ID',
  `app_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '微信公众号 appid',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '菜单名称',
  `menu_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '菜单标识',
  `parent_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父ID',
  `type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '按钮类型',
  `url` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '网页链接',
  `mini_program_app_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '小程序appid',
  `mini_program_page_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '小程序页面路径',
  `article_id` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '跳转图文的媒体编号',
  `reply_message_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息类型',
  `reply_content` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的消息内容',
  `reply_media_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的媒体文件 id',
  `reply_media_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的媒体文件 URL',
  `reply_title` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的标题',
  `reply_description` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的描述',
  `reply_thumb_media_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的缩略图的媒体 id',
  `reply_thumb_media_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的缩略图的媒体 URL',
  `reply_articles` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的图文消息数组',
  `reply_music_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的音乐链接',
  `reply_hq_music_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回复的高质量音乐链接',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT 0 COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 169 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '公众号菜单表';

-- ----------------------------
-- Records of mp_menu
-- ----------------------------
BEGIN;
INSERT INTO `mp_menu` (`id`, `account_id`, `app_id`, `name`, `menu_key`, `parent_id`, `type`, `url`, `mini_program_app_id`, `mini_program_page_path`, `article_id`, `reply_message_type`, `reply_content`, `reply_media_id`, `reply_media_url`, `reply_title`, `reply_description`, `reply_thumb_media_id`, `reply_thumb_media_url`, `reply_articles`, `reply_music_url`, `reply_hq_music_url`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (1, 1, 'wx5b23ba7a5589ecbb', '今日歌曲', 'V1001_TODAY_MUSIC', '0', 'click', NULL, NULL, NULL, NULL, 'text', '幸会幸会', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', '2023-01-07 02:51:58', '', '2023-01-14 15:44:49', b'1', 1), (2, 1, 'wx5b23ba7a5589ecbb', '搜索', '', '0', 'view', 'http://www.soso.com/', NULL, NULL, NULL, 'text', '幸会幸会', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', '2023-01-07 02:51:58', '', '2023-01-14 13:22:13', b'1', 1), (3, 1, 'wx5b23ba7a5589ecbb', '父按钮', '', '0', '', '', NULL, NULL, NULL, 'text', '幸会幸会', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', '2023-01-07 02:51:58', '', '2023-01-14 15:44:49', b'1', 1), (4, 1, 'wx5b23ba7a5589ecbb', '归去来兮', 'MUSIC', '3', 'click', NULL, NULL, NULL, NULL, 'text', '幸会幸会', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', '2023-01-07 02:51:58', '', '2023-01-14 15:44:49', b'1', 1), (5, 1, 'wx5b23ba7a5589ecbb', '不说', '', '3', 'view', 'http://www.soso.com/', NULL, NULL, NULL, 'text', '幸会幸会', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', '2023-01-07 02:51:58', '', '2023-01-14 15:44:49', b'1', 1), (26, 1, 'wx5b23ba7a5589ecbb', '今日歌曲', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-14 23:44:50', '1', '2023-01-14 16:35:05', b'1', 1), (27, 1, 'wx5b23ba7a5589ecbb', '搜索', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-14 23:44:50', '1', '2023-01-14 16:35:05', b'1', 1), (28, 1, 'wx5b23ba7a5589ecbb', '父按钮', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-14 23:44:50', '1', '2023-01-14 16:35:05', b'1', 1), (29, 1, 'wx5b23ba7a5589ecbb', '归去来兮', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-14 23:44:50', '1', '2023-01-14 16:35:05', b'1', 1), (30, 1, 'wx5b23ba7a5589ecbb', '不说', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-14 23:44:50', '1', '2023-01-14 16:35:05', b'1', 1), (31, 1, 'wx5b23ba7a5589ecbb', '123', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:35:05', '1', '2023-01-14 16:35:43', b'1', 1), (32, 1, 'wx5b23ba7a5589ecbb', '123', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:35:43', '1', '2023-01-14 16:39:10', b'1', 1), (33, 1, 'wx5b23ba7a5589ecbb', '嘿嘿', NULL, '0', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:39:10', '1', '2023-01-14 16:40:09', b'1', 1), (38, 1, 'wx5b23ba7a5589ecbb', '顶级1', NULL, '0', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:42:54', '1', '2023-01-14 16:51:35', b'1', 1), (39, 1, 'wx5b23ba7a5589ecbb', '明星', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:42:54', '1', '2023-01-14 16:51:35', b'1', 1), (40, 1, 'wx5b23ba7a5589ecbb', '喊个', NULL, '39', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:42:54', '1', '2023-01-14 16:51:35', b'1', 1), (41, 1, 'wx5b23ba7a5589ecbb', 'haha', NULL, '39', 'view', 'http://soso.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:42:54', '1', '2023-01-14 16:51:35', b'1', 1), (42, 1, 'wx5b23ba7a5589ecbb', '顶级1', NULL, '0', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:51:35', '1', '2023-01-14 16:51:53', b'1', 1), (43, 1, 'wx5b23ba7a5589ecbb', '明星', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:51:35', '1', '2023-01-14 16:51:53', b'1', 1), (44, 1, 'wx5b23ba7a5589ecbb', '喊个', NULL, '43', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:51:35', '1', '2023-01-14 16:51:53', b'1', 1), (45, 1, 'wx5b23ba7a5589ecbb', 'haha', NULL, '43', 'view', 'http://soso.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 00:51:35', '1', '2023-01-14 16:51:53', b'1', 1), (46, 1, 'wx5b23ba7a5589ecbb', '测试菜单', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 11:32:17', '1', '2023-01-15 04:39:11', b'1', 1), (47, 1, 'wx5b23ba7a5589ecbb', '跳转网页', NULL, '46', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 11:32:17', '1', '2023-01-15 04:39:11', b'1', 1), (48, 1, 'wx5b23ba7a5589ecbb', '点击回复', '123', '0', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '1', '2023-01-15 12:39:12', '1', '2023-01-15 09:19:01', b'1', 1), (49, 1, 'wx5b23ba7a5589ecbb', '点击回复', '123', '0', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:19:02', '1', '2023-01-15 09:26:50', b'1', 1), (50, 1, 'wx5b23ba7a5589ecbb', '点击回复', '123', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', '', '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:26:51', '1', '2023-01-15 09:27:39', b'1', 1), (51, 1, 'wx5b23ba7a5589ecbb', '点击回复', '123', '0', 'click', NULL, NULL, NULL, NULL, 'video', '', 'XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT', 'http://test.yudao.iocoder.cn/XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT.mp4', '奥特曼', '奥特快', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:27:40', '1', '2023-01-15 09:28:20', b'1', 1), (52, 1, 'wx5b23ba7a5589ecbb', '点击回复', '123', '0', 'click', NULL, NULL, NULL, NULL, 'video', '', 'XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT', 'http://test.yudao.iocoder.cn/XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT.mp4', NULL, '奥特快', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:28:21', '1', '2023-01-15 09:29:21', b'1', 1), (53, 1, 'wx5b23ba7a5589ecbb', '点击回复', '123', '0', 'click', NULL, NULL, NULL, NULL, 'video', '', 'XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT', 'http://test.yudao.iocoder.cn/XQockIDz-7p8wHuI0wxzd2dZvhKWrQnxM5pPXvaW8Qsid2hLjVxk90wM47ZsYERT.mp4', NULL, '奥特快', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:29:22', '1', '2023-01-15 09:32:49', b'1', 1), (54, 1, 'wx5b23ba7a5589ecbb', '回复图片', '01', '0', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:29:22', '1', '2023-01-15 09:32:49', b'1', 1), (55, 1, 'wx5b23ba7a5589ecbb', '回复图片', 'image', '0', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8.jpg', '', '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:33:06', '1', '2023-01-15 09:33:45', b'1', 1), (56, 1, 'wx5b23ba7a5589ecbb', '回复图片', 'image', '0', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8.jpg', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:33:45', '1', '2023-01-15 09:33:55', b'1', 1), (57, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', '', '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:33:45', '1', '2023-01-15 09:33:55', b'1', 1), (58, 1, 'wx5b23ba7a5589ecbb', '回复图片', 'image', '0', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8.jpg', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:33:56', '1', '2023-01-15 09:34:02', b'1', 1), (59, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:33:56', '1', '2023-01-15 09:34:02', b'1', 1), (60, 1, 'wx5b23ba7a5589ecbb', '回复图片', 'image', '0', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-jVixJGgnBnkBPRbuVptOW0CHYuQFyiOVNtamctS8xU8.jpg', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:34:02', '1', '2023-01-15 09:34:44', b'1', 1), (61, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:34:02', '1', '2023-01-15 09:34:44', b'1', 1), (62, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:34:45', '1', '2023-01-15 09:36:27', b'1', 1), (63, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:36:28', '1', '2023-01-15 09:37:20', b'1', 1), (64, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:37:21', '1', '2023-01-15 09:40:13', b'1', 1), (65, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:40:14', '1', '2023-01-15 09:40:24', b'1', 1), (66, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:40:24', '1', '2023-01-15 09:41:12', b'1', 1), (67, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'video', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', '', '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:41:13', '1', '2023-01-15 09:43:32', b'1', 1), (68, 1, 'wx5b23ba7a5589ecbb', '回复视频', '123', '0', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', '我是视频', '我真的是视频', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:41:13', '1', '2023-01-15 09:43:32', b'1', 1), (69, 1, 'wx5b23ba7a5589ecbb', '回复语音', 'aoteman', '0', 'click', NULL, NULL, NULL, NULL, 'video', '', 'a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_Gz-Yg8hVk5OgQ6iWZU_KSOEhpQ31JmkGh0JYPKgi9ebKPthnsckQbQVWfiN58VLrfg.mp3', NULL, '', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:43:33', '1', '2023-01-15 10:06:28', b'1', 1), (70, 1, 'wx5b23ba7a5589ecbb', '回复视频', '123', '0', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', NULL, '我真的是视频', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:43:33', '1', '2023-01-15 10:06:28', b'1', 1), (71, 1, 'wx5b23ba7a5589ecbb', '回复音乐', 'ao11', '0', 'click', NULL, NULL, NULL, NULL, 'music', '', NULL, NULL, '1', '2', NULL, NULL, NULL, '', '', '1', '2023-01-15 17:43:33', '1', '2023-01-15 10:06:28', b'1', 1), (72, 1, 'wx5b23ba7a5589ecbb', '回复音乐', '01', '0', 'click', NULL, NULL, NULL, NULL, 'music', '', NULL, NULL, '1', '2', 'wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl', 'http://test.yudao.iocoder.cn/wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl.png', NULL, 'https://www.iocoder.cn/1.mp3', 'https://www.iocoder.cn/2.mp3', '1', '2023-01-15 18:16:12', '1', '2023-01-15 10:21:13', b'1', 1), (73, 1, 'wx5b23ba7a5589ecbb', '回复音乐', '01', '0', 'click', NULL, NULL, NULL, NULL, 'music', '', NULL, NULL, '1', '2', 'wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl', 'http://test.yudao.iocoder.cn/wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl.png', NULL, 'https://www.iocoder.cn/1.mp3', 'https://www.iocoder.cn/2.mp3', '1', '2023-01-15 18:21:14', '1', '2023-01-15 10:21:36', b'1', 1), (74, 1, 'wx5b23ba7a5589ecbb', '回复音乐', '01', '0', 'click', NULL, NULL, NULL, NULL, 'music', '', NULL, NULL, '1', '2', 'wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl', 'http://test.yudao.iocoder.cn/wBnOlFbeYaWXb7AVX5Ha_Uy373JHA2EoS0FUziAhkwP0r6Hv43PeQHXKY4GADfbl.png', NULL, 'https://www.iocoder.cn/1.mp3', 'https://www.iocoder.cn/2.mp3', '1', '2023-01-15 18:21:36', '1', '2023-01-15 10:21:59', b'1', 1), (75, 1, 'wx5b23ba7a5589ecbb', '回复图文', 'music', '0', 'click', NULL, NULL, NULL, NULL, 'news', '', NULL, NULL, '', '', NULL, NULL, '[{\"title\":\"我是标题\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=1&sn=dadf5d7e9aa594b58666fb2013fdf215&chksm=9f6354aea814ddb8fde13b17a34acbe86987b5c3403c6bd47e1e94977f6988b62653f6ab55e6#rd\"},{\"title\":\"我是标题 2\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=2&sn=c8041e2fc639c07d73bbbb6f80cf1784&chksm=9f6354aea814ddb8f48d7b330252c0374878014feb45a8fd4c22aaa0483c062f20ba15463368#rd\"}]', NULL, NULL, '1', '2023-01-15 18:23:23', '1', '2023-01-15 10:23:53', b'1', 1), (76, 1, 'wx5b23ba7a5589ecbb', '回复图文', 'music', '0', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, '', '', NULL, NULL, '[{\"title\":\"我是标题\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=1&sn=dadf5d7e9aa594b58666fb2013fdf215&chksm=9f6354aea814ddb8fde13b17a34acbe86987b5c3403c6bd47e1e94977f6988b62653f6ab55e6#rd\"},{\"title\":\"我是标题 2\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=2&sn=c8041e2fc639c07d73bbbb6f80cf1784&chksm=9f6354aea814ddb8f48d7b330252c0374878014feb45a8fd4c22aaa0483c062f20ba15463368#rd\"}]', NULL, NULL, '1', '2023-01-15 18:23:54', '1', '2023-01-15 11:13:21', b'1', 1), (77, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:21', '1', '2023-01-15 11:13:36', b'1', 1), (78, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '77', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:21', '1', '2023-01-15 11:13:36', b'1', 1), (79, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:36', '1', '2023-01-15 11:13:49', b'1', 1), (80, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '79', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:36', '1', '2023-01-15 11:13:49', b'1', 1), (81, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '79', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:36', '1', '2023-01-15 11:13:49', b'1', 1), (82, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:49', '1', '2023-01-15 11:14:06', b'1', 1), (83, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '82', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:49', '1', '2023-01-15 11:14:06', b'1', 1), (84, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '82', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:49', '1', '2023-01-15 11:14:06', b'1', 1), (85, 1, 'wx5b23ba7a5589ecbb', '语音', 'v3', '82', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:13:49', '1', '2023-01-15 11:14:06', b'1', 1), (86, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:07', '1', '2023-01-15 11:14:35', b'1', 1), (87, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '86', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:07', '1', '2023-01-15 11:14:35', b'1', 1), (88, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '86', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:07', '1', '2023-01-15 11:14:35', b'1', 1), (89, 1, 'wx5b23ba7a5589ecbb', '语音', 'v3', '86', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:07', '1', '2023-01-15 11:14:35', b'1', 1), (90, 1, 'wx5b23ba7a5589ecbb', '子菜单名称', 'o', '86', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', '我是视频', '我真的是视频', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:07', '1', '2023-01-15 11:14:35', b'1', 1), (91, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:35', '1', '2023-01-15 11:18:13', b'1', 1), (92, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '91', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:35', '1', '2023-01-15 11:18:13', b'1', 1), (93, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '91', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:35', '1', '2023-01-15 11:18:13', b'1', 1), (94, 1, 'wx5b23ba7a5589ecbb', '语音', 'v3', '91', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:35', '1', '2023-01-15 11:18:13', b'1', 1), (95, 1, 'wx5b23ba7a5589ecbb', '视频', 'o', '91', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', '我是视频', '我真的是视频', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:14:35', '1', '2023-01-15 11:18:13', b'1', 1), (96, 1, 'wx5b23ba7a5589ecbb', '图文', 'wx', '91', 'click', NULL, NULL, NULL, NULL, 'news', '', NULL, NULL, '', '', NULL, NULL, '[{\"title\":\"我是标题\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=1&sn=dadf5d7e9aa594b58666fb2013fdf215&chksm=9f6354aea814ddb8fde13b17a34acbe86987b5c3403c6bd47e1e94977f6988b62653f6ab55e6#rd\"},{\"title\":\"我是标题 2\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=2&sn=c8041e2fc639c07d73bbbb6f80cf1784&chksm=9f6354aea814ddb8f48d7b330252c0374878014feb45a8fd4c22aaa0483c062f20ba15463368#rd\"}]', NULL, NULL, '1', '2023-01-15 19:14:35', '1', '2023-01-15 11:18:13', b'1', 1), (97, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:18:14', '1', '2023-01-15 11:26:07', b'1', 1), (98, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '97', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:18:14', '1', '2023-01-15 11:26:07', b'1', 1), (99, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '97', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:18:14', '1', '2023-01-15 11:26:07', b'1', 1), (100, 1, 'wx5b23ba7a5589ecbb', '语音', 'v3', '97', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:18:14', '1', '2023-01-15 11:26:07', b'1', 1), (101, 1, 'wx5b23ba7a5589ecbb', '视频', 'o', '97', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', '我是视频', '我真的是视频', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:18:14', '1', '2023-01-15 11:26:07', b'1', 1), (102, 1, 'wx5b23ba7a5589ecbb', '图文', 'wx', '97', 'click', NULL, NULL, NULL, NULL, 'news', '', NULL, NULL, '', '', NULL, NULL, '[{\"title\":\"我是标题\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=1&sn=dadf5d7e9aa594b58666fb2013fdf215&chksm=9f6354aea814ddb8fde13b17a34acbe86987b5c3403c6bd47e1e94977f6988b62653f6ab55e6#rd\"},{\"title\":\"我是标题 2\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=2&sn=c8041e2fc639c07d73bbbb6f80cf1784&chksm=9f6354aea814ddb8f48d7b330252c0374878014feb45a8fd4c22aaa0483c062f20ba15463368#rd\"}]', NULL, NULL, '1', '2023-01-15 19:18:14', '1', '2023-01-15 11:26:07', b'1', 1), (103, 1, 'wx5b23ba7a5589ecbb', '测试', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:18:14', '1', '2023-01-15 11:26:07', b'1', 1), (104, 1, 'wx5b23ba7a5589ecbb', '跳转网页', NULL, '103', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:18:14', '1', '2023-01-15 11:26:07', b'1', 1), (105, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (106, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '105', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (107, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '105', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (108, 1, 'wx5b23ba7a5589ecbb', '语音', 'v3', '105', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (109, 1, 'wx5b23ba7a5589ecbb', '视频', 'o', '105', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', '我是视频', '我真的是视频', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (110, 1, 'wx5b23ba7a5589ecbb', '图文', 'wx', '105', 'click', NULL, NULL, NULL, NULL, 'news', '', NULL, NULL, '', '', NULL, NULL, '[{\"title\":\"我是标题\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=1&sn=dadf5d7e9aa594b58666fb2013fdf215&chksm=9f6354aea814ddb8fde13b17a34acbe86987b5c3403c6bd47e1e94977f6988b62653f6ab55e6#rd\"},{\"title\":\"我是标题 2\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=2&sn=c8041e2fc639c07d73bbbb6f80cf1784&chksm=9f6354aea814ddb8f48d7b330252c0374878014feb45a8fd4c22aaa0483c062f20ba15463368#rd\"}]', NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (111, 1, 'wx5b23ba7a5589ecbb', '测试', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (112, 1, 'wx5b23ba7a5589ecbb', '跳转网页', NULL, '111', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (113, 1, 'wx5b23ba7a5589ecbb', '扫码回复', 'test_02', '111', 'scancode_waitmsg', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:26:08', '1', '2023-01-15 11:33:57', b'1', 1), (114, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (115, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '114', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (116, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '114', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (117, 1, 'wx5b23ba7a5589ecbb', '语音', 'v3', '114', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (118, 1, 'wx5b23ba7a5589ecbb', '视频', 'o', '114', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', '我是视频', '我真的是视频', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (119, 1, 'wx5b23ba7a5589ecbb', '图文', 'wx', '114', 'click', NULL, NULL, NULL, NULL, 'news', '', NULL, NULL, '', '', NULL, NULL, '[{\"title\":\"我是标题\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=1&sn=dadf5d7e9aa594b58666fb2013fdf215&chksm=9f6354aea814ddb8fde13b17a34acbe86987b5c3403c6bd47e1e94977f6988b62653f6ab55e6#rd\"},{\"title\":\"我是标题 2\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=2&sn=c8041e2fc639c07d73bbbb6f80cf1784&chksm=9f6354aea814ddb8f48d7b330252c0374878014feb45a8fd4c22aaa0483c062f20ba15463368#rd\"}]', NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (120, 1, 'wx5b23ba7a5589ecbb', '测试', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (121, 1, 'wx5b23ba7a5589ecbb', '跳转网页', NULL, '120', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (122, 1, 'wx5b23ba7a5589ecbb', '扫码回复', 'test_02', '120', 'scancode_waitmsg', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (123, 1, 'wx5b23ba7a5589ecbb', '扫码直接回结果', '2344455', '120', 'scancode_push', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:33:58', '1', '2023-01-15 11:44:54', b'1', 1), (124, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (125, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '124', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (126, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '124', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (127, 1, 'wx5b23ba7a5589ecbb', '语音', 'v3', '124', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (128, 1, 'wx5b23ba7a5589ecbb', '视频', 'o', '124', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', '我是视频', '我真的是视频', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (129, 1, 'wx5b23ba7a5589ecbb', '图文', 'wx', '124', 'click', NULL, NULL, NULL, NULL, 'news', '', NULL, NULL, '', '', NULL, NULL, '[{\"title\":\"我是标题\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=1&sn=dadf5d7e9aa594b58666fb2013fdf215&chksm=9f6354aea814ddb8fde13b17a34acbe86987b5c3403c6bd47e1e94977f6988b62653f6ab55e6#rd\"},{\"title\":\"我是标题 2\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=2&sn=c8041e2fc639c07d73bbbb6f80cf1784&chksm=9f6354aea814ddb8f48d7b330252c0374878014feb45a8fd4c22aaa0483c062f20ba15463368#rd\"}]', NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (130, 1, 'wx5b23ba7a5589ecbb', '测试', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (131, 1, 'wx5b23ba7a5589ecbb', '跳转网页', NULL, '130', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (132, 1, 'wx5b23ba7a5589ecbb', '扫码回复', 'test_02', '130', 'scancode_waitmsg', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (133, 1, 'wx5b23ba7a5589ecbb', '扫码直接回结果', '2344455', '130', 'scancode_push', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (134, 1, 'wx5b23ba7a5589ecbb', '系统拍照', '0x0', '130', 'pic_sysphoto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (135, 1, 'wx5b23ba7a5589ecbb', '拍照或相册', '0x3', '130', 'pic_photo_or_album', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (136, 1, 'wx5b23ba7a5589ecbb', '测试2', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (137, 1, 'wx5b23ba7a5589ecbb', '微信相册', 'ppp2222', '136', 'pic_weixin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:44:55', '1', '2023-01-15 11:52:04', b'1', 1), (138, 1, 'wx5b23ba7a5589ecbb', '回复图文', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (139, 1, 'wx5b23ba7a5589ecbb', '文本', 't1', '138', 'click', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (140, 1, 'wx5b23ba7a5589ecbb', '图片', 'pic', '138', 'click', NULL, NULL, NULL, NULL, 'image', '', 'r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pgFtUNLu1foMSAMkoOsrQrTZ8EtTMssBLfTtzP0dfjG.png', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (141, 1, 'wx5b23ba7a5589ecbb', '语音', 'v3', '138', 'click', NULL, NULL, NULL, NULL, 'voice', '', 'a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA', 'http://test.yudao.iocoder.cn/a6kOoewXIbX57gB0kCb_G0h41eeCLWXi-DiMGrPG1iQwjuxGoAoDZCqt6J7IrUrjYwTfa9dGyTJ7qbQ-8TlNrA.mp3', '', '', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (142, 1, 'wx5b23ba7a5589ecbb', '视频', 'o', '138', 'click', NULL, NULL, NULL, NULL, 'video', '', 'r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU', 'http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-v2-X9sD87sdZ8qoWWgu9QgP2NEjlTvDJ47KfF2xhyiU.mp4', '我是视频', '我真的是视频', NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (143, 1, 'wx5b23ba7a5589ecbb', '图文', 'wx', '138', 'click', NULL, NULL, NULL, NULL, 'news', '', NULL, NULL, '', '', NULL, NULL, '[{\"title\":\"我是标题\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=1&sn=dadf5d7e9aa594b58666fb2013fdf215&chksm=9f6354aea814ddb8fde13b17a34acbe86987b5c3403c6bd47e1e94977f6988b62653f6ab55e6#rd\"},{\"title\":\"我是标题 2\",\"description\":null,\"picUrl\":\"http://test.yudao.iocoder.cn/r6ryvl6LrxBU0miaST4Y-pIcmK-zAAId-9TGgy-DrSLhjVuWbuT3ZBjk9K1yQ0Dn.png\",\"url\":\"http://mp.weixin.qq.com/s?__biz=MzA3NjM4MzQzOQ==&mid=2247483662&idx=2&sn=c8041e2fc639c07d73bbbb6f80cf1784&chksm=9f6354aea814ddb8f48d7b330252c0374878014feb45a8fd4c22aaa0483c062f20ba15463368#rd\"}]', NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (144, 1, 'wx5b23ba7a5589ecbb', '测试', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (145, 1, 'wx5b23ba7a5589ecbb', '跳转网页', NULL, '144', 'view', 'https://www.iocoder.cn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (146, 1, 'wx5b23ba7a5589ecbb', '扫码回复', 'test_02', '144', 'scancode_waitmsg', NULL, NULL, NULL, NULL, 'text', '123', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (147, 1, 'wx5b23ba7a5589ecbb', '扫码直接回结果', '2344455', '144', 'scancode_push', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (148, 1, 'wx5b23ba7a5589ecbb', '系统拍照', '0x0', '144', 'pic_sysphoto', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (149, 1, 'wx5b23ba7a5589ecbb', '拍照或相册', '0x3', '144', 'pic_photo_or_album', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (150, 1, 'wx5b23ba7a5589ecbb', '测试2', NULL, '0', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (151, 1, 'wx5b23ba7a5589ecbb', '微信相册', 'ppp2222', '150', 'pic_weixin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1), (152, 1, 'wx5b23ba7a5589ecbb', '选择地理位置', 'lll2', '150', 'location_select', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', '2023-01-15 19:52:04', '1', '2023-01-15 13:20:22', b'1', 1);
COMMIT;

-- ----------------------------
-- Table structure for mp_message
-- ----------------------------
DROP TABLE IF EXISTS `mp_message`;
CREATE TABLE `mp_message`  (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `msg_id` bigint NULL DEFAULT NULL COMMENT '微信公众号的消息编号',
  `account_id` bigint NOT NULL COMMENT '公众号账号的编号',
  `app_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公众号 appId',
  `user_id` bigint NOT NULL COMMENT '公众号粉丝的编号',
  `openid` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '公众号粉丝标志',
  `type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '消息类型',
  `send_from` tinyint NOT NULL COMMENT '消息来源',
  `content` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息内容',
  `media_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '媒体文件 id',
  `media_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '媒体文件 URL',
  `recognition` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '语音识别后文本',
  `format` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '语音格式',
  `title` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标题',
  `description` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `thumb_media_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '缩略图的媒体 id',
  `thumb_media_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '缩略图的媒体 URL',
  `url` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '点击图文消息跳转链接',
  `location_x` double NULL DEFAULT NULL COMMENT '地理位置维度',
  `location_y` double NULL DEFAULT NULL COMMENT '地理位置经度',
  `scale` double NULL DEFAULT NULL COMMENT '地图缩放大小',
  `label` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '详细地址',
  `articles` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图文消息数组',
  `music_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '音乐链接',
  `hq_music_url` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '高质量音乐链接',
  `event` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '事件类型',
  `event_key` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '事件 Key',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT 0 COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 407 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '公众号消息表 ';

-- ----------------------------
-- Records of mp_message
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mp_tag
-- ----------------------------
DROP TABLE IF EXISTS `mp_tag`;
CREATE TABLE `mp_tag`  (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `tag_id` bigint NULL DEFAULT NULL COMMENT '公众号标签 id',
  `name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标签名称',
  `count` int NULL DEFAULT 0 COMMENT '粉丝数量',
  `account_id` bigint NOT NULL COMMENT '公众号账号的编号',
  `app_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公众号 appId',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT 0 COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '公众号标签表';

-- ----------------------------
-- Records of mp_tag
-- ----------------------------
BEGIN;
INSERT INTO `mp_tag` (`id`, `tag_id`, `name`, `count`, `account_id`, `app_id`, `creator`, `create_time`, `updater`, `update_time`, `deleted`, `tenant_id`) VALUES (3, 100, '测试标签啦', 0, 1, 'wx5b23ba7a5589ecbb', '1', '2023-01-01 20:33:28', '1', '2023-01-08 03:23:53', b'1', 1), (4, 101, '测试', 0, 1, 'wx5b23ba7a5589ecbb', '1', '2023-01-01 20:33:28', '1', '2023-01-08 03:21:00', b'1', 1), (7, 102, '搞起来', 0, 1, 'wx5b23ba7a5589ecbb', '1', '2023-01-01 20:33:28', '1', '2023-01-08 04:03:00', b'1', 1);
COMMIT;

-- ----------------------------
-- Table structure for mp_user
-- ----------------------------
DROP TABLE IF EXISTS `mp_user`;
CREATE TABLE `mp_user`  (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编号',
  `openid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户标识',
  `subscribe_status` tinyint NOT NULL COMMENT '关注状态',
  `subscribe_time` datetime NOT NULL COMMENT '关注时间',
  `nickname` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '昵称',
  `head_image_url` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '头像地址',
  `unsubscribe_time` datetime NULL DEFAULT NULL COMMENT '取消关注时间',
  `language` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '语言',
  `country` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '国家',
  `province` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '省份',
  `city` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '城市',
  `remark` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '备注',
  `tag_ids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '标签编号数组',
  `account_id` bigint NOT NULL COMMENT '微信公众号ID',
  `app_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '微信公众号 appid',
  `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
  `tenant_id` bigint NOT NULL DEFAULT 0 COMMENT '租户编号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '公众号粉丝表';

-- ----------------------------
-- Records of mp_user
-- ----------------------------
BEGIN;
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
