package cn.iocoder.mall.systemservice.controller;

import cn.iocoder.common.framework.vo.CommonResult;
import cn.iocoder.common.framework.vo.PageResult;
import cn.iocoder.mall.systemservice.manager.errorcode.ErrorCodeManager;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeAutoGenerateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeCreateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodePageDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeUpdateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.vo.ErrorCodeVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

import static cn.iocoder.common.framework.vo.CommonResult.success;

/**
 * Title:
 * Description:
 *
 * @author zhuyang
 * @version 1.0 2021/10/11
 */
@RestController
@RequestMapping("/system/errorcode")
public class ErrorCodeController {
    @Autowired
    private ErrorCodeManager errorCodeManager;

    @GetMapping("listErrorCodes")
    public CommonResult<List<ErrorCodeVO>> listErrorCodes(@RequestParam("group") String group, @RequestParam("minUpdateTime") Date minUpdateTime) {
        return success(errorCodeManager.listErrorCodes(group, minUpdateTime));
    }

    @PostMapping("autoGenerateErrorCodes")
    public CommonResult<Boolean> autoGenerateErrorCodes(@RequestBody List<ErrorCodeAutoGenerateDTO> autoGenerateDTOs) {
        errorCodeManager.autoGenerateErrorCodes(autoGenerateDTOs);
        return success(true);
    }

    @PostMapping("createErrorCode")
    public CommonResult<Integer> createErrorCode(@RequestBody ErrorCodeCreateDTO createDTO) {
        return success(errorCodeManager.createErrorCode(createDTO));
    }

    @PostMapping("updateErrorCode")
    public CommonResult<Boolean> updateErrorCode(@RequestBody ErrorCodeUpdateDTO updateDTO) {
        errorCodeManager.updateErrorCode(updateDTO);
        return success(true);
    }

    @GetMapping("deleteErrorCode")
    public CommonResult<Boolean> deleteErrorCode(@RequestParam("errorCodeId")Integer errorCodeId) {
        errorCodeManager.deleteErrorCode(errorCodeId);
        return success(true);
    }

    @GetMapping("getErrorCode")
    public CommonResult<ErrorCodeVO> getErrorCode(@RequestParam("errorCodeId")Integer errorCodeId) {
        return success(errorCodeManager.getErrorCode(errorCodeId));
    }

    @GetMapping("listErrorCodesByIds")
    public CommonResult<List<ErrorCodeVO>> listErrorCodes(@RequestParam("errorCodeIds")List<Integer> errorCodeIds) {
        return success(errorCodeManager.listErrorCodes(errorCodeIds));
    }

    @PostMapping("pageErrorCode")
    public CommonResult<PageResult<ErrorCodeVO>> pageErrorCode(@RequestBody ErrorCodePageDTO pageDTO) {
        return success(errorCodeManager.pageErrorCode(pageDTO));
    }
}
