/*
 Navicat Premium Data Transfer

 Source Server         : 127.0.0.1 Oracle
 Source Server Type    : Oracle
 Source Server Version : 110200
 Source Host           : 127.0.0.1:1521
 Source Schema         : ROOT

 Target Server Type    : Oracle
 Target Server Version : 110200
 File Encoding         : 65001

 Date: 15/06/2022 08:20:08
*/


-- ----------------------------
-- Table structure for BPM_FORM
-- ----------------------------
DROP TABLE "BPM_FORM";
CREATE TABLE "BPM_FORM" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(64),
  "STATUS" NUMBER(4,0) NOT NULL,
  "CONF" NVARCHAR2(1000),
  "FIELDS" NCLOB,
  "REMARK" NVARCHAR2(255),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "BPM_FORM"."ID" IS '编号';
COMMENT ON COLUMN "BPM_FORM"."NAME" IS '表单名';
COMMENT ON COLUMN "BPM_FORM"."STATUS" IS '开启状态';
COMMENT ON COLUMN "BPM_FORM"."CONF" IS '表单的配置';
COMMENT ON COLUMN "BPM_FORM"."FIELDS" IS '表单项的数组';
COMMENT ON COLUMN "BPM_FORM"."REMARK" IS '备注';
COMMENT ON COLUMN "BPM_FORM"."CREATOR" IS '创建者';
COMMENT ON COLUMN "BPM_FORM"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "BPM_FORM"."UPDATER" IS '更新者';
COMMENT ON COLUMN "BPM_FORM"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "BPM_FORM"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "BPM_FORM"."DELETED" IS '是否删除';
COMMENT ON TABLE "BPM_FORM" IS '工作流的表单定义';

-- ----------------------------
-- Records of BPM_FORM
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for BPM_OA_LEAVE
-- ----------------------------
DROP TABLE "BPM_OA_LEAVE";
CREATE TABLE "BPM_OA_LEAVE" (
  "ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "TYPE" NUMBER(4,0) NOT NULL,
  "REASON" NVARCHAR2(200),
  "START_TIME" DATE NOT NULL,
  "END_TIME" DATE NOT NULL,
  "DAY" NUMBER(4,0) NOT NULL,
  "RESULT" NUMBER(4,0) NOT NULL,
  "PROCESS_INSTANCE_ID" NVARCHAR2(64),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "BPM_OA_LEAVE"."ID" IS '请假表单主键';
COMMENT ON COLUMN "BPM_OA_LEAVE"."USER_ID" IS '申请人的用户编号';
COMMENT ON COLUMN "BPM_OA_LEAVE"."TYPE" IS '请假类型';
COMMENT ON COLUMN "BPM_OA_LEAVE"."REASON" IS '请假原因';
COMMENT ON COLUMN "BPM_OA_LEAVE"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "BPM_OA_LEAVE"."END_TIME" IS '结束时间';
COMMENT ON COLUMN "BPM_OA_LEAVE"."DAY" IS '请假天数';
COMMENT ON COLUMN "BPM_OA_LEAVE"."RESULT" IS '请假结果';
COMMENT ON COLUMN "BPM_OA_LEAVE"."PROCESS_INSTANCE_ID" IS '流程实例的编号';
COMMENT ON COLUMN "BPM_OA_LEAVE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "BPM_OA_LEAVE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "BPM_OA_LEAVE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "BPM_OA_LEAVE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "BPM_OA_LEAVE"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "BPM_OA_LEAVE"."DELETED" IS '是否删除';
COMMENT ON TABLE "BPM_OA_LEAVE" IS 'OA 请假申请表';

-- ----------------------------
-- Records of BPM_OA_LEAVE
-- ----------------------------
INSERT INTO "BPM_OA_LEAVE" ("ID", "USER_ID", "TYPE", "REASON", "START_TIME", "END_TIME", "DAY", "RESULT", "PROCESS_INSTANCE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('0', '1', '2', '123', TO_DATE('2022-05-02 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-05-11 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '9', '2', '64394b8d-c947-11ec-a43c-3e2374911326', '1', TO_DATE('2022-05-01 20:08:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 20:30:02', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for BPM_PROCESS_DEFINITION_EXT
-- ----------------------------
DROP TABLE "BPM_PROCESS_DEFINITION_EXT";
CREATE TABLE "BPM_PROCESS_DEFINITION_EXT" (
  "ID" NUMBER(20,0) NOT NULL,
  "PROCESS_DEFINITION_ID" NVARCHAR2(64),
  "MODEL_ID" NVARCHAR2(64),
  "DESCRIPTION" NVARCHAR2(255),
  "FORM_TYPE" NUMBER(4,0) NOT NULL,
  "FORM_ID" NUMBER(20,0),
  "FORM_CONF" NVARCHAR2(1000),
  "FORM_FIELDS" NCLOB,
  "FORM_CUSTOM_CREATE_PATH" NVARCHAR2(255),
  "FORM_CUSTOM_VIEW_PATH" NVARCHAR2(255),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."ID" IS '编号';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."PROCESS_DEFINITION_ID" IS '流程定义的编号';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."MODEL_ID" IS '流程模型的编号';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."DESCRIPTION" IS '描述';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."FORM_TYPE" IS '表单类型';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."FORM_ID" IS '表单编号';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."FORM_CONF" IS '表单的配置';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."FORM_FIELDS" IS '表单项的数组';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."FORM_CUSTOM_CREATE_PATH" IS '自定义表单的提交路径';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."FORM_CUSTOM_VIEW_PATH" IS '自定义表单的查看路径';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."UPDATER" IS '更新者';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "BPM_PROCESS_DEFINITION_EXT"."DELETED" IS '是否删除';
COMMENT ON TABLE "BPM_PROCESS_DEFINITION_EXT" IS 'Bpm 流程定义的拓展表
';

-- ----------------------------
-- Records of BPM_PROCESS_DEFINITION_EXT
-- ----------------------------
INSERT INTO "BPM_PROCESS_DEFINITION_EXT" ("ID", "PROCESS_DEFINITION_ID", "MODEL_ID", "DESCRIPTION", "FORM_TYPE", "FORM_ID", "FORM_CONF", "FORM_FIELDS", "FORM_CUSTOM_CREATE_PATH", "FORM_CUSTOM_VIEW_PATH", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('0', 'oa_leave:1:5b8f470c-c947-11ec-a43c-3e2374911326', 'd0d2e04c-c945-11ec-baf6-3e2374911326', NULL, '20', NULL, NULL, NULL, '/bpm/oa/leave/create', '/bpm/oa/leave/detail', '1', TO_DATE('2022-05-01 20:08:05', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 20:08:05', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for BPM_PROCESS_INSTANCE_EXT
-- ----------------------------
DROP TABLE "BPM_PROCESS_INSTANCE_EXT";
CREATE TABLE "BPM_PROCESS_INSTANCE_EXT" (
  "ID" NUMBER(20,0) NOT NULL,
  "START_USER_ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(64),
  "PROCESS_INSTANCE_ID" NVARCHAR2(64),
  "PROCESS_DEFINITION_ID" NVARCHAR2(64),
  "CATEGORY" NVARCHAR2(64),
  "STATUS" NUMBER(4,0) NOT NULL,
  "RESULT" NUMBER(4,0) NOT NULL,
  "END_TIME" DATE,
  "FORM_VARIABLES" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."ID" IS '编号';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."START_USER_ID" IS '发起流程的用户编号';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."NAME" IS '流程实例的名字';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."PROCESS_INSTANCE_ID" IS '流程实例的编号';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."PROCESS_DEFINITION_ID" IS '流程定义的编号';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."CATEGORY" IS '流程分类';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."STATUS" IS '流程实例的状态';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."RESULT" IS '流程实例的结果';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."END_TIME" IS '结束时间';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."FORM_VARIABLES" IS '表单值';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."UPDATER" IS '更新者';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "BPM_PROCESS_INSTANCE_EXT"."DELETED" IS '是否删除';
COMMENT ON TABLE "BPM_PROCESS_INSTANCE_EXT" IS '工作流的流程实例的拓展';

-- ----------------------------
-- Records of BPM_PROCESS_INSTANCE_EXT
-- ----------------------------
INSERT INTO "BPM_PROCESS_INSTANCE_EXT" ("ID", "START_USER_ID", "NAME", "PROCESS_INSTANCE_ID", "PROCESS_DEFINITION_ID", "CATEGORY", "STATUS", "RESULT", "END_TIME", "FORM_VARIABLES", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('0', '1', 'OA 请假', '64394b8d-c947-11ec-a43c-3e2374911326', 'oa_leave:1:5b8f470c-c947-11ec-a43c-3e2374911326', '2', '2', '2', TO_DATE('2022-05-01 20:30:02', 'SYYYY-MM-DD HH24:MI:SS'), '{"day":9}', '1', TO_DATE('2022-05-01 20:08:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 20:30:02', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for BPM_TASK_ASSIGN_RULE
-- ----------------------------
DROP TABLE "BPM_TASK_ASSIGN_RULE";
CREATE TABLE "BPM_TASK_ASSIGN_RULE" (
  "ID" NUMBER(20,0) NOT NULL,
  "MODEL_ID" NVARCHAR2(64),
  "PROCESS_DEFINITION_ID" NVARCHAR2(64) DEFAULT '',
  "TASK_DEFINITION_KEY" NVARCHAR2(64) DEFAULT '',
  "TYPE" NUMBER(4,0) NOT NULL,
  "OPTIONS" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."ID" IS '编号';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."MODEL_ID" IS '流程模型的编号';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."PROCESS_DEFINITION_ID" IS '流程定义的编号';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."TASK_DEFINITION_KEY" IS '流程任务定义的 key';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."TYPE" IS '规则类型';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."OPTIONS" IS '规则值，JSON 数组';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "BPM_TASK_ASSIGN_RULE"."DELETED" IS '是否删除';
COMMENT ON TABLE "BPM_TASK_ASSIGN_RULE" IS 'Bpm 任务规则表';

-- ----------------------------
-- Records of BPM_TASK_ASSIGN_RULE
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for BPM_TASK_EXT
-- ----------------------------
DROP TABLE "BPM_TASK_EXT";
CREATE TABLE "BPM_TASK_EXT" (
  "ID" NUMBER(20,0) NOT NULL,
  "ASSIGNEE_USER_ID" NUMBER(20,0),
  "NAME" NVARCHAR2(64),
  "TASK_ID" NVARCHAR2(64),
  "RESULT" NUMBER(4,0) NOT NULL,
  "REASON" NVARCHAR2(255),
  "END_TIME" DATE,
  "PROCESS_INSTANCE_ID" NVARCHAR2(64),
  "PROCESS_DEFINITION_ID" NVARCHAR2(64),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "BPM_TASK_EXT"."ID" IS '编号';
COMMENT ON COLUMN "BPM_TASK_EXT"."ASSIGNEE_USER_ID" IS '任务的审批人';
COMMENT ON COLUMN "BPM_TASK_EXT"."NAME" IS '任务的名字';
COMMENT ON COLUMN "BPM_TASK_EXT"."TASK_ID" IS '任务的编号';
COMMENT ON COLUMN "BPM_TASK_EXT"."RESULT" IS '任务的结果';
COMMENT ON COLUMN "BPM_TASK_EXT"."REASON" IS '审批建议';
COMMENT ON COLUMN "BPM_TASK_EXT"."END_TIME" IS '任务的结束时间';
COMMENT ON COLUMN "BPM_TASK_EXT"."PROCESS_INSTANCE_ID" IS '流程实例的编号';
COMMENT ON COLUMN "BPM_TASK_EXT"."PROCESS_DEFINITION_ID" IS '流程定义的编号';
COMMENT ON COLUMN "BPM_TASK_EXT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "BPM_TASK_EXT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "BPM_TASK_EXT"."UPDATER" IS '更新者';
COMMENT ON COLUMN "BPM_TASK_EXT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "BPM_TASK_EXT"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "BPM_TASK_EXT"."DELETED" IS '是否删除';
COMMENT ON TABLE "BPM_TASK_EXT" IS '工作流的流程任务的拓展表';

-- ----------------------------
-- Records of BPM_TASK_EXT
-- ----------------------------
INSERT INTO "BPM_TASK_EXT" ("ID", "ASSIGNEE_USER_ID", "NAME", "TASK_ID", "RESULT", "REASON", "END_TIME", "PROCESS_INSTANCE_ID", "PROCESS_DEFINITION_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('0', '1', 'task01', '6445a7a5-c947-11ec-a43c-3e2374911326', '2', '123', TO_DATE('2022-05-01 20:30:02', 'SYYYY-MM-DD HH24:MI:SS'), '64394b8d-c947-11ec-a43c-3e2374911326', 'oa_leave:1:5b8f470c-c947-11ec-a43c-3e2374911326', '1', TO_DATE('2022-05-01 20:08:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 20:30:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for BPM_USER_GROUP
-- ----------------------------
DROP TABLE "BPM_USER_GROUP";
CREATE TABLE "BPM_USER_GROUP" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(30),
  "DESCRIPTION" NVARCHAR2(255),
  "MEMBER_USER_IDS" NCLOB NOT NULL,
  "STATUS" NUMBER(4,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "BPM_USER_GROUP"."ID" IS '编号';
COMMENT ON COLUMN "BPM_USER_GROUP"."NAME" IS '组名';
COMMENT ON COLUMN "BPM_USER_GROUP"."DESCRIPTION" IS '描述';
COMMENT ON COLUMN "BPM_USER_GROUP"."MEMBER_USER_IDS" IS '成员编号数组';
COMMENT ON COLUMN "BPM_USER_GROUP"."STATUS" IS '状态（0正常 1停用）';
COMMENT ON COLUMN "BPM_USER_GROUP"."CREATOR" IS '创建者';
COMMENT ON COLUMN "BPM_USER_GROUP"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "BPM_USER_GROUP"."UPDATER" IS '更新者';
COMMENT ON COLUMN "BPM_USER_GROUP"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "BPM_USER_GROUP"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "BPM_USER_GROUP"."DELETED" IS '是否删除';
COMMENT ON TABLE "BPM_USER_GROUP" IS '用户组';

-- ----------------------------
-- Records of BPM_USER_GROUP
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_API_ACCESS_LOG
-- ----------------------------
DROP TABLE "INFRA_API_ACCESS_LOG";
CREATE TABLE "INFRA_API_ACCESS_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "TRACE_ID" NVARCHAR2(64),
  "USER_ID" NUMBER(20,0) DEFAULT 0 NOT NULL,
  "USER_TYPE" NUMBER(4,0) DEFAULT 0 NOT NULL,
  "APPLICATION_NAME" NVARCHAR2(50),
  "REQUEST_METHOD" NVARCHAR2(16),
  "REQUEST_URL" NVARCHAR2(255),
  "REQUEST_PARAMS" NCLOB,
  "USER_IP" NVARCHAR2(50),
  "USER_AGENT" NVARCHAR2(512),
  "BEGIN_TIME" DATE NOT NULL,
  "END_TIME" DATE NOT NULL,
  "DURATION" NUMBER(11,0) NOT NULL,
  "RESULT_CODE" NUMBER(11,0) NOT NULL,
  "RESULT_MSG" NVARCHAR2(512),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."ID" IS '日志主键';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."TRACE_ID" IS '链路追踪编号';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."APPLICATION_NAME" IS '应用名';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."REQUEST_METHOD" IS '请求方法名';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."REQUEST_URL" IS '请求地址';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."REQUEST_PARAMS" IS '请求参数';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."USER_IP" IS '用户 IP';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."USER_AGENT" IS '浏览器 UA';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."BEGIN_TIME" IS '开始请求时间';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."END_TIME" IS '结束请求时间';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."DURATION" IS '执行时长';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."RESULT_CODE" IS '结果码';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."RESULT_MSG" IS '结果提示';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_API_ACCESS_LOG"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "INFRA_API_ACCESS_LOG" IS 'API 访问日志表';

-- ----------------------------
-- Records of INFRA_API_ACCESS_LOG
-- ----------------------------
INSERT INTO "INFRA_API_ACCESS_LOG" ("ID", "TRACE_ID", "USER_ID", "USER_TYPE", "APPLICATION_NAME", "REQUEST_METHOD", "REQUEST_URL", "REQUEST_PARAMS", "USER_IP", "USER_AGENT", "BEGIN_TIME", "END_TIME", "DURATION", "RESULT_CODE", "RESULT_MSG", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('0', NULL, '0', '2', 'yudao-server', 'GET', '/admin-api/system/dict-data/list-all-simple', '{"query":{},"body":null}', '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36', TO_DATE('2022-05-13 01:26:54', 'SYYYY-MM-DD HH24:MI:SS'), TO_DATE('2022-05-13 01:26:54', 'SYYYY-MM-DD HH24:MI:SS'), '94', '0', NULL, NULL, TO_DATE('2022-05-13 01:26:54', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-13 01:26:54', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_API_ERROR_LOG
-- ----------------------------
DROP TABLE "INFRA_API_ERROR_LOG";
CREATE TABLE "INFRA_API_ERROR_LOG" (
  "ID" NUMBER(11,0) NOT NULL,
  "TRACE_ID" NVARCHAR2(64),
  "USER_ID" NUMBER(11,0) NOT NULL,
  "USER_TYPE" NUMBER(4,0) NOT NULL,
  "APPLICATION_NAME" NVARCHAR2(50),
  "REQUEST_METHOD" NVARCHAR2(16),
  "REQUEST_URL" NVARCHAR2(255),
  "REQUEST_PARAMS" NCLOB,
  "USER_IP" NVARCHAR2(50),
  "USER_AGENT" NVARCHAR2(512),
  "EXCEPTION_TIME" DATE NOT NULL,
  "EXCEPTION_NAME" NVARCHAR2(128),
  "EXCEPTION_MESSAGE" NCLOB NOT NULL,
  "EXCEPTION_ROOT_CAUSE_MESSAGE" NCLOB NOT NULL,
  "EXCEPTION_STACK_TRACE" NCLOB NOT NULL,
  "EXCEPTION_CLASS_NAME" NVARCHAR2(512),
  "EXCEPTION_FILE_NAME" NVARCHAR2(512),
  "EXCEPTION_METHOD_NAME" NVARCHAR2(512),
  "EXCEPTION_LINE_NUMBER" NUMBER(11,0) NOT NULL,
  "PROCESS_STATUS" NUMBER(4,0) NOT NULL,
  "PROCESS_TIME" DATE,
  "PROCESS_USER_ID" NUMBER(11,0),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."ID" IS '编号';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."TRACE_ID" IS '链路追踪编号
     *
     * 一般来说，通过链路追踪编号，可以将访问日志，错误日志，链路追踪日志，logger 打印日志等，结合在一起，从而进行排错。';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."APPLICATION_NAME" IS '应用名
     *
     * 目前读取 spring.application.name';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."REQUEST_METHOD" IS '请求方法名';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."REQUEST_URL" IS '请求地址';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."REQUEST_PARAMS" IS '请求参数';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."USER_IP" IS '用户 IP';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."USER_AGENT" IS '浏览器 UA';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_TIME" IS '异常发生时间';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_NAME" IS '异常名
     *
     * {@link Throwable#getClass()} 的类全名';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_MESSAGE" IS '异常导致的消息
     *
     * {@link cn.iocoder.common.framework.util.ExceptionUtil#getMessage(Throwable)}';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_ROOT_CAUSE_MESSAGE" IS '异常导致的根消息
     *
     * {@link cn.iocoder.common.framework.util.ExceptionUtil#getRootCauseMessage(Throwable)}';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_STACK_TRACE" IS '异常的栈轨迹
     *
     * {@link cn.iocoder.common.framework.util.ExceptionUtil#getServiceException(Exception)}';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_CLASS_NAME" IS '异常发生的类全名
     *
     * {@link StackTraceElement#getClassName()}';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_FILE_NAME" IS '异常发生的类文件
     *
     * {@link StackTraceElement#getFileName()}';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_METHOD_NAME" IS '异常发生的方法名
     *
     * {@link StackTraceElement#getMethodName()}';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."EXCEPTION_LINE_NUMBER" IS '异常发生的方法所在行
     *
     * {@link StackTraceElement#getLineNumber()}';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."PROCESS_STATUS" IS '处理状态';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."PROCESS_TIME" IS '处理时间';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."PROCESS_USER_ID" IS '处理用户编号';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_API_ERROR_LOG"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "INFRA_API_ERROR_LOG" IS '系统异常日志';

-- ----------------------------
-- Records of INFRA_API_ERROR_LOG
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_CODEGEN_COLUMN
-- ----------------------------
DROP TABLE "INFRA_CODEGEN_COLUMN";
CREATE TABLE "INFRA_CODEGEN_COLUMN" (
  "ID" NUMBER(20,0) NOT NULL,
  "TABLE_ID" NUMBER(20,0) NOT NULL,
  "COLUMN_NAME" NVARCHAR2(200),
  "DATA_TYPE" NVARCHAR2(100),
  "COLUMN_COMMENT" NVARCHAR2(500),
  "NULLABLE" NUMBER(4,0),
  "PRIMARY_KEY" NUMBER(4,0),
  "AUTO_INCREMENT" NUMBER(4,0),
  "ORDINAL_POSITION" NUMBER(11,0) NOT NULL,
  "JAVA_TYPE" NVARCHAR2(32),
  "JAVA_FIELD" NVARCHAR2(64),
  "DICT_TYPE" NVARCHAR2(200),
  "EXAMPLE" NVARCHAR2(64),
  "CREATE_OPERATION" NUMBER(4,0),
  "UPDATE_OPERATION" NUMBER(4,0),
  "LIST_OPERATION" NUMBER(4,0),
  "LIST_OPERATION_CONDITION" NVARCHAR2(32) NOT NULL,
  "LIST_OPERATION_RESULT" NUMBER(4,0),
  "HTML_TYPE" NVARCHAR2(32),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."ID" IS '编号';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."TABLE_ID" IS '表编号';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."COLUMN_NAME" IS '字段名';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."DATA_TYPE" IS '字段类型';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."COLUMN_COMMENT" IS '字段描述';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."NULLABLE" IS '是否允许为空';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."PRIMARY_KEY" IS '是否主键';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."AUTO_INCREMENT" IS '是否自增';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."ORDINAL_POSITION" IS '排序';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."JAVA_TYPE" IS 'Java 属性类型';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."JAVA_FIELD" IS 'Java 属性名';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."DICT_TYPE" IS '字典类型';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."EXAMPLE" IS '数据示例';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."CREATE_OPERATION" IS '是否为 Create 创建操作的字段';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."UPDATE_OPERATION" IS '是否为 Update 更新操作的字段';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."LIST_OPERATION" IS '是否为 List 查询操作的字段';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."LIST_OPERATION_CONDITION" IS 'List 查询操作的条件类型';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."LIST_OPERATION_RESULT" IS '是否为 List 查询操作的返回字段';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."HTML_TYPE" IS '显示类型';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_CODEGEN_COLUMN"."DELETED" IS '是否删除';
COMMENT ON TABLE "INFRA_CODEGEN_COLUMN" IS '代码生成表字段定义';

-- ----------------------------
-- Records of INFRA_CODEGEN_COLUMN
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_CODEGEN_TABLE
-- ----------------------------
DROP TABLE "INFRA_CODEGEN_TABLE";
CREATE TABLE "INFRA_CODEGEN_TABLE" (
  "ID" NUMBER(20,0) NOT NULL,
  "DATA_SOURCE_CONFIG_ID" NUMBER NOT NULL,
  "SCENE" NUMBER(4,0) NOT NULL,
  "TABLE_NAME" NVARCHAR2(200),
  "TABLE_COMMENT" NVARCHAR2(500),
  "REMARK" NVARCHAR2(500),
  "MODULE_NAME" NVARCHAR2(30),
  "BUSINESS_NAME" NVARCHAR2(30),
  "CLASS_NAME" NVARCHAR2(100),
  "CLASS_COMMENT" NVARCHAR2(50),
  "AUTHOR" NVARCHAR2(50),
  "TEMPLATE_TYPE" NUMBER(4,0) NOT NULL,
  "PARENT_MENU_ID" NUMBER(20,0),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."ID" IS '编号';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."DATA_SOURCE_CONFIG_ID" IS '数据源配置的编号';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."SCENE" IS '生成场景';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."TABLE_NAME" IS '表名称';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."TABLE_COMMENT" IS '表描述';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."REMARK" IS '备注';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."MODULE_NAME" IS '模块名';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."BUSINESS_NAME" IS '业务名';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."CLASS_NAME" IS '类名称';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."CLASS_COMMENT" IS '类描述';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."AUTHOR" IS '作者';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."TEMPLATE_TYPE" IS '模板类型';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."PARENT_MENU_ID" IS '父菜单编号';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_CODEGEN_TABLE"."DELETED" IS '是否删除';
COMMENT ON TABLE "INFRA_CODEGEN_TABLE" IS '代码生成表定义';

-- ----------------------------
-- Records of INFRA_CODEGEN_TABLE
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_CONFIG
-- ----------------------------
DROP TABLE "INFRA_CONFIG";
CREATE TABLE "INFRA_CONFIG" (
  "ID" NUMBER(11,0) NOT NULL,
  "CATEGORY" NVARCHAR2(50),
  "TYPE" NUMBER(4,0) NOT NULL,
  "NAME" NVARCHAR2(100),
  "CONFIG_KEY" NVARCHAR2(100),
  "VALUE" NVARCHAR2(500),
  "VISIBLE" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(500),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_CONFIG"."ID" IS '参数主键';
COMMENT ON COLUMN "INFRA_CONFIG"."CATEGORY" IS '参数分组';
COMMENT ON COLUMN "INFRA_CONFIG"."TYPE" IS '参数类型';
COMMENT ON COLUMN "INFRA_CONFIG"."NAME" IS '参数名称';
COMMENT ON COLUMN "INFRA_CONFIG"."CONFIG_KEY" IS '参数键名';
COMMENT ON COLUMN "INFRA_CONFIG"."VALUE" IS '参数键值';
COMMENT ON COLUMN "INFRA_CONFIG"."VISIBLE" IS '是否可见';
COMMENT ON COLUMN "INFRA_CONFIG"."REMARK" IS '备注';
COMMENT ON COLUMN "INFRA_CONFIG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_CONFIG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_CONFIG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_CONFIG"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "INFRA_CONFIG" IS '参数配置表';

-- ----------------------------
-- Records of INFRA_CONFIG
-- ----------------------------
INSERT INTO "INFRA_CONFIG" ("ID", "CATEGORY", "TYPE", "NAME", "CONFIG_KEY", "VALUE", "VISIBLE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1', 'ui', '1', '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', '0', '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 12:21:26', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "INFRA_CONFIG" ("ID", "CATEGORY", "TYPE", "NAME", "CONFIG_KEY", "VALUE", "VISIBLE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('2', 'biz', '1', '用户管理-账号初始密码', 'sys.user.init-password', '123456', '0', '初始化密码 123456', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-20 02:25:51', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "INFRA_CONFIG" ("ID", "CATEGORY", "TYPE", "NAME", "CONFIG_KEY", "VALUE", "VISIBLE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('3', 'ui', '1', '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', '0', '深色主题theme-dark，浅色主题theme-light', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-01-19 03:05:21', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "INFRA_CONFIG" ("ID", "CATEGORY", "TYPE", "NAME", "CONFIG_KEY", "VALUE", "VISIBLE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('4', '1', '2', 'xxx', 'demo.test', '10', '0', '5', NULL, TO_DATE('2021-01-19 03:10:26', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-01-20 09:25:55', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "INFRA_CONFIG" ("ID", "CATEGORY", "TYPE", "NAME", "CONFIG_KEY", "VALUE", "VISIBLE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('5', 'xxx', '2', 'xxx', 'xxx', 'xxx', '1', 'xxx', NULL, TO_DATE('2021-02-09 20:06:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-02-09 20:06:47', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "INFRA_CONFIG" ("ID", "CATEGORY", "TYPE", "NAME", "CONFIG_KEY", "VALUE", "VISIBLE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('6', 'biz', '2', '登陆验证码的开关', 'yudao.captcha.enable', 'true', '1', NULL, '1', TO_DATE('2022-02-17 00:03:11', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-17 00:15:33', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_DATA_SOURCE_CONFIG
-- ----------------------------
DROP TABLE "INFRA_DATA_SOURCE_CONFIG";
CREATE TABLE "INFRA_DATA_SOURCE_CONFIG" (
  "ID" NUMBER NOT NULL,
  "NAME" NVARCHAR2(100) NOT NULL,
  "URL" NCLOB NOT NULL,
  "USERNAME" NVARCHAR2(255) NOT NULL,
  "PASSWORD" NVARCHAR2(255) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."ID" IS '主键编号';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."NAME" IS '参数名称';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."URL" IS '数据源连接';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."USERNAME" IS '用户名';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."PASSWORD" IS '密码';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_DATA_SOURCE_CONFIG"."DELETED" IS '是否删除';
COMMENT ON TABLE "INFRA_DATA_SOURCE_CONFIG" IS '数据源配置表';

-- ----------------------------
-- Records of INFRA_DATA_SOURCE_CONFIG
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_FILE
-- ----------------------------
DROP TABLE "INFRA_FILE";
CREATE TABLE "INFRA_FILE" (
  "ID" NUMBER(20,0) NOT NULL,
  "CONFIG_ID" NUMBER(20,0),
  "PATH" NVARCHAR2(512),
  "URL" NCLOB,
  "TYPE" NVARCHAR2(63),
  "SIZE" NUMBER(11,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0,
  "NAME" NVARCHAR2(512)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_FILE"."ID" IS '文件编号';
COMMENT ON COLUMN "INFRA_FILE"."CONFIG_ID" IS '配置编号';
COMMENT ON COLUMN "INFRA_FILE"."PATH" IS '文件路径';
COMMENT ON COLUMN "INFRA_FILE"."URL" IS '文件 URL';
COMMENT ON COLUMN "INFRA_FILE"."TYPE" IS '文件类型';
COMMENT ON COLUMN "INFRA_FILE"."SIZE" IS '文件大小';
COMMENT ON COLUMN "INFRA_FILE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_FILE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_FILE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_FILE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_FILE"."NAME" IS '文件名';
COMMENT ON TABLE "INFRA_FILE" IS '文件表';

-- ----------------------------
-- Records of INFRA_FILE
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_FILE_CONFIG
-- ----------------------------
DROP TABLE "INFRA_FILE_CONFIG";
CREATE TABLE "INFRA_FILE_CONFIG" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(63),
  "STORAGE" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(255),
  "MASTER" NUMBER(4,0),
  "CONFIG" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."ID" IS '编号';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."NAME" IS '配置名';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."STORAGE" IS '存储器';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."REMARK" IS '备注';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."MASTER" IS '是否为主配置';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."CONFIG" IS '存储配置';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_FILE_CONFIG"."DELETED" IS '是否删除';
COMMENT ON TABLE "INFRA_FILE_CONFIG" IS '文件配置表';

-- ----------------------------
-- Records of INFRA_FILE_CONFIG
-- ----------------------------
INSERT INTO "INFRA_FILE_CONFIG" ("ID", "NAME", "STORAGE", "REMARK", "MASTER", "CONFIG", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('4', '数据库', '1', '我是数据库', '0', '{"@class":"cn.iocoder.yudao.framework.file.core.client.db.DBFileClientConfig","domain":"http://127.0.0.1:48080"}', '1', TO_DATE('2022-03-15 23:56:24', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 19:10:11', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "INFRA_FILE_CONFIG" ("ID", "NAME", "STORAGE", "REMARK", "MASTER", "CONFIG", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('5', '本地磁盘', '10', '测试下本地存储', '0', '{"@class":"cn.iocoder.yudao.framework.file.core.client.local.LocalFileClientConfig","basePath":"/Users/yunai/file_test","domain":"http://127.0.0.1:48080"}', '1', TO_DATE('2022-03-15 23:57:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 19:10:11', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "INFRA_FILE_CONFIG" ("ID", "NAME", "STORAGE", "REMARK", "MASTER", "CONFIG", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('11', 'S3 - 七牛云', '20', NULL, '1', '{"@class":"cn.iocoder.yudao.framework.file.core.client.s3.S3FileClientConfig","endpoint":"s3-cn-south-1.qiniucs.com","domain":"http://test.yudao.iocoder.cn","bucket":"ruoyi-vue-pro","accessKey":"b7yvuhBSAGjmtPhMFcn9iMOxUOY_I06cA_p0ZUx8","accessSecret":"kXM1l5ia1RvSX3QaOEcwI3RLz3Y2rmNszWonKZtP"}', '1', TO_DATE('2022-03-19 18:00:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 19:10:11', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_FILE_CONTENT
-- ----------------------------
DROP TABLE "INFRA_FILE_CONTENT";
CREATE TABLE "INFRA_FILE_CONTENT" (
  "ID" NUMBER(20,0) NOT NULL,
  "CONFIG_ID" NUMBER(20,0) NOT NULL,
  "PATH" NVARCHAR2(512),
  "CONTENT" BLOB NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."ID" IS '编号';
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."CONFIG_ID" IS '配置编号';
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."PATH" IS '文件路径';
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."CONTENT" IS '文件内容';
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_FILE_CONTENT"."DELETED" IS '是否删除';
COMMENT ON TABLE "INFRA_FILE_CONTENT" IS '文件表';

-- ----------------------------
-- Records of INFRA_FILE_CONTENT
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_JOB
-- ----------------------------
DROP TABLE "INFRA_JOB";
CREATE TABLE "INFRA_JOB" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(32),
  "STATUS" NUMBER(4,0) NOT NULL,
  "HANDLER_NAME" NVARCHAR2(64),
  "HANDLER_PARAM" NVARCHAR2(255),
  "CRON_EXPRESSION" NVARCHAR2(32),
  "RETRY_COUNT" NUMBER(11,0) NOT NULL,
  "RETRY_INTERVAL" NUMBER(11,0) NOT NULL,
  "MONITOR_TIMEOUT" NUMBER(11,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_JOB"."ID" IS '任务编号';
COMMENT ON COLUMN "INFRA_JOB"."NAME" IS '任务名称';
COMMENT ON COLUMN "INFRA_JOB"."STATUS" IS '任务状态';
COMMENT ON COLUMN "INFRA_JOB"."HANDLER_NAME" IS '处理器的名字';
COMMENT ON COLUMN "INFRA_JOB"."HANDLER_PARAM" IS '处理器的参数';
COMMENT ON COLUMN "INFRA_JOB"."CRON_EXPRESSION" IS 'CRON 表达式';
COMMENT ON COLUMN "INFRA_JOB"."RETRY_COUNT" IS '重试次数';
COMMENT ON COLUMN "INFRA_JOB"."RETRY_INTERVAL" IS '重试间隔';
COMMENT ON COLUMN "INFRA_JOB"."MONITOR_TIMEOUT" IS '监控超时时间';
COMMENT ON COLUMN "INFRA_JOB"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_JOB"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_JOB"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_JOB"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "INFRA_JOB" IS '定时任务表';

-- ----------------------------
-- Records of INFRA_JOB
-- ----------------------------
INSERT INTO "INFRA_JOB" ("ID", "NAME", "STATUS", "HANDLER_NAME", "HANDLER_PARAM", "CRON_EXPRESSION", "RETRY_COUNT", "RETRY_INTERVAL", "MONITOR_TIMEOUT", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('0', '用户 Session 超时 Job', '1', 'userSessionTimeoutJob', NULL, '0 * * * * ? *', '3', '2000', '0', '1', TO_DATE('2022-05-01 20:44:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 20:44:03', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_JOB_LOG
-- ----------------------------
DROP TABLE "INFRA_JOB_LOG";
CREATE TABLE "INFRA_JOB_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "JOB_ID" NUMBER(20,0) NOT NULL,
  "HANDLER_NAME" NVARCHAR2(64),
  "HANDLER_PARAM" NVARCHAR2(255),
  "EXECUTE_INDEX" NUMBER(4,0) NOT NULL,
  "BEGIN_TIME" DATE NOT NULL,
  "END_TIME" DATE,
  "DURATION" NUMBER(11,0),
  "STATUS" NUMBER(4,0) NOT NULL,
  "RESULT" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_JOB_LOG"."ID" IS '日志编号';
COMMENT ON COLUMN "INFRA_JOB_LOG"."JOB_ID" IS '任务编号';
COMMENT ON COLUMN "INFRA_JOB_LOG"."HANDLER_NAME" IS '处理器的名字';
COMMENT ON COLUMN "INFRA_JOB_LOG"."HANDLER_PARAM" IS '处理器的参数';
COMMENT ON COLUMN "INFRA_JOB_LOG"."EXECUTE_INDEX" IS '第几次执行';
COMMENT ON COLUMN "INFRA_JOB_LOG"."BEGIN_TIME" IS '开始执行时间';
COMMENT ON COLUMN "INFRA_JOB_LOG"."END_TIME" IS '结束执行时间';
COMMENT ON COLUMN "INFRA_JOB_LOG"."DURATION" IS '执行时长';
COMMENT ON COLUMN "INFRA_JOB_LOG"."STATUS" IS '任务状态';
COMMENT ON COLUMN "INFRA_JOB_LOG"."RESULT" IS '结果数据';
COMMENT ON COLUMN "INFRA_JOB_LOG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_JOB_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_JOB_LOG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_JOB_LOG"."UPDATE_TIME" IS '更新时间';
COMMENT ON TABLE "INFRA_JOB_LOG" IS '定时任务日志表';

-- ----------------------------
-- Records of INFRA_JOB_LOG
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for INFRA_TEST_DEMO
-- ----------------------------
DROP TABLE "INFRA_TEST_DEMO";
CREATE TABLE "INFRA_TEST_DEMO" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(100),
  "STATUS" NUMBER(4,0) NOT NULL,
  "TYPE" NUMBER(4,0) NOT NULL,
  "CATEGORY" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(500),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "INFRA_TEST_DEMO"."ID" IS '编号';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."NAME" IS '名字';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."STATUS" IS '状态';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."TYPE" IS '类型';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."CATEGORY" IS '分类';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."REMARK" IS '备注';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."CREATOR" IS '创建者';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."UPDATER" IS '更新者';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "INFRA_TEST_DEMO"."DELETED" IS '是否删除';
COMMENT ON TABLE "INFRA_TEST_DEMO" IS '字典类型表';

-- ----------------------------
-- Records of INFRA_TEST_DEMO
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for MEMBER_USER
-- ----------------------------
DROP TABLE "MEMBER_USER";
CREATE TABLE "MEMBER_USER" (
  "ID" NUMBER(20,0) NOT NULL,
  "NICKNAME" NVARCHAR2(30),
  "AVATAR" NVARCHAR2(255),
  "STATUS" NUMBER(4,0) NOT NULL,
  "MOBILE" NVARCHAR2(11),
  "PASSWORD" NVARCHAR2(100),
  "REGISTER_IP" NVARCHAR2(32),
  "LOGIN_IP" NVARCHAR2(50),
  "LOGIN_DATE" DATE,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "MEMBER_USER"."ID" IS '编号';
COMMENT ON COLUMN "MEMBER_USER"."NICKNAME" IS '用户昵称';
COMMENT ON COLUMN "MEMBER_USER"."AVATAR" IS '头像';
COMMENT ON COLUMN "MEMBER_USER"."STATUS" IS '状态';
COMMENT ON COLUMN "MEMBER_USER"."MOBILE" IS '手机号';
COMMENT ON COLUMN "MEMBER_USER"."PASSWORD" IS '密码';
COMMENT ON COLUMN "MEMBER_USER"."REGISTER_IP" IS '注册 IP';
COMMENT ON COLUMN "MEMBER_USER"."LOGIN_IP" IS '最后登录IP';
COMMENT ON COLUMN "MEMBER_USER"."LOGIN_DATE" IS '最后登录时间';
COMMENT ON COLUMN "MEMBER_USER"."CREATOR" IS '创建者';
COMMENT ON COLUMN "MEMBER_USER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "MEMBER_USER"."UPDATER" IS '更新者';
COMMENT ON COLUMN "MEMBER_USER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "MEMBER_USER"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "MEMBER_USER" IS '用户';

-- ----------------------------
-- Records of MEMBER_USER
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for PAY_APP
-- ----------------------------
DROP TABLE "PAY_APP";
CREATE TABLE "PAY_APP" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(64),
  "STATUS" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(255),
  "PAY_NOTIFY_URL" NCLOB,
  "REFUND_NOTIFY_URL" NCLOB,
  "MERCHANT_ID" NUMBER(20,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "PAY_APP"."ID" IS '应用编号';
COMMENT ON COLUMN "PAY_APP"."NAME" IS '应用名';
COMMENT ON COLUMN "PAY_APP"."STATUS" IS '开启状态';
COMMENT ON COLUMN "PAY_APP"."REMARK" IS '备注';
COMMENT ON COLUMN "PAY_APP"."PAY_NOTIFY_URL" IS '支付结果的回调地址';
COMMENT ON COLUMN "PAY_APP"."REFUND_NOTIFY_URL" IS '退款结果的回调地址';
COMMENT ON COLUMN "PAY_APP"."MERCHANT_ID" IS '商户编号';
COMMENT ON COLUMN "PAY_APP"."CREATOR" IS '创建者';
COMMENT ON COLUMN "PAY_APP"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "PAY_APP"."UPDATER" IS '更新者';
COMMENT ON COLUMN "PAY_APP"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "PAY_APP"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "PAY_APP" IS '支付应用信息';

-- ----------------------------
-- Records of PAY_APP
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for PAY_CHANNEL
-- ----------------------------
DROP TABLE "PAY_CHANNEL";
CREATE TABLE "PAY_CHANNEL" (
  "ID" NUMBER(20,0) NOT NULL,
  "CODE" NVARCHAR2(32),
  "STATUS" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(255),
  "FEE_RATE" NUMBER NOT NULL,
  "MERCHANT_ID" NUMBER(20,0) NOT NULL,
  "APP_ID" NUMBER(20,0) NOT NULL,
  "CONFIG" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "PAY_CHANNEL"."ID" IS '商户编号';
COMMENT ON COLUMN "PAY_CHANNEL"."CODE" IS '渠道编码';
COMMENT ON COLUMN "PAY_CHANNEL"."STATUS" IS '开启状态';
COMMENT ON COLUMN "PAY_CHANNEL"."REMARK" IS '备注';
COMMENT ON COLUMN "PAY_CHANNEL"."FEE_RATE" IS '渠道费率，单位：百分比';
COMMENT ON COLUMN "PAY_CHANNEL"."MERCHANT_ID" IS '商户编号';
COMMENT ON COLUMN "PAY_CHANNEL"."APP_ID" IS '应用编号';
COMMENT ON COLUMN "PAY_CHANNEL"."CONFIG" IS '支付渠道配置';
COMMENT ON COLUMN "PAY_CHANNEL"."CREATOR" IS '创建者';
COMMENT ON COLUMN "PAY_CHANNEL"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "PAY_CHANNEL"."UPDATER" IS '更新者';
COMMENT ON COLUMN "PAY_CHANNEL"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "PAY_CHANNEL"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "PAY_CHANNEL" IS '支付渠道
';

-- ----------------------------
-- Records of PAY_CHANNEL
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for PAY_MERCHANT
-- ----------------------------
DROP TABLE "PAY_MERCHANT";
CREATE TABLE "PAY_MERCHANT" (
  "ID" NUMBER(20,0) NOT NULL,
  "NO" NVARCHAR2(32),
  "NAME" NVARCHAR2(64),
  "SHORT_NAME" NVARCHAR2(64),
  "STATUS" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(255),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "PAY_MERCHANT"."ID" IS '商户编号';
COMMENT ON COLUMN "PAY_MERCHANT"."NO" IS '商户号';
COMMENT ON COLUMN "PAY_MERCHANT"."NAME" IS '商户全称';
COMMENT ON COLUMN "PAY_MERCHANT"."SHORT_NAME" IS '商户简称';
COMMENT ON COLUMN "PAY_MERCHANT"."STATUS" IS '开启状态';
COMMENT ON COLUMN "PAY_MERCHANT"."REMARK" IS '备注';
COMMENT ON COLUMN "PAY_MERCHANT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "PAY_MERCHANT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "PAY_MERCHANT"."UPDATER" IS '更新者';
COMMENT ON COLUMN "PAY_MERCHANT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "PAY_MERCHANT"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "PAY_MERCHANT" IS '支付商户信息';

-- ----------------------------
-- Records of PAY_MERCHANT
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for PAY_NOTIFY_LOG
-- ----------------------------
DROP TABLE "PAY_NOTIFY_LOG";
CREATE TABLE "PAY_NOTIFY_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "TASK_ID" NUMBER(20,0) NOT NULL,
  "NOTIFY_TIMES" NUMBER(4,0) NOT NULL,
  "RESPONSE" NCLOB,
  "STATUS" NUMBER(4,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."ID" IS '日志编号';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."TASK_ID" IS '通知任务编号';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."NOTIFY_TIMES" IS '第几次被通知';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."RESPONSE" IS '请求参数';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."STATUS" IS '通知状态';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "PAY_NOTIFY_LOG"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "PAY_NOTIFY_LOG" IS '支付通知 App 的日志';

-- ----------------------------
-- Records of PAY_NOTIFY_LOG
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for PAY_NOTIFY_TASK
-- ----------------------------
DROP TABLE "PAY_NOTIFY_TASK";
CREATE TABLE "PAY_NOTIFY_TASK" (
  "ID" NUMBER(20,0) NOT NULL,
  "MERCHANT_ID" NUMBER(20,0) NOT NULL,
  "APP_ID" NUMBER(20,0) NOT NULL,
  "TYPE" NUMBER(4,0) NOT NULL,
  "DATA_ID" NUMBER(20,0) NOT NULL,
  "STATUS" NUMBER(4,0) NOT NULL,
  "MERCHANT_ORDER_ID" NVARCHAR2(64),
  "NEXT_NOTIFY_TIME" DATE NOT NULL,
  "LAST_EXECUTE_TIME" DATE NOT NULL,
  "NOTIFY_TIMES" NUMBER(4,0) NOT NULL,
  "MAX_NOTIFY_TIMES" NUMBER(4,0) NOT NULL,
  "NOTIFY_URL" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."ID" IS '任务编号';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."MERCHANT_ID" IS '商户编号';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."APP_ID" IS '应用编号';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."TYPE" IS '通知类型';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."DATA_ID" IS '数据编号';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."STATUS" IS '通知状态';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."MERCHANT_ORDER_ID" IS '商户订单编号';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."NEXT_NOTIFY_TIME" IS '下一次通知时间';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."LAST_EXECUTE_TIME" IS '最后一次执行时间';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."NOTIFY_TIMES" IS '当前通知次数';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."MAX_NOTIFY_TIMES" IS '最大可通知次数';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."NOTIFY_URL" IS '异步通知地址';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."CREATOR" IS '创建者';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."UPDATER" IS '更新者';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "PAY_NOTIFY_TASK"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "PAY_NOTIFY_TASK" IS '商户支付、退款等的通知
';

-- ----------------------------
-- Records of PAY_NOTIFY_TASK
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for PAY_ORDER
-- ----------------------------
DROP TABLE "PAY_ORDER";
CREATE TABLE "PAY_ORDER" (
  "ID" NUMBER(20,0) NOT NULL,
  "MERCHANT_ID" NUMBER(20,0) NOT NULL,
  "APP_ID" NUMBER(20,0) NOT NULL,
  "CHANNEL_ID" NUMBER(20,0),
  "CHANNEL_CODE" NVARCHAR2(32),
  "MERCHANT_ORDER_ID" NVARCHAR2(64),
  "SUBJECT" NVARCHAR2(32),
  "BODY" NVARCHAR2(128),
  "NOTIFY_URL" NCLOB,
  "NOTIFY_STATUS" NUMBER(4,0) NOT NULL,
  "AMOUNT" NUMBER(20,0) NOT NULL,
  "CHANNEL_FEE_RATE" NUMBER,
  "CHANNEL_FEE_AMOUNT" NUMBER(20,0),
  "STATUS" NUMBER(4,0) NOT NULL,
  "USER_IP" NVARCHAR2(50),
  "EXPIRE_TIME" DATE NOT NULL,
  "SUCCESS_TIME" DATE,
  "NOTIFY_TIME" DATE,
  "SUCCESS_EXTENSION_ID" NUMBER(20,0),
  "REFUND_STATUS" NUMBER(4,0) NOT NULL,
  "REFUND_TIMES" NUMBER(4,0) NOT NULL,
  "REFUND_AMOUNT" NUMBER(20,0) NOT NULL,
  "CHANNEL_USER_ID" NVARCHAR2(255),
  "CHANNEL_ORDER_NO" NVARCHAR2(64),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "PAY_ORDER"."ID" IS '支付订单编号';
COMMENT ON COLUMN "PAY_ORDER"."MERCHANT_ID" IS '商户编号';
COMMENT ON COLUMN "PAY_ORDER"."APP_ID" IS '应用编号';
COMMENT ON COLUMN "PAY_ORDER"."CHANNEL_ID" IS '渠道编号';
COMMENT ON COLUMN "PAY_ORDER"."CHANNEL_CODE" IS '渠道编码';
COMMENT ON COLUMN "PAY_ORDER"."MERCHANT_ORDER_ID" IS '商户订单编号';
COMMENT ON COLUMN "PAY_ORDER"."SUBJECT" IS '商品标题';
COMMENT ON COLUMN "PAY_ORDER"."BODY" IS '商品描述';
COMMENT ON COLUMN "PAY_ORDER"."NOTIFY_URL" IS '异步通知地址';
COMMENT ON COLUMN "PAY_ORDER"."NOTIFY_STATUS" IS '通知商户支付结果的回调状态';
COMMENT ON COLUMN "PAY_ORDER"."AMOUNT" IS '支付金额，单位：分';
COMMENT ON COLUMN "PAY_ORDER"."CHANNEL_FEE_RATE" IS '渠道手续费，单位：百分比';
COMMENT ON COLUMN "PAY_ORDER"."CHANNEL_FEE_AMOUNT" IS '渠道手续金额，单位：分';
COMMENT ON COLUMN "PAY_ORDER"."STATUS" IS '支付状态';
COMMENT ON COLUMN "PAY_ORDER"."USER_IP" IS '用户 IP';
COMMENT ON COLUMN "PAY_ORDER"."EXPIRE_TIME" IS '订单失效时间';
COMMENT ON COLUMN "PAY_ORDER"."SUCCESS_TIME" IS '订单支付成功时间';
COMMENT ON COLUMN "PAY_ORDER"."NOTIFY_TIME" IS '订单支付通知时间';
COMMENT ON COLUMN "PAY_ORDER"."SUCCESS_EXTENSION_ID" IS '支付成功的订单拓展单编号';
COMMENT ON COLUMN "PAY_ORDER"."REFUND_STATUS" IS '退款状态';
COMMENT ON COLUMN "PAY_ORDER"."REFUND_TIMES" IS '退款次数';
COMMENT ON COLUMN "PAY_ORDER"."REFUND_AMOUNT" IS '退款总金额，单位：分';
COMMENT ON COLUMN "PAY_ORDER"."CHANNEL_USER_ID" IS '渠道用户编号';
COMMENT ON COLUMN "PAY_ORDER"."CHANNEL_ORDER_NO" IS '渠道订单号';
COMMENT ON COLUMN "PAY_ORDER"."CREATOR" IS '创建者';
COMMENT ON COLUMN "PAY_ORDER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "PAY_ORDER"."UPDATER" IS '更新者';
COMMENT ON COLUMN "PAY_ORDER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "PAY_ORDER"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "PAY_ORDER" IS '支付订单
';

-- ----------------------------
-- Records of PAY_ORDER
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for PAY_ORDER_EXTENSION
-- ----------------------------
DROP TABLE "PAY_ORDER_EXTENSION";
CREATE TABLE "PAY_ORDER_EXTENSION" (
  "ID" NUMBER(20,0) NOT NULL,
  "NO" NVARCHAR2(64),
  "ORDER_ID" NUMBER(20,0) NOT NULL,
  "CHANNEL_ID" NUMBER(20,0) NOT NULL,
  "CHANNEL_CODE" NVARCHAR2(32),
  "USER_IP" NVARCHAR2(50),
  "STATUS" NUMBER(4,0) NOT NULL,
  "CHANNEL_EXTRAS" NVARCHAR2(256),
  "CHANNEL_NOTIFY_DATA" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."ID" IS '支付订单编号';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."NO" IS '支付订单号';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."ORDER_ID" IS '支付订单编号';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."CHANNEL_ID" IS '渠道编号';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."CHANNEL_CODE" IS '渠道编码';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."USER_IP" IS '用户 IP';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."STATUS" IS '支付状态';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."CHANNEL_EXTRAS" IS '支付渠道的额外参数';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."CHANNEL_NOTIFY_DATA" IS '支付渠道异步通知的内容';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."CREATOR" IS '创建者';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."UPDATER" IS '更新者';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "PAY_ORDER_EXTENSION"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "PAY_ORDER_EXTENSION" IS '支付订单
';

-- ----------------------------
-- Records of PAY_ORDER_EXTENSION
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for PAY_REFUND
-- ----------------------------
DROP TABLE "PAY_REFUND";
CREATE TABLE "PAY_REFUND" (
  "ID" NUMBER(20,0) NOT NULL,
  "MERCHANT_ID" NUMBER(20,0) NOT NULL,
  "APP_ID" NUMBER(20,0) NOT NULL,
  "CHANNEL_ID" NUMBER(20,0) NOT NULL,
  "CHANNEL_CODE" NVARCHAR2(32),
  "ORDER_ID" NUMBER(20,0) NOT NULL,
  "TRADE_NO" NVARCHAR2(64),
  "MERCHANT_ORDER_ID" NVARCHAR2(64),
  "MERCHANT_REFUND_NO" NVARCHAR2(64),
  "NOTIFY_URL" NCLOB,
  "NOTIFY_STATUS" NUMBER(4,0) NOT NULL,
  "STATUS" NUMBER(4,0) NOT NULL,
  "TYPE" NUMBER(4,0) NOT NULL,
  "PAY_AMOUNT" NUMBER(20,0) NOT NULL,
  "REFUND_AMOUNT" NUMBER(20,0) NOT NULL,
  "REASON" NVARCHAR2(256),
  "USER_IP" NVARCHAR2(50),
  "CHANNEL_ORDER_NO" NVARCHAR2(64),
  "CHANNEL_REFUND_NO" NVARCHAR2(64),
  "CHANNEL_ERROR_CODE" NVARCHAR2(128),
  "CHANNEL_ERROR_MSG" NVARCHAR2(256),
  "CHANNEL_EXTRAS" NCLOB,
  "EXPIRE_TIME" DATE,
  "SUCCESS_TIME" DATE,
  "NOTIFY_TIME" DATE,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "PAY_REFUND"."ID" IS '支付退款编号';
COMMENT ON COLUMN "PAY_REFUND"."MERCHANT_ID" IS '商户编号';
COMMENT ON COLUMN "PAY_REFUND"."APP_ID" IS '应用编号';
COMMENT ON COLUMN "PAY_REFUND"."CHANNEL_ID" IS '渠道编号';
COMMENT ON COLUMN "PAY_REFUND"."CHANNEL_CODE" IS '渠道编码';
COMMENT ON COLUMN "PAY_REFUND"."ORDER_ID" IS '支付订单编号 pay_order 表id';
COMMENT ON COLUMN "PAY_REFUND"."TRADE_NO" IS '交易订单号 pay_extension 表no 字段';
COMMENT ON COLUMN "PAY_REFUND"."MERCHANT_ORDER_ID" IS '商户订单编号（商户系统生成）';
COMMENT ON COLUMN "PAY_REFUND"."MERCHANT_REFUND_NO" IS '商户退款订单号（商户系统生成）';
COMMENT ON COLUMN "PAY_REFUND"."NOTIFY_URL" IS '异步通知商户地址';
COMMENT ON COLUMN "PAY_REFUND"."NOTIFY_STATUS" IS '通知商户退款结果的回调状态';
COMMENT ON COLUMN "PAY_REFUND"."STATUS" IS '退款状态';
COMMENT ON COLUMN "PAY_REFUND"."TYPE" IS '退款类型(部分退款，全部退款)';
COMMENT ON COLUMN "PAY_REFUND"."PAY_AMOUNT" IS '支付金额,单位分';
COMMENT ON COLUMN "PAY_REFUND"."REFUND_AMOUNT" IS '退款金额,单位分';
COMMENT ON COLUMN "PAY_REFUND"."REASON" IS '退款原因';
COMMENT ON COLUMN "PAY_REFUND"."USER_IP" IS '用户 IP';
COMMENT ON COLUMN "PAY_REFUND"."CHANNEL_ORDER_NO" IS '渠道订单号，pay_order 中的channel_order_no 对应';
COMMENT ON COLUMN "PAY_REFUND"."CHANNEL_REFUND_NO" IS '渠道退款单号，渠道返回';
COMMENT ON COLUMN "PAY_REFUND"."CHANNEL_ERROR_CODE" IS '渠道调用报错时，错误码';
COMMENT ON COLUMN "PAY_REFUND"."CHANNEL_ERROR_MSG" IS '渠道调用报错时，错误信息';
COMMENT ON COLUMN "PAY_REFUND"."CHANNEL_EXTRAS" IS '支付渠道的额外参数';
COMMENT ON COLUMN "PAY_REFUND"."EXPIRE_TIME" IS '退款失效时间';
COMMENT ON COLUMN "PAY_REFUND"."SUCCESS_TIME" IS '退款成功时间';
COMMENT ON COLUMN "PAY_REFUND"."NOTIFY_TIME" IS '退款通知时间';
COMMENT ON COLUMN "PAY_REFUND"."CREATOR" IS '创建者';
COMMENT ON COLUMN "PAY_REFUND"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "PAY_REFUND"."UPDATER" IS '更新者';
COMMENT ON COLUMN "PAY_REFUND"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "PAY_REFUND"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "PAY_REFUND" IS '退款订单';

-- ----------------------------
-- Records of PAY_REFUND
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_BLOB_TRIGGERS
-- ----------------------------
DROP TABLE "QRTZ_BLOB_TRIGGERS";
CREATE TABLE "QRTZ_BLOB_TRIGGERS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "TRIGGER_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "TRIGGER_GROUP" VARCHAR2(200 BYTE) NOT NULL,
  "BLOB_DATA" BLOB
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_BLOB_TRIGGERS
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_CALENDARS
-- ----------------------------
DROP TABLE "QRTZ_CALENDARS";
CREATE TABLE "QRTZ_CALENDARS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "CALENDAR_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "CALENDAR" BLOB NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_CALENDARS
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_CRON_TRIGGERS
-- ----------------------------
DROP TABLE "QRTZ_CRON_TRIGGERS";
CREATE TABLE "QRTZ_CRON_TRIGGERS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "TRIGGER_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "TRIGGER_GROUP" VARCHAR2(200 BYTE) NOT NULL,
  "CRON_EXPRESSION" VARCHAR2(120 BYTE) NOT NULL,
  "TIME_ZONE_ID" VARCHAR2(80 BYTE)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_CRON_TRIGGERS
-- ----------------------------
INSERT INTO "QRTZ_CRON_TRIGGERS" ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP", "CRON_EXPRESSION", "TIME_ZONE_ID") VALUES ('schedulerName', 'userSessionTimeoutJob', 'DEFAULT', '0 * * * * ? *', 'Asia/Shanghai');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_FIRED_TRIGGERS
-- ----------------------------
DROP TABLE "QRTZ_FIRED_TRIGGERS";
CREATE TABLE "QRTZ_FIRED_TRIGGERS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "ENTRY_ID" VARCHAR2(95 BYTE) NOT NULL,
  "TRIGGER_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "TRIGGER_GROUP" VARCHAR2(200 BYTE) NOT NULL,
  "INSTANCE_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "FIRED_TIME" NUMBER(13,0) NOT NULL,
  "SCHED_TIME" NUMBER(13,0) NOT NULL,
  "PRIORITY" NUMBER(13,0) NOT NULL,
  "STATE" VARCHAR2(16 BYTE) NOT NULL,
  "JOB_NAME" VARCHAR2(200 BYTE),
  "JOB_GROUP" VARCHAR2(200 BYTE),
  "IS_NONCONCURRENT" VARCHAR2(1 BYTE),
  "REQUESTS_RECOVERY" VARCHAR2(1 BYTE)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_FIRED_TRIGGERS
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_JOB_DETAILS
-- ----------------------------
DROP TABLE "QRTZ_JOB_DETAILS";
CREATE TABLE "QRTZ_JOB_DETAILS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "JOB_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "JOB_GROUP" VARCHAR2(200 BYTE) NOT NULL,
  "DESCRIPTION" VARCHAR2(250 BYTE),
  "JOB_CLASS_NAME" VARCHAR2(250 BYTE) NOT NULL,
  "IS_DURABLE" VARCHAR2(1 BYTE) NOT NULL,
  "IS_NONCONCURRENT" VARCHAR2(1 BYTE) NOT NULL,
  "IS_UPDATE_DATA" VARCHAR2(1 BYTE) NOT NULL,
  "REQUESTS_RECOVERY" VARCHAR2(1 BYTE) NOT NULL,
  "JOB_DATA" BLOB
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_JOB_DETAILS
-- ----------------------------
INSERT INTO "QRTZ_JOB_DETAILS" ("SCHED_NAME", "JOB_NAME", "JOB_GROUP", "DESCRIPTION", "JOB_CLASS_NAME", "IS_DURABLE", "IS_NONCONCURRENT", "IS_UPDATE_DATA", "REQUESTS_RECOVERY", "JOB_DATA") VALUES ('schedulerName', 'userSessionTimeoutJob', 'DEFAULT', NULL, 'cn.iocoder.yudao.framework.quartz.core.handler.JobHandlerInvoker', '0', '1', '1', '0', HEXTORAW('ACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C770800000010000000027400064A4F425F49447372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B020000787000000000000000007400104A4F425F48414E444C45525F4E414D457400157573657253657373696F6E54696D656F75744A6F627800'));
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_LOCKS
-- ----------------------------
DROP TABLE "QRTZ_LOCKS";
CREATE TABLE "QRTZ_LOCKS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "LOCK_NAME" VARCHAR2(40 BYTE) NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_LOCKS
-- ----------------------------
INSERT INTO "QRTZ_LOCKS" ("SCHED_NAME", "LOCK_NAME") VALUES ('schedulerName', 'STATE_ACCESS');
INSERT INTO "QRTZ_LOCKS" ("SCHED_NAME", "LOCK_NAME") VALUES ('schedulerName', 'TRIGGER_ACCESS');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_PAUSED_TRIGGER_GRPS
-- ----------------------------
DROP TABLE "QRTZ_PAUSED_TRIGGER_GRPS";
CREATE TABLE "QRTZ_PAUSED_TRIGGER_GRPS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "TRIGGER_GROUP" VARCHAR2(200 BYTE) NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_PAUSED_TRIGGER_GRPS
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_SCHEDULER_STATE
-- ----------------------------
DROP TABLE "QRTZ_SCHEDULER_STATE";
CREATE TABLE "QRTZ_SCHEDULER_STATE" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "INSTANCE_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "LAST_CHECKIN_TIME" NUMBER(13,0) NOT NULL,
  "CHECKIN_INTERVAL" NUMBER(13,0) NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_SCHEDULER_STATE
-- ----------------------------
INSERT INTO "QRTZ_SCHEDULER_STATE" ("SCHED_NAME", "INSTANCE_NAME", "LAST_CHECKIN_TIME", "CHECKIN_INTERVAL") VALUES ('schedulerName', 'Yunai.local1651409076356', '1651409097967', '15000');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
DROP TABLE "QRTZ_SIMPLE_TRIGGERS";
CREATE TABLE "QRTZ_SIMPLE_TRIGGERS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "TRIGGER_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "TRIGGER_GROUP" VARCHAR2(200 BYTE) NOT NULL,
  "REPEAT_COUNT" NUMBER(7,0) NOT NULL,
  "REPEAT_INTERVAL" NUMBER(12,0) NOT NULL,
  "TIMES_TRIGGERED" NUMBER(10,0) NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
DROP TABLE "QRTZ_SIMPROP_TRIGGERS";
CREATE TABLE "QRTZ_SIMPROP_TRIGGERS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "TRIGGER_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "TRIGGER_GROUP" VARCHAR2(200 BYTE) NOT NULL,
  "STR_PROP_1" VARCHAR2(512 BYTE),
  "STR_PROP_2" VARCHAR2(512 BYTE),
  "STR_PROP_3" VARCHAR2(512 BYTE),
  "INT_PROP_1" NUMBER(10,0),
  "INT_PROP_2" NUMBER(10,0),
  "LONG_PROP_1" NUMBER(13,0),
  "LONG_PROP_2" NUMBER(13,0),
  "DEC_PROP_1" NUMBER(13,4),
  "DEC_PROP_2" NUMBER(13,4),
  "BOOL_PROP_1" VARCHAR2(1 BYTE),
  "BOOL_PROP_2" VARCHAR2(1 BYTE)
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for QRTZ_TRIGGERS
-- ----------------------------
DROP TABLE "QRTZ_TRIGGERS";
CREATE TABLE "QRTZ_TRIGGERS" (
  "SCHED_NAME" VARCHAR2(120 BYTE) NOT NULL,
  "TRIGGER_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "TRIGGER_GROUP" VARCHAR2(200 BYTE) NOT NULL,
  "JOB_NAME" VARCHAR2(200 BYTE) NOT NULL,
  "JOB_GROUP" VARCHAR2(200 BYTE) NOT NULL,
  "DESCRIPTION" VARCHAR2(250 BYTE),
  "NEXT_FIRE_TIME" NUMBER(13,0),
  "PREV_FIRE_TIME" NUMBER(13,0),
  "PRIORITY" NUMBER(13,0),
  "TRIGGER_STATE" VARCHAR2(16 BYTE) NOT NULL,
  "TRIGGER_TYPE" VARCHAR2(8 BYTE) NOT NULL,
  "START_TIME" NUMBER(13,0) NOT NULL,
  "END_TIME" NUMBER(13,0),
  "CALENDAR_NAME" VARCHAR2(200 BYTE),
  "MISFIRE_INSTR" NUMBER(2,0),
  "JOB_DATA" BLOB
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;

-- ----------------------------
-- Records of QRTZ_TRIGGERS
-- ----------------------------
INSERT INTO "QRTZ_TRIGGERS" ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP", "JOB_NAME", "JOB_GROUP", "DESCRIPTION", "NEXT_FIRE_TIME", "PREV_FIRE_TIME", "PRIORITY", "TRIGGER_STATE", "TRIGGER_TYPE", "START_TIME", "END_TIME", "CALENDAR_NAME", "MISFIRE_INSTR", "JOB_DATA") VALUES ('schedulerName', 'userSessionTimeoutJob', 'DEFAULT', 'userSessionTimeoutJob', 'DEFAULT', NULL, '1651409160000', '1651409100000', '5', 'WAITING', 'CRON', '1651409043000', '0', NULL, '0', HEXTORAW('ACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C770800000010000000037400114A4F425F48414E444C45525F504152414D707400124A4F425F52455452595F494E54455256414C737200116A6176612E6C616E672E496E746567657212E2A0A4F781873802000149000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000007D074000F4A4F425F52455452595F434F554E547371007E0009000000037800'));
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_DEPT
-- ----------------------------
DROP TABLE "SYSTEM_DEPT";
CREATE TABLE "SYSTEM_DEPT" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(30),
  "PARENT_ID" NUMBER(20,0) NOT NULL,
  "SORT" NUMBER(11,0) NOT NULL,
  "LEADER_USER_ID" NUMBER(20,0),
  "PHONE" NVARCHAR2(11),
  "EMAIL" NVARCHAR2(50),
  "STATUS" NUMBER(4,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_DEPT"."ID" IS '部门id';
COMMENT ON COLUMN "SYSTEM_DEPT"."NAME" IS '部门名称';
COMMENT ON COLUMN "SYSTEM_DEPT"."PARENT_ID" IS '父部门id';
COMMENT ON COLUMN "SYSTEM_DEPT"."SORT" IS '显示顺序';
COMMENT ON COLUMN "SYSTEM_DEPT"."LEADER_USER_ID" IS '负责人';
COMMENT ON COLUMN "SYSTEM_DEPT"."PHONE" IS '联系电话';
COMMENT ON COLUMN "SYSTEM_DEPT"."EMAIL" IS '邮箱';
COMMENT ON COLUMN "SYSTEM_DEPT"."STATUS" IS '部门状态（0正常 1停用）';
COMMENT ON COLUMN "SYSTEM_DEPT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_DEPT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_DEPT"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_DEPT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_DEPT"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_DEPT"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_DEPT" IS '部门表';

-- ----------------------------
-- Records of SYSTEM_DEPT
-- ----------------------------
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('100', '芋道源码', '0', '0', '1', '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-14 01:04:05', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('101', '深圳总公司', '100', '1', '104', '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 19:47:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('102', '长沙分公司', '100', '2', NULL, '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 05:01:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('103', '研发部门', '101', '1', '104', '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-14 01:04:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('104', '市场部门', '101', '2', NULL, '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 05:01:38', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('105', '测试部门', '101', '3', NULL, '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 05:01:37', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('106', '财务部门', '101', '4', '103', '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-15 21:32:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('107', '运维部门', '101', '5', NULL, '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 05:01:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('108', '市场部门', '102', '1', NULL, '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 08:35:45', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('109', '财务部门', '102', '2', NULL, '15888888888', 'ry@qq.com', '0', 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-15 05:01:29', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('110', '新部门', '0', '1', NULL, NULL, NULL, '0', '110', TO_DATE('2022-02-23 20:46:30', 'SYYYY-MM-DD HH24:MI:SS'), '110', TO_DATE('2022-02-23 20:46:30', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_DEPT" ("ID", "NAME", "PARENT_ID", "SORT", "LEADER_USER_ID", "PHONE", "EMAIL", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('111', '顶级部门', '0', '1', NULL, NULL, NULL, '0', '113', TO_DATE('2022-03-07 21:44:50', 'SYYYY-MM-DD HH24:MI:SS'), '113', TO_DATE('2022-03-07 21:44:50', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_DICT_DATA
-- ----------------------------
DROP TABLE "SYSTEM_DICT_DATA";
CREATE TABLE "SYSTEM_DICT_DATA" (
  "ID" NUMBER(20,0) NOT NULL,
  "SORT" NUMBER(11,0) NOT NULL,
  "LABEL" NVARCHAR2(100),
  "VALUE" NVARCHAR2(100),
  "DICT_TYPE" NVARCHAR2(100),
  "STATUS" NUMBER(4,0) NOT NULL,
  "COLOR_TYPE" NVARCHAR2(100),
  "CSS_CLASS" NVARCHAR2(100),
  "REMARK" NVARCHAR2(500),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."ID" IS '字典编码';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."SORT" IS '字典排序';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."LABEL" IS '字典标签';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."VALUE" IS '字典键值';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."DICT_TYPE" IS '字典类型';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."STATUS" IS '状态（0正常 1停用）';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."COLOR_TYPE" IS '颜色类型';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."CSS_CLASS" IS 'css 样式';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."REMARK" IS '备注';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_DICT_DATA"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_DICT_DATA" IS '字典数据表';

-- ----------------------------
-- Records of SYSTEM_DICT_DATA
-- ----------------------------
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1143', '20', '流程发起人的一级领导', '20', 'bpm_task_assign_script', '0', NULL, NULL, '任务分配自定义脚本 - 流程发起人的一级领导', '103', TO_DATE('2022-01-15 21:24:31', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-15 21:24:31', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1144', '21', '流程发起人的二级领导', '21', 'bpm_task_assign_script', '0', NULL, NULL, '任务分配自定义脚本 - 流程发起人的二级领导', '103', TO_DATE('2022-01-15 21:24:46', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-15 21:24:57', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1145', '1', '管理后台', '1', 'infra_codegen_scene', '0', NULL, NULL, '代码生成的场景枚举 - 管理后台', '1', TO_DATE('2022-02-02 13:15:06', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-10 16:32:59', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1146', '2', '用户 APP', '2', 'infra_codegen_scene', '0', NULL, NULL, '代码生成的场景枚举 - 用户 APP', '1', TO_DATE('2022-02-02 13:15:19', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-10 16:33:03', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1147', '0', '未退款', '0', 'pay_refund_order_type', '0', 'info', NULL, '退款类型 - 未退款', '1', TO_DATE('2022-02-16 14:09:01', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 14:09:01', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1148', '10', '部分退款', '10', 'pay_refund_order_type', '0', 'success', NULL, '退款类型 - 部分退款', '1', TO_DATE('2022-02-16 14:09:25', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 14:11:38', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1149', '20', '全部退款', '20', 'pay_refund_order_type', '0', 'warning', NULL, '退款类型 - 全部退款', '1', TO_DATE('2022-02-16 14:11:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 14:11:33', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1150', '1', '数据库', '1', 'infra_file_storage', '0', 'default', NULL, NULL, '1', TO_DATE('2022-03-15 00:25:28', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-15 00:25:28', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1151', '10', '本地磁盘', '10', 'infra_file_storage', '0', 'default', NULL, NULL, '1', TO_DATE('2022-03-15 00:25:41', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-15 00:25:56', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1152', '11', 'FTP 服务器', '11', 'infra_file_storage', '0', 'default', NULL, NULL, '1', TO_DATE('2022-03-15 00:26:06', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-15 00:26:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1153', '12', 'SFTP 服务器', '12', 'infra_file_storage', '0', 'default', NULL, NULL, '1', TO_DATE('2022-03-15 00:26:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-15 00:26:22', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1154', '20', 'S3 对象存储', '20', 'infra_file_storage', '0', 'default', NULL, NULL, '1', TO_DATE('2022-03-15 00:26:31', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-15 00:26:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1155', '103', '短信登录', '103', 'system_login_type', '0', 'default', NULL, NULL, '1', TO_DATE('2022-05-09 23:57:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-09 23:58:09', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1156', '1', 'password', 'password', 'system_oauth2_grant_type', '0', 'default', NULL, '密码模式', '1', TO_DATE('2022-05-12 00:22:05', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 16:26:01', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1157', '2', 'authorization_code', 'authorization_code', 'system_oauth2_grant_type', '0', 'primary', NULL, '授权码模式', '1', TO_DATE('2022-05-12 00:22:59', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 16:26:02', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1158', '3', 'implicit', 'implicit', 'system_oauth2_grant_type', '0', 'success', NULL, '简化模式', '1', TO_DATE('2022-05-12 00:23:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 16:26:05', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1159', '4', 'client_credentials', 'client_credentials', 'system_oauth2_grant_type', '0', 'default', NULL, '客户端模式', '1', TO_DATE('2022-05-12 00:23:51', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 16:26:08', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1160', '5', 'refresh_token', 'refresh_token', 'system_oauth2_grant_type', '0', 'info', NULL, '刷新模式', '1', TO_DATE('2022-05-12 00:24:02', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 16:26:11', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('79', '2', '手动编辑', '2', 'system_error_code_type', '0', 'primary', NULL, NULL, '1', TO_DATE('2021-04-21 00:07:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:57:24', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('80', '100', '账号登录', '100', 'system_login_type', '0', 'primary', NULL, '账号登录', '1', TO_DATE('2021-10-06 00:52:02', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('81', '101', '社交登录', '101', 'system_login_type', '0', 'info', NULL, '社交登录', '1', TO_DATE('2021-10-06 00:52:17', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:11:40', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('83', '200', '主动登出', '200', 'system_login_type', '0', 'primary', NULL, '主动登出', '1', TO_DATE('2021-10-06 00:52:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:11:49', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('85', '202', '强制登出', '202', 'system_login_type', '0', 'danger', NULL, '强制退出', '1', TO_DATE('2021-10-06 00:53:41', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:11:57', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('86', '0', '病假', '1', 'bpm_oa_leave_type', '0', 'primary', NULL, NULL, '1', TO_DATE('2021-09-21 22:35:28', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:00:41', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('87', '1', '事假', '2', 'bpm_oa_leave_type', '0', 'info', NULL, NULL, '1', TO_DATE('2021-09-21 22:36:11', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:00:49', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('88', '2', '婚假', '3', 'bpm_oa_leave_type', '0', 'warning', NULL, NULL, '1', TO_DATE('2021-09-21 22:36:38', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:00:53', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('98', '1', 'v2', 'v2', 'pay_channel_wechat_version', '0', NULL, NULL, 'v2版本', '1', TO_DATE('2021-11-08 17:00:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-08 17:00:58', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('99', '2', 'v3', 'v3', 'pay_channel_wechat_version', '0', NULL, NULL, 'v3版本', '1', TO_DATE('2021-11-08 17:01:07', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-08 17:01:07', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('108', '1', 'RSA2', 'RSA2', 'pay_channel_alipay_sign_type', '0', NULL, NULL, 'RSA2', '1', TO_DATE('2021-11-18 15:39:29', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-18 15:39:29', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('109', '1', '公钥模式', '1', 'pay_channel_alipay_mode', '0', NULL, NULL, '公钥模式：privateKey + alipayPublicKey', '1', TO_DATE('2021-11-18 15:45:23', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-18 15:45:23', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('110', '2', '证书模式', '2', 'pay_channel_alipay_mode', '0', NULL, NULL, '证书模式：appCertContent + alipayPublicCertContent + rootCertContent', '1', TO_DATE('2021-11-18 15:45:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-18 15:45:40', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('111', '1', '线上', 'https://openapi.alipay.com/gateway.do', 'pay_channel_alipay_server_type', '0', NULL, NULL, '网关地址 - 线上', '1', TO_DATE('2021-11-18 16:59:32', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-21 17:37:29', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('112', '2', '沙箱', 'https://openapi.alipaydev.com/gateway.do', 'pay_channel_alipay_server_type', '0', NULL, NULL, '网关地址 - 沙箱', '1', TO_DATE('2021-11-18 16:59:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-21 17:37:39', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('113', '1', '微信 JSAPI 支付', 'wx_pub', 'pay_channel_code_type', '0', NULL, NULL, '微信 JSAPI（公众号） 支付', '1', TO_DATE('2021-12-03 10:40:24', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-04 16:41:00', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('114', '2', '微信小程序支付', 'wx_lite', 'pay_channel_code_type', '0', NULL, NULL, '微信小程序支付', '1', TO_DATE('2021-12-03 10:41:06', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 10:41:06', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('115', '3', '微信 App 支付', 'wx_app', 'pay_channel_code_type', '0', NULL, NULL, '微信 App 支付', '1', TO_DATE('2021-12-03 10:41:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 10:41:20', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('116', '4', '支付宝 PC 网站支付', 'alipay_pc', 'pay_channel_code_type', '0', NULL, NULL, '支付宝 PC 网站支付', '1', TO_DATE('2021-12-03 10:42:09', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 10:42:09', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('117', '5', '支付宝 Wap 网站支付', 'alipay_wap', 'pay_channel_code_type', '0', NULL, NULL, '支付宝 Wap 网站支付', '1', TO_DATE('2021-12-03 10:42:26', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 10:42:26', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('118', '6', '支付宝App 支付', 'alipay_app', 'pay_channel_code_type', '0', NULL, NULL, '支付宝App 支付', '1', TO_DATE('2021-12-03 10:42:55', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 10:42:55', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('119', '7', '支付宝扫码支付', 'alipay_qr', 'pay_channel_code_type', '0', NULL, NULL, '支付宝扫码支付', '1', TO_DATE('2021-12-03 10:43:10', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 10:43:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('120', '1', '通知成功', '10', 'pay_order_notify_status', '0', 'success', NULL, '通知成功', '1', TO_DATE('2021-12-03 11:02:41', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:59:13', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('121', '2', '通知失败', '20', 'pay_order_notify_status', '0', 'danger', NULL, '通知失败', '1', TO_DATE('2021-12-03 11:02:59', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:59:17', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('122', '3', '未通知', '0', 'pay_order_notify_status', '0', 'info', NULL, '未通知', '1', TO_DATE('2021-12-03 11:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:59:23', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('123', '1', '支付成功', '10', 'pay_order_status', '0', 'success', NULL, '支付成功', '1', TO_DATE('2021-12-03 11:18:29', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 15:24:25', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('124', '2', '支付关闭', '20', 'pay_order_status', '0', 'danger', NULL, '支付关闭', '1', TO_DATE('2021-12-03 11:18:42', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 15:24:31', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('125', '3', '未支付', '0', 'pay_order_status', '0', 'info', NULL, '未支付', '1', TO_DATE('2021-12-03 11:18:18', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 15:24:35', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('126', '1', '未退款', '0', 'pay_order_refund_status', '0', NULL, NULL, '未退款', '1', TO_DATE('2021-12-03 11:30:35', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 11:34:05', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('127', '2', '部分退款', '10', 'pay_order_refund_status', '0', NULL, NULL, '部分退款', '1', TO_DATE('2021-12-03 11:30:44', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 11:34:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('128', '3', '全部退款', '20', 'pay_order_refund_status', '0', NULL, NULL, '全部退款', '1', TO_DATE('2021-12-03 11:30:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 11:34:14', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1117', '1', '退款订单生成', '0', 'pay_refund_order_status', '0', 'primary', NULL, '退款订单生成', '1', TO_DATE('2021-12-10 16:44:44', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 14:05:24', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1118', '2', '退款成功', '1', 'pay_refund_order_status', '0', 'success', NULL, '退款成功', '1', TO_DATE('2021-12-10 16:44:59', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 14:05:28', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1119', '3', '退款失败', '2', 'pay_refund_order_status', '0', 'danger', NULL, '退款失败', '1', TO_DATE('2021-12-10 16:45:10', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 14:05:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1124', '8', '退款关闭', '99', 'pay_refund_order_status', '0', 'info', NULL, '退款关闭', '1', TO_DATE('2021-12-10 16:46:26', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 14:05:40', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1125', '0', '默认', '1', 'bpm_model_category', '0', 'primary', NULL, '流程分类 - 默认', '1', TO_DATE('2022-01-02 08:41:11', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:01:42', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1126', '0', 'OA', '2', 'bpm_model_category', '0', 'success', NULL, '流程分类 - OA', '1', TO_DATE('2022-01-02 08:41:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:01:50', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1127', '0', '进行中', '1', 'bpm_process_instance_status', '0', 'primary', NULL, '流程实例的状态 - 进行中', '1', TO_DATE('2022-01-07 23:47:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:07:49', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1128', '2', '已完成', '2', 'bpm_process_instance_status', '0', 'success', NULL, '流程实例的状态 - 已完成', '1', TO_DATE('2022-01-07 23:47:49', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:07:54', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1129', '1', '处理中', '1', 'bpm_process_instance_result', '0', 'primary', NULL, '流程实例的结果 - 处理中', '1', TO_DATE('2022-01-07 23:48:32', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:53:26', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1130', '2', '通过', '2', 'bpm_process_instance_result', '0', 'success', NULL, '流程实例的结果 - 通过', '1', TO_DATE('2022-01-07 23:48:45', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:53:31', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1131', '3', '不通过', '3', 'bpm_process_instance_result', '0', 'danger', NULL, '流程实例的结果 - 不通过', '1', TO_DATE('2022-01-07 23:48:55', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:53:38', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1132', '4', '已取消', '4', 'bpm_process_instance_result', '0', 'info', NULL, '流程实例的结果 - 撤销', '1', TO_DATE('2022-01-07 23:49:06', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:53:42', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1133', '10', '流程表单', '10', 'bpm_model_form_type', '0', NULL, NULL, '流程的表单类型 - 流程表单', '103', TO_DATE('2022-01-11 23:51:30', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-11 23:51:30', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1134', '20', '业务表单', '20', 'bpm_model_form_type', '0', NULL, NULL, '流程的表单类型 - 业务表单', '103', TO_DATE('2022-01-11 23:51:47', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-11 23:51:47', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1135', '10', '角色', '10', 'bpm_task_assign_rule_type', '0', 'info', NULL, '任务分配规则的类型 - 角色', '103', TO_DATE('2022-01-12 23:21:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:06:14', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1136', '20', '部门的成员', '20', 'bpm_task_assign_rule_type', '0', 'primary', NULL, '任务分配规则的类型 - 部门的成员', '103', TO_DATE('2022-01-12 23:21:47', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:05:28', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1137', '21', '部门的负责人', '21', 'bpm_task_assign_rule_type', '0', 'primary', NULL, '任务分配规则的类型 - 部门的负责人', '103', TO_DATE('2022-01-12 23:33:36', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:05:31', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1138', '30', '用户', '30', 'bpm_task_assign_rule_type', '0', 'info', NULL, '任务分配规则的类型 - 用户', '103', TO_DATE('2022-01-12 23:34:02', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:05:50', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1139', '40', '用户组', '40', 'bpm_task_assign_rule_type', '0', 'warning', NULL, '任务分配规则的类型 - 用户组', '103', TO_DATE('2022-01-12 23:34:21', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:05:57', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1140', '50', '自定义脚本', '50', 'bpm_task_assign_rule_type', '0', 'danger', NULL, '任务分配规则的类型 - 自定义脚本', '103', TO_DATE('2022-01-12 23:34:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:06:01', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1141', '22', '岗位', '22', 'bpm_task_assign_rule_type', '0', 'success', NULL, '任务分配规则的类型 - 岗位', '103', TO_DATE('2022-01-14 18:41:55', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:05:39', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1142', '10', '流程发起人', '10', 'bpm_task_assign_script', '0', NULL, NULL, '任务分配自定义脚本 - 流程发起人', '103', TO_DATE('2022-01-15 00:10:57', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-15 21:24:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1', '1', '男', '1', 'system_user_sex', '0', 'default', 'A', '性别男', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-29 00:14:39', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('2', '2', '女', '2', 'system_user_sex', '1', 'success', NULL, '性别女', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 01:30:51', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('8', '1', '正常', '1', 'infra_job_status', '0', 'success', NULL, '正常状态', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:33:38', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('9', '2', '暂停', '2', 'infra_job_status', '0', 'danger', NULL, '停用状态', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:33:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('12', '1', '系统内置', '1', 'infra_config_type', '0', 'danger', NULL, '参数类型 - 系统内置', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:06:02', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('13', '2', '自定义', '2', 'infra_config_type', '0', 'primary', NULL, '参数类型 - 自定义', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:06:07', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('14', '1', '通知', '1', 'system_notice_type', '0', 'success', NULL, '通知', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:05:57', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('15', '2', '公告', '2', 'system_notice_type', '0', 'info', NULL, '公告', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:06:01', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('16', '0', '其它', '0', 'system_operate_type', '0', 'default', NULL, '其它操作', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:32:46', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('17', '1', '查询', '1', 'system_operate_type', '0', 'info', NULL, '查询操作', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:33:16', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('18', '2', '新增', '2', 'system_operate_type', '0', 'primary', NULL, '新增操作', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:33:13', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('19', '3', '修改', '3', 'system_operate_type', '0', 'warning', NULL, '修改操作', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:33:22', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('20', '4', '删除', '4', 'system_operate_type', '0', 'danger', NULL, '删除操作', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:33:27', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('22', '5', '导出', '5', 'system_operate_type', '0', 'default', NULL, '导出操作', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:33:32', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('23', '6', '导入', '6', 'system_operate_type', '0', 'default', NULL, '导入操作', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:33:35', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('27', '1', '开启', '0', 'common_status', '0', 'primary', NULL, '开启状态', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 08:00:39', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('28', '2', '关闭', '1', 'common_status', '0', 'info', NULL, '关闭状态', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 08:00:44', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('29', '1', '目录', '1', 'system_menu_type', '0', NULL, NULL, '目录', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:43:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('30', '2', '菜单', '2', 'system_menu_type', '0', NULL, NULL, '菜单', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:43:41', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('31', '3', '按钮', '3', 'system_menu_type', '0', NULL, NULL, '按钮', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:43:39', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('32', '1', '内置', '1', 'system_role_type', '0', 'danger', NULL, '内置角色', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:02:08', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('33', '2', '自定义', '2', 'system_role_type', '0', 'primary', NULL, '自定义角色', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:02:12', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('34', '1', '全部数据权限', '1', 'system_data_scope', '0', NULL, NULL, '全部数据权限', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:47:17', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('35', '2', '指定部门数据权限', '2', 'system_data_scope', '0', NULL, NULL, '指定部门数据权限', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:47:18', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('36', '3', '本部门数据权限', '3', 'system_data_scope', '0', NULL, NULL, '本部门数据权限', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:47:16', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('37', '4', '本部门及以下数据权限', '4', 'system_data_scope', '0', NULL, NULL, '本部门及以下数据权限', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:47:21', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('38', '5', '仅本人数据权限', '5', 'system_data_scope', '0', NULL, NULL, '仅本人数据权限', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:47:23', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('39', '0', '成功', '0', 'system_login_result', '0', 'success', NULL, '登陆结果 - 成功', NULL, TO_DATE('2021-01-18 06:17:36', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:23:49', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('40', '10', '账号或密码不正确', '10', 'system_login_result', '0', 'primary', NULL, '登陆结果 - 账号或密码不正确', NULL, TO_DATE('2021-01-18 06:17:54', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:24:27', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('41', '20', '用户被禁用', '20', 'system_login_result', '0', 'warning', NULL, '登陆结果 - 用户被禁用', NULL, TO_DATE('2021-01-18 06:17:54', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:23:57', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('42', '30', '验证码不存在', '30', 'system_login_result', '0', 'info', NULL, '登陆结果 - 验证码不存在', NULL, TO_DATE('2021-01-18 06:17:54', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:24:07', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('43', '31', '验证码不正确', '31', 'system_login_result', '0', 'info', NULL, '登陆结果 - 验证码不正确', NULL, TO_DATE('2021-01-18 06:17:54', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:24:11', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('44', '100', '未知异常', '100', 'system_login_result', '0', 'danger', NULL, '登陆结果 - 未知异常', NULL, TO_DATE('2021-01-18 06:17:54', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:24:23', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('45', '1', '是', 'true', 'infra_boolean_string', '0', 'danger', NULL, 'Boolean 是否类型 - 是', NULL, TO_DATE('2021-01-19 03:20:55', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-15 23:01:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('46', '1', '否', 'false', 'infra_boolean_string', '0', 'info', NULL, 'Boolean 是否类型 - 否', NULL, TO_DATE('2021-01-19 03:20:55', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-15 23:09:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('47', '1', '永不超时', '1', 'infra_redis_timeout_type', '0', 'primary', NULL, 'Redis 未设置超时的情况', NULL, TO_DATE('2021-01-26 00:53:17', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:03:35', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('48', '1', '动态超时', '2', 'infra_redis_timeout_type', '0', 'info', NULL, '程序里动态传入超时时间，无法固定', NULL, TO_DATE('2021-01-26 00:55:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:03:41', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('49', '3', '固定超时', '3', 'infra_redis_timeout_type', '0', 'success', NULL, 'Redis 设置了过期时间', NULL, TO_DATE('2021-01-26 00:55:26', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:03:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('50', '1', '单表（增删改查）', '1', 'infra_codegen_template_type', '0', NULL, NULL, NULL, NULL, TO_DATE('2021-02-05 07:09:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-03-10 16:33:15', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('51', '2', '树表（增删改查）', '2', 'infra_codegen_template_type', '0', NULL, NULL, NULL, NULL, TO_DATE('2021-02-05 07:14:46', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-03-10 16:33:19', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('53', '0', '初始化中', '0', 'infra_job_status', '0', 'primary', NULL, NULL, NULL, TO_DATE('2021-02-07 07:46:49', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:33:29', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('57', '0', '运行中', '0', 'infra_job_log_status', '0', 'primary', NULL, 'RUNNING', NULL, TO_DATE('2021-02-08 10:04:24', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:07:48', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('58', '1', '成功', '1', 'infra_job_log_status', '0', 'success', NULL, NULL, NULL, TO_DATE('2021-02-08 10:06:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:07:52', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('59', '2', '失败', '2', 'infra_job_log_status', '0', 'warning', NULL, '失败', NULL, TO_DATE('2021-02-08 10:07:38', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 19:07:56', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('60', '1', '会员', '1', 'user_type', '0', 'primary', NULL, NULL, NULL, TO_DATE('2021-02-26 00:16:27', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:22:19', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('61', '2', '管理员', '2', 'user_type', '0', 'success', NULL, NULL, NULL, TO_DATE('2021-02-26 00:16:34', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:22:22', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('62', '0', '未处理', '0', 'infra_api_error_log_process_status', '0', 'primary', NULL, NULL, NULL, TO_DATE('2021-02-26 07:07:19', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:14:17', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('63', '1', '已处理', '1', 'infra_api_error_log_process_status', '0', 'success', NULL, NULL, NULL, TO_DATE('2021-02-26 07:07:26', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:14:08', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('64', '2', '已忽略', '2', 'infra_api_error_log_process_status', '0', 'danger', NULL, NULL, NULL, TO_DATE('2021-02-26 07:07:34', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 20:14:14', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('65', '1', '云片', 'YUN_PIAN', 'system_sms_channel_code', '0', 'success', NULL, NULL, '1', TO_DATE('2021-04-05 01:05:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:09:55', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('66', '2', '阿里云', 'ALIYUN', 'system_sms_channel_code', '0', 'primary', NULL, NULL, '1', TO_DATE('2021-04-05 01:05:26', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:09:52', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('67', '1', '验证码', '1', 'system_sms_template_type', '0', 'warning', NULL, NULL, '1', TO_DATE('2021-04-05 21:50:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 12:48:30', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('68', '2', '通知', '2', 'system_sms_template_type', '0', 'primary', NULL, NULL, '1', TO_DATE('2021-04-05 21:51:08', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 12:48:27', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('69', '0', '营销', '3', 'system_sms_template_type', '0', 'danger', NULL, NULL, '1', TO_DATE('2021-04-05 21:51:15', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 12:48:22', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('70', '0', '初始化', '0', 'system_sms_send_status', '0', 'primary', NULL, NULL, '1', TO_DATE('2021-04-11 20:18:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:26:07', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('71', '1', '发送成功', '10', 'system_sms_send_status', '0', 'success', NULL, NULL, '1', TO_DATE('2021-04-11 20:18:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:25:56', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('72', '2', '发送失败', '20', 'system_sms_send_status', '0', 'danger', NULL, NULL, '1', TO_DATE('2021-04-11 20:18:49', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:26:03', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('73', '3', '不发送', '30', 'system_sms_send_status', '0', 'info', NULL, NULL, '1', TO_DATE('2021-04-11 20:19:44', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:26:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('74', '0', '等待结果', '0', 'system_sms_receive_status', '0', 'primary', NULL, NULL, '1', TO_DATE('2021-04-11 20:27:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:28:24', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('75', '1', '接收成功', '10', 'system_sms_receive_status', '0', 'success', NULL, NULL, '1', TO_DATE('2021-04-11 20:29:25', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:28:28', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('76', '2', '接收失败', '20', 'system_sms_receive_status', '0', 'danger', NULL, NULL, '1', TO_DATE('2021-04-11 20:29:31', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:28:32', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('77', '0', '调试(钉钉)', 'DEBUG_DING_TALK', 'system_sms_channel_code', '0', 'info', NULL, NULL, '1', TO_DATE('2021-04-13 00:20:37', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 10:10:00', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_DATA" ("ID", "SORT", "LABEL", "VALUE", "DICT_TYPE", "STATUS", "COLOR_TYPE", "CSS_CLASS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('78', '1', '自动生成', '1', 'system_error_code_type', '0', 'warning', NULL, NULL, '1', TO_DATE('2021-04-21 00:06:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:57:20', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_DICT_TYPE
-- ----------------------------
DROP TABLE "SYSTEM_DICT_TYPE";
CREATE TABLE "SYSTEM_DICT_TYPE" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(100),
  "TYPE" NVARCHAR2(100),
  "STATUS" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(500),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."ID" IS '字典主键';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."NAME" IS '字典名称';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."TYPE" IS '字典类型';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."STATUS" IS '状态（0正常 1停用）';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."REMARK" IS '备注';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_DICT_TYPE"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_DICT_TYPE" IS '字典类型表';

-- ----------------------------
-- Records of SYSTEM_DICT_TYPE
-- ----------------------------
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1', '用户性别', 'system_user_sex', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 12:55:56', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('6', '参数类型', 'infra_config_type', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:36:54', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('7', '通知类型', 'system_notice_type', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:35:26', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('9', '操作类型', 'system_operate_type', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 09:32:21', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('10', '系统状态', 'common_status', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:21:28', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('11', 'Boolean 是否类型', 'infra_boolean_string', '0', 'boolean 转是否', NULL, TO_DATE('2021-01-19 03:20:08', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:37:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('104', '登陆结果', 'system_login_result', '0', '登陆结果', NULL, TO_DATE('2021-01-18 06:17:11', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:36:00', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('105', 'Redis 超时类型', 'infra_redis_timeout_type', '0', 'RedisKeyDefine.TimeoutTypeEnum', NULL, TO_DATE('2021-01-26 00:52:50', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:50:29', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('106', '代码生成模板类型', 'infra_codegen_template_type', '0', NULL, NULL, TO_DATE('2021-02-05 07:08:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-03-10 16:33:42', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('107', '定时任务状态', 'infra_job_status', '0', NULL, NULL, TO_DATE('2021-02-07 07:44:16', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:51:11', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('108', '定时任务日志状态', 'infra_job_log_status', '0', NULL, NULL, TO_DATE('2021-02-08 10:03:51', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:50:43', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('109', '用户类型', 'user_type', '0', NULL, NULL, TO_DATE('2021-02-26 00:15:51', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-02-26 00:15:51', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('110', 'API 异常数据的处理状态', 'infra_api_error_log_process_status', '0', NULL, NULL, TO_DATE('2021-02-26 07:07:01', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-01 16:50:53', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('111', '短信渠道编码', 'system_sms_channel_code', '0', NULL, '1', TO_DATE('2021-04-05 01:04:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 02:09:08', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('112', '短信模板的类型', 'system_sms_template_type', '0', NULL, '1', TO_DATE('2021-04-05 21:50:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-01 16:35:06', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('113', '短信发送状态', 'system_sms_send_status', '0', NULL, '1', TO_DATE('2021-04-11 20:18:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-01 16:35:09', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('114', '短信接收状态', 'system_sms_receive_status', '0', NULL, '1', TO_DATE('2021-04-11 20:27:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-01 16:35:14', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('115', '错误码的类型', 'system_error_code_type', '0', NULL, '1', TO_DATE('2021-04-21 00:06:30', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-01 16:36:49', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('116', '登陆日志的类型', 'system_login_type', '0', '登陆日志的类型', '1', TO_DATE('2021-10-06 00:50:46', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-01 16:35:56', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('117', 'OA 请假类型', 'bpm_oa_leave_type', '0', NULL, '1', TO_DATE('2021-09-21 22:34:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-01-22 10:41:37', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('122', '支付渠道微信版本', 'pay_channel_wechat_version', '0', '支付渠道微信版本', '1', TO_DATE('2021-11-08 17:00:26', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-08 17:00:26', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('127', '支付渠道支付宝算法类型', 'pay_channel_alipay_sign_type', '0', '支付渠道支付宝算法类型', '1', TO_DATE('2021-11-18 15:39:09', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-18 15:39:09', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('128', '支付渠道支付宝公钥类型', 'pay_channel_alipay_mode', '0', '支付渠道支付宝公钥类型', '1', TO_DATE('2021-11-18 15:44:28', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-18 15:44:28', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('129', '支付宝网关地址', 'pay_channel_alipay_server_type', '0', '支付宝网关地址', '1', TO_DATE('2021-11-18 16:58:55', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-11-18 17:01:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('130', '支付渠道编码类型', 'pay_channel_code_type', '0', '支付渠道的编码', '1', TO_DATE('2021-12-03 10:35:08', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 10:35:08', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('131', '支付订单回调状态', 'pay_order_notify_status', '0', '支付订单回调状态', '1', TO_DATE('2021-12-03 10:53:29', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 10:53:29', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('132', '支付订单状态', 'pay_order_status', '0', '支付订单状态', '1', TO_DATE('2021-12-03 11:17:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 11:17:50', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('133', '支付订单退款状态', 'pay_order_refund_status', '0', '支付订单退款状态', '1', TO_DATE('2021-12-03 11:27:31', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-03 11:27:31', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('134', '退款订单状态', 'pay_refund_order_status', '0', '退款订单状态', '1', TO_DATE('2021-12-10 16:42:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-10 16:42:50', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('135', '退款订单类别', 'pay_refund_order_type', '0', '退款订单类别', '1', TO_DATE('2021-12-10 17:14:53', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-10 17:14:53', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('138', '流程分类', 'bpm_model_category', '0', '流程分类', '1', TO_DATE('2022-01-02 08:40:45', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-01-02 08:40:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('139', '流程实例的状态', 'bpm_process_instance_status', '0', '流程实例的状态', '1', TO_DATE('2022-01-07 23:46:42', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-01-07 23:46:42', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('140', '流程实例的结果', 'bpm_process_instance_result', '0', '流程实例的结果', '1', TO_DATE('2022-01-07 23:48:10', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-01-07 23:48:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('141', '流程的表单类型', 'bpm_model_form_type', '0', '流程的表单类型', '103', TO_DATE('2022-01-11 23:50:45', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-11 23:50:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('142', '任务分配规则的类型', 'bpm_task_assign_rule_type', '0', '任务分配规则的类型', '103', TO_DATE('2022-01-12 23:21:04', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-12 15:46:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('143', '任务分配自定义脚本', 'bpm_task_assign_script', '0', '任务分配自定义脚本', '103', TO_DATE('2022-01-15 00:10:35', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-01-15 00:10:35', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('144', '代码生成的场景枚举', 'infra_codegen_scene', '0', '代码生成的场景枚举', '1', TO_DATE('2022-02-02 13:14:45', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-10 16:33:46', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('145', '角色类型', 'system_role_type', '0', '角色类型', '1', TO_DATE('2022-02-16 13:01:46', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-16 13:01:46', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_DICT_TYPE" ("ID", "NAME", "TYPE", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('146', '文件存储器', 'infra_file_storage', '0', '文件存储器', '1', TO_DATE('2022-03-15 00:24:38', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-15 00:24:38', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_ERROR_CODE
-- ----------------------------
DROP TABLE "SYSTEM_ERROR_CODE";
CREATE TABLE "SYSTEM_ERROR_CODE" (
  "ID" NUMBER(20,0) NOT NULL,
  "TYPE" NUMBER(4,0) NOT NULL,
  "APPLICATION_NAME" NVARCHAR2(50),
  "CODE" NUMBER(11,0) NOT NULL,
  "MESSAGE" NVARCHAR2(512),
  "MEMO" NVARCHAR2(512),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."ID" IS '错误码编号';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."TYPE" IS '错误码类型';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."APPLICATION_NAME" IS '应用名';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."CODE" IS '错误码编码';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."MESSAGE" IS '错误码错误提示';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."MEMO" IS '备注';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_ERROR_CODE"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_ERROR_CODE" IS '错误码表';

-- ----------------------------
-- Records of SYSTEM_ERROR_CODE
-- ----------------------------
INSERT INTO "SYSTEM_ERROR_CODE" ("ID", "TYPE", "APPLICATION_NAME", "CODE", "MESSAGE", "MEMO", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('0', '1', 'yudao-server', '1001007000', '数据源配置不存在', NULL, NULL, TO_DATE('2022-05-01 01:08:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-01 01:08:31', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_ERROR_CODE" ("ID", "TYPE", "APPLICATION_NAME", "CODE", "MESSAGE", "MEMO", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('0', '1', 'yudao-server', '1009000002', '获取高亮流程图异常', NULL, NULL, TO_DATE('2022-05-13 01:26:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-13 01:26:47', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_LOGIN_LOG
-- ----------------------------
DROP TABLE "SYSTEM_LOGIN_LOG";
CREATE TABLE "SYSTEM_LOGIN_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "LOG_TYPE" NUMBER(20,0) NOT NULL,
  "TRACE_ID" NVARCHAR2(64),
  "USER_ID" NUMBER(20,0) NOT NULL,
  "USER_TYPE" NUMBER(4,0) NOT NULL,
  "USERNAME" NVARCHAR2(50),
  "RESULT" NUMBER(4,0) NOT NULL,
  "USER_IP" NVARCHAR2(50),
  "USER_AGENT" NVARCHAR2(512),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."ID" IS '访问ID';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."LOG_TYPE" IS '日志类型';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."TRACE_ID" IS '链路追踪编号';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."USERNAME" IS '用户账号';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."RESULT" IS '登陆结果';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."USER_IP" IS '用户 IP';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."USER_AGENT" IS '浏览器 UA';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_LOGIN_LOG"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_LOGIN_LOG" IS '系统访问记录';

-- ----------------------------
-- Records of SYSTEM_LOGIN_LOG
-- ----------------------------
INSERT INTO "SYSTEM_LOGIN_LOG" ("ID", "LOG_TYPE", "TRACE_ID", "USER_ID", "USER_TYPE", "USERNAME", "RESULT", "USER_IP", "USER_AGENT", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('0', '100', NULL, '1', '2', 'admin', '0', '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36', NULL, TO_DATE('2022-05-13 01:27:36', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-13 01:27:36', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_MENU
-- ----------------------------
DROP TABLE "SYSTEM_MENU";
CREATE TABLE "SYSTEM_MENU" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(50) NOT NULL,
  "PERMISSION" NVARCHAR2(100),
  "TYPE" NUMBER(6,0) NOT NULL,
  "SORT" NUMBER(11,0) NOT NULL,
  "PARENT_ID" NUMBER(20,0) NOT NULL,
  "PATH" NVARCHAR2(200),
  "ICON" NVARCHAR2(100),
  "COMPONENT" NVARCHAR2(255),
  "STATUS" NUMBER(6,0) NOT NULL,
  "VISIBLE" NVARCHAR2(4) NOT NULL,
  "KEEP_ALIVE" NVARCHAR2(4) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(6,0) NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_MENU"."ID" IS '菜单ID';
COMMENT ON COLUMN "SYSTEM_MENU"."NAME" IS '菜单名称';
COMMENT ON COLUMN "SYSTEM_MENU"."PERMISSION" IS '权限标识';
COMMENT ON COLUMN "SYSTEM_MENU"."TYPE" IS '菜单类型';
COMMENT ON COLUMN "SYSTEM_MENU"."SORT" IS '显示顺序';
COMMENT ON COLUMN "SYSTEM_MENU"."PARENT_ID" IS '父菜单ID';
COMMENT ON COLUMN "SYSTEM_MENU"."PATH" IS '路由地址';
COMMENT ON COLUMN "SYSTEM_MENU"."ICON" IS '菜单图标';
COMMENT ON COLUMN "SYSTEM_MENU"."COMPONENT" IS '组件路径';
COMMENT ON COLUMN "SYSTEM_MENU"."STATUS" IS '菜单状态';
COMMENT ON COLUMN "SYSTEM_MENU"."VISIBLE" IS '是否可见';
COMMENT ON COLUMN "SYSTEM_MENU"."KEEP_ALIVE" IS '是否缓存';
COMMENT ON COLUMN "SYSTEM_MENU"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_MENU"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_MENU"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_MENU"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_MENU"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_MENU" IS '菜单权限表';

-- ----------------------------
-- Records of SYSTEM_MENU
-- ----------------------------
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1', '系统管理', NULL, '1', '10', '0', '/system', 'system', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('2', '基础设施', NULL, '1', '20', '0', '/infra', 'monitor', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('5', 'OA 示例', NULL, '1', '40', '1185', 'oa', 'people', NULL, '0', '1', '1', 'admin', TO_DATE('2021-09-20 16:26:19', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('100', '用户管理', 'system:user:list', '2', '1', '1', 'user', 'user', 'system/user/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('101', '角色管理', NULL, '2', '2', '1', 'role', 'peoples', 'system/role/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('102', '菜单管理', NULL, '2', '3', '1', 'menu', 'tree-table', 'system/menu/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('103', '部门管理', NULL, '2', '4', '1', 'dept', 'tree', 'system/dept/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('104', '岗位管理', NULL, '2', '5', '1', 'post', 'post', 'system/post/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('105', '字典管理', NULL, '2', '6', '1', 'dict', 'dict', 'system/dict/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('106', '配置管理', NULL, '2', '6', '2', 'config', 'edit', 'infra/config/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('107', '通知公告', NULL, '2', '8', '1', 'notice', 'message', 'system/notice/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('108', '审计日志', NULL, '1', '9', '1', 'log', 'log', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('109', '令牌管理', NULL, '2', '2', '1261', 'token', 'online', 'system/oauth2/token/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 23:31:42', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('110', '定时任务', NULL, '2', '12', '2', 'job', 'job', 'infra/job/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('111', 'MySQL 监控', NULL, '2', '9', '2', 'druid', 'druid', 'infra/druid/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('112', 'Java 监控', NULL, '2', '11', '2', 'admin-server', 'server', 'infra/server/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('113', 'Redis 监控', NULL, '2', '10', '2', 'redis', 'redis', 'infra/redis/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('114', '表单构建', 'infra:build:list', '2', '2', '2', 'build', 'build', 'infra/build/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('115', '代码生成', 'infra:codegen:query', '2', '1', '2', 'codegen', 'code', 'infra/codegen/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('116', '系统接口', 'infra:swagger:list', '2', '3', '2', 'swagger', 'swagger', 'infra/swagger/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('500', '操作日志', NULL, '2', '1', '108', 'operate-log', 'form', 'system/operatelog/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('501', '登录日志', NULL, '2', '2', '108', 'login-log', 'logininfor', 'system/loginlog/index', '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1001', '用户查询', 'system:user:query', '3', '1', '100', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1002', '用户新增', 'system:user:create', '3', '2', '100', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1003', '用户修改', 'system:user:update', '3', '3', '100', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1004', '用户删除', 'system:user:delete', '3', '4', '100', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1005', '用户导出', 'system:user:export', '3', '5', '100', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1006', '用户导入', 'system:user:import', '3', '6', '100', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1007', '重置密码', 'system:user:update-password', '3', '7', '100', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1008', '角色查询', 'system:role:query', '3', '1', '101', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1009', '角色新增', 'system:role:create', '3', '2', '101', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1010', '角色修改', 'system:role:update', '3', '3', '101', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1011', '角色删除', 'system:role:delete', '3', '4', '101', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1012', '角色导出', 'system:role:export', '3', '5', '101', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1013', '菜单查询', 'system:menu:query', '3', '1', '102', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1014', '菜单新增', 'system:menu:create', '3', '2', '102', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1015', '菜单修改', 'system:menu:update', '3', '3', '102', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1016', '菜单删除', 'system:menu:delete', '3', '4', '102', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1017', '部门查询', 'system:dept:query', '3', '1', '103', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1018', '部门新增', 'system:dept:create', '3', '2', '103', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1019', '部门修改', 'system:dept:update', '3', '3', '103', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1020', '部门删除', 'system:dept:delete', '3', '4', '103', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1021', '岗位查询', 'system:post:query', '3', '1', '104', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1022', '岗位新增', 'system:post:create', '3', '2', '104', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1023', '岗位修改', 'system:post:update', '3', '3', '104', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1024', '岗位删除', 'system:post:delete', '3', '4', '104', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1025', '岗位导出', 'system:post:export', '3', '5', '104', NULL, '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1026', '字典查询', 'system:dict:query', '3', '1', '105', '#', '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1027', '字典新增', 'system:dict:create', '3', '2', '105', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1028', '字典修改', 'system:dict:update', '3', '3', '105', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1029', '字典删除', 'system:dict:delete', '3', '4', '105', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1030', '字典导出', 'system:dict:export', '3', '5', '105', '#', '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1031', '配置查询', 'infra:config:query', '3', '1', '106', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1032', '配置新增', 'infra:config:create', '3', '2', '106', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1033', '配置修改', 'infra:config:update', '3', '3', '106', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1034', '配置删除', 'infra:config:delete', '3', '4', '106', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1035', '配置导出', 'infra:config:export', '3', '5', '106', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1036', '公告查询', 'system:notice:query', '3', '1', '107', '#', '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1037', '公告新增', 'system:notice:create', '3', '2', '107', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1038', '公告修改', 'system:notice:update', '3', '3', '107', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1039', '公告删除', 'system:notice:delete', '3', '4', '107', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1040', '操作查询', 'system:operate-log:query', '3', '1', '500', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1042', '日志导出', 'system:operate-log:export', '3', '2', '500', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1043', '登录查询', 'system:login-log:query', '3', '1', '501', '#', '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1045', '日志导出', 'system:login-log:export', '3', '3', '501', '#', '#', NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1046', '令牌列表', 'system:oauth2-token:page', '3', '1', '109', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-09 23:54:42', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1048', '令牌删除', 'system:oauth2-token:delete', '3', '2', '109', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-09 23:54:53', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1050', '任务新增', 'infra:job:create', '3', '2', '110', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1051', '任务修改', 'infra:job:update', '3', '3', '110', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1052', '任务删除', 'infra:job:delete', '3', '4', '110', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1053', '状态修改', 'infra:job:update', '3', '5', '110', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1054', '任务导出', 'infra:job:export', '3', '7', '110', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1056', '生成修改', 'infra:codegen:update', '3', '2', '115', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1057', '生成删除', 'infra:codegen:delete', '3', '3', '115', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1058', '导入代码', 'infra:codegen:create', '3', '2', '115', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1059', '预览代码', 'infra:codegen:preview', '3', '4', '115', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1060', '生成代码', 'infra:codegen:download', '3', '5', '115', NULL, NULL, NULL, '0', '1', '1', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1063', '设置角色菜单权限', 'system:permission:assign-role-menu', '3', '6', '101', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-01-06 17:53:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1064', '设置角色数据权限', 'system:permission:assign-role-data-scope', '3', '7', '101', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-01-06 17:56:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1065', '设置用户角色', 'system:permission:assign-user-role', '3', '8', '101', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-01-07 10:23:28', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1066', '获得 Redis 监控信息', 'infra:redis:get-monitor-info', '3', '1', '113', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-01-26 01:02:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1067', '获得 Redis Key 列表', 'infra:redis:get-key-list', '3', '2', '113', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-01-26 01:02:52', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1070', '代码生成示例', 'infra:test-demo:query', '2', '1', '2', 'test-demo', 'validCode', 'infra/testDemo/index', '0', '1', '1', NULL, TO_DATE('2021-02-06 12:42:49', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1071', '测试示例表创建', 'infra:test-demo:create', '3', '1', '1070', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-02-06 12:42:49', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1072', '测试示例表更新', 'infra:test-demo:update', '3', '2', '1070', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-02-06 12:42:49', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1073', '测试示例表删除', 'infra:test-demo:delete', '3', '3', '1070', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-02-06 12:42:49', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1074', '测试示例表导出', 'infra:test-demo:export', '3', '4', '1070', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-02-06 12:42:49', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1075', '任务触发', 'infra:job:trigger', '3', '8', '110', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-02-07 13:03:10', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1076', '数据库文档', NULL, '2', '4', '2', 'db-doc', 'table', 'infra/dbDoc/index', '0', '1', '1', NULL, TO_DATE('2021-02-08 01:41:47', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1077', '监控平台', NULL, '2', '13', '2', 'skywalking', 'eye-open', 'infra/skywalking/index', '0', '1', '1', NULL, TO_DATE('2021-02-08 20:41:31', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1078', '访问日志', NULL, '2', '1', '1083', 'api-access-log', 'log', 'infra/apiAccessLog/index', '0', '1', '1', NULL, TO_DATE('2021-02-26 01:32:59', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1082', '日志导出', 'infra:api-access-log:export', '3', '2', '1078', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-02-26 01:32:59', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1083', 'API 日志', NULL, '2', '8', '2', 'log', 'log', NULL, '0', '1', '1', NULL, TO_DATE('2021-02-26 02:18:24', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1084', '错误日志', 'infra:api-error-log:query', '2', '2', '1083', 'api-error-log', 'log', 'infra/apiErrorLog/index', '0', '1', '1', NULL, TO_DATE('2021-02-26 07:53:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1085', '日志处理', 'infra:api-error-log:update-status', '3', '2', '1084', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-02-26 07:53:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1086', '日志导出', 'infra:api-error-log:export', '3', '3', '1084', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-02-26 07:53:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1087', '任务查询', 'infra:job:query', '3', '1', '110', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2021-03-10 01:26:19', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1088', '日志查询', 'infra:api-access-log:query', '3', '1', '1078', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2021-03-10 01:28:04', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1089', '日志查询', 'infra:api-error-log:query', '3', '1', '1084', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2021-03-10 01:29:09', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1090', '文件列表', NULL, '2', '5', '1243', 'file', 'upload', 'infra/file/index', '0', '1', '1', NULL, TO_DATE('2021-03-12 20:16:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1091', '文件查询', 'infra:file:query', '3', '1', '1090', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-03-12 20:16:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1092', '文件删除', 'infra:file:delete', '3', '4', '1090', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-03-12 20:16:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1093', '短信管理', NULL, '1', '11', '1', 'sms', 'validCode', NULL, '0', '1', '1', '1', TO_DATE('2021-04-05 01:10:16', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1094', '短信渠道', NULL, '2', '0', '1093', 'sms-channel', 'phone', 'system/sms/smsChannel', '0', '1', '1', NULL, TO_DATE('2021-04-01 11:07:15', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1095', '短信渠道查询', 'system:sms-channel:query', '3', '1', '1094', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 11:07:15', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1096', '短信渠道创建', 'system:sms-channel:create', '3', '2', '1094', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 11:07:15', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1097', '短信渠道更新', 'system:sms-channel:update', '3', '3', '1094', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 11:07:15', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1098', '短信渠道删除', 'system:sms-channel:delete', '3', '4', '1094', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 11:07:15', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1100', '短信模板', NULL, '2', '1', '1093', 'sms-template', 'phone', 'system/sms/smsTemplate', '0', '1', '1', NULL, TO_DATE('2021-04-01 17:35:17', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1101', '短信模板查询', 'system:sms-template:query', '3', '1', '1100', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 17:35:17', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1102', '短信模板创建', 'system:sms-template:create', '3', '2', '1100', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 17:35:17', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1103', '短信模板更新', 'system:sms-template:update', '3', '3', '1100', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 17:35:17', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1104', '短信模板删除', 'system:sms-template:delete', '3', '4', '1100', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 17:35:17', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1105', '短信模板导出', 'system:sms-template:export', '3', '5', '1100', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-01 17:35:17', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1106', '发送测试短信', 'system:sms-template:send-sms', '3', '6', '1100', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2021-04-11 00:26:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1107', '短信日志', NULL, '2', '2', '1093', 'sms-log', 'phone', 'system/sms/smsLog', '0', '1', '1', NULL, TO_DATE('2021-04-11 08:37:05', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1108', '短信日志查询', 'system:sms-log:query', '3', '1', '1107', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-11 08:37:05', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1109', '短信日志导出', 'system:sms-log:export', '3', '5', '1107', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-11 08:37:05', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1110', '错误码管理', NULL, '2', '12', '1', 'error-code', 'code', 'system/errorCode/index', '0', '1', '1', NULL, TO_DATE('2021-04-13 21:46:42', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1111', '错误码查询', 'system:error-code:query', '3', '1', '1110', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-13 21:46:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1112', '错误码创建', 'system:error-code:create', '3', '2', '1110', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-13 21:46:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1113', '错误码更新', 'system:error-code:update', '3', '3', '1110', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-13 21:46:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1114', '错误码删除', 'system:error-code:delete', '3', '4', '1110', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-13 21:46:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1115', '错误码导出', 'system:error-code:export', '3', '5', '1110', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-04-13 21:46:42', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1117', '支付管理', NULL, '1', '11', '0', '/pay', 'money', NULL, '0', '1', '1', '1', TO_DATE('2021-12-25 16:43:41', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1118', '请假查询', NULL, '2', '0', '5', 'leave', 'user', 'bpm/oa/leave/index', '0', '1', '1', NULL, TO_DATE('2021-09-20 08:51:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1119', '请假申请查询', 'bpm:oa-leave:query', '3', '1', '1118', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-09-20 08:51:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1120', '请假申请创建', 'bpm:oa-leave:create', '3', '2', '1118', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-09-20 08:51:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1126', '应用信息', NULL, '2', '1', '1117', 'app', 'table', 'pay/app/index', '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:30', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1127', '支付应用信息查询', 'pay:app:query', '3', '1', '1126', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1128', '支付应用信息创建', 'pay:app:create', '3', '2', '1126', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1129', '支付应用信息更新', 'pay:app:update', '3', '3', '1126', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1130', '支付应用信息删除', 'pay:app:delete', '3', '4', '1126', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1131', '支付应用信息导出', 'pay:app:export', '3', '5', '1126', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:31', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1132', '秘钥解析', 'pay:channel:parsing', '3', '6', '1129', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2021-11-08 15:15:47', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1133', '支付商户信息查询', 'pay:merchant:query', '3', '1', '1132', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1134', '支付商户信息创建', 'pay:merchant:create', '3', '2', '1132', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1135', '支付商户信息更新', 'pay:merchant:update', '3', '3', '1132', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1136', '支付商户信息删除', 'pay:merchant:delete', '3', '4', '1132', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1137', '支付商户信息导出', 'pay:merchant:export', '3', '5', '1132', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-11-10 01:13:41', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1138', '租户列表', NULL, '2', '0', '1224', 'list', 'peoples', 'system/tenant/index', '0', '1', '1', NULL, TO_DATE('2021-12-14 12:31:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1139', '租户查询', 'system:tenant:query', '3', '1', '1138', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-14 12:31:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1140', '租户创建', 'system:tenant:create', '3', '2', '1138', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-14 12:31:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1141', '租户更新', 'system:tenant:update', '3', '3', '1138', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-14 12:31:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1142', '租户删除', 'system:tenant:delete', '3', '4', '1138', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-14 12:31:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1143', '租户导出', 'system:tenant:export', '3', '5', '1138', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-14 12:31:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1150', '秘钥解析', NULL, '3', '6', '1129', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2021-11-08 15:15:47', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1161', '退款订单', NULL, '2', '3', '1117', 'refund', 'order', 'pay/refund/index', '0', '1', '1', NULL, TO_DATE('2021-12-25 08:29:07', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1162', '退款订单查询', 'pay:refund:query', '3', '1', '1161', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:29:07', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1163', '退款订单创建', 'pay:refund:create', '3', '2', '1161', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:29:07', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1164', '退款订单更新', 'pay:refund:update', '3', '3', '1161', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:29:07', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1165', '退款订单删除', 'pay:refund:delete', '3', '4', '1161', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:29:07', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1166', '退款订单导出', 'pay:refund:export', '3', '5', '1161', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:29:07', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1173', '支付订单', NULL, '2', '2', '1117', 'order', 'pay', 'pay/order/index', '0', '1', '1', NULL, TO_DATE('2021-12-25 08:49:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1174', '支付订单查询', 'pay:order:query', '3', '1', '1173', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:49:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1175', '支付订单创建', 'pay:order:create', '3', '2', '1173', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:49:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1176', '支付订单更新', 'pay:order:update', '3', '3', '1173', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:49:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1177', '支付订单删除', 'pay:order:delete', '3', '4', '1173', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:49:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1178', '支付订单导出', 'pay:order:export', '3', '5', '1173', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 08:49:43', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1179', '商户信息', NULL, '2', '0', '1117', 'merchant', 'merchant', 'pay/merchant/index', '0', '1', '1', NULL, TO_DATE('2021-12-25 09:01:44', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1180', '支付商户信息查询', 'pay:merchant:query', '3', '1', '1179', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 09:01:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1181', '支付商户信息创建', 'pay:merchant:create', '3', '2', '1179', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 09:01:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1182', '支付商户信息更新', 'pay:merchant:update', '3', '3', '1179', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 09:01:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1183', '支付商户信息删除', NULL, '3', '4', '1179', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 09:01:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1184', '支付商户信息导出', 'pay:merchant:export', '3', '5', '1179', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-25 09:01:44', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1185', '工作流程', NULL, '1', '50', '0', '/bpm', 'tool', NULL, '0', '1', '1', '1', TO_DATE('2021-12-30 20:26:36', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1186', '流程管理', NULL, '1', '10', '1185', 'manager', 'nested', NULL, '0', '1', '1', '1', TO_DATE('2021-12-30 20:28:30', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1187', '流程表单', NULL, '2', '0', '1186', 'form', 'form', 'bpm/form/index', '0', '1', '1', NULL, TO_DATE('2021-12-30 12:38:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1188', '表单查询', 'bpm:form:query', '3', '1', '1187', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-30 12:38:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1189', '表单创建', 'bpm:form:create', '3', '2', '1187', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-30 12:38:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1190', '表单更新', 'bpm:form:update', '3', '3', '1187', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-30 12:38:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1191', '表单删除', 'bpm:form:delete', '3', '4', '1187', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-30 12:38:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1192', '表单导出', 'bpm:form:export', '3', '5', '1187', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2021-12-30 12:38:22', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1193', '流程模型', NULL, '2', '5', '1186', 'model', 'guide', 'bpm/model/index', '0', '1', '1', '1', TO_DATE('2021-12-31 23:24:58', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1194', '模型查询', 'bpm:model:query', '3', '1', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-03 19:01:10', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1195', '模型创建', 'bpm:model:create', '3', '2', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-03 19:01:24', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1196', '模型导入', 'bpm:model:import', '3', '3', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-03 19:01:35', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1197', '模型更新', 'bpm:model:update', '3', '4', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-03 19:02:28', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1198', '模型删除', 'bpm:model:delete', '3', '5', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-03 19:02:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1199', '模型发布', 'bpm:model:deploy', '3', '6', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-03 19:03:24', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1200', '任务管理', NULL, '1', '20', '1185', 'task', 'cascader', NULL, '0', '1', '1', '1', TO_DATE('2022-01-07 23:51:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1201', '我的流程', NULL, '2', '0', '1200', 'my', 'people', 'bpm/processInstance/index', '0', '1', '1', NULL, TO_DATE('2022-01-07 15:53:44', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1202', '流程实例的查询', 'bpm:process-instance:query', '3', '1', '1201', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-01-07 15:53:44', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1207', '待办任务', NULL, '2', '10', '1200', 'todo', 'eye-open', 'bpm/task/todo', '0', '1', '1', '1', TO_DATE('2022-01-08 10:33:37', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1208', '已办任务', NULL, '2', '20', '1200', 'done', 'eye', 'bpm/task/done', '0', '1', '1', '1', TO_DATE('2022-01-08 10:34:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1209', '用户分组', NULL, '2', '2', '1186', 'user-group', 'people', 'bpm/group/index', '0', '1', '1', NULL, TO_DATE('2022-01-14 02:14:20', 'SYYYY-MM-DD HH24:MI:SS'), '103', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1210', '用户组查询', 'bpm:user-group:query', '3', '1', '1209', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-01-14 02:14:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1211', '用户组创建', 'bpm:user-group:create', '3', '2', '1209', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-01-14 02:14:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1212', '用户组更新', 'bpm:user-group:update', '3', '3', '1209', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-01-14 02:14:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1213', '用户组删除', 'bpm:user-group:delete', '3', '4', '1209', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-01-14 02:14:20', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1215', '流程定义查询', 'bpm:process-definition:query', '3', '10', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-23 00:21:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1216', '流程任务分配规则查询', 'bpm:task-assign-rule:query', '3', '20', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-23 00:26:53', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1217', '流程任务分配规则创建', 'bpm:task-assign-rule:create', '3', '21', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-23 00:28:15', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1218', '流程任务分配规则更新', 'bpm:task-assign-rule:update', '3', '22', '1193', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-23 00:28:41', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1219', '流程实例的创建', 'bpm:process-instance:create', '3', '2', '1201', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-23 00:36:15', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1220', '流程实例的取消', 'bpm:process-instance:cancel', '3', '3', '1201', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-23 00:36:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1221', '流程任务的查询', 'bpm:task:query', '3', '1', '1207', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-23 00:38:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1222', '流程任务的更新', 'bpm:task:update', '3', '2', '1207', NULL, NULL, NULL, '0', '1', '1', '1', TO_DATE('2022-01-23 00:39:24', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1224', '租户管理', NULL, '2', '0', '1', 'tenant', 'peoples', NULL, '0', '1', '1', '1', TO_DATE('2022-02-20 01:41:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1225', '租户套餐', NULL, '2', '0', '1224', 'package', 'eye', 'system/tenantPackage/index', '0', '1', '1', NULL, TO_DATE('2022-02-19 17:44:06', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-21 01:21:25', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1226', '租户套餐查询', 'system:tenant-package:query', '3', '1', '1225', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-02-19 17:44:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1227', '租户套餐创建', 'system:tenant-package:create', '3', '2', '1225', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-02-19 17:44:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1228', '租户套餐更新', 'system:tenant-package:update', '3', '3', '1225', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-02-19 17:44:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1229', '租户套餐删除', 'system:tenant-package:delete', '3', '4', '1225', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-02-19 17:44:06', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1237', '文件配置', NULL, '2', '0', '1243', 'file-config', 'config', 'infra/fileConfig/index', '0', '1', '1', NULL, TO_DATE('2022-03-15 14:35:28', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1238', '文件配置查询', 'infra:file-config:query', '3', '1', '1237', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-03-15 14:35:28', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1239', '文件配置创建', 'infra:file-config:create', '3', '2', '1237', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-03-15 14:35:28', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1240', '文件配置更新', 'infra:file-config:update', '3', '3', '1237', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-03-15 14:35:28', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1241', '文件配置删除', 'infra:file-config:delete', '3', '4', '1237', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-03-15 14:35:28', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1242', '文件配置导出', 'infra:file-config:export', '3', '5', '1237', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-03-15 14:35:28', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1243', '文件管理', NULL, '2', '5', '2', 'file', 'download', NULL, '0', '1', '1', '1', TO_DATE('2022-03-16 23:47:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1247', '敏感词管理', NULL, '2', '13', '1', 'sensitive-word', 'education', 'system/sensitiveWord/index', '0', '1', '1', NULL, TO_DATE('2022-04-07 16:55:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1248', '敏感词查询', 'system:sensitive-word:query', '3', '1', '1247', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-07 16:55:03', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1249', '敏感词创建', 'system:sensitive-word:create', '3', '2', '1247', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-07 16:55:03', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1250', '敏感词更新', 'system:sensitive-word:update', '3', '3', '1247', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-07 16:55:03', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1251', '敏感词删除', 'system:sensitive-word:delete', '3', '4', '1247', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-07 16:55:03', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1252', '敏感词导出', 'system:sensitive-word:export', '3', '5', '1247', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-07 16:55:03', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-20 17:03:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1254', '作者动态', NULL, '1', '0', '0', 'https://www.iocoder.cn', 'people', NULL, '0', '1', '1', '1', TO_DATE('2022-04-23 01:03:15', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1255', '数据源配置', NULL, '2', '1', '2', 'data-source-config', 'rate', 'infra/dataSourceConfig/index', '0', '1', '1', NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-27 22:42:06', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1256', '数据源配置查询', 'infra:data-source-config:query', '3', '1', '1255', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1257', '数据源配置创建', 'infra:data-source-config:create', '3', '2', '1255', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1258', '数据源配置更新', 'infra:data-source-config:update', '3', '3', '1255', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1259', '数据源配置删除', 'infra:data-source-config:delete', '3', '4', '1255', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1260', '数据源配置导出', 'infra:data-source-config:export', '3', '5', '1255', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-04-27 14:37:32', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1261', 'OAuth 2.0', NULL, '1', '10', '1', 'oauth2', 'people', NULL, '0', '1', '1', '1', TO_DATE('2022-05-09 23:38:17', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 18:11:34', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1263', '应用管理', NULL, '2', '0', '1261', 'oauth2/application', 'tool', 'system/oauth2/client/index', '0', '1', '1', NULL, TO_DATE('2022-05-10 16:26:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 23:31:36', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1264', '客户端查询', 'system:oauth2-client:query', '3', '1', '1263', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-05-10 16:26:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 00:31:06', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1265', '客户端创建', 'system:oauth2-client:create', '3', '2', '1263', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-05-10 16:26:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 00:31:23', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1266', '客户端更新', 'system:oauth2-client:update', '3', '3', '1263', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-05-10 16:26:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 00:31:28', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_MENU" ("ID", "NAME", "PERMISSION", "TYPE", "SORT", "PARENT_ID", "PATH", "ICON", "COMPONENT", "STATUS", "VISIBLE", "KEEP_ALIVE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1267', '客户端删除', 'system:oauth2-client:delete', '3', '4', '1263', NULL, NULL, NULL, '0', '1', '1', NULL, TO_DATE('2022-05-10 16:26:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-11 00:31:33', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_NOTICE
-- ----------------------------
DROP TABLE "SYSTEM_NOTICE";
CREATE TABLE "SYSTEM_NOTICE" (
  "ID" NUMBER(20,0) NOT NULL,
  "TITLE" NVARCHAR2(50),
  "CONTENT" NCLOB NOT NULL,
  "NOTICE_TYPE" NUMBER(4,0) NOT NULL,
  "STATUS" NUMBER(4,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_NOTICE"."ID" IS '公告ID';
COMMENT ON COLUMN "SYSTEM_NOTICE"."TITLE" IS '公告标题';
COMMENT ON COLUMN "SYSTEM_NOTICE"."CONTENT" IS '公告内容';
COMMENT ON COLUMN "SYSTEM_NOTICE"."NOTICE_TYPE" IS '公告类型（1通知 2公告）';
COMMENT ON COLUMN "SYSTEM_NOTICE"."STATUS" IS '公告状态（0正常 1关闭）';
COMMENT ON COLUMN "SYSTEM_NOTICE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_NOTICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_NOTICE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_NOTICE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_NOTICE"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_NOTICE"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_NOTICE" IS '通知公告表';

-- ----------------------------
-- Records of SYSTEM_NOTICE
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_OAUTH2_ACCESS_TOKEN
-- ----------------------------
DROP TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN";
CREATE TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" (
  "ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "ACCESS_TOKEN" NVARCHAR2(255) NOT NULL,
  "REFRESH_TOKEN" NVARCHAR2(32) NOT NULL,
  "USER_TYPE" NUMBER(4,0) NOT NULL,
  "CLIENT_ID" NVARCHAR2(255) NOT NULL,
  "EXPIRES_TIME" DATE NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0 NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "SCOPES" NVARCHAR2(255) DEFAULT ''
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."ACCESS_TOKEN" IS '访问令牌';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."REFRESH_TOKEN" IS '刷新令牌';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."CLIENT_ID" IS '客户端编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."EXPIRES_TIME" IS '过期时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."DELETED" IS '是否删除';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_ACCESS_TOKEN"."SCOPES" IS '授权范围';
COMMENT ON TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" IS '刷新令牌';

-- ----------------------------
-- Records of SYSTEM_OAUTH2_ACCESS_TOKEN
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_OAUTH2_APPROVE
-- ----------------------------
DROP TABLE "SYSTEM_OAUTH2_APPROVE";
CREATE TABLE "SYSTEM_OAUTH2_APPROVE" (
  "ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "USER_TYPE" NUMBER(4,0) NOT NULL,
  "CLIENT_ID" NVARCHAR2(255) NOT NULL,
  "SCOPE" NVARCHAR2(255) NOT NULL,
  "APPROVED" VARCHAR2(1 BYTE) NOT NULL,
  "EXPIRES_TIME" DATE NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0 NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."CLIENT_ID" IS '客户端编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."SCOPE" IS '授权范围';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."APPROVED" IS '是否接受';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."EXPIRES_TIME" IS '过期时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."DELETED" IS '是否删除';
COMMENT ON COLUMN "SYSTEM_OAUTH2_APPROVE"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "SYSTEM_OAUTH2_APPROVE" IS 'OAuth2 批准表';

-- ----------------------------
-- Records of SYSTEM_OAUTH2_APPROVE
-- ----------------------------
INSERT INTO "SYSTEM_OAUTH2_APPROVE" ("ID", "USER_ID", "USER_TYPE", "CLIENT_ID", "SCOPE", "APPROVED", "EXPIRES_TIME", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED", "TENANT_ID") VALUES ('42', '1', '2', 'default', 'user.write', '1', TO_DATE('2022-06-25 00:36:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-26 00:35:06', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-26 00:36:50', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYSTEM_OAUTH2_APPROVE" ("ID", "USER_ID", "USER_TYPE", "CLIENT_ID", "SCOPE", "APPROVED", "EXPIRES_TIME", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED", "TENANT_ID") VALUES ('43', '1', '2', 'default', 'user.read', '1', TO_DATE('2022-06-25 00:36:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-26 00:35:06', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-26 00:36:50', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_OAUTH2_CLIENT
-- ----------------------------
DROP TABLE "SYSTEM_OAUTH2_CLIENT";
CREATE TABLE "SYSTEM_OAUTH2_CLIENT" (
  "ID" NUMBER(20,0) NOT NULL,
  "CLIENT_ID" NVARCHAR2(255) NOT NULL,
  "SECRET" NVARCHAR2(255) NOT NULL,
  "NAME" NVARCHAR2(255) NOT NULL,
  "LOGO" NVARCHAR2(255) NOT NULL,
  "DESCRIPTION" NVARCHAR2(255),
  "STATUS" NUMBER(4,0) NOT NULL,
  "ACCESS_TOKEN_VALIDITY_SECONDS" NUMBER(11,0) NOT NULL,
  "REFRESH_TOKEN_VALIDITY_SECONDS" NUMBER(11,0) NOT NULL,
  "REDIRECT_URIS" NVARCHAR2(255) NOT NULL,
  "AUTO_APPROVE_SCOPES" VARCHAR2(255 BYTE) DEFAULT '',
  "AUTHORIZED_GRANT_TYPES" NVARCHAR2(255) NOT NULL,
  "SCOPES" NVARCHAR2(255) DEFAULT '',
  "AUTHORITIES" NVARCHAR2(255),
  "RESOURCE_IDS" NVARCHAR2(255),
  "ADDITIONAL_INFORMATION" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."CLIENT_ID" IS '客户端编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."SECRET" IS '客户端密钥';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."NAME" IS '应用名';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."LOGO" IS '应用图标';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."DESCRIPTION" IS '应用描述';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."STATUS" IS '状态';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."ACCESS_TOKEN_VALIDITY_SECONDS" IS '访问令牌的有效期';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."REFRESH_TOKEN_VALIDITY_SECONDS" IS '刷新令牌的有效期';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."REDIRECT_URIS" IS '可重定向的 URI 地址';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."AUTO_APPROVE_SCOPES" IS '自动通过的授权范围';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."AUTHORIZED_GRANT_TYPES" IS '授权类型';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."SCOPES" IS '授权范围';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."AUTHORITIES" IS '权限';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."RESOURCE_IDS" IS '资源';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."ADDITIONAL_INFORMATION" IS '附加信息';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CLIENT"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_OAUTH2_CLIENT" IS 'OAuth2 客户端表';

-- ----------------------------
-- Records of SYSTEM_OAUTH2_CLIENT
-- ----------------------------
INSERT INTO "SYSTEM_OAUTH2_CLIENT" ("ID", "CLIENT_ID", "SECRET", "NAME", "LOGO", "DESCRIPTION", "STATUS", "ACCESS_TOKEN_VALIDITY_SECONDS", "REFRESH_TOKEN_VALIDITY_SECONDS", "REDIRECT_URIS", "AUTO_APPROVE_SCOPES", "AUTHORIZED_GRANT_TYPES", "SCOPES", "AUTHORITIES", "RESOURCE_IDS", "ADDITIONAL_INFORMATION", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1', 'default', 'admin123', '芋道源码', 'http://test.yudao.iocoder.cn/a5e2e244368878a366b516805a4aabf1.png', '我是描述', '0', '180', '8640', '["https://www.iocoder.cn","https://doc.iocoder.cn"]', NULL, '["password","authorization_code","implicit","refresh_token"]', '["user.read","user.write"]', '["system:user:query"]', '[]', '{}', '1', TO_DATE('2022-05-11 21:47:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-12 01:00:20', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_OAUTH2_CLIENT" ("ID", "CLIENT_ID", "SECRET", "NAME", "LOGO", "DESCRIPTION", "STATUS", "ACCESS_TOKEN_VALIDITY_SECONDS", "REFRESH_TOKEN_VALIDITY_SECONDS", "REDIRECT_URIS", "AUTO_APPROVE_SCOPES", "AUTHORIZED_GRANT_TYPES", "SCOPES", "AUTHORITIES", "RESOURCE_IDS", "ADDITIONAL_INFORMATION", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('40', 'test', 'test2', 'biubiu', 'http://test.yudao.iocoder.cn/277a899d573723f1fcdfb57340f00379.png', NULL, '0', '1800', '43200', '["https://www.iocoder.cn"]', '[]', '["password","authorization_code","implicit"]', '[]', '[]', '[]', '{}', '1', TO_DATE('2022-05-12 00:28:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-26 00:30:33', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_OAUTH2_CODE
-- ----------------------------
DROP TABLE "SYSTEM_OAUTH2_CODE";
CREATE TABLE "SYSTEM_OAUTH2_CODE" (
  "ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "USER_TYPE" NUMBER(4,0) NOT NULL,
  "CODE" NVARCHAR2(32) NOT NULL,
  "CLIENT_ID" NVARCHAR2(255) NOT NULL,
  "SCOPES" NVARCHAR2(255),
  "EXPIRES_TIME" DATE NOT NULL,
  "REDIRECT_URI" NVARCHAR2(255),
  "STATE" NVARCHAR2(255) DEFAULT '',
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0 NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."CODE" IS '授权码';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."CLIENT_ID" IS '客户端编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."SCOPES" IS '授权范围';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."EXPIRES_TIME" IS '过期时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."REDIRECT_URI" IS '可重定向的 URI 地址';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."STATE" IS '状态';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."DELETED" IS '是否删除';
COMMENT ON COLUMN "SYSTEM_OAUTH2_CODE"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "SYSTEM_OAUTH2_CODE" IS 'OAuth2 授权码表';

-- ----------------------------
-- Records of SYSTEM_OAUTH2_CODE
-- ----------------------------
INSERT INTO "SYSTEM_OAUTH2_CODE" ("ID", "USER_ID", "USER_TYPE", "CODE", "CLIENT_ID", "SCOPES", "EXPIRES_TIME", "REDIRECT_URI", "STATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED", "TENANT_ID") VALUES ('3', '1', '2', 'b882271c7082496e889e8e1a798f1ca2', 'default', '["user.write"]', TO_DATE('2022-05-26 00:41:41', 'SYYYY-MM-DD HH24:MI:SS'), 'https://www.iocoder.cn', NULL, '1', TO_DATE('2022-05-26 00:36:41', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-26 00:36:41', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYSTEM_OAUTH2_CODE" ("ID", "USER_ID", "USER_TYPE", "CODE", "CLIENT_ID", "SCOPES", "EXPIRES_TIME", "REDIRECT_URI", "STATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED", "TENANT_ID") VALUES ('4', '1', '2', '69f7969f221c41e8a5a7887daad9d14e', 'default', '["user.write","user.read"]', TO_DATE('2022-05-26 00:41:50', 'SYYYY-MM-DD HH24:MI:SS'), 'https://www.iocoder.cn', NULL, '1', TO_DATE('2022-05-26 00:36:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-26 00:36:50', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYSTEM_OAUTH2_CODE" ("ID", "USER_ID", "USER_TYPE", "CODE", "CLIENT_ID", "SCOPES", "EXPIRES_TIME", "REDIRECT_URI", "STATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED", "TENANT_ID") VALUES ('5', '1', '2', 'b624454a2fd1447f95849629cf3079a1', 'default', '["user.read","user.write"]', TO_DATE('2022-05-26 00:41:52', 'SYYYY-MM-DD HH24:MI:SS'), 'https://www.iocoder.cn', NULL, '1', TO_DATE('2022-05-26 00:36:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-26 00:36:52', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_OAUTH2_REFRESH_TOKEN
-- ----------------------------
DROP TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN";
CREATE TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" (
  "ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "REFRESH_TOKEN" NVARCHAR2(32) NOT NULL,
  "USER_TYPE" NUMBER(4,0) NOT NULL,
  "CLIENT_ID" NVARCHAR2(255) NOT NULL,
  "EXPIRES_TIME" DATE NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER DEFAULT 0 NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "SCOPES" NVARCHAR2(255) DEFAULT ''
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."REFRESH_TOKEN" IS '刷新令牌';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."CLIENT_ID" IS '客户端编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."EXPIRES_TIME" IS '过期时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."DELETED" IS '是否删除';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_OAUTH2_REFRESH_TOKEN"."SCOPES" IS '授权范围';
COMMENT ON TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" IS '刷新令牌';

-- ----------------------------
-- Records of SYSTEM_OAUTH2_REFRESH_TOKEN
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_OPERATE_LOG
-- ----------------------------
DROP TABLE "SYSTEM_OPERATE_LOG";
CREATE TABLE "SYSTEM_OPERATE_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "TRACE_ID" NVARCHAR2(64),
  "USER_ID" NUMBER(20,0) NOT NULL,
  "USER_TYPE" NUMBER(4,0) NOT NULL,
  "MODULE" NVARCHAR2(50),
  "NAME" NVARCHAR2(50),
  "TYPE" NUMBER(20,0) NOT NULL,
  "CONTENT" NCLOB,
  "EXTS" NVARCHAR2(512),
  "REQUEST_METHOD" NVARCHAR2(16),
  "REQUEST_URL" NVARCHAR2(255),
  "USER_IP" NVARCHAR2(50),
  "USER_AGENT" NVARCHAR2(200),
  "JAVA_METHOD" NVARCHAR2(512),
  "JAVA_METHOD_ARGS" NCLOB,
  "START_TIME" DATE NOT NULL,
  "DURATION" NUMBER(11,0) NOT NULL,
  "RESULT_CODE" NUMBER(11,0) NOT NULL,
  "RESULT_MSG" NVARCHAR2(512),
  "RESULT_DATA" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."ID" IS '日志主键';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."TRACE_ID" IS '链路追踪编号';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."MODULE" IS '模块标题';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."NAME" IS '操作名';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."TYPE" IS '操作分类';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."CONTENT" IS '操作内容';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."EXTS" IS '拓展字段';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."REQUEST_METHOD" IS '请求方法名';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."REQUEST_URL" IS '请求地址';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."USER_IP" IS '用户 IP';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."USER_AGENT" IS '浏览器 UA';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."JAVA_METHOD" IS 'Java 方法名';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."JAVA_METHOD_ARGS" IS 'Java 方法的参数';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."START_TIME" IS '操作时间';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."DURATION" IS '执行时长';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."RESULT_CODE" IS '结果码';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."RESULT_MSG" IS '结果提示';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."RESULT_DATA" IS '结果数据';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_OPERATE_LOG"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_OPERATE_LOG" IS '操作日志记录';

-- ----------------------------
-- Records of SYSTEM_OPERATE_LOG
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_POST
-- ----------------------------
DROP TABLE "SYSTEM_POST";
CREATE TABLE "SYSTEM_POST" (
  "ID" NUMBER(20,0) NOT NULL,
  "CODE" NVARCHAR2(64),
  "NAME" NVARCHAR2(50),
  "SORT" NUMBER(11,0) NOT NULL,
  "STATUS" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(500),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_POST"."ID" IS '岗位ID';
COMMENT ON COLUMN "SYSTEM_POST"."CODE" IS '岗位编码';
COMMENT ON COLUMN "SYSTEM_POST"."NAME" IS '岗位名称';
COMMENT ON COLUMN "SYSTEM_POST"."SORT" IS '显示顺序';
COMMENT ON COLUMN "SYSTEM_POST"."STATUS" IS '状态（0正常 1停用）';
COMMENT ON COLUMN "SYSTEM_POST"."REMARK" IS '备注';
COMMENT ON COLUMN "SYSTEM_POST"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_POST"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_POST"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_POST"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_POST"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_POST"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_POST" IS '岗位信息表';

-- ----------------------------
-- Records of SYSTEM_POST
-- ----------------------------
INSERT INTO "SYSTEM_POST" ("ID", "CODE", "NAME", "SORT", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1', 'ceo', '董事长', '1', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-04 17:50:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_POST" ("ID", "CODE", "NAME", "SORT", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('2', 'se', '项目经理', '2', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-12-12 10:47:47', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_POST" ("ID", "CODE", "NAME", "SORT", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('3', 'hr', '人力资源', '3', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-12 10:47:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_POST" ("ID", "CODE", "NAME", "SORT", "STATUS", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('4', 'user', '普通员工', '4', '0', NULL, 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-12-12 10:47:51', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_ROLE
-- ----------------------------
DROP TABLE "SYSTEM_ROLE";
CREATE TABLE "SYSTEM_ROLE" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(30),
  "CODE" NVARCHAR2(100),
  "SORT" NUMBER(11,0) NOT NULL,
  "DATA_SCOPE" NUMBER(4,0) NOT NULL,
  "DATA_SCOPE_DEPT_IDS" NVARCHAR2(500),
  "STATUS" NUMBER(4,0) NOT NULL,
  "TYPE" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(500),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_ROLE"."ID" IS '角色ID';
COMMENT ON COLUMN "SYSTEM_ROLE"."NAME" IS '角色名称';
COMMENT ON COLUMN "SYSTEM_ROLE"."CODE" IS '角色权限字符串';
COMMENT ON COLUMN "SYSTEM_ROLE"."SORT" IS '显示顺序';
COMMENT ON COLUMN "SYSTEM_ROLE"."DATA_SCOPE" IS '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）';
COMMENT ON COLUMN "SYSTEM_ROLE"."DATA_SCOPE_DEPT_IDS" IS '数据范围(指定部门数组)';
COMMENT ON COLUMN "SYSTEM_ROLE"."STATUS" IS '角色状态（0正常 1停用）';
COMMENT ON COLUMN "SYSTEM_ROLE"."TYPE" IS '角色类型';
COMMENT ON COLUMN "SYSTEM_ROLE"."REMARK" IS '备注';
COMMENT ON COLUMN "SYSTEM_ROLE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_ROLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_ROLE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_ROLE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_ROLE"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_ROLE"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_ROLE" IS '角色信息表';

-- ----------------------------
-- Records of SYSTEM_ROLE
-- ----------------------------
INSERT INTO "SYSTEM_ROLE" ("ID", "NAME", "CODE", "SORT", "DATA_SCOPE", "DATA_SCOPE_DEPT_IDS", "STATUS", "TYPE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1', '超级管理员', 'super_admin', '1', '1', NULL, '0', '1', '超级管理员', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-22 05:08:21', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE" ("ID", "NAME", "CODE", "SORT", "DATA_SCOPE", "DATA_SCOPE_DEPT_IDS", "STATUS", "TYPE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('2', '普通角色', 'common', '2', '2', NULL, '0', '1', '普通角色', 'admin', TO_DATE('2021-01-05 17:03:48', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-22 05:08:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE" ("ID", "NAME", "CODE", "SORT", "DATA_SCOPE", "DATA_SCOPE_DEPT_IDS", "STATUS", "TYPE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('101', '测试账号', 'test', '0', '1', '[]', '0', '2', '132', NULL, TO_DATE('2021-01-06 13:49:35', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 22:00:41', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE" ("ID", "NAME", "CODE", "SORT", "DATA_SCOPE", "DATA_SCOPE_DEPT_IDS", "STATUS", "TYPE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('109', '租户管理员', 'tenant_admin', '0', '1', NULL, '0', '1', '系统自动生成', '1', TO_DATE('2022-02-22 00:56:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 00:56:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE" ("ID", "NAME", "CODE", "SORT", "DATA_SCOPE", "DATA_SCOPE_DEPT_IDS", "STATUS", "TYPE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('110', '测试角色', 'test', '0', '1', '[]', '0', '2', '嘿嘿', '110', TO_DATE('2022-02-23 00:14:34', 'SYYYY-MM-DD HH24:MI:SS'), '110', TO_DATE('2022-02-23 13:14:58', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE" ("ID", "NAME", "CODE", "SORT", "DATA_SCOPE", "DATA_SCOPE_DEPT_IDS", "STATUS", "TYPE", "REMARK", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('111', '租户管理员', 'tenant_admin', '0', '1', NULL, '0', '1', '系统自动生成', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_ROLE_MENU
-- ----------------------------
DROP TABLE "SYSTEM_ROLE_MENU";
CREATE TABLE "SYSTEM_ROLE_MENU" (
  "ID" NUMBER(20,0) NOT NULL,
  "ROLE_ID" NUMBER(20,0) NOT NULL,
  "MENU_ID" NUMBER(20,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."ID" IS '自增编号';
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."ROLE_ID" IS '角色ID';
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."MENU_ID" IS '菜单ID';
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_ROLE_MENU"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_ROLE_MENU" IS '角色和菜单关联表';

-- ----------------------------
-- Records of SYSTEM_ROLE_MENU
-- ----------------------------
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('434', '2', '1', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('454', '2', '1093', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('455', '2', '1094', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('460', '2', '1100', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('467', '2', '1107', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('470', '2', '1110', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('476', '2', '1117', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('477', '2', '100', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('478', '2', '101', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('479', '2', '102', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('480', '2', '1126', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('481', '2', '103', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('483', '2', '104', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('485', '2', '105', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('488', '2', '107', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('490', '2', '108', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('492', '2', '109', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('498', '2', '1138', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('523', '2', '1224', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('524', '2', '1225', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('541', '2', '500', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('543', '2', '501', '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:09:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('675', '2', '2', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('689', '2', '1077', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('690', '2', '1078', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('692', '2', '1083', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('693', '2', '1084', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('699', '2', '1090', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('702', '2', '1116', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('703', '2', '106', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('704', '2', '110', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('705', '2', '111', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('706', '2', '112', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('707', '2', '113', '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 13:16:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('263', '109', '1', '1', TO_DATE('2022-02-22 00:56:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 00:56:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1486', '109', '103', '1', TO_DATE('2022-02-23 19:32:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 19:32:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1487', '109', '104', '1', TO_DATE('2022-02-23 19:32:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 19:32:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1489', '1', '1', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1490', '1', '2', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1494', '1', '1077', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1495', '1', '1078', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1496', '1', '1083', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1497', '1', '1084', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1498', '1', '1090', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1499', '1', '1093', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1500', '1', '1094', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1501', '1', '1100', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1502', '1', '1107', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1503', '1', '1110', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1504', '1', '1116', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1505', '1', '1117', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1506', '1', '100', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1507', '1', '101', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1508', '1', '102', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1509', '1', '1126', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1510', '1', '103', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1511', '1', '104', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1512', '1', '105', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1513', '1', '106', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1514', '1', '107', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1515', '1', '108', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1516', '1', '109', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1517', '1', '110', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1518', '1', '111', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1519', '1', '112', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1520', '1', '113', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1522', '1', '1138', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1525', '1', '1224', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1526', '1', '1225', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1527', '1', '500', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1528', '1', '501', '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:03:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1529', '109', '1024', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1530', '109', '1025', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1536', '109', '1017', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1537', '109', '1018', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1538', '109', '1019', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1539', '109', '1020', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1540', '109', '1021', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1541', '109', '1022', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1542', '109', '1023', '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 20:30:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1576', '111', '1024', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1577', '111', '1025', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1578', '111', '1', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1584', '111', '103', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1585', '111', '104', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1587', '111', '1017', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1588', '111', '1018', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1589', '111', '1019', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1590', '111', '1020', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1591', '111', '1021', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1592', '111', '1022', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1593', '111', '1023', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1594', '109', '102', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1595', '109', '1013', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1596', '109', '1014', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1597', '109', '1015', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1598', '109', '1016', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1599', '111', '102', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1600', '111', '1013', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1601', '111', '1014', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1602', '111', '1015', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1603', '111', '1016', '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1604', '101', '1216', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1605', '101', '1217', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1606', '101', '1218', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1607', '101', '1219', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1608', '101', '1220', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1609', '101', '1221', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1610', '101', '5', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1611', '101', '1222', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1612', '101', '1118', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1613', '101', '1119', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1614', '101', '1120', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1615', '101', '1185', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1616', '101', '1186', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1617', '101', '1187', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1618', '101', '1188', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1619', '101', '1189', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1620', '101', '1190', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1621', '101', '1191', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1622', '101', '1192', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1623', '101', '1193', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1624', '101', '1194', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1625', '101', '1195', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1626', '101', '1196', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1627', '101', '1197', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1628', '101', '1198', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1629', '101', '1199', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1630', '101', '1200', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1631', '101', '1201', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1632', '101', '1202', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1633', '101', '1207', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1634', '101', '1208', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1635', '101', '1209', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1636', '101', '1210', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1637', '101', '1211', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1638', '101', '1212', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1639', '101', '1213', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1640', '101', '1215', '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:45:52', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_ROLE_MENU" ("ID", "ROLE_ID", "MENU_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1296', '110', '1', '110', TO_DATE('2022-02-23 00:23:55', 'SYYYY-MM-DD HH24:MI:SS'), '110', TO_DATE('2022-02-23 00:23:55', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_SENSITIVE_WORD
-- ----------------------------
DROP TABLE "SYSTEM_SENSITIVE_WORD";
CREATE TABLE "SYSTEM_SENSITIVE_WORD" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(255) NOT NULL,
  "DESCRIPTION" NVARCHAR2(512),
  "TAGS" NVARCHAR2(255),
  "STATUS" NUMBER(4,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."NAME" IS '敏感词';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."DESCRIPTION" IS '描述';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."TAGS" IS '标签数组';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."STATUS" IS '状态';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_SENSITIVE_WORD"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_SENSITIVE_WORD" IS '敏感词';

-- ----------------------------
-- Records of SYSTEM_SENSITIVE_WORD
-- ----------------------------
INSERT INTO "SYSTEM_SENSITIVE_WORD" ("ID", "NAME", "DESCRIPTION", "TAGS", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1', '测试', '啊哈哈', '论坛,吃瓜', '0', '1', TO_DATE('2022-04-08 19:51:45', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-08 12:10:45', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SENSITIVE_WORD" ("ID", "NAME", "DESCRIPTION", "TAGS", "STATUS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('2', '测试', '哈哈', '论坛,吃瓜,蔬菜', '0', '1', TO_DATE('2022-04-08 20:10:27', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-04-08 13:13:52', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_SMS_CHANNEL
-- ----------------------------
DROP TABLE "SYSTEM_SMS_CHANNEL";
CREATE TABLE "SYSTEM_SMS_CHANNEL" (
  "ID" NUMBER(20,0) NOT NULL,
  "SIGNATURE" NVARCHAR2(12),
  "CODE" NVARCHAR2(63),
  "STATUS" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(255),
  "API_KEY" NVARCHAR2(128),
  "API_SECRET" NVARCHAR2(128),
  "CALLBACK_URL" NVARCHAR2(255),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."SIGNATURE" IS '短信签名';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."CODE" IS '渠道编码';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."STATUS" IS '开启状态';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."REMARK" IS '备注';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."API_KEY" IS '短信 API 的账号';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."API_SECRET" IS '短信 API 的秘钥';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."CALLBACK_URL" IS '短信发送回调 URL';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_SMS_CHANNEL"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_SMS_CHANNEL" IS '短信渠道';

-- ----------------------------
-- Records of SYSTEM_SMS_CHANNEL
-- ----------------------------
INSERT INTO "SYSTEM_SMS_CHANNEL" ("ID", "SIGNATURE", "CODE", "STATUS", "REMARK", "API_KEY", "API_SECRET", "CALLBACK_URL", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1', '芋道', 'YUN_PIAN', '0', '呵呵呵哒', '1555a14277cb8a608cf45a9e6a80d510', NULL, 'http://vdwapu.natappfree.cc/admin-api/system/sms/callback/yunpian', NULL, TO_DATE('2021-03-31 06:12:20', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 16:48:44', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_CHANNEL" ("ID", "SIGNATURE", "CODE", "STATUS", "REMARK", "API_KEY", "API_SECRET", "CALLBACK_URL", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('2', 'Ballcat', 'ALIYUN', '0', '啦啦啦', 'LTAI5tCnKso2uG3kJ5gRav88', 'fGJ5SNXL7P1NHNRmJ7DJaMJGPyE55C', NULL, NULL, TO_DATE('2021-03-31 11:53:10', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-04-14 00:08:37', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_CHANNEL" ("ID", "SIGNATURE", "CODE", "STATUS", "REMARK", "API_KEY", "API_SECRET", "CALLBACK_URL", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('4', '测试渠道', 'DEBUG_DING_TALK', '0', '123', '696b5d8ead48071237e4aa5861ff08dbadb2b4ded1c688a7b7c9afc615579859', 'SEC5c4e5ff888bc8a9923ae47f59e7ccd30af1f14d93c55b4e2c9cb094e35aeed67', NULL, '1', TO_DATE('2021-04-13 00:23:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-04-14 00:07:10', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_SMS_CODE
-- ----------------------------
DROP TABLE "SYSTEM_SMS_CODE";
CREATE TABLE "SYSTEM_SMS_CODE" (
  "ID" NUMBER(20,0) NOT NULL,
  "MOBILE" NVARCHAR2(11),
  "CODE" NVARCHAR2(6),
  "CREATE_IP" NVARCHAR2(15),
  "SCENE" NUMBER(4,0) NOT NULL,
  "TODAY_INDEX" NUMBER(4,0) NOT NULL,
  "USED" NUMBER(4,0) NOT NULL,
  "USED_TIME" DATE,
  "USED_IP" NVARCHAR2(255),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."MOBILE" IS '手机号';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."CODE" IS '验证码';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."CREATE_IP" IS '创建 IP';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."SCENE" IS '发送场景';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."TODAY_INDEX" IS '今日发送的第几条';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."USED" IS '是否使用';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."USED_TIME" IS '使用时间';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."USED_IP" IS '使用 IP';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_SMS_CODE"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_SMS_CODE" IS '手机验证码';

-- ----------------------------
-- Records of SYSTEM_SMS_CODE
-- ----------------------------
INSERT INTO "SYSTEM_SMS_CODE" ("ID", "MOBILE", "CODE", "CREATE_IP", "SCENE", "TODAY_INDEX", "USED", "USED_TIME", "USED_IP", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('0', '15601691399', '9999', '127.0.0.1', '1', '1', '0', NULL, NULL, NULL, TO_DATE('2022-05-01 17:52:58', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-01 17:52:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_SMS_LOG
-- ----------------------------
DROP TABLE "SYSTEM_SMS_LOG";
CREATE TABLE "SYSTEM_SMS_LOG" (
  "ID" NUMBER(20,0) NOT NULL,
  "CHANNEL_ID" NUMBER(20,0) NOT NULL,
  "CHANNEL_CODE" NVARCHAR2(63),
  "TEMPLATE_ID" NUMBER(20,0) NOT NULL,
  "TEMPLATE_CODE" NVARCHAR2(63),
  "TEMPLATE_TYPE" NUMBER(4,0) NOT NULL,
  "TEMPLATE_CONTENT" NVARCHAR2(255),
  "TEMPLATE_PARAMS" NVARCHAR2(255),
  "API_TEMPLATE_ID" NVARCHAR2(63),
  "MOBILE" NVARCHAR2(11),
  "USER_ID" NUMBER(20,0),
  "USER_TYPE" NUMBER(4,0),
  "SEND_STATUS" NUMBER(4,0) NOT NULL,
  "SEND_TIME" DATE,
  "SEND_CODE" NUMBER(11,0),
  "SEND_MSG" NVARCHAR2(255),
  "API_SEND_CODE" NVARCHAR2(63),
  "API_SEND_MSG" NVARCHAR2(255),
  "API_REQUEST_ID" NVARCHAR2(255),
  "API_SERIAL_NO" NVARCHAR2(255),
  "RECEIVE_STATUS" NUMBER(4,0) NOT NULL,
  "RECEIVE_TIME" DATE,
  "API_RECEIVE_CODE" NVARCHAR2(63),
  "API_RECEIVE_MSG" NVARCHAR2(255),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."CHANNEL_ID" IS '短信渠道编号';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."CHANNEL_CODE" IS '短信渠道编码';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."TEMPLATE_ID" IS '模板编号';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."TEMPLATE_CODE" IS '模板编码';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."TEMPLATE_TYPE" IS '短信类型';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."TEMPLATE_CONTENT" IS '短信内容';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."TEMPLATE_PARAMS" IS '短信参数';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."API_TEMPLATE_ID" IS '短信 API 的模板编号';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."MOBILE" IS '手机号';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."USER_ID" IS '用户编号';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."SEND_STATUS" IS '发送状态';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."SEND_TIME" IS '发送时间';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."SEND_CODE" IS '发送结果的编码';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."SEND_MSG" IS '发送结果的提示';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."API_SEND_CODE" IS '短信 API 发送结果的编码';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."API_SEND_MSG" IS '短信 API 发送失败的提示';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."API_REQUEST_ID" IS '短信 API 发送返回的唯一请求 ID';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."API_SERIAL_NO" IS '短信 API 发送返回的序号';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."RECEIVE_STATUS" IS '接收状态';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."RECEIVE_TIME" IS '接收时间';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."API_RECEIVE_CODE" IS 'API 接收结果的编码';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."API_RECEIVE_MSG" IS 'API 接收结果的说明';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_SMS_LOG"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_SMS_LOG" IS '短信日志';

-- ----------------------------
-- Records of SYSTEM_SMS_LOG
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_SMS_TEMPLATE
-- ----------------------------
DROP TABLE "SYSTEM_SMS_TEMPLATE";
CREATE TABLE "SYSTEM_SMS_TEMPLATE" (
  "ID" NUMBER(20,0) NOT NULL,
  "TYPE" NUMBER(4,0) NOT NULL,
  "STATUS" NUMBER(4,0) NOT NULL,
  "CODE" NVARCHAR2(63),
  "NAME" NVARCHAR2(63),
  "CONTENT" NVARCHAR2(255),
  "PARAMS" NVARCHAR2(255),
  "REMARK" NVARCHAR2(255),
  "API_TEMPLATE_ID" NVARCHAR2(63),
  "CHANNEL_ID" NUMBER(20,0) NOT NULL,
  "CHANNEL_CODE" NVARCHAR2(63),
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."ID" IS '编号';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."TYPE" IS '短信签名';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."STATUS" IS '开启状态';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."CODE" IS '模板编码';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."NAME" IS '模板名称';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."CONTENT" IS '模板内容';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."PARAMS" IS '参数数组';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."REMARK" IS '备注';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."API_TEMPLATE_ID" IS '短信 API 的模板编号';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."CHANNEL_ID" IS '短信渠道编号';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."CHANNEL_CODE" IS '短信渠道编码';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_SMS_TEMPLATE"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_SMS_TEMPLATE" IS '短信模板';

-- ----------------------------
-- Records of SYSTEM_SMS_TEMPLATE
-- ----------------------------
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('2', '1', '0', 'test_01', '测试验证码短信', '正在进行登录操作{operation}，您的验证码是{code}', '["operation","code"]', NULL, '4383920', '1', 'YUN_PIAN', NULL, TO_DATE('2021-03-31 10:49:38', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-04-10 01:22:00', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('3', '1', '0', 'test_02', '公告通知', '您的验证码{code}，该验证码5分钟内有效，请勿泄漏于他人！', '["code"]', NULL, 'SMS_207945135', '2', 'ALIYUN', NULL, TO_DATE('2021-03-31 11:56:30', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-04-10 01:22:02', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('6', '3', '0', 'test-01', '测试模板', '哈哈哈 {name}', '["name"]', 'f哈哈哈', '4383920', '1', 'YUN_PIAN', '1', TO_DATE('2021-04-10 01:07:21', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-04-10 01:22:05', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('7', '3', '0', 'test-04', '测试下', '老鸡{name}，牛逼{code}', '["name","code"]', NULL, 'suibian', '4', 'DEBUG_DING_TALK', '1', TO_DATE('2021-04-13 00:29:53', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-04-14 00:30:38', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('8', '1', '0', 'user-sms-login', '前台用户短信登录', '您的验证码是{code}', '["code"]', NULL, '4372216', '1', 'YUN_PIAN', '1', TO_DATE('2021-10-11 08:10:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-10-11 08:10:00', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('9', '2', '0', 'bpm_task_assigned', '【工作流】任务被分配', '您收到了一条新的待办任务：{processInstanceName}-{taskName}，申请人：{startUserNickname}，处理链接：{detailUrl}', '["processInstanceName","taskName","startUserNickname","detailUrl"]', NULL, 'suibian', '4', 'DEBUG_DING_TALK', '1', TO_DATE('2022-01-21 22:31:19', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-01-22 00:03:36', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('10', '2', '0', 'bpm_process_instance_reject', '【工作流】流程被不通过', '您的流程被审批不通过：{processInstanceName}，原因：{reason}，查看链接：{detailUrl}', '["processInstanceName","reason","detailUrl"]', NULL, 'suibian', '4', 'DEBUG_DING_TALK', '1', TO_DATE('2022-01-22 00:03:31', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-01-22 00:24:31', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('11', '2', '0', 'bpm_process_instance_approve', '【工作流】流程被通过', '您的流程被审批通过：{processInstanceName}，查看链接：{detailUrl}', '["processInstanceName","detailUrl"]', NULL, 'suibian', '4', 'DEBUG_DING_TALK', '1', TO_DATE('2022-01-22 00:04:31', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-01-22 00:24:23', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_SMS_TEMPLATE" ("ID", "TYPE", "STATUS", "CODE", "NAME", "CONTENT", "PARAMS", "REMARK", "API_TEMPLATE_ID", "CHANNEL_ID", "CHANNEL_CODE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('13', '1', '0', 'admin-sms-login', '后台用户短信登录', '您的验证码是{code}', '["code"]', NULL, '4372216', '1', 'YUN_PIAN', '1', TO_DATE('2021-10-11 08:10:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2021-10-11 08:10:00', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_SOCIAL_USER
-- ----------------------------
DROP TABLE "SYSTEM_SOCIAL_USER";
CREATE TABLE "SYSTEM_SOCIAL_USER" (
  "ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "USER_TYPE" NUMBER(4,0) NOT NULL,
  "TYPE" NUMBER(4,0) NOT NULL,
  "OPENID" NVARCHAR2(32),
  "TOKEN" NVARCHAR2(256),
  "UNION_ID" NVARCHAR2(32),
  "RAW_TOKEN_INFO" NCLOB,
  "NICKNAME" NVARCHAR2(32),
  "AVATAR" NVARCHAR2(255),
  "RAW_USER_INFO" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."ID" IS '主键(自增策略)';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."USER_ID" IS '关联的用户编号';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."USER_TYPE" IS '用户类型';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."TYPE" IS '社交平台的类型';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."OPENID" IS '社交 openid';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."TOKEN" IS '社交 token';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."UNION_ID" IS '社交的全局编号';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."RAW_TOKEN_INFO" IS '原始 Token 数据，一般是 JSON 格式';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."NICKNAME" IS '用户昵称';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."AVATAR" IS '用户头像';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."RAW_USER_INFO" IS '原始用户数据，一般是 JSON 格式';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_SOCIAL_USER"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_SOCIAL_USER" IS '社交用户';

-- ----------------------------
-- Records of SYSTEM_SOCIAL_USER
-- ----------------------------
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_TENANT
-- ----------------------------
DROP TABLE "SYSTEM_TENANT";
CREATE TABLE "SYSTEM_TENANT" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(30),
  "CONTACT_USER_ID" NUMBER(20,0),
  "CONTACT_NAME" NVARCHAR2(30),
  "CONTACT_MOBILE" NVARCHAR2(500),
  "STATUS" NUMBER(4,0) NOT NULL,
  "DOMAIN" NVARCHAR2(256),
  "PACKAGE_ID" NUMBER(20,0) NOT NULL,
  "EXPIRE_TIME" DATE NOT NULL,
  "ACCOUNT_COUNT" NUMBER(11,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_TENANT"."ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_TENANT"."NAME" IS '租户名';
COMMENT ON COLUMN "SYSTEM_TENANT"."CONTACT_USER_ID" IS '联系人的用户编号';
COMMENT ON COLUMN "SYSTEM_TENANT"."CONTACT_NAME" IS '联系人';
COMMENT ON COLUMN "SYSTEM_TENANT"."CONTACT_MOBILE" IS '联系手机';
COMMENT ON COLUMN "SYSTEM_TENANT"."STATUS" IS '租户状态（0正常 1停用）';
COMMENT ON COLUMN "SYSTEM_TENANT"."DOMAIN" IS '绑定域名';
COMMENT ON COLUMN "SYSTEM_TENANT"."PACKAGE_ID" IS '租户套餐编号';
COMMENT ON COLUMN "SYSTEM_TENANT"."EXPIRE_TIME" IS '过期时间';
COMMENT ON COLUMN "SYSTEM_TENANT"."ACCOUNT_COUNT" IS '账号数量';
COMMENT ON COLUMN "SYSTEM_TENANT"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_TENANT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_TENANT"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_TENANT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_TENANT"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_TENANT" IS '租户表';

-- ----------------------------
-- Records of SYSTEM_TENANT
-- ----------------------------
INSERT INTO "SYSTEM_TENANT" ("ID", "NAME", "CONTACT_USER_ID", "CONTACT_NAME", "CONTACT_MOBILE", "STATUS", "DOMAIN", "PACKAGE_ID", "EXPIRE_TIME", "ACCOUNT_COUNT", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('1', '芋道源码', NULL, '芋艿', '17321315478', '0', 'https://www.iocoder.cn', '0', TO_DATE('2099-02-19 17:14:16', 'SYYYY-MM-DD HH24:MI:SS'), '9999', '1', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 12:15:11', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_TENANT" ("ID", "NAME", "CONTACT_USER_ID", "CONTACT_NAME", "CONTACT_MOBILE", "STATUS", "DOMAIN", "PACKAGE_ID", "EXPIRE_TIME", "ACCOUNT_COUNT", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('121', '小租户', '110', '小王2', '15601691300', '0', 'http://www.iocoder.cn', '111', TO_DATE('2024-03-11 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '20', '1', TO_DATE('2022-02-22 00:56:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:37:20', 'SYYYY-MM-DD HH24:MI:SS'), '0');
INSERT INTO "SYSTEM_TENANT" ("ID", "NAME", "CONTACT_USER_ID", "CONTACT_NAME", "CONTACT_MOBILE", "STATUS", "DOMAIN", "PACKAGE_ID", "EXPIRE_TIME", "ACCOUNT_COUNT", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('122', '测试租户', '113', '芋道', '15601691300', '0', 'https://www.iocoder.cn', '111', TO_DATE('2022-04-30 00:00:00', 'SYYYY-MM-DD HH24:MI:SS'), '50', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_TENANT_PACKAGE
-- ----------------------------
DROP TABLE "SYSTEM_TENANT_PACKAGE";
CREATE TABLE "SYSTEM_TENANT_PACKAGE" (
  "ID" NUMBER(20,0) NOT NULL,
  "NAME" NVARCHAR2(30),
  "STATUS" NUMBER(4,0) NOT NULL,
  "REMARK" NVARCHAR2(256),
  "MENU_IDS" NCLOB,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(4,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."ID" IS '套餐编号';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."NAME" IS '套餐名';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."STATUS" IS '租户状态（0正常 1停用）';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."REMARK" IS '备注';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."MENU_IDS" IS '关联的菜单编号';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_TENANT_PACKAGE"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_TENANT_PACKAGE" IS '租户套餐表';

-- ----------------------------
-- Records of SYSTEM_TENANT_PACKAGE
-- ----------------------------
INSERT INTO "SYSTEM_TENANT_PACKAGE" ("ID", "NAME", "STATUS", "REMARK", "MENU_IDS", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED") VALUES ('111', '普通套餐', '0', '小功能', '[1024,1025,1,102,103,104,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023]', '1', TO_DATE('2022-02-22 00:54:00', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 18:39:13', 'SYYYY-MM-DD HH24:MI:SS'), '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_USERS
-- ----------------------------
DROP TABLE "SYSTEM_USERS";
CREATE TABLE "SYSTEM_USERS" (
  "ID" NUMBER(20,0) NOT NULL,
  "USERNAME" NVARCHAR2(30),
  "PASSWORD" NVARCHAR2(100),
  "NICKNAME" NVARCHAR2(30),
  "REMARK" NVARCHAR2(500),
  "DEPT_ID" NUMBER(20,0),
  "POST_IDS" NVARCHAR2(255),
  "EMAIL" NVARCHAR2(50),
  "MOBILE" NVARCHAR2(11),
  "SEX" NUMBER(4,0),
  "AVATAR" NVARCHAR2(100),
  "STATUS" NUMBER(4,0) NOT NULL,
  "LOGIN_IP" NVARCHAR2(50),
  "LOGIN_DATE" DATE,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_USERS"."ID" IS '用户ID';
COMMENT ON COLUMN "SYSTEM_USERS"."USERNAME" IS '用户账号';
COMMENT ON COLUMN "SYSTEM_USERS"."PASSWORD" IS '密码';
COMMENT ON COLUMN "SYSTEM_USERS"."NICKNAME" IS '用户昵称';
COMMENT ON COLUMN "SYSTEM_USERS"."REMARK" IS '备注';
COMMENT ON COLUMN "SYSTEM_USERS"."DEPT_ID" IS '部门ID';
COMMENT ON COLUMN "SYSTEM_USERS"."POST_IDS" IS '岗位编号数组';
COMMENT ON COLUMN "SYSTEM_USERS"."EMAIL" IS '用户邮箱';
COMMENT ON COLUMN "SYSTEM_USERS"."MOBILE" IS '手机号码';
COMMENT ON COLUMN "SYSTEM_USERS"."SEX" IS '用户性别';
COMMENT ON COLUMN "SYSTEM_USERS"."AVATAR" IS '头像地址';
COMMENT ON COLUMN "SYSTEM_USERS"."STATUS" IS '帐号状态（0正常 1停用）';
COMMENT ON COLUMN "SYSTEM_USERS"."LOGIN_IP" IS '最后登录IP';
COMMENT ON COLUMN "SYSTEM_USERS"."LOGIN_DATE" IS '最后登录时间';
COMMENT ON COLUMN "SYSTEM_USERS"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_USERS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_USERS"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_USERS"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_USERS"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_USERS"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_USERS" IS '用户信息表';

-- ----------------------------
-- Records of SYSTEM_USERS
-- ----------------------------
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('115', 'anzhen', '$2a$10$Qr2lBUuwvDMb98p/o7iSPuHb7GRi4zPHSq4g01ETuY.l4O5txXfvi', 'anzhen', NULL, '100', '[]', NULL, NULL, NULL, NULL, '0', NULL, NULL, '1', TO_DATE('2022-03-24 18:50:59', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-24 18:50:59', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1', 'admin', '$2a$10$0acJOIk2D25/oC87nyclE..0lzeu9DtQ/n3geP4fkun/zIVRhHJIO', '芋道源码', '管理员', '103', '[1,2]', 'aoteman@126.com', '15612345678', '1', 'http://test.yudao.iocoder.cn/a294ecb2-73dd-4353-bf40-296b8931d0bf', '0', '127.0.0.1', TO_DATE('2022-05-13 09:40:57', 'SYYYY-MM-DD HH24:MI:SS'), 'admin', TO_DATE('2021-01-05 17:03:47', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-05-13 09:40:57', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('100', 'yudao', '$2a$10$11U48RhyJ5pSBYWSn12AD./ld671.ycSzJHbyrtpeoMeYiw31eo8a', '芋道', '不要吓我', '104', '[1]', 'yudao@iocoder.cn', '15601691300', '1', NULL, '1', NULL, NULL, NULL, TO_DATE('2021-01-07 09:07:17', 'SYYYY-MM-DD HH24:MI:SS'), '104', TO_DATE('2021-12-16 09:26:10', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('103', 'yuanma', '$2a$10$wWoPT7sqriM2O1YXRL.je.GiL538OR6ZTN8aQZr9JAGdnpCH2tpYe', '源码', NULL, '106', NULL, 'yuanma@iocoder.cn', '15601701300', '0', NULL, '0', '127.0.0.1', TO_DATE('2022-01-18 00:33:40', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-01-13 23:50:35', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-01-18 00:33:40', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('104', 'test', '$2a$10$e5RpuDCC0GYSt0Hvd2.CjujIXwgGct4SnXi6dVGxdgFsnqgEryk5a', '测试号', NULL, '107', '[]', '111@qq.com', '15601691200', '1', NULL, '0', '127.0.0.1', TO_DATE('2022-03-19 21:46:19', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2021-01-21 02:13:53', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-03-19 21:46:19', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('107', 'admin107', '$2a$10$dYOOBKMO93v/.ReCqzyFg.o67Tqk.bbc2bhrpyBGkIw9aypCtr2pm', '芋艿', NULL, NULL, NULL, NULL, '15601691300', '0', NULL, '0', NULL, NULL, '1', TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-27 08:26:51', 'SYYYY-MM-DD HH24:MI:SS'), '118', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('108', 'admin108', '$2a$10$y6mfvKoNYL1GXWak8nYwVOH.kCWqjactkzdoIDgiKl93WN3Ejg.Lu', '芋艿', NULL, NULL, NULL, NULL, '15601691300', '0', NULL, '0', NULL, NULL, '1', TO_DATE('2022-02-20 23:00:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-27 08:26:53', 'SYYYY-MM-DD HH24:MI:SS'), '119', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('109', 'admin109', '$2a$10$JAqvH0tEc0I7dfDVBI7zyuB4E3j.uH6daIjV53.vUS6PknFkDJkuK', '芋艿', NULL, NULL, NULL, NULL, '15601691300', '0', NULL, '0', NULL, NULL, '1', TO_DATE('2022-02-20 23:11:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-27 08:26:56', 'SYYYY-MM-DD HH24:MI:SS'), '120', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('110', 'admin110', '$2a$10$qYxoXs0ogPHgYllyEneYde9xcCW5hZgukrxeXZ9lmLhKse8TK6IwW', '小王', NULL, NULL, NULL, NULL, '15601691300', '0', NULL, '0', '127.0.0.1', TO_DATE('2022-02-23 19:36:28', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 00:56:14', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-27 08:26:59', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('111', 'test', '$2a$10$mExveopHUx9Q4QiLtAzhDeH3n4/QlNLzEsM4AqgxKrU.ciUZDXZCy', '测试用户', NULL, NULL, '[]', NULL, NULL, '0', NULL, '0', NULL, NULL, '110', TO_DATE('2022-02-23 13:14:33', 'SYYYY-MM-DD HH24:MI:SS'), '110', TO_DATE('2022-02-23 13:14:33', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('112', 'newobject', '$2a$10$jh5MsR.ud/gKe3mVeUp5t.nEXGDSmHyv5OYjWQwHO8wlGmMSI9Twy', '新对象', NULL, NULL, '[]', NULL, NULL, '0', NULL, '0', NULL, NULL, '1', TO_DATE('2022-02-23 19:08:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-23 19:08:03', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('113', 'aoteman', '$2a$10$0acJOIk2D25/oC87nyclE..0lzeu9DtQ/n3geP4fkun/zIVRhHJIO', '芋道', NULL, NULL, NULL, NULL, '15601691300', '0', NULL, '0', '127.0.0.1', TO_DATE('2022-03-19 18:38:51', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-03-19 18:38:51', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('114', 'hrmgr', '$2a$10$TR4eybBioGRhBmDBWkqWLO6NIh3mzYa8KBKDDB5woiGYFVlRAi.fu', 'hr 小姐姐', NULL, NULL, '[3]', NULL, NULL, '0', NULL, '0', '127.0.0.1', TO_DATE('2022-03-19 22:15:43', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:50:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 01:08:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USERS" ("ID", "USERNAME", "PASSWORD", "NICKNAME", "REMARK", "DEPT_ID", "POST_IDS", "EMAIL", "MOBILE", "SEX", "AVATAR", "STATUS", "LOGIN_IP", "LOGIN_DATE", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('0', 'admin2', '$2a$10$KYL8IPJPIzuZWfOgPqOuU.VeZqWistCv5pxtoaq2SwPBDgBR4uh6G', '123', NULL, NULL, '[]', NULL, NULL, NULL, NULL, '0', NULL, NULL, '1', TO_DATE('2022-05-01 01:05:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-05-01 01:05:12', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_USER_POST
-- ----------------------------
DROP TABLE "SYSTEM_USER_POST";
CREATE TABLE "SYSTEM_USER_POST" (
  "ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "POST_ID" NUMBER(20,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE NOT NULL,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL,
  "TENANT_ID" NUMBER(20,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_USER_POST"."ID" IS 'id';
COMMENT ON COLUMN "SYSTEM_USER_POST"."USER_ID" IS '用户ID';
COMMENT ON COLUMN "SYSTEM_USER_POST"."POST_ID" IS '岗位ID';
COMMENT ON COLUMN "SYSTEM_USER_POST"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_USER_POST"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_USER_POST"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_USER_POST"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_USER_POST"."DELETED" IS '是否删除';
COMMENT ON COLUMN "SYSTEM_USER_POST"."TENANT_ID" IS '租户编号';
COMMENT ON TABLE "SYSTEM_USER_POST" IS '用户岗位表';

-- ----------------------------
-- Records of SYSTEM_USER_POST
-- ----------------------------
INSERT INTO "SYSTEM_USER_POST" ("ID", "USER_ID", "POST_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED", "TENANT_ID") VALUES ('112', '1', '1', 'admin', TO_DATE('2022-05-02 07:25:24', 'SYYYY-MM-DD HH24:MI:SS'), 'admin', TO_DATE('2022-05-02 07:25:24', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYSTEM_USER_POST" ("ID", "USER_ID", "POST_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED", "TENANT_ID") VALUES ('113', '100', '1', 'admin', TO_DATE('2022-05-02 07:25:24', 'SYYYY-MM-DD HH24:MI:SS'), 'admin', TO_DATE('2022-05-02 07:25:24', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
INSERT INTO "SYSTEM_USER_POST" ("ID", "USER_ID", "POST_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "DELETED", "TENANT_ID") VALUES ('114', '114', '3', 'admin', TO_DATE('2022-05-02 07:25:24', 'SYYYY-MM-DD HH24:MI:SS'), 'admin', TO_DATE('2022-05-02 07:25:24', 'SYYYY-MM-DD HH24:MI:SS'), '0', '1');
COMMIT;
COMMIT;

-- ----------------------------
-- Table structure for SYSTEM_USER_ROLE
-- ----------------------------
DROP TABLE "SYSTEM_USER_ROLE";
CREATE TABLE "SYSTEM_USER_ROLE" (
  "ID" NUMBER(20,0) NOT NULL,
  "USER_ID" NUMBER(20,0) NOT NULL,
  "ROLE_ID" NUMBER(20,0) NOT NULL,
  "CREATOR" NVARCHAR2(64),
  "CREATE_TIME" DATE,
  "UPDATER" NVARCHAR2(64),
  "UPDATE_TIME" DATE,
  "TENANT_ID" NUMBER(20,0) NOT NULL,
  "DELETED" NUMBER(1,0) DEFAULT 0 NOT NULL
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."ID" IS '自增编号';
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."USER_ID" IS '用户ID';
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."ROLE_ID" IS '角色ID';
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."CREATOR" IS '创建者';
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."UPDATER" IS '更新者';
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."TENANT_ID" IS '租户编号';
COMMENT ON COLUMN "SYSTEM_USER_ROLE"."DELETED" IS '是否删除';
COMMENT ON TABLE "SYSTEM_USER_ROLE" IS '用户和角色关联表';

-- ----------------------------
-- Records of SYSTEM_USER_ROLE
-- ----------------------------
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('1', '1', '1', NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('2', '2', '2', NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('4', '100', '101', NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('5', '100', '1', NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('6', '100', '2', NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('7', '104', '101', NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), NULL, TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('10', '103', '1', '1', TO_DATE('2022-01-11 13:19:45', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-01-11 13:19:45', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('11', '107', '106', '1', TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-20 22:59:33', 'SYYYY-MM-DD HH24:MI:SS'), '118', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('12', '108', '107', '1', TO_DATE('2022-02-20 23:00:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-20 23:00:50', 'SYYYY-MM-DD HH24:MI:SS'), '119', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('13', '109', '108', '1', TO_DATE('2022-02-20 23:11:50', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-20 23:11:50', 'SYYYY-MM-DD HH24:MI:SS'), '120', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('14', '110', '109', '1', TO_DATE('2022-02-22 00:56:14', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-02-22 00:56:14', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('15', '111', '110', '110', TO_DATE('2022-02-23 13:14:38', 'SYYYY-MM-DD HH24:MI:SS'), '110', TO_DATE('2022-02-23 13:14:38', 'SYYYY-MM-DD HH24:MI:SS'), '121', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('16', '113', '111', '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-07 21:37:58', 'SYYYY-MM-DD HH24:MI:SS'), '122', '0');
INSERT INTO "SYSTEM_USER_ROLE" ("ID", "USER_ID", "ROLE_ID", "CREATOR", "CREATE_TIME", "UPDATER", "UPDATE_TIME", "TENANT_ID", "DELETED") VALUES ('17', '114', '101', '1', TO_DATE('2022-03-19 21:51:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', TO_DATE('2022-03-19 21:51:13', 'SYYYY-MM-DD HH24:MI:SS'), '1', '0');
COMMIT;
COMMIT;

-- ----------------------------
-- Sequence structure for BPM_FORM_SEQ
-- ----------------------------
DROP SEQUENCE "BPM_FORM_SEQ";
CREATE SEQUENCE "BPM_FORM_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for BPM_OA_LEAVE_SEQ
-- ----------------------------
DROP SEQUENCE "BPM_OA_LEAVE_SEQ";
CREATE SEQUENCE "BPM_OA_LEAVE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for BPM_PROCESS_DEFINITION_EXT_SEQ
-- ----------------------------
DROP SEQUENCE "BPM_PROCESS_DEFINITION_EXT_SEQ";
CREATE SEQUENCE "BPM_PROCESS_DEFINITION_EXT_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for BPM_PROCESS_INSTANCE_EXT_SEQ
-- ----------------------------
DROP SEQUENCE "BPM_PROCESS_INSTANCE_EXT_SEQ";
CREATE SEQUENCE "BPM_PROCESS_INSTANCE_EXT_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for BPM_TASK_ASSIGN_RULE_SEQ
-- ----------------------------
DROP SEQUENCE "BPM_TASK_ASSIGN_RULE_SEQ";
CREATE SEQUENCE "BPM_TASK_ASSIGN_RULE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for BPM_TASK_EXT_SEQ
-- ----------------------------
DROP SEQUENCE "BPM_TASK_EXT_SEQ";
CREATE SEQUENCE "BPM_TASK_EXT_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for BPM_USER_GROUP_SEQ
-- ----------------------------
DROP SEQUENCE "BPM_USER_GROUP_SEQ";
CREATE SEQUENCE "BPM_USER_GROUP_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_API_ACCESS_LOG_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_API_ACCESS_LOG_SEQ";
CREATE SEQUENCE "INFRA_API_ACCESS_LOG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_API_ERROR_LOG_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_API_ERROR_LOG_SEQ";
CREATE SEQUENCE "INFRA_API_ERROR_LOG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_CODEGEN_COLUMN_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_CODEGEN_COLUMN_SEQ";
CREATE SEQUENCE "INFRA_CODEGEN_COLUMN_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_CODEGEN_TABLE_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_CODEGEN_TABLE_SEQ";
CREATE SEQUENCE "INFRA_CODEGEN_TABLE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_CONFIG_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_CONFIG_SEQ";
CREATE SEQUENCE "INFRA_CONFIG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_DATA_SOURCE_CONFIG_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_DATA_SOURCE_CONFIG_SEQ";
CREATE SEQUENCE "INFRA_DATA_SOURCE_CONFIG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_FILE_CONFIG_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_FILE_CONFIG_SEQ";
CREATE SEQUENCE "INFRA_FILE_CONFIG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_FILE_CONTENT_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_FILE_CONTENT_SEQ";
CREATE SEQUENCE "INFRA_FILE_CONTENT_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_FILE_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_FILE_SEQ";
CREATE SEQUENCE "INFRA_FILE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_JOB_LOG_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_JOB_LOG_SEQ";
CREATE SEQUENCE "INFRA_JOB_LOG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_JOB_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_JOB_SEQ";
CREATE SEQUENCE "INFRA_JOB_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for INFRA_TEST_DEMO_SEQ
-- ----------------------------
DROP SEQUENCE "INFRA_TEST_DEMO_SEQ";
CREATE SEQUENCE "INFRA_TEST_DEMO_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for MEMBER_USER_SEQ
-- ----------------------------
DROP SEQUENCE "MEMBER_USER_SEQ";
CREATE SEQUENCE "MEMBER_USER_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for PAY_APP_SEQ
-- ----------------------------
DROP SEQUENCE "PAY_APP_SEQ";
CREATE SEQUENCE "PAY_APP_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for PAY_CHANNEL_SEQ
-- ----------------------------
DROP SEQUENCE "PAY_CHANNEL_SEQ";
CREATE SEQUENCE "PAY_CHANNEL_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for PAY_MERCHANT_SEQ
-- ----------------------------
DROP SEQUENCE "PAY_MERCHANT_SEQ";
CREATE SEQUENCE "PAY_MERCHANT_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for PAY_NOTIFY_LOG_SEQ
-- ----------------------------
DROP SEQUENCE "PAY_NOTIFY_LOG_SEQ";
CREATE SEQUENCE "PAY_NOTIFY_LOG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for PAY_NOTIFY_TASK_SEQ
-- ----------------------------
DROP SEQUENCE "PAY_NOTIFY_TASK_SEQ";
CREATE SEQUENCE "PAY_NOTIFY_TASK_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for PAY_ORDER_EXTENSION_SEQ
-- ----------------------------
DROP SEQUENCE "PAY_ORDER_EXTENSION_SEQ";
CREATE SEQUENCE "PAY_ORDER_EXTENSION_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for PAY_ORDER_SEQ
-- ----------------------------
DROP SEQUENCE "PAY_ORDER_SEQ";
CREATE SEQUENCE "PAY_ORDER_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for PAY_REFUND_SEQ
-- ----------------------------
DROP SEQUENCE "PAY_REFUND_SEQ";
CREATE SEQUENCE "PAY_REFUND_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_DEPT_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_DEPT_SEQ";
CREATE SEQUENCE "SYSTEM_DEPT_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_DICT_DATA_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_DICT_DATA_SEQ";
CREATE SEQUENCE "SYSTEM_DICT_DATA_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_DICT_TYPE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_DICT_TYPE_SEQ";
CREATE SEQUENCE "SYSTEM_DICT_TYPE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_ERROR_CODE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_ERROR_CODE_SEQ";
CREATE SEQUENCE "SYSTEM_ERROR_CODE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_LOGIN_LOG_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_LOGIN_LOG_SEQ";
CREATE SEQUENCE "SYSTEM_LOGIN_LOG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_MENU_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_MENU_SEQ";
CREATE SEQUENCE "SYSTEM_MENU_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_NOTICE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_NOTICE_SEQ";
CREATE SEQUENCE "SYSTEM_NOTICE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_OAUTH2_ACCESS_TOKEN_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_OAUTH2_ACCESS_TOKEN_SEQ";
CREATE SEQUENCE "SYSTEM_OAUTH2_ACCESS_TOKEN_SEQ" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_OAUTH2_APPROVE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_OAUTH2_APPROVE_SEQ";
CREATE SEQUENCE "SYSTEM_OAUTH2_APPROVE_SEQ" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_OAUTH2_CLIENT_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_OAUTH2_CLIENT_SEQ";
CREATE SEQUENCE "SYSTEM_OAUTH2_CLIENT_SEQ" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_OAUTH2_CODE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_OAUTH2_CODE_SEQ";
CREATE SEQUENCE "SYSTEM_OAUTH2_CODE_SEQ" MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_OPERATE_LOG_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_OPERATE_LOG_SEQ";
CREATE SEQUENCE "SYSTEM_OPERATE_LOG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_POST_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_POST_SEQ";
CREATE SEQUENCE "SYSTEM_POST_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_ROLE_MENU_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_ROLE_MENU_SEQ";
CREATE SEQUENCE "SYSTEM_ROLE_MENU_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_ROLE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_ROLE_SEQ";
CREATE SEQUENCE "SYSTEM_ROLE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_SENSITIVE_WORD_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_SENSITIVE_WORD_SEQ";
CREATE SEQUENCE "SYSTEM_SENSITIVE_WORD_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_SMS_CHANNEL_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_SMS_CHANNEL_SEQ";
CREATE SEQUENCE "SYSTEM_SMS_CHANNEL_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_SMS_CODE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_SMS_CODE_SEQ";
CREATE SEQUENCE "SYSTEM_SMS_CODE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_SMS_LOG_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_SMS_LOG_SEQ";
CREATE SEQUENCE "SYSTEM_SMS_LOG_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_SMS_TEMPLATE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_SMS_TEMPLATE_SEQ";
CREATE SEQUENCE "SYSTEM_SMS_TEMPLATE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_SOCIAL_USER_BIND_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_SOCIAL_USER_BIND_SEQ";
CREATE SEQUENCE "SYSTEM_SOCIAL_USER_BIND_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_SOCIAL_USER_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_SOCIAL_USER_SEQ";
CREATE SEQUENCE "SYSTEM_SOCIAL_USER_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_TENANT_PACKAGE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_TENANT_PACKAGE_SEQ";
CREATE SEQUENCE "SYSTEM_TENANT_PACKAGE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_TENANT_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_TENANT_SEQ";
CREATE SEQUENCE "SYSTEM_TENANT_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_USER_POST_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_USER_POST_SEQ";
CREATE SEQUENCE "SYSTEM_USER_POST_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_USER_ROLE_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_USER_ROLE_SEQ";
CREATE SEQUENCE "SYSTEM_USER_ROLE_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_USER_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_USER_SEQ";
CREATE SEQUENCE "SYSTEM_USER_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Sequence structure for SYSTEM_USER_SESSION_SEQ
-- ----------------------------
DROP SEQUENCE "SYSTEM_USER_SESSION_SEQ";
CREATE SEQUENCE "SYSTEM_USER_SESSION_SEQ" MINVALUE 0 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 CACHE 20;

-- ----------------------------
-- Checks structure for table BPM_FORM
-- ----------------------------
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C007768" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C007769" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C007770" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C007771" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C007772" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C008199" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C008446" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C008447" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C008448" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C008449" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C008450" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_FORM" ADD CONSTRAINT "SYS_C008451" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table BPM_OA_LEAVE
-- ----------------------------
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007773" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007774" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007775" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007776" CHECK ("START_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007777" CHECK ("END_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007778" CHECK ("DAY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007779" CHECK ("RESULT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007780" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007781" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C007782" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008200" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008452" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008453" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008454" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008455" CHECK ("START_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008456" CHECK ("END_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008457" CHECK ("DAY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008458" CHECK ("RESULT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008459" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008460" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008461" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_OA_LEAVE" ADD CONSTRAINT "SYS_C008462" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table BPM_PROCESS_DEFINITION_EXT
-- ----------------------------
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C007783" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C007784" CHECK ("FORM_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C007785" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C007786" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C007787" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C008201" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C008463" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C008464" CHECK ("FORM_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C008465" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C008466" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C008467" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_DEFINITION_EXT" ADD CONSTRAINT "SYS_C008468" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table BPM_PROCESS_INSTANCE_EXT
-- ----------------------------
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C007788" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C007789" CHECK ("START_USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C007790" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C007791" CHECK ("RESULT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C007792" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C007793" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C007794" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008202" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008469" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008470" CHECK ("START_USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008471" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008472" CHECK ("RESULT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008473" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008474" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008475" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_PROCESS_INSTANCE_EXT" ADD CONSTRAINT "SYS_C008476" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table BPM_TASK_ASSIGN_RULE
-- ----------------------------
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C007795" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C007796" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C007797" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C007798" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C007799" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C008203" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C008477" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C008478" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C008479" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C008480" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C008481" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_ASSIGN_RULE" ADD CONSTRAINT "SYS_C008482" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table BPM_TASK_EXT
-- ----------------------------
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C007800" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C007801" CHECK ("RESULT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C007802" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C007803" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C007804" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C008204" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C008483" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C008484" CHECK ("RESULT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C008485" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C008486" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C008487" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_TASK_EXT" ADD CONSTRAINT "SYS_C008488" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table BPM_USER_GROUP
-- ----------------------------
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C007807" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C007808" CHECK ("MEMBER_USER_IDS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C007809" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C007810" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C007811" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C007812" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C008205" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C008489" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C008490" CHECK ("MEMBER_USER_IDS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C008491" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C008492" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C008493" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C008494" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "BPM_USER_GROUP" ADD CONSTRAINT "SYS_C008495" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_API_ACCESS_LOG
-- ----------------------------
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007829" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007830" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007831" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007832" CHECK ("BEGIN_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007833" CHECK ("END_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007834" CHECK ("DURATION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007835" CHECK ("RESULT_CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007836" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007837" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C007838" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008496" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008497" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008498" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008499" CHECK ("BEGIN_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008500" CHECK ("END_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008501" CHECK ("DURATION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008502" CHECK ("RESULT_CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008503" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008504" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ACCESS_LOG" ADD CONSTRAINT "SYS_C008505" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_API_ERROR_LOG
-- ----------------------------
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007851" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007852" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007853" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007854" CHECK ("EXCEPTION_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007855" CHECK ("EXCEPTION_MESSAGE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007856" CHECK ("EXCEPTION_ROOT_CAUSE_MESSAGE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007857" CHECK ("EXCEPTION_STACK_TRACE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007858" CHECK ("EXCEPTION_LINE_NUMBER" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007859" CHECK ("PROCESS_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007860" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007861" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C007862" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008506" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008507" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008508" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008509" CHECK ("EXCEPTION_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008510" CHECK ("EXCEPTION_MESSAGE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008511" CHECK ("EXCEPTION_ROOT_CAUSE_MESSAGE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008512" CHECK ("EXCEPTION_STACK_TRACE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008513" CHECK ("EXCEPTION_LINE_NUMBER" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008514" CHECK ("PROCESS_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008515" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008516" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_API_ERROR_LOG" ADD CONSTRAINT "SYS_C008517" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_CODEGEN_COLUMN
-- ----------------------------
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C007839" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C007840" CHECK ("TABLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C007841" CHECK ("ORDINAL_POSITION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C007842" CHECK ("LIST_OPERATION_CONDITION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C007843" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C007844" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C008518" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C008519" CHECK ("TABLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C008520" CHECK ("ORDINAL_POSITION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C008521" CHECK ("LIST_OPERATION_CONDITION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C008522" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_COLUMN" ADD CONSTRAINT "SYS_C008523" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_CODEGEN_TABLE
-- ----------------------------
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C007845" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C007846" CHECK ("DATA_SOURCE_CONFIG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C007847" CHECK ("SCENE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C007848" CHECK ("TEMPLATE_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C007849" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C007850" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C008524" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C008525" CHECK ("DATA_SOURCE_CONFIG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C008526" CHECK ("SCENE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C008527" CHECK ("TEMPLATE_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C008528" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CODEGEN_TABLE" ADD CONSTRAINT "SYS_C008529" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_CONFIG
-- ----------------------------
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C007863" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C007864" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C007865" CHECK ("VISIBLE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C007866" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C007867" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C008530" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C008531" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C008532" CHECK ("VISIBLE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C008533" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_CONFIG" ADD CONSTRAINT "SYS_C008534" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_DATA_SOURCE_CONFIG
-- ----------------------------
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008187" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008188" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008189" CHECK ("URL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008190" CHECK ("USERNAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008191" CHECK ("PASSWORD" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008192" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008193" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008194" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008535" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008536" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008537" CHECK ("URL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008538" CHECK ("USERNAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008539" CHECK ("PASSWORD" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008540" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008541" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_DATA_SOURCE_CONFIG" ADD CONSTRAINT "SYS_C008542" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_FILE
-- ----------------------------
ALTER TABLE "INFRA_FILE" ADD CONSTRAINT "SYS_C007868" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE" ADD CONSTRAINT "SYS_C007869" CHECK ("SIZE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE" ADD CONSTRAINT "SYS_C007870" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE" ADD CONSTRAINT "SYS_C007871" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE" ADD CONSTRAINT "SYS_C008543" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE" ADD CONSTRAINT "SYS_C008544" CHECK ("SIZE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE" ADD CONSTRAINT "SYS_C008545" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE" ADD CONSTRAINT "SYS_C008546" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_FILE_CONFIG
-- ----------------------------
ALTER TABLE "INFRA_FILE_CONFIG" ADD CONSTRAINT "SYS_C007872" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONFIG" ADD CONSTRAINT "SYS_C007873" CHECK ("STORAGE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONFIG" ADD CONSTRAINT "SYS_C007874" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONFIG" ADD CONSTRAINT "SYS_C007875" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONFIG" ADD CONSTRAINT "SYS_C008547" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONFIG" ADD CONSTRAINT "SYS_C008548" CHECK ("STORAGE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONFIG" ADD CONSTRAINT "SYS_C008549" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONFIG" ADD CONSTRAINT "SYS_C008550" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_FILE_CONTENT
-- ----------------------------
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C007876" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C007877" CHECK ("CONFIG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C007878" CHECK ("CONTENT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C007879" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C007880" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C008551" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C008552" CHECK ("CONFIG_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C008553" CHECK ("CONTENT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C008554" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_FILE_CONTENT" ADD CONSTRAINT "SYS_C008555" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_JOB
-- ----------------------------
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C007881" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C007882" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C007883" CHECK ("RETRY_COUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C007884" CHECK ("RETRY_INTERVAL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C007885" CHECK ("MONITOR_TIMEOUT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C007886" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C007887" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C008556" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C008557" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C008558" CHECK ("RETRY_COUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C008559" CHECK ("RETRY_INTERVAL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C008560" CHECK ("MONITOR_TIMEOUT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C008561" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB" ADD CONSTRAINT "SYS_C008562" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_JOB_LOG
-- ----------------------------
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C007894" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C007895" CHECK ("JOB_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C007896" CHECK ("EXECUTE_INDEX" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C007897" CHECK ("BEGIN_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C007898" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C007899" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C007900" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C008563" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C008564" CHECK ("JOB_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C008565" CHECK ("EXECUTE_INDEX" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C008566" CHECK ("BEGIN_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C008567" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C008568" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_JOB_LOG" ADD CONSTRAINT "SYS_C008569" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table INFRA_TEST_DEMO
-- ----------------------------
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C007888" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C007889" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C007890" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C007891" CHECK ("CATEGORY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C007892" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C007893" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C008570" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C008571" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C008572" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C008573" CHECK ("CATEGORY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C008574" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "INFRA_TEST_DEMO" ADD CONSTRAINT "SYS_C008575" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table MEMBER_USER
-- ----------------------------
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C007901" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C007902" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C007903" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C007904" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C007905" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C008576" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C008577" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C008578" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C008579" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "MEMBER_USER" ADD CONSTRAINT "SYS_C008580" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table PAY_APP
-- ----------------------------
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C007906" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C007907" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C007908" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C007909" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C007910" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C007911" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C008581" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C008582" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C008583" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C008584" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C008585" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_APP" ADD CONSTRAINT "SYS_C008586" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table PAY_CHANNEL
-- ----------------------------
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C007912" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C007913" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C007914" CHECK ("FEE_RATE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C007915" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C007916" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C007917" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C007918" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C007919" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C008587" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C008588" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C008589" CHECK ("FEE_RATE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C008590" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C008591" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C008592" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C008593" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_CHANNEL" ADD CONSTRAINT "SYS_C008594" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table PAY_MERCHANT
-- ----------------------------
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C007920" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C007921" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C007922" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C007923" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C007924" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C008595" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C008596" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C008597" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C008598" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_MERCHANT" ADD CONSTRAINT "SYS_C008599" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table PAY_NOTIFY_LOG
-- ----------------------------
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C007925" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C007926" CHECK ("TASK_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C007927" CHECK ("NOTIFY_TIMES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C007928" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C007929" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C007930" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C007931" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C008600" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C008601" CHECK ("TASK_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C008602" CHECK ("NOTIFY_TIMES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C008603" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C008604" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C008605" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_LOG" ADD CONSTRAINT "SYS_C008606" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table PAY_NOTIFY_TASK
-- ----------------------------
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007932" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007933" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007934" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007935" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007936" CHECK ("DATA_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007937" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007938" CHECK ("NEXT_NOTIFY_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007939" CHECK ("LAST_EXECUTE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007940" CHECK ("NOTIFY_TIMES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007941" CHECK ("MAX_NOTIFY_TIMES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007942" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007943" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C007944" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008607" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008608" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008609" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008610" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008611" CHECK ("DATA_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008612" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008613" CHECK ("NEXT_NOTIFY_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008614" CHECK ("LAST_EXECUTE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008615" CHECK ("NOTIFY_TIMES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008616" CHECK ("MAX_NOTIFY_TIMES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008617" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008618" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_NOTIFY_TASK" ADD CONSTRAINT "SYS_C008619" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table PAY_ORDER
-- ----------------------------
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007945" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007946" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007947" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007948" CHECK ("NOTIFY_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007949" CHECK ("AMOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007950" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007951" CHECK ("EXPIRE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007952" CHECK ("REFUND_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007953" CHECK ("REFUND_TIMES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007954" CHECK ("REFUND_AMOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007955" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007956" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C007957" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008620" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008621" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008622" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008623" CHECK ("NOTIFY_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008624" CHECK ("AMOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008625" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008626" CHECK ("EXPIRE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008627" CHECK ("REFUND_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008628" CHECK ("REFUND_TIMES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008629" CHECK ("REFUND_AMOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008630" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008631" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER" ADD CONSTRAINT "SYS_C008632" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table PAY_ORDER_EXTENSION
-- ----------------------------
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C007958" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C007959" CHECK ("ORDER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C007960" CHECK ("CHANNEL_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C007961" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C007962" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C007963" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C007964" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C008633" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C008634" CHECK ("ORDER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C008635" CHECK ("CHANNEL_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C008636" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C008637" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C008638" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_ORDER_EXTENSION" ADD CONSTRAINT "SYS_C008639" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table PAY_REFUND
-- ----------------------------
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007965" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007966" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007967" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007968" CHECK ("CHANNEL_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007969" CHECK ("ORDER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007970" CHECK ("NOTIFY_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007971" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007972" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007973" CHECK ("PAY_AMOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007974" CHECK ("REFUND_AMOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007975" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007976" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C007977" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008640" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008641" CHECK ("MERCHANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008642" CHECK ("APP_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008643" CHECK ("CHANNEL_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008644" CHECK ("ORDER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008645" CHECK ("NOTIFY_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008646" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008647" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008648" CHECK ("PAY_AMOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008649" CHECK ("REFUND_AMOUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008650" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008651" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "PAY_REFUND" ADD CONSTRAINT "SYS_C008652" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_BLOB_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "QRTZ_BLOB_TRIG_PK" PRIMARY KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");

-- ----------------------------
-- Checks structure for table QRTZ_BLOB_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "SYS_C008266" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "SYS_C008267" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "SYS_C008268" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "SYS_C008653" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "SYS_C008654" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "SYS_C008655" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_CALENDARS
-- ----------------------------
ALTER TABLE "QRTZ_CALENDARS" ADD CONSTRAINT "QRTZ_CALENDARS_PK" PRIMARY KEY ("SCHED_NAME", "CALENDAR_NAME");

-- ----------------------------
-- Checks structure for table QRTZ_CALENDARS
-- ----------------------------
ALTER TABLE "QRTZ_CALENDARS" ADD CONSTRAINT "SYS_C008271" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CALENDARS" ADD CONSTRAINT "SYS_C008272" CHECK ("CALENDAR_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CALENDARS" ADD CONSTRAINT "SYS_C008273" CHECK ("CALENDAR" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CALENDARS" ADD CONSTRAINT "SYS_C008656" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CALENDARS" ADD CONSTRAINT "SYS_C008657" CHECK ("CALENDAR_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CALENDARS" ADD CONSTRAINT "SYS_C008658" CHECK ("CALENDAR" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_CRON_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "QRTZ_CRON_TRIG_PK" PRIMARY KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");

-- ----------------------------
-- Checks structure for table QRTZ_CRON_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "SYS_C008255" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "SYS_C008256" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "SYS_C008257" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "SYS_C008258" CHECK ("CRON_EXPRESSION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "SYS_C008659" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "SYS_C008660" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "SYS_C008661" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "SYS_C008662" CHECK ("CRON_EXPRESSION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_FIRED_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "QRTZ_FIRED_TRIGGER_PK" PRIMARY KEY ("SCHED_NAME", "ENTRY_ID");

-- ----------------------------
-- Checks structure for table QRTZ_FIRED_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008278" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008279" CHECK ("ENTRY_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008280" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008281" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008282" CHECK ("INSTANCE_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008283" CHECK ("FIRED_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008284" CHECK ("SCHED_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008285" CHECK ("PRIORITY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008286" CHECK ("STATE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008663" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008664" CHECK ("ENTRY_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008665" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008666" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008667" CHECK ("INSTANCE_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008668" CHECK ("FIRED_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008669" CHECK ("SCHED_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008670" CHECK ("PRIORITY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT "SYS_C008671" CHECK ("STATE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table QRTZ_FIRED_TRIGGERS
-- ----------------------------
CREATE INDEX "IDX_QRTZ_FT_INST_JOB_REQ_RCVRY"
  ON "QRTZ_FIRED_TRIGGERS" ("SCHED_NAME" ASC, "INSTANCE_NAME" ASC, "REQUESTS_RECOVERY" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_FT_JG"
  ON "QRTZ_FIRED_TRIGGERS" ("SCHED_NAME" ASC, "JOB_GROUP" ASC)
  LOGGING
  ONLINE
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_FT_J_G"
  ON "QRTZ_FIRED_TRIGGERS" ("SCHED_NAME" ASC, "JOB_NAME" ASC, "JOB_GROUP" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_FT_TG"
  ON "QRTZ_FIRED_TRIGGERS" ("SCHED_NAME" ASC, "TRIGGER_GROUP" ASC) LOCAL
  LOGGING
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table QRTZ_JOB_DETAILS
-- ----------------------------
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "QRTZ_JOB_DETAILS_PK" PRIMARY KEY ("SCHED_NAME", "JOB_NAME", "JOB_GROUP");

-- ----------------------------
-- Checks structure for table QRTZ_JOB_DETAILS
-- ----------------------------
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "SYS_C008228" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "SYS_C008229" CHECK ("JOB_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "SYS_C008230" CHECK ("JOB_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "SYS_C008231" CHECK ("JOB_CLASS_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "SYS_C008232" CHECK ("IS_DURABLE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "SYS_C008233" CHECK ("IS_NONCONCURRENT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "SYS_C008234" CHECK ("IS_UPDATE_DATA" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT "SYS_C008235" CHECK ("REQUESTS_RECOVERY" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table QRTZ_JOB_DETAILS
-- ----------------------------
CREATE INDEX "IDX_QRTZ_J_GRP"
  ON "QRTZ_JOB_DETAILS" ("SCHED_NAME" ASC, "JOB_GROUP" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_J_REQ_RECOVERY"
  ON "QRTZ_JOB_DETAILS" ("SCHED_NAME" ASC, "REQUESTS_RECOVERY" ASC) LOCAL
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Primary Key structure for table QRTZ_LOCKS
-- ----------------------------
ALTER TABLE "QRTZ_LOCKS" ADD CONSTRAINT "QRTZ_LOCKS_PK" PRIMARY KEY ("SCHED_NAME", "LOCK_NAME");

-- ----------------------------
-- Checks structure for table QRTZ_LOCKS
-- ----------------------------
ALTER TABLE "QRTZ_LOCKS" ADD CONSTRAINT "SYS_C008293" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_LOCKS" ADD CONSTRAINT "SYS_C008294" CHECK ("LOCK_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_LOCKS" ADD CONSTRAINT "SYS_C008672" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_LOCKS" ADD CONSTRAINT "SYS_C008673" CHECK ("LOCK_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_PAUSED_TRIGGER_GRPS
-- ----------------------------
ALTER TABLE "QRTZ_PAUSED_TRIGGER_GRPS" ADD CONSTRAINT "QRTZ_PAUSED_TRIG_GRPS_PK" PRIMARY KEY ("SCHED_NAME", "TRIGGER_GROUP");

-- ----------------------------
-- Checks structure for table QRTZ_PAUSED_TRIGGER_GRPS
-- ----------------------------
ALTER TABLE "QRTZ_PAUSED_TRIGGER_GRPS" ADD CONSTRAINT "SYS_C008275" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_PAUSED_TRIGGER_GRPS" ADD CONSTRAINT "SYS_C008276" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_PAUSED_TRIGGER_GRPS" ADD CONSTRAINT "SYS_C008674" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_PAUSED_TRIGGER_GRPS" ADD CONSTRAINT "SYS_C008675" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_SCHEDULER_STATE
-- ----------------------------
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "QRTZ_SCHEDULER_STATE_PK" PRIMARY KEY ("SCHED_NAME", "INSTANCE_NAME");

-- ----------------------------
-- Checks structure for table QRTZ_SCHEDULER_STATE
-- ----------------------------
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "SYS_C008288" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "SYS_C008289" CHECK ("INSTANCE_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "SYS_C008290" CHECK ("LAST_CHECKIN_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "SYS_C008291" CHECK ("CHECKIN_INTERVAL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "SYS_C008676" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "SYS_C008677" CHECK ("INSTANCE_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "SYS_C008678" CHECK ("LAST_CHECKIN_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT "SYS_C008679" CHECK ("CHECKIN_INTERVAL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "QRTZ_SIMPLE_TRIG_PK" PRIMARY KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");

-- ----------------------------
-- Checks structure for table QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008247" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008248" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008249" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008250" CHECK ("REPEAT_COUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008251" CHECK ("REPEAT_INTERVAL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008252" CHECK ("TIMES_TRIGGERED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008680" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008681" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008682" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008683" CHECK ("REPEAT_COUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008684" CHECK ("REPEAT_INTERVAL" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "SYS_C008685" CHECK ("TIMES_TRIGGERED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "QRTZ_SIMPROP_TRIG_PK" PRIMARY KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");

-- ----------------------------
-- Checks structure for table QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "SYS_C008261" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "SYS_C008262" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "SYS_C008263" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "SYS_C008686" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "SYS_C008687" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "SYS_C008688" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table QRTZ_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "QRTZ_TRIGGERS_PK" PRIMARY KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP");

-- ----------------------------
-- Checks structure for table QRTZ_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008237" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008238" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008239" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008240" CHECK ("JOB_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008241" CHECK ("JOB_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008242" CHECK ("TRIGGER_STATE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008243" CHECK ("TRIGGER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008244" CHECK ("START_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008689" CHECK ("SCHED_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008690" CHECK ("TRIGGER_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008691" CHECK ("TRIGGER_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008692" CHECK ("JOB_NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008693" CHECK ("JOB_GROUP" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008694" CHECK ("TRIGGER_STATE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008695" CHECK ("TRIGGER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "SYS_C008696" CHECK ("START_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Indexes structure for table QRTZ_TRIGGERS
-- ----------------------------
CREATE INDEX "IDX_QRTZ_T_C"
  ON "QRTZ_TRIGGERS" ("SCHED_NAME" ASC, "CALENDAR_NAME" ASC) LOCAL
  LOGGING
  ONLINE
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_T_J"
  ON "QRTZ_TRIGGERS" ("SCHED_NAME" ASC, "JOB_NAME" ASC, "JOB_GROUP" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_T_JG"
  ON "QRTZ_TRIGGERS" ("SCHED_NAME" ASC, "JOB_GROUP" ASC) LOCAL
  LOGGING
  ONLINE
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_T_NEXT_FIRE_TIME"
  ON "QRTZ_TRIGGERS" ("SCHED_NAME" ASC, "NEXT_FIRE_TIME" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_T_NFT_ST"
  ON "QRTZ_TRIGGERS" ("SCHED_NAME" ASC, "TRIGGER_STATE" ASC, "NEXT_FIRE_TIME" ASC) LOCAL
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_T_NFT_ST_MISFIRE"
  ON "QRTZ_TRIGGERS" ("SCHED_NAME" ASC, "MISFIRE_INSTR" ASC, "NEXT_FIRE_TIME" ASC, "TRIGGER_STATE" ASC) LOCAL
  LOGGING
  ONLINE
  NOSORT
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);
CREATE INDEX "IDX_QRTZ_T_STATE"
  ON "QRTZ_TRIGGERS" ("SCHED_NAME" ASC, "TRIGGER_STATE" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  FREELISTS 1
  FREELIST GROUPS 1
  BUFFER_POOL DEFAULT
);

-- ----------------------------
-- Checks structure for table SYSTEM_DEPT
-- ----------------------------
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008030" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008031" CHECK ("PARENT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008032" CHECK ("SORT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008033" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008034" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008035" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008036" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008206" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008697" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008698" CHECK ("PARENT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008699" CHECK ("SORT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008700" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008701" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008702" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008703" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DEPT" ADD CONSTRAINT "SYS_C008704" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_DICT_DATA
-- ----------------------------
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008037" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008038" CHECK ("SORT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008039" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008040" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008041" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008207" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008705" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008706" CHECK ("SORT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008707" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008708" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008709" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_DATA" ADD CONSTRAINT "SYS_C008710" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_DICT_TYPE
-- ----------------------------
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008042" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008043" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008044" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008045" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008208" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008711" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008712" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008713" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008714" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_DICT_TYPE" ADD CONSTRAINT "SYS_C008715" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_ERROR_CODE
-- ----------------------------
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008046" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008047" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008048" CHECK ("CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008049" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008050" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008209" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008716" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008717" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008718" CHECK ("CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008719" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008720" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ERROR_CODE" ADD CONSTRAINT "SYS_C008721" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_LOGIN_LOG
-- ----------------------------
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008056" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008057" CHECK ("LOG_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008058" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008059" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008060" CHECK ("RESULT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008061" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008062" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008063" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008210" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008722" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008723" CHECK ("LOG_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008724" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008725" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008726" CHECK ("RESULT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008727" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008728" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008729" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_LOGIN_LOG" ADD CONSTRAINT "SYS_C008730" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_MENU
-- ----------------------------
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009625" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009626" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009628" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009629" CHECK ("SORT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009630" CHECK ("PARENT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009631" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009632" CHECK ("VISIBLE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009633" CHECK ("KEEP_ALIVE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009634" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009635" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_MENU" ADD CONSTRAINT "SYS_C009636" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_NOTICE
-- ----------------------------
ALTER TABLE "SYSTEM_NOTICE" ADD CONSTRAINT "SYS_C009566" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_NOTICE" ADD CONSTRAINT "SYS_C009567" CHECK ("CONTENT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_NOTICE" ADD CONSTRAINT "SYS_C009568" CHECK ("NOTICE_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_NOTICE" ADD CONSTRAINT "SYS_C009569" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_NOTICE" ADD CONSTRAINT "SYS_C009570" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_NOTICE" ADD CONSTRAINT "SYS_C009571" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_NOTICE" ADD CONSTRAINT "SYS_C009572" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_NOTICE" ADD CONSTRAINT "SYS_C009573" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table SYSTEM_OAUTH2_ACCESS_TOKEN
-- ----------------------------
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008444" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table SYSTEM_OAUTH2_ACCESS_TOKEN
-- ----------------------------
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008418" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008419" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008420" CHECK ("ACCESS_TOKEN" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008421" CHECK ("REFRESH_TOKEN" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008422" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008423" CHECK ("CLIENT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008424" CHECK ("EXPIRES_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008425" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008426" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008427" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_ACCESS_TOKEN" ADD CONSTRAINT "SYS_C008428" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_OAUTH2_APPROVE
-- ----------------------------
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009679" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009691" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009692" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009693" CHECK ("CLIENT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009694" CHECK ("SCOPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009695" CHECK ("APPROVED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009696" CHECK ("EXPIRES_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009697" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009698" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009699" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_APPROVE" ADD CONSTRAINT "SYS_C009700" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table SYSTEM_OAUTH2_CLIENT
-- ----------------------------
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008445" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table SYSTEM_OAUTH2_CLIENT
-- ----------------------------
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008429" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008430" CHECK ("CLIENT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008431" CHECK ("SECRET" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008432" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008433" CHECK ("LOGO" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008434" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008435" CHECK ("ACCESS_TOKEN_VALIDITY_SECONDS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008436" CHECK ("REFRESH_TOKEN_VALIDITY_SECONDS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008437" CHECK ("REDIRECT_URIS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008439" CHECK ("AUTHORIZED_GRANT_TYPES" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008440" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008441" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CLIENT" ADD CONSTRAINT "SYS_C008442" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_OAUTH2_CODE
-- ----------------------------
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009680" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009681" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009682" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009683" CHECK ("CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009684" CHECK ("CLIENT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009685" CHECK ("EXPIRES_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009687" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009688" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009689" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_CODE" ADD CONSTRAINT "SYS_C009690" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table SYSTEM_OAUTH2_REFRESH_TOKEN
-- ----------------------------
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008443" PRIMARY KEY ("ID");

-- ----------------------------
-- Checks structure for table SYSTEM_OAUTH2_REFRESH_TOKEN
-- ----------------------------
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008408" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008409" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008410" CHECK ("REFRESH_TOKEN" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008411" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008412" CHECK ("CLIENT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008413" CHECK ("EXPIRES_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008414" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008415" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008416" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OAUTH2_REFRESH_TOKEN" ADD CONSTRAINT "SYS_C008417" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_OPERATE_LOG
-- ----------------------------
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009574" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009575" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009576" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009577" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009578" CHECK ("START_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009579" CHECK ("DURATION" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009580" CHECK ("RESULT_CODE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009581" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009582" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009583" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_OPERATE_LOG" ADD CONSTRAINT "SYS_C009584" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_POST
-- ----------------------------
ALTER TABLE "SYSTEM_POST" ADD CONSTRAINT "SYS_C009585" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_POST" ADD CONSTRAINT "SYS_C009586" CHECK ("SORT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_POST" ADD CONSTRAINT "SYS_C009587" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_POST" ADD CONSTRAINT "SYS_C009588" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_POST" ADD CONSTRAINT "SYS_C009589" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_POST" ADD CONSTRAINT "SYS_C009590" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_POST" ADD CONSTRAINT "SYS_C009591" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_ROLE
-- ----------------------------
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009592" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009593" CHECK ("SORT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009594" CHECK ("DATA_SCOPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009595" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009596" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009597" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009598" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009599" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE" ADD CONSTRAINT "SYS_C009600" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_ROLE_MENU
-- ----------------------------
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008108" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008109" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008110" CHECK ("MENU_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008111" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008112" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008113" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008218" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008776" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008777" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008778" CHECK ("MENU_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008779" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008780" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008781" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_ROLE_MENU" ADD CONSTRAINT "SYS_C008782" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_SENSITIVE_WORD
-- ----------------------------
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008102" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008103" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008104" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008105" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008106" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008107" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008783" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008784" CHECK ("NAME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008785" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008786" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008787" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SENSITIVE_WORD" ADD CONSTRAINT "SYS_C008788" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_SMS_CHANNEL
-- ----------------------------
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008114" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008115" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008116" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008117" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008219" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008789" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008790" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008791" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008792" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CHANNEL" ADD CONSTRAINT "SYS_C008793" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_SMS_CODE
-- ----------------------------
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008118" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008119" CHECK ("SCENE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008120" CHECK ("TODAY_INDEX" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008121" CHECK ("USED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008122" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008123" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008124" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008220" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008794" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008795" CHECK ("SCENE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008796" CHECK ("TODAY_INDEX" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008797" CHECK ("USED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008798" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008799" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008800" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_CODE" ADD CONSTRAINT "SYS_C008801" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_SMS_LOG
-- ----------------------------
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008125" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008126" CHECK ("CHANNEL_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008127" CHECK ("TEMPLATE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008128" CHECK ("TEMPLATE_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008129" CHECK ("SEND_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008130" CHECK ("RECEIVE_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008131" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008132" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008221" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008802" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008803" CHECK ("CHANNEL_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008804" CHECK ("TEMPLATE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008805" CHECK ("TEMPLATE_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008806" CHECK ("SEND_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008807" CHECK ("RECEIVE_STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008808" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008809" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_LOG" ADD CONSTRAINT "SYS_C008810" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_SMS_TEMPLATE
-- ----------------------------
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008133" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008134" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008135" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008136" CHECK ("CHANNEL_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008137" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008138" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008222" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008811" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008812" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008813" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008814" CHECK ("CHANNEL_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008815" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008816" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SMS_TEMPLATE" ADD CONSTRAINT "SYS_C008817" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_SOCIAL_USER
-- ----------------------------
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008139" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008140" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008141" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008142" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008143" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008144" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008145" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008223" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008818" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008819" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008820" CHECK ("USER_TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008821" CHECK ("TYPE" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008822" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008823" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008824" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_SOCIAL_USER" ADD CONSTRAINT "SYS_C008825" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_TENANT
-- ----------------------------
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008146" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008147" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008148" CHECK ("PACKAGE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008149" CHECK ("EXPIRE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008150" CHECK ("ACCOUNT_COUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008151" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008152" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008224" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008826" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008827" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008828" CHECK ("PACKAGE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008829" CHECK ("EXPIRE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008830" CHECK ("ACCOUNT_COUNT" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008831" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008832" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT" ADD CONSTRAINT "SYS_C008833" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_TENANT_PACKAGE
-- ----------------------------
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008153" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008154" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008155" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008156" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008197" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008834" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008835" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008836" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008837" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_TENANT_PACKAGE" ADD CONSTRAINT "SYS_C008838" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_USERS
-- ----------------------------
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008157" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008158" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008159" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008160" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008161" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008227" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008839" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008840" CHECK ("STATUS" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008841" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008842" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008843" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USERS" ADD CONSTRAINT "SYS_C008844" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_USER_POST
-- ----------------------------
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008302" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008303" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008304" CHECK ("POST_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008305" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008306" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008307" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008308" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008845" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008846" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008847" CHECK ("POST_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008848" CHECK ("CREATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008849" CHECK ("UPDATE_TIME" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008850" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_POST" ADD CONSTRAINT "SYS_C008851" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYSTEM_USER_ROLE
-- ----------------------------
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008162" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008163" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008164" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008165" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008226" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008852" CHECK ("ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008853" CHECK ("USER_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008854" CHECK ("ROLE_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008855" CHECK ("TENANT_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
ALTER TABLE "SYSTEM_USER_ROLE" ADD CONSTRAINT "SYS_C008856" CHECK ("DELETED" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Foreign Keys structure for table QRTZ_BLOB_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "QRTZ_BLOB_TRIG_TO_TRIG_FK" FOREIGN KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") REFERENCES "QRTZ_TRIGGERS" ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Foreign Keys structure for table QRTZ_CRON_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "QRTZ_CRON_TRIG_TO_TRIG_FK" FOREIGN KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") REFERENCES "QRTZ_TRIGGERS" ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Foreign Keys structure for table QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "QRTZ_SIMPLE_TRIG_TO_TRIG_FK" FOREIGN KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") REFERENCES "QRTZ_TRIGGERS" ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Foreign Keys structure for table QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "QRTZ_SIMPROP_TRIG_TO_TRIG_FK" FOREIGN KEY ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") REFERENCES "QRTZ_TRIGGERS" ("SCHED_NAME", "TRIGGER_NAME", "TRIGGER_GROUP") NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
