/*
 Navicat Premium Data Transfer

 Source Server         : onemall
 Source Server Type    : MySQL
 Source Server Version : 50726
 Source Host           : 192.168.88.14:3306
 Source Schema         : mall_user

 Target Server Type    : MySQL
 Target Server Version : 50726
 File Encoding         : 65001

 Date: 13/03/2020 07:37:23
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for mobile_code
-- ----------------------------
DROP TABLE IF EXISTS `mobile_code`;
CREATE TABLE `mobile_code` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mobile` varchar(11) NOT NULL,
  `code` varchar(6) NOT NULL,
  `today_index` tinyint(4) NOT NULL,
  `used` tinyint(4) NOT NULL,
  `used_user_id` int(20) DEFAULT NULL,
  `used_time` datetime DEFAULT NULL,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=399 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for oauth2_refresh_token
-- ----------------------------
DROP TABLE IF EXISTS `oauth2_refresh_token`;
CREATE TABLE `oauth2_refresh_token` (
  `id` varchar(32) NOT NULL,
  `user_id` int(20) DEFAULT NULL,
  `valid` tinyint(4) DEFAULT NULL,
  `expires_time` datetime DEFAULT NULL,
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_uid` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for user_address
-- ----------------------------
DROP TABLE IF EXISTS `user_address`;
CREATE TABLE `user_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '用户编号',
  `area_no` varchar(10) COLLATE utf8mb4_bin NOT NULL COMMENT '区域编号',
  `name` varchar(10) COLLATE utf8mb4_bin NOT NULL COMMENT '收件人名称',
  `mobile` varchar(20) COLLATE utf8mb4_bin NOT NULL COMMENT '手机号',
  `address` varchar(250) COLLATE utf8mb4_bin NOT NULL COMMENT '详细地址',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `has_default` int(1) NOT NULL COMMENT '是否默认',
  `deleted` int(2) NOT NULL COMMENT '删除状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Records of user_address
-- ----------------------------
BEGIN;
INSERT INTO `user_address` VALUES (1, 1, '230102', 'mi', '13302926050', '湖南省深圳市北京去3环', '2019-04-06 17:06:12', '2019-04-06 18:20:11', 0, 0);
INSERT INTO `user_address` VALUES (2, 1, '22033', 'sin', '18132019023', '湖南省深圳市北京3环56号', '2019-04-06 17:13:13', NULL, 0, 0);
INSERT INTO `user_address` VALUES (3, 1, '110101', '--23', '13302926050', '1231323123213123', '2019-04-06 18:04:29', '2019-04-08 13:53:37', 0, 0);
INSERT INTO `user_address` VALUES (4, 1, '220302', 'sin', '18132019023', '湖南省深圳市北京3环56号', '2019-04-06 18:17:16', NULL, 0, 1);
INSERT INTO `user_address` VALUES (5, 1, '220302', 'sin', '18132019023', '湖南省深圳市北京3环56号', '2019-04-06 18:17:44', '2019-04-06 18:22:29', 0, 0);
INSERT INTO `user_address` VALUES (6, 29, '110101', 'Andy', '13302925934', '中二环，光电大厦11F 前台收', '2019-04-10 19:48:06', '2019-04-11 21:11:42', 2, 0);
INSERT INTO `user_address` VALUES (7, 29, '110101', 'md', '19089233321', 'bsdafosabdfasdbfsadfasdfsdfsaf', '2019-04-11 21:11:13', '2019-04-11 21:11:32', 1, 0);
INSERT INTO `user_address` VALUES (8, 43, '110113', '李永东', '17610928218', '国测8号A区6号楼2单元', '2019-04-29 14:12:07', NULL, 1, 0);
INSERT INTO `user_address` VALUES (9, 43, '110113', '李永东', '17610928218', '国测8号A区6号楼2单元', '2019-04-29 14:12:07', NULL, 1, 0);
INSERT INTO `user_address` VALUES (10, 43, '110113', '李永东', '17610928218', '国测8号A区6号楼2单元', '2019-04-29 14:12:07', NULL, 1, 0);
INSERT INTO `user_address` VALUES (11, 61, '110101', 'sfasdf', '13124278822', 'asdfasdfsd', '2019-05-07 14:16:17', NULL, 2, 0);
INSERT INTO `user_address` VALUES (12, 67, '120101', 'xxx', '18670071886', '2`121`2`12', '2019-05-10 21:05:58', NULL, 1, 0);
INSERT INTO `user_address` VALUES (13, 73, '110101', '芋道源码', '15601691388', '北京五环，就是五环啊', '2019-05-17 17:57:35', NULL, 1, 0);
INSERT INTO `user_address` VALUES (14, 76, '110101', 'tt', '15977944314', 'ttttttttttt', '2019-05-20 11:48:34', NULL, 2, 0);
INSERT INTO `user_address` VALUES (15, 90, '110101', '手', '15555555555', '老婆婆给你信咯lol明您了lol', '2019-05-29 18:33:09', NULL, 2, 0);
INSERT INTO `user_address` VALUES (16, 92, '110102', '333', '13511111111', '北京市商城测试地址3335666', '2019-05-30 17:50:55', NULL, 1, 0);
INSERT INTO `user_address` VALUES (17, 92, '110101', '测', '13612345678', '测试地址的打对方 13666', '2019-05-30 17:52:53', NULL, 2, 0);
INSERT INTO `user_address` VALUES (18, 197, '110101', '胡家明', '18856655656', '44444444444', '2019-08-12 17:35:00', NULL, 2, 0);
COMMIT;

-- ----------------------------
-- Table structure for user_register
-- ----------------------------
DROP TABLE IF EXISTS `user_register`;
CREATE TABLE `user_register` (
  `id` int(20) NOT NULL,
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `udpate_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of user_register
-- ----------------------------
BEGIN;
INSERT INTO `user_register` VALUES (10, '2018-09-23 00:16:10', '2018-09-22 06:31:27');
INSERT INTO `user_register` VALUES (11, '2018-09-26 19:26:36', '2018-09-24 00:55:39');
INSERT INTO `user_register` VALUES (22, '2019-02-25 16:10:37', '2019-02-23 19:21:39');
INSERT INTO `user_register` VALUES (23, '2019-02-25 16:16:29', '2019-02-23 19:27:31');
INSERT INTO `user_register` VALUES (25, '2019-02-25 16:20:54', '2019-02-23 19:31:56');
INSERT INTO `user_register` VALUES (26, '2019-02-26 01:35:53', '2019-02-23 20:51:31');
INSERT INTO `user_register` VALUES (27, '2019-03-28 14:41:06', '2019-03-28 14:41:06');
INSERT INTO `user_register` VALUES (28, '2019-04-04 19:27:00', '2019-04-04 19:27:00');
INSERT INTO `user_register` VALUES (29, '2019-04-09 21:44:10', '2019-04-09 21:44:10');
INSERT INTO `user_register` VALUES (30, '2019-04-22 19:50:37', '2019-04-22 19:50:37');
INSERT INTO `user_register` VALUES (31, '2019-04-22 21:24:35', '2019-04-22 21:24:35');
INSERT INTO `user_register` VALUES (32, '2019-04-22 21:26:56', '2019-04-22 21:26:55');
INSERT INTO `user_register` VALUES (33, '2019-04-22 21:27:18', '2019-04-22 21:27:17');
INSERT INTO `user_register` VALUES (34, '2019-04-22 21:43:52', '2019-04-22 21:43:51');
INSERT INTO `user_register` VALUES (35, '2019-04-22 22:19:18', '2019-04-22 22:19:17');
INSERT INTO `user_register` VALUES (36, '2019-04-22 23:22:13', '2019-04-22 23:22:12');
INSERT INTO `user_register` VALUES (37, '2019-04-22 23:43:53', '2019-04-22 23:43:52');
INSERT INTO `user_register` VALUES (38, '2019-04-22 23:45:24', '2019-04-22 23:45:24');
INSERT INTO `user_register` VALUES (39, '2019-04-23 07:53:37', '2019-04-23 07:53:36');
INSERT INTO `user_register` VALUES (40, '2019-04-23 09:05:17', '2019-04-23 09:05:16');
INSERT INTO `user_register` VALUES (41, '2019-04-24 08:18:03', '2019-04-24 08:18:02');
INSERT INTO `user_register` VALUES (42, '2019-04-28 07:54:17', '2019-04-28 07:54:16');
INSERT INTO `user_register` VALUES (43, '2019-04-29 14:11:13', '2019-04-29 14:11:12');
INSERT INTO `user_register` VALUES (44, '2019-04-29 14:30:14', '2019-04-29 14:30:13');
INSERT INTO `user_register` VALUES (51, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (46, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (48, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (45, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (52, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (50, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (53, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (47, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (54, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (49, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (55, '2019-05-01 15:40:19', '2019-05-01 15:40:19');
INSERT INTO `user_register` VALUES (56, '2019-05-04 02:38:50', '2019-05-04 02:38:49');
INSERT INTO `user_register` VALUES (57, '2019-05-05 15:57:44', '2019-05-05 15:57:44');
INSERT INTO `user_register` VALUES (58, '2019-05-05 16:20:06', '2019-05-05 16:20:05');
INSERT INTO `user_register` VALUES (59, '2019-05-05 19:11:59', '2019-05-05 19:11:58');
INSERT INTO `user_register` VALUES (60, '2019-05-06 17:27:41', '2019-05-06 17:27:41');
INSERT INTO `user_register` VALUES (61, '2019-05-07 14:15:52', '2019-05-07 14:15:52');
INSERT INTO `user_register` VALUES (62, '2019-05-07 18:12:30', '2019-05-07 18:12:30');
INSERT INTO `user_register` VALUES (63, '2019-05-08 09:55:14', '2019-05-08 09:55:13');
INSERT INTO `user_register` VALUES (64, '2019-05-08 16:37:46', '2019-05-08 16:37:45');
INSERT INTO `user_register` VALUES (65, '2019-05-08 20:16:10', '2019-05-08 20:16:10');
INSERT INTO `user_register` VALUES (66, '2019-05-09 19:36:57', '2019-05-09 19:36:57');
INSERT INTO `user_register` VALUES (67, '2019-05-10 21:05:25', '2019-05-10 21:05:24');
INSERT INTO `user_register` VALUES (68, '2019-05-10 22:10:38', '2019-05-10 22:10:37');
INSERT INTO `user_register` VALUES (69, '2019-05-11 00:24:00', '2019-05-11 00:23:59');
INSERT INTO `user_register` VALUES (70, '2019-05-12 07:33:22', '2019-05-12 07:33:22');
INSERT INTO `user_register` VALUES (71, '2019-05-13 09:53:52', '2019-05-13 09:53:51');
INSERT INTO `user_register` VALUES (72, '2019-05-17 00:25:54', '2019-05-17 00:25:53');
INSERT INTO `user_register` VALUES (73, '2019-05-17 17:49:25', '2019-05-17 17:49:25');
INSERT INTO `user_register` VALUES (74, '2019-05-17 21:52:55', '2019-05-17 21:52:54');
INSERT INTO `user_register` VALUES (75, '2019-05-18 15:55:44', '2019-05-18 15:55:43');
INSERT INTO `user_register` VALUES (76, '2019-05-20 11:47:51', '2019-05-20 11:47:50');
INSERT INTO `user_register` VALUES (77, '2019-05-21 17:32:38', '2019-05-21 17:32:37');
INSERT INTO `user_register` VALUES (78, '2019-05-22 15:51:01', '2019-05-22 15:51:01');
INSERT INTO `user_register` VALUES (79, '2019-05-23 14:27:45', '2019-05-23 14:27:44');
INSERT INTO `user_register` VALUES (80, '2019-05-23 17:55:58', '2019-05-23 17:55:57');
INSERT INTO `user_register` VALUES (81, '2019-05-24 11:31:45', '2019-05-24 11:31:45');
INSERT INTO `user_register` VALUES (82, '2019-05-24 12:40:53', '2019-05-24 12:40:52');
INSERT INTO `user_register` VALUES (83, '2019-05-24 17:47:00', '2019-05-24 17:47:00');
INSERT INTO `user_register` VALUES (84, '2019-05-27 09:58:17', '2019-05-27 09:58:16');
INSERT INTO `user_register` VALUES (85, '2019-05-28 09:09:18', '2019-05-28 09:09:17');
INSERT INTO `user_register` VALUES (86, '2019-05-28 14:10:39', '2019-05-28 14:10:39');
INSERT INTO `user_register` VALUES (87, '2019-05-28 16:18:00', '2019-05-28 16:18:01');
INSERT INTO `user_register` VALUES (88, '2019-05-28 16:55:36', '2019-05-28 16:55:36');
INSERT INTO `user_register` VALUES (89, '2019-05-28 22:39:22', '2019-05-28 22:39:21');
INSERT INTO `user_register` VALUES (90, '2019-05-29 18:31:59', '2019-05-29 18:31:59');
INSERT INTO `user_register` VALUES (91, '2019-05-30 09:38:34', '2019-05-30 09:38:33');
INSERT INTO `user_register` VALUES (92, '2019-05-30 17:47:12', '2019-05-30 17:47:11');
INSERT INTO `user_register` VALUES (93, '2019-05-31 17:10:44', '2019-05-31 17:10:44');
INSERT INTO `user_register` VALUES (94, '2019-06-01 08:04:57', '2019-06-01 08:04:56');
INSERT INTO `user_register` VALUES (95, '2019-06-01 10:09:17', '2019-06-01 10:09:16');
INSERT INTO `user_register` VALUES (96, '2019-06-01 15:58:38', '2019-06-01 15:58:38');
INSERT INTO `user_register` VALUES (97, '2019-06-01 18:21:57', '2019-06-01 18:21:56');
INSERT INTO `user_register` VALUES (98, '2019-06-01 18:24:07', '2019-06-01 18:24:06');
INSERT INTO `user_register` VALUES (99, '2019-06-01 23:56:49', '2019-06-01 23:56:48');
INSERT INTO `user_register` VALUES (100, '2019-06-02 18:10:33', '2019-06-02 18:10:33');
INSERT INTO `user_register` VALUES (101, '2019-06-02 22:38:28', '2019-06-02 22:38:27');
INSERT INTO `user_register` VALUES (102, '2019-06-03 17:12:47', '2019-06-03 17:12:47');
INSERT INTO `user_register` VALUES (103, '2019-06-04 10:26:05', '2019-06-04 10:26:05');
INSERT INTO `user_register` VALUES (104, '2019-06-04 12:41:14', '2019-06-04 12:41:13');
INSERT INTO `user_register` VALUES (105, '2019-06-04 16:31:46', '2019-06-04 16:31:46');
INSERT INTO `user_register` VALUES (106, '2019-06-04 20:26:23', '2019-06-04 20:26:22');
INSERT INTO `user_register` VALUES (107, '2019-06-04 21:14:13', '2019-06-04 21:14:13');
INSERT INTO `user_register` VALUES (108, '2019-06-05 09:31:39', '2019-06-05 09:31:39');
INSERT INTO `user_register` VALUES (109, '2019-06-05 17:42:21', '2019-06-05 17:42:20');
INSERT INTO `user_register` VALUES (110, '2019-06-06 14:11:53', '2019-06-06 14:11:52');
INSERT INTO `user_register` VALUES (111, '2019-06-07 13:49:30', '2019-06-07 13:49:30');
INSERT INTO `user_register` VALUES (112, '2019-06-07 14:30:31', '2019-06-07 14:30:31');
INSERT INTO `user_register` VALUES (113, '2019-06-08 22:20:00', '2019-06-08 22:20:00');
INSERT INTO `user_register` VALUES (114, '2019-06-08 22:25:01', '2019-06-08 22:25:01');
INSERT INTO `user_register` VALUES (115, '2019-06-09 20:15:18', '2019-06-09 20:15:17');
INSERT INTO `user_register` VALUES (116, '2019-06-09 22:56:12', '2019-06-09 22:56:11');
INSERT INTO `user_register` VALUES (117, '2019-06-11 14:58:04', '2019-06-11 14:58:04');
INSERT INTO `user_register` VALUES (118, '2019-06-11 15:52:55', '2019-06-11 15:52:54');
INSERT INTO `user_register` VALUES (119, '2019-06-11 17:28:11', '2019-06-11 17:28:10');
INSERT INTO `user_register` VALUES (120, '2019-06-11 19:30:48', '2019-06-11 19:30:13');
INSERT INTO `user_register` VALUES (121, '2019-06-11 20:13:58', '2019-06-11 20:13:58');
INSERT INTO `user_register` VALUES (122, '2019-06-12 16:00:27', '2019-06-12 16:00:27');
INSERT INTO `user_register` VALUES (123, '2019-06-12 16:32:42', '2019-06-12 16:32:41');
INSERT INTO `user_register` VALUES (124, '2019-06-14 14:33:18', '2019-06-14 14:33:18');
INSERT INTO `user_register` VALUES (125, '2019-06-14 19:00:09', '2019-06-14 19:00:09');
INSERT INTO `user_register` VALUES (126, '2019-06-18 15:32:21', '2019-06-18 15:32:20');
INSERT INTO `user_register` VALUES (127, '2019-06-19 14:30:45', '2019-06-19 14:30:44');
INSERT INTO `user_register` VALUES (128, '2019-06-19 14:35:26', '2019-06-19 14:35:26');
INSERT INTO `user_register` VALUES (129, '2019-06-20 07:46:15', '2019-06-20 07:46:14');
INSERT INTO `user_register` VALUES (130, '2019-06-21 11:51:25', '2019-06-21 11:51:24');
INSERT INTO `user_register` VALUES (131, '2019-06-21 14:10:56', '2019-06-21 14:10:56');
INSERT INTO `user_register` VALUES (132, '2019-06-21 14:43:21', '2019-06-21 14:43:20');
INSERT INTO `user_register` VALUES (133, '2019-06-21 15:39:05', '2019-06-21 15:39:04');
INSERT INTO `user_register` VALUES (134, '2019-06-23 19:01:58', '2019-06-23 19:01:57');
INSERT INTO `user_register` VALUES (135, '2019-06-23 22:24:30', '2019-06-23 22:24:29');
INSERT INTO `user_register` VALUES (136, '2019-06-24 14:10:39', '2019-06-24 14:10:39');
INSERT INTO `user_register` VALUES (137, '2019-06-24 15:08:54', '2019-06-24 15:08:54');
INSERT INTO `user_register` VALUES (138, '2019-06-24 17:39:36', '2019-06-24 17:39:35');
INSERT INTO `user_register` VALUES (139, '2019-06-25 09:54:06', '2019-06-25 09:54:06');
INSERT INTO `user_register` VALUES (140, '2019-06-25 11:27:30', '2019-06-25 11:27:30');
INSERT INTO `user_register` VALUES (141, '2019-06-26 14:55:31', '2019-06-26 14:55:30');
INSERT INTO `user_register` VALUES (142, '2019-06-27 14:27:14', '2019-06-27 14:27:13');
INSERT INTO `user_register` VALUES (143, '2019-06-30 20:28:12', '2019-06-30 20:28:12');
INSERT INTO `user_register` VALUES (10, '2018-09-23 00:16:10', '2018-09-22 06:31:27');
INSERT INTO `user_register` VALUES (11, '2018-09-26 19:26:36', '2018-09-24 00:55:39');
INSERT INTO `user_register` VALUES (22, '2019-02-25 16:10:37', '2019-02-23 19:21:39');
INSERT INTO `user_register` VALUES (23, '2019-02-25 16:16:29', '2019-02-23 19:27:31');
INSERT INTO `user_register` VALUES (25, '2019-02-25 16:20:54', '2019-02-23 19:31:56');
INSERT INTO `user_register` VALUES (26, '2019-02-26 01:35:53', '2019-02-23 20:51:31');
INSERT INTO `user_register` VALUES (27, '2019-03-28 14:41:06', '2019-03-28 14:41:06');
INSERT INTO `user_register` VALUES (28, '2019-04-04 19:27:00', '2019-04-04 19:27:00');
INSERT INTO `user_register` VALUES (29, '2019-04-09 21:44:10', '2019-04-09 21:44:10');
INSERT INTO `user_register` VALUES (30, '2019-04-22 19:50:37', '2019-04-22 19:50:37');
INSERT INTO `user_register` VALUES (31, '2019-04-22 21:24:35', '2019-04-22 21:24:35');
INSERT INTO `user_register` VALUES (32, '2019-04-22 21:26:56', '2019-04-22 21:26:55');
INSERT INTO `user_register` VALUES (33, '2019-04-22 21:27:18', '2019-04-22 21:27:17');
INSERT INTO `user_register` VALUES (34, '2019-04-22 21:43:52', '2019-04-22 21:43:51');
INSERT INTO `user_register` VALUES (35, '2019-04-22 22:19:18', '2019-04-22 22:19:17');
INSERT INTO `user_register` VALUES (36, '2019-04-22 23:22:13', '2019-04-22 23:22:12');
INSERT INTO `user_register` VALUES (37, '2019-04-22 23:43:53', '2019-04-22 23:43:52');
INSERT INTO `user_register` VALUES (38, '2019-04-22 23:45:24', '2019-04-22 23:45:24');
INSERT INTO `user_register` VALUES (39, '2019-04-23 07:53:37', '2019-04-23 07:53:36');
INSERT INTO `user_register` VALUES (40, '2019-04-23 09:05:17', '2019-04-23 09:05:16');
INSERT INTO `user_register` VALUES (41, '2019-04-24 08:18:03', '2019-04-24 08:18:02');
INSERT INTO `user_register` VALUES (42, '2019-04-28 07:54:17', '2019-04-28 07:54:16');
INSERT INTO `user_register` VALUES (43, '2019-04-29 14:11:13', '2019-04-29 14:11:12');
INSERT INTO `user_register` VALUES (44, '2019-04-29 14:30:14', '2019-04-29 14:30:13');
INSERT INTO `user_register` VALUES (51, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (46, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (48, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (45, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (52, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (50, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (53, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (47, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (54, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (49, '2019-04-30 20:58:53', '2019-04-30 20:58:55');
INSERT INTO `user_register` VALUES (55, '2019-05-01 15:40:19', '2019-05-01 15:40:19');
INSERT INTO `user_register` VALUES (56, '2019-05-04 02:38:50', '2019-05-04 02:38:49');
INSERT INTO `user_register` VALUES (57, '2019-05-05 15:57:44', '2019-05-05 15:57:44');
INSERT INTO `user_register` VALUES (58, '2019-05-05 16:20:06', '2019-05-05 16:20:05');
INSERT INTO `user_register` VALUES (59, '2019-05-05 19:11:59', '2019-05-05 19:11:58');
INSERT INTO `user_register` VALUES (60, '2019-05-06 17:27:41', '2019-05-06 17:27:41');
INSERT INTO `user_register` VALUES (61, '2019-05-07 14:15:52', '2019-05-07 14:15:52');
INSERT INTO `user_register` VALUES (62, '2019-05-07 18:12:30', '2019-05-07 18:12:30');
INSERT INTO `user_register` VALUES (63, '2019-05-08 09:55:14', '2019-05-08 09:55:13');
INSERT INTO `user_register` VALUES (64, '2019-05-08 16:37:46', '2019-05-08 16:37:45');
INSERT INTO `user_register` VALUES (65, '2019-05-08 20:16:10', '2019-05-08 20:16:10');
INSERT INTO `user_register` VALUES (66, '2019-05-09 19:36:57', '2019-05-09 19:36:57');
INSERT INTO `user_register` VALUES (67, '2019-05-10 21:05:25', '2019-05-10 21:05:24');
INSERT INTO `user_register` VALUES (68, '2019-05-10 22:10:38', '2019-05-10 22:10:37');
INSERT INTO `user_register` VALUES (69, '2019-05-11 00:24:00', '2019-05-11 00:23:59');
INSERT INTO `user_register` VALUES (70, '2019-05-12 07:33:22', '2019-05-12 07:33:22');
INSERT INTO `user_register` VALUES (71, '2019-05-13 09:53:52', '2019-05-13 09:53:51');
INSERT INTO `user_register` VALUES (72, '2019-05-17 00:25:54', '2019-05-17 00:25:53');
INSERT INTO `user_register` VALUES (73, '2019-05-17 17:49:25', '2019-05-17 17:49:25');
INSERT INTO `user_register` VALUES (74, '2019-05-17 21:52:55', '2019-05-17 21:52:54');
INSERT INTO `user_register` VALUES (75, '2019-05-18 15:55:44', '2019-05-18 15:55:43');
INSERT INTO `user_register` VALUES (76, '2019-05-20 11:47:51', '2019-05-20 11:47:50');
INSERT INTO `user_register` VALUES (77, '2019-05-21 17:32:38', '2019-05-21 17:32:37');
INSERT INTO `user_register` VALUES (78, '2019-05-22 15:51:01', '2019-05-22 15:51:01');
INSERT INTO `user_register` VALUES (79, '2019-05-23 14:27:45', '2019-05-23 14:27:44');
INSERT INTO `user_register` VALUES (80, '2019-05-23 17:55:58', '2019-05-23 17:55:57');
INSERT INTO `user_register` VALUES (81, '2019-05-24 11:31:45', '2019-05-24 11:31:45');
INSERT INTO `user_register` VALUES (82, '2019-05-24 12:40:53', '2019-05-24 12:40:52');
INSERT INTO `user_register` VALUES (83, '2019-05-24 17:47:00', '2019-05-24 17:47:00');
INSERT INTO `user_register` VALUES (84, '2019-05-27 09:58:17', '2019-05-27 09:58:16');
INSERT INTO `user_register` VALUES (85, '2019-05-28 09:09:18', '2019-05-28 09:09:17');
INSERT INTO `user_register` VALUES (86, '2019-05-28 14:10:39', '2019-05-28 14:10:39');
INSERT INTO `user_register` VALUES (87, '2019-05-28 16:18:00', '2019-05-28 16:18:01');
INSERT INTO `user_register` VALUES (88, '2019-05-28 16:55:36', '2019-05-28 16:55:36');
INSERT INTO `user_register` VALUES (89, '2019-05-28 22:39:22', '2019-05-28 22:39:21');
INSERT INTO `user_register` VALUES (90, '2019-05-29 18:31:59', '2019-05-29 18:31:59');
INSERT INTO `user_register` VALUES (91, '2019-05-30 09:38:34', '2019-05-30 09:38:33');
INSERT INTO `user_register` VALUES (92, '2019-05-30 17:47:12', '2019-05-30 17:47:11');
INSERT INTO `user_register` VALUES (93, '2019-05-31 17:10:44', '2019-05-31 17:10:44');
INSERT INTO `user_register` VALUES (94, '2019-06-01 08:04:57', '2019-06-01 08:04:56');
INSERT INTO `user_register` VALUES (95, '2019-06-01 10:09:17', '2019-06-01 10:09:16');
INSERT INTO `user_register` VALUES (96, '2019-06-01 15:58:38', '2019-06-01 15:58:38');
INSERT INTO `user_register` VALUES (97, '2019-06-01 18:21:57', '2019-06-01 18:21:56');
INSERT INTO `user_register` VALUES (98, '2019-06-01 18:24:07', '2019-06-01 18:24:06');
INSERT INTO `user_register` VALUES (99, '2019-06-01 23:56:49', '2019-06-01 23:56:48');
INSERT INTO `user_register` VALUES (100, '2019-06-02 18:10:33', '2019-06-02 18:10:33');
INSERT INTO `user_register` VALUES (101, '2019-06-02 22:38:28', '2019-06-02 22:38:27');
INSERT INTO `user_register` VALUES (102, '2019-06-03 17:12:47', '2019-06-03 17:12:47');
INSERT INTO `user_register` VALUES (103, '2019-06-04 10:26:05', '2019-06-04 10:26:05');
INSERT INTO `user_register` VALUES (104, '2019-06-04 12:41:14', '2019-06-04 12:41:13');
INSERT INTO `user_register` VALUES (105, '2019-06-04 16:31:46', '2019-06-04 16:31:46');
INSERT INTO `user_register` VALUES (106, '2019-06-04 20:26:23', '2019-06-04 20:26:22');
INSERT INTO `user_register` VALUES (107, '2019-06-04 21:14:13', '2019-06-04 21:14:13');
INSERT INTO `user_register` VALUES (108, '2019-06-05 09:31:39', '2019-06-05 09:31:39');
INSERT INTO `user_register` VALUES (109, '2019-06-05 17:42:21', '2019-06-05 17:42:20');
INSERT INTO `user_register` VALUES (110, '2019-06-06 14:11:53', '2019-06-06 14:11:52');
INSERT INTO `user_register` VALUES (111, '2019-06-07 13:49:30', '2019-06-07 13:49:30');
INSERT INTO `user_register` VALUES (112, '2019-06-07 14:30:31', '2019-06-07 14:30:31');
INSERT INTO `user_register` VALUES (113, '2019-06-08 22:20:00', '2019-06-08 22:20:00');
INSERT INTO `user_register` VALUES (114, '2019-06-08 22:25:01', '2019-06-08 22:25:01');
INSERT INTO `user_register` VALUES (115, '2019-06-09 20:15:18', '2019-06-09 20:15:17');
INSERT INTO `user_register` VALUES (116, '2019-06-09 22:56:12', '2019-06-09 22:56:11');
INSERT INTO `user_register` VALUES (117, '2019-06-11 14:58:04', '2019-06-11 14:58:04');
INSERT INTO `user_register` VALUES (118, '2019-06-11 15:52:55', '2019-06-11 15:52:54');
INSERT INTO `user_register` VALUES (119, '2019-06-11 17:28:11', '2019-06-11 17:28:10');
INSERT INTO `user_register` VALUES (120, '2019-06-11 19:30:48', '2019-06-11 19:30:13');
INSERT INTO `user_register` VALUES (121, '2019-06-11 20:13:58', '2019-06-11 20:13:58');
INSERT INTO `user_register` VALUES (122, '2019-06-12 16:00:27', '2019-06-12 16:00:27');
INSERT INTO `user_register` VALUES (123, '2019-06-12 16:32:42', '2019-06-12 16:32:41');
INSERT INTO `user_register` VALUES (124, '2019-06-14 14:33:18', '2019-06-14 14:33:18');
INSERT INTO `user_register` VALUES (125, '2019-06-14 19:00:09', '2019-06-14 19:00:09');
INSERT INTO `user_register` VALUES (126, '2019-06-18 15:32:21', '2019-06-18 15:32:20');
INSERT INTO `user_register` VALUES (127, '2019-06-19 14:30:45', '2019-06-19 14:30:44');
INSERT INTO `user_register` VALUES (128, '2019-06-19 14:35:26', '2019-06-19 14:35:26');
INSERT INTO `user_register` VALUES (129, '2019-06-20 07:46:15', '2019-06-20 07:46:14');
INSERT INTO `user_register` VALUES (130, '2019-06-21 11:51:25', '2019-06-21 11:51:24');
INSERT INTO `user_register` VALUES (131, '2019-06-21 14:10:56', '2019-06-21 14:10:56');
INSERT INTO `user_register` VALUES (132, '2019-06-21 14:43:21', '2019-06-21 14:43:20');
INSERT INTO `user_register` VALUES (133, '2019-06-21 15:39:05', '2019-06-21 15:39:04');
INSERT INTO `user_register` VALUES (134, '2019-06-23 19:01:58', '2019-06-23 19:01:57');
INSERT INTO `user_register` VALUES (135, '2019-06-23 22:24:30', '2019-06-23 22:24:29');
INSERT INTO `user_register` VALUES (136, '2019-06-24 14:10:39', '2019-06-24 14:10:39');
INSERT INTO `user_register` VALUES (137, '2019-06-24 15:08:54', '2019-06-24 15:08:54');
INSERT INTO `user_register` VALUES (138, '2019-06-24 17:39:36', '2019-06-24 17:39:35');
INSERT INTO `user_register` VALUES (139, '2019-06-25 09:54:06', '2019-06-25 09:54:06');
INSERT INTO `user_register` VALUES (140, '2019-06-25 11:27:30', '2019-06-25 11:27:30');
INSERT INTO `user_register` VALUES (141, '2019-06-26 14:55:31', '2019-06-26 14:55:30');
INSERT INTO `user_register` VALUES (142, '2019-06-27 14:27:14', '2019-06-27 14:27:13');
INSERT INTO `user_register` VALUES (143, '2019-06-30 20:28:12', '2019-06-30 20:28:12');
INSERT INTO `user_register` VALUES (144, '2019-07-01 16:46:04', '2019-07-01 16:46:03');
INSERT INTO `user_register` VALUES (145, '2019-07-01 18:37:09', '2019-07-01 18:37:09');
INSERT INTO `user_register` VALUES (146, '2019-07-01 19:05:10', '2019-07-01 19:05:09');
INSERT INTO `user_register` VALUES (147, '2019-07-01 21:43:34', '2019-07-01 21:43:33');
INSERT INTO `user_register` VALUES (148, '2019-07-01 23:04:13', '2019-07-01 23:04:12');
INSERT INTO `user_register` VALUES (149, '2019-07-02 10:09:14', '2019-07-02 10:09:14');
INSERT INTO `user_register` VALUES (150, '2019-07-02 11:14:08', '2019-07-02 11:14:08');
INSERT INTO `user_register` VALUES (151, '2019-07-02 11:58:04', '2019-07-02 11:58:04');
INSERT INTO `user_register` VALUES (152, '2019-07-02 13:27:55', '2019-07-02 13:27:55');
INSERT INTO `user_register` VALUES (153, '2019-07-02 16:10:07', '2019-07-02 16:10:06');
INSERT INTO `user_register` VALUES (154, '2019-07-02 20:25:00', '2019-07-02 20:25:00');
INSERT INTO `user_register` VALUES (155, '2019-07-03 11:15:39', '2019-07-03 11:15:39');
INSERT INTO `user_register` VALUES (156, '2019-07-03 11:37:02', '2019-07-03 11:37:01');
INSERT INTO `user_register` VALUES (157, '2019-07-05 15:23:13', '2019-07-05 15:23:12');
INSERT INTO `user_register` VALUES (158, '2019-07-06 11:32:23', '2019-07-06 11:32:23');
INSERT INTO `user_register` VALUES (159, '2019-07-07 17:57:20', '2019-07-07 17:57:20');
INSERT INTO `user_register` VALUES (160, '2019-07-08 16:53:50', '2019-07-08 16:53:50');
INSERT INTO `user_register` VALUES (161, '2019-07-08 22:37:08', '2019-07-08 22:37:08');
INSERT INTO `user_register` VALUES (162, '2019-07-09 14:35:46', '2019-07-09 14:35:46');
INSERT INTO `user_register` VALUES (163, '2019-07-09 17:57:59', '2019-07-09 17:57:59');
INSERT INTO `user_register` VALUES (164, '2019-07-09 20:49:21', '2019-07-09 20:49:21');
INSERT INTO `user_register` VALUES (165, '2019-07-10 19:42:32', '2019-07-10 19:42:32');
INSERT INTO `user_register` VALUES (166, '2019-07-11 09:04:59', '2019-07-11 09:04:59');
INSERT INTO `user_register` VALUES (167, '2019-07-11 10:57:27', '2019-07-11 10:57:26');
INSERT INTO `user_register` VALUES (168, '2019-07-11 11:07:21', '2019-07-11 11:07:20');
INSERT INTO `user_register` VALUES (169, '2019-07-11 12:32:56', '2019-07-11 12:32:55');
INSERT INTO `user_register` VALUES (170, '2019-07-16 09:52:56', '2019-07-16 09:52:56');
INSERT INTO `user_register` VALUES (171, '2019-07-16 15:04:37', '2019-07-16 15:04:36');
INSERT INTO `user_register` VALUES (172, '2019-07-16 18:14:40', '2019-07-16 18:14:39');
INSERT INTO `user_register` VALUES (173, '2019-07-17 07:29:40', '2019-07-17 07:29:40');
INSERT INTO `user_register` VALUES (174, '2019-07-17 13:14:09', '2019-07-17 13:14:08');
INSERT INTO `user_register` VALUES (175, '2019-07-18 09:41:55', '2019-07-18 09:41:54');
INSERT INTO `user_register` VALUES (176, '2019-07-18 15:36:29', '2019-07-18 15:36:29');
INSERT INTO `user_register` VALUES (177, '2019-07-19 20:08:56', '2019-07-19 20:08:55');
INSERT INTO `user_register` VALUES (178, '2019-07-20 09:41:00', '2019-07-20 09:41:00');
INSERT INTO `user_register` VALUES (179, '2019-07-20 23:56:28', '2019-07-20 23:56:27');
INSERT INTO `user_register` VALUES (180, '2019-07-23 14:42:38', '2019-07-23 14:42:38');
INSERT INTO `user_register` VALUES (181, '2019-07-26 11:47:54', '2019-07-26 11:47:53');
INSERT INTO `user_register` VALUES (182, '2019-07-27 00:45:27', '2019-07-27 00:45:26');
INSERT INTO `user_register` VALUES (183, '2019-07-27 23:48:06', '2019-07-27 23:48:06');
INSERT INTO `user_register` VALUES (184, '2019-07-30 22:30:36', '2019-07-30 22:30:36');
INSERT INTO `user_register` VALUES (185, '2019-07-31 10:41:00', '2019-07-31 10:41:00');
INSERT INTO `user_register` VALUES (186, '2019-07-31 16:40:21', '2019-07-31 16:40:20');
INSERT INTO `user_register` VALUES (187, '2019-08-01 15:41:15', '2019-08-01 15:41:14');
INSERT INTO `user_register` VALUES (188, '2019-08-01 22:17:42', '2019-08-01 22:17:41');
INSERT INTO `user_register` VALUES (189, '2019-08-02 16:08:24', '2019-08-02 16:08:23');
INSERT INTO `user_register` VALUES (190, '2019-08-02 16:19:46', '2019-08-02 16:19:45');
INSERT INTO `user_register` VALUES (191, '2019-08-02 19:28:21', '2019-08-02 19:28:21');
INSERT INTO `user_register` VALUES (192, '2019-08-05 13:29:43', '2019-08-05 13:29:42');
INSERT INTO `user_register` VALUES (193, '2019-08-07 13:40:20', '2019-08-07 13:40:19');
INSERT INTO `user_register` VALUES (194, '2019-08-08 17:34:25', '2019-08-08 17:34:25');
INSERT INTO `user_register` VALUES (195, '2019-08-10 15:36:16', '2019-08-10 15:36:17');
INSERT INTO `user_register` VALUES (196, '2019-08-12 15:35:59', '2019-08-12 15:35:58');
INSERT INTO `user_register` VALUES (197, '2019-08-12 17:28:19', '2019-08-12 17:28:19');
INSERT INTO `user_register` VALUES (198, '2019-08-13 15:38:55', '2019-08-13 15:38:55');
INSERT INTO `user_register` VALUES (199, '2019-08-13 18:08:35', '2019-08-13 18:08:34');
INSERT INTO `user_register` VALUES (200, '2019-08-14 09:44:26', '2019-08-14 09:44:25');
INSERT INTO `user_register` VALUES (201, '2019-08-14 11:44:44', '2019-08-14 11:44:43');
INSERT INTO `user_register` VALUES (202, '2019-08-14 15:48:47', '2019-08-14 15:48:46');
INSERT INTO `user_register` VALUES (203, '2019-08-14 23:01:33', '2019-08-14 23:01:32');
INSERT INTO `user_register` VALUES (204, '2019-08-17 10:40:19', '2019-08-17 10:40:18');
INSERT INTO `user_register` VALUES (205, '2019-08-17 15:02:01', '2019-08-17 15:02:00');
INSERT INTO `user_register` VALUES (206, '2019-08-18 01:07:01', '2019-08-18 01:07:00');
INSERT INTO `user_register` VALUES (207, '2019-08-20 12:53:59', '2019-08-20 12:53:58');
INSERT INTO `user_register` VALUES (208, '2019-08-20 17:51:36', '2019-08-20 17:51:36');
INSERT INTO `user_register` VALUES (209, '2019-08-20 19:15:43', '2019-08-20 19:15:43');
INSERT INTO `user_register` VALUES (210, '2019-08-23 09:59:34', '2019-08-23 09:59:33');
INSERT INTO `user_register` VALUES (211, '2019-08-24 06:54:18', '2019-08-24 06:54:18');
INSERT INTO `user_register` VALUES (212, '2019-08-26 10:24:28', '2019-08-26 10:24:25');
INSERT INTO `user_register` VALUES (213, '2019-08-27 15:07:39', '2019-08-27 15:07:39');
INSERT INTO `user_register` VALUES (214, '2019-08-27 15:58:02', '2019-08-27 15:58:01');
INSERT INTO `user_register` VALUES (215, '2019-08-30 09:13:12', '2019-08-30 09:13:11');
INSERT INTO `user_register` VALUES (216, '2019-08-30 11:35:59', '2019-08-30 11:35:59');
INSERT INTO `user_register` VALUES (217, '2019-08-30 15:09:01', '2019-08-30 15:09:00');
INSERT INTO `user_register` VALUES (218, '2019-09-03 15:41:56', '2019-09-03 15:41:56');
INSERT INTO `user_register` VALUES (219, '2019-09-04 17:46:39', '2019-09-04 17:46:39');
INSERT INTO `user_register` VALUES (220, '2019-09-05 10:18:07', '2019-09-05 10:18:07');
INSERT INTO `user_register` VALUES (221, '2019-09-05 15:12:28', '2019-09-05 15:12:27');
INSERT INTO `user_register` VALUES (222, '2019-09-05 15:13:54', '2019-09-05 15:13:53');
INSERT INTO `user_register` VALUES (223, '2019-09-05 17:16:11', '2019-09-05 17:16:11');
COMMIT;

-- ----------------------------
-- Table structure for user_spu_collections
-- ----------------------------
DROP TABLE IF EXISTS `user_spu_collections`;
CREATE TABLE `user_spu_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id自增长',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `nickname` varchar(50) NOT NULL COMMENT '用户名称',
  `spu_id` int(11) NOT NULL COMMENT '商品id',
  `spu_name` varchar(50) NOT NULL COMMENT '商品名字',
  `spu_image` varchar(250) NOT NULL COMMENT '图片名字',
  `sell_point` varchar(50) NOT NULL DEFAULT '' COMMENT '卖点',
  `price` int(11) DEFAULT NULL COMMENT '价格',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `deleted` smallint(2) NOT NULL COMMENT '删除状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户_商品_收藏记录表';

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '用户编号',
  `mobile` varchar(11) COLLATE utf8mb4_bin NOT NULL,
  `nickname` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '昵称',
  `avatar` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '头像',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted` bit(1) DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `idx_uid` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- ----------------------------
-- Records of users
-- ----------------------------
BEGIN;
INSERT INTO `users` VALUES (1, '15601691399', '你猜12345', 'http://static.iocoder.cn/1553652151601.jpg?imageView2/2/w/308/h/210/interlace/1/q/100', 1, '2018-09-22 06:26:49', '2019-04-04 19:28:44', b'0');
INSERT INTO `users` VALUES (2, '15601691340', NULL, NULL, 1, '2018-09-22 06:26:49', '2019-03-10 17:50:42', b'0');
INSERT INTO `users` VALUES (10, '15601691345', NULL, NULL, 1, '2018-09-23 00:16:10', '2019-03-10 17:50:43', b'0');
INSERT INTO `users` VALUES (11, '15601691346', NULL, NULL, 1, '2018-09-26 19:26:36', '2019-03-10 17:50:44', b'0');
INSERT INTO `users` VALUES (22, '15601691361', NULL, NULL, 1, '2019-02-25 16:10:37', '2019-03-10 17:50:45', b'0');
INSERT INTO `users` VALUES (23, '15601691362', NULL, NULL, 1, '2019-02-25 16:16:29', '2019-03-10 17:50:46', b'0');
INSERT INTO `users` VALUES (25, '15601691363', NULL, NULL, 1, '2019-02-25 16:20:54', '2019-03-10 17:50:46', b'0');
INSERT INTO `users` VALUES (26, '15601691365', '未来可惜', 'http://static.iocoder.cn/1553652151601.jpg?imageView2/2/w/308/h/210/interlace/1/q/100', 1, '2019-02-26 01:35:53', '2019-03-28 11:33:29', b'0');
INSERT INTO `users` VALUES (27, '15601691400', NULL, NULL, 1, '2019-03-28 14:41:03', '2019-03-28 14:41:06', b'0');
INSERT INTO `users` VALUES (28, '15601991399', '王文斌', NULL, 1, '2019-04-04 19:27:00', '2019-04-04 19:28:15', b'0');
INSERT INTO `users` VALUES (29, '15601691300', NULL, NULL, 1, '2019-04-09 21:44:10', '2019-04-09 21:44:10', b'0');
INSERT INTO `users` VALUES (30, '13888888888', NULL, NULL, 1, '2019-04-22 19:50:37', '2019-04-22 19:50:36', b'0');
INSERT INTO `users` VALUES (31, '13211111111', NULL, NULL, 1, '2019-04-22 21:24:35', '2019-04-22 21:24:35', b'0');
INSERT INTO `users` VALUES (32, '18511110000', NULL, NULL, 1, '2019-04-22 21:26:56', '2019-04-22 21:26:55', b'0');
INSERT INTO `users` VALUES (33, '17395501992', NULL, NULL, 1, '2019-04-22 21:27:18', '2019-04-22 21:27:17', b'0');
INSERT INTO `users` VALUES (34, '13511111111', NULL, NULL, 1, '2019-04-22 21:43:52', '2019-04-22 21:43:51', b'0');
INSERT INTO `users` VALUES (35, '18549816713', NULL, NULL, 1, '2019-04-22 22:19:18', '2019-04-22 22:19:17', b'0');
INSERT INTO `users` VALUES (36, '18666666666', NULL, NULL, 1, '2019-04-22 23:22:13', '2019-04-22 23:22:12', b'0');
INSERT INTO `users` VALUES (37, '18927161773', NULL, NULL, 1, '2019-04-22 23:43:53', '2019-04-22 23:43:52', b'0');
INSERT INTO `users` VALUES (38, '18350220746', NULL, NULL, 1, '2019-04-22 23:45:24', '2019-04-22 23:45:24', b'0');
INSERT INTO `users` VALUES (39, '15147613519', 'honey', NULL, 1, '2019-04-23 07:53:37', '2019-04-23 07:53:50', b'0');
INSERT INTO `users` VALUES (40, '17789675416', NULL, NULL, 1, '2019-04-23 09:05:17', '2019-04-23 09:05:16', b'0');
INSERT INTO `users` VALUES (41, '15121030455', NULL, NULL, 1, '2019-04-24 08:18:03', '2019-04-24 08:18:02', b'0');
INSERT INTO `users` VALUES (42, '13900000000', NULL, NULL, 1, '2019-04-28 07:54:16', '2019-04-28 07:54:16', b'0');
INSERT INTO `users` VALUES (43, '17610928215', NULL, NULL, 1, '2019-04-29 14:11:13', '2019-04-29 14:11:12', b'0');
INSERT INTO `users` VALUES (44, '15601750880', NULL, NULL, 1, '2019-04-29 14:30:14', '2019-04-29 14:30:13', b'0');
INSERT INTO `users` VALUES (45, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (46, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (47, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (48, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (49, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (50, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (51, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (52, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (53, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (54, '18777777777', NULL, NULL, 1, '2019-04-30 20:58:46', '2019-04-30 20:58:53', b'0');
INSERT INTO `users` VALUES (55, '15855896584', NULL, NULL, 1, '2019-05-01 15:40:19', '2019-05-01 15:40:19', b'0');
INSERT INTO `users` VALUES (56, '17701085860', '123', NULL, 1, '2019-05-04 02:38:49', '2019-05-04 02:39:04', b'0');
INSERT INTO `users` VALUES (57, '11112345678', NULL, NULL, 1, '2019-05-05 15:57:44', '2019-05-05 15:57:44', b'0');
INSERT INTO `users` VALUES (58, '13488713179', NULL, NULL, 1, '2019-05-05 16:20:06', '2019-05-05 16:20:05', b'0');
INSERT INTO `users` VALUES (59, '15621062596', NULL, NULL, 1, '2019-05-05 19:11:59', '2019-05-05 19:11:58', b'0');
INSERT INTO `users` VALUES (60, '18888888888', NULL, NULL, 1, '2019-05-06 17:27:41', '2019-05-06 17:27:41', b'0');
INSERT INTO `users` VALUES (61, '13124278923', NULL, NULL, 1, '2019-05-07 14:15:52', '2019-05-07 14:15:52', b'0');
INSERT INTO `users` VALUES (62, '15819687417', NULL, NULL, 1, '2019-05-07 18:12:30', '2019-05-07 18:12:30', b'0');
INSERT INTO `users` VALUES (63, '13003322623', NULL, NULL, 1, '2019-05-08 09:55:14', '2019-05-08 09:55:13', b'0');
INSERT INTO `users` VALUES (64, '13645713053', NULL, NULL, 1, '2019-05-08 16:37:46', '2019-05-08 16:37:45', b'0');
INSERT INTO `users` VALUES (65, '18621098888', NULL, NULL, 1, '2019-05-08 20:16:10', '2019-05-08 20:16:10', b'0');
INSERT INTO `users` VALUES (66, '13333333333', 'ds', NULL, 1, '2019-05-09 19:36:57', '2019-05-09 19:37:53', b'0');
INSERT INTO `users` VALUES (67, '18670071886', NULL, NULL, 1, '2019-05-10 21:05:25', '2019-05-10 21:05:24', b'0');
INSERT INTO `users` VALUES (68, '15618823536', NULL, NULL, 1, '2019-05-10 22:10:38', '2019-05-10 22:10:37', b'0');
INSERT INTO `users` VALUES (69, '15612345678', NULL, NULL, 1, '2019-05-11 00:24:00', '2019-05-11 00:23:59', b'0');
INSERT INTO `users` VALUES (70, '13918901441', NULL, NULL, 1, '2019-05-12 07:33:22', '2019-05-12 07:33:22', b'0');
INSERT INTO `users` VALUES (71, '18926576699', NULL, NULL, 1, '2019-05-13 09:53:52', '2019-05-13 09:53:51', b'0');
INSERT INTO `users` VALUES (72, '15601691341', NULL, NULL, 1, '2019-05-17 00:25:54', '2019-05-17 00:25:53', b'0');
INSERT INTO `users` VALUES (73, '15601691388', '你猜', NULL, 1, '2019-05-17 17:49:25', '2019-05-17 17:49:30', b'0');
INSERT INTO `users` VALUES (74, '15136212594', NULL, NULL, 1, '2019-05-17 21:52:55', '2019-05-17 21:52:54', b'0');
INSERT INTO `users` VALUES (75, '13111111111', NULL, NULL, 1, '2019-05-18 15:55:44', '2019-05-18 15:55:43', b'0');
INSERT INTO `users` VALUES (76, '15977944314', NULL, NULL, 1, '2019-05-20 11:47:51', '2019-05-20 11:47:50', b'0');
INSERT INTO `users` VALUES (77, '12345678901', NULL, NULL, 1, '2019-05-21 17:32:38', '2019-05-21 17:32:37', b'0');
INSERT INTO `users` VALUES (78, '15652958958', NULL, NULL, 1, '2019-05-22 15:51:01', '2019-05-22 15:51:01', b'0');
INSERT INTO `users` VALUES (79, '13838382438', NULL, NULL, 1, '2019-05-23 14:27:45', '2019-05-23 14:27:44', b'0');
INSERT INTO `users` VALUES (80, '17620370300', NULL, NULL, 1, '2019-05-23 17:55:58', '2019-05-23 17:55:57', b'0');
INSERT INTO `users` VALUES (81, '18810797024', NULL, NULL, 1, '2019-05-24 11:31:45', '2019-05-24 11:31:45', b'0');
INSERT INTO `users` VALUES (82, '17612184394', NULL, NULL, 1, '2019-05-24 12:40:53', '2019-05-24 12:40:52', b'0');
INSERT INTO `users` VALUES (83, '13555556666', NULL, NULL, 1, '2019-05-24 17:47:00', '2019-05-24 17:47:00', b'0');
INSERT INTO `users` VALUES (84, '18398263215', NULL, NULL, 1, '2019-05-27 09:58:17', '2019-05-27 09:58:16', b'0');
INSERT INTO `users` VALUES (85, '17621922840', NULL, NULL, 1, '2019-05-28 09:09:18', '2019-05-28 09:09:17', b'0');
INSERT INTO `users` VALUES (86, '13133333333', NULL, NULL, 1, '2019-05-28 14:10:39', '2019-05-28 14:10:39', b'0');
INSERT INTO `users` VALUES (87, '13080612932', NULL, NULL, 1, '2019-05-28 16:18:00', '2019-05-28 16:18:01', b'0');
INSERT INTO `users` VALUES (88, '17682306666', NULL, NULL, 1, '2019-05-28 16:55:36', '2019-05-28 16:55:36', b'0');
INSERT INTO `users` VALUES (89, '13033339999', NULL, NULL, 1, '2019-05-28 22:39:22', '2019-05-28 22:39:21', b'0');
INSERT INTO `users` VALUES (90, '18846916971', '唐老鸭', NULL, 1, '2019-05-29 18:31:59', '2019-05-29 18:32:20', b'0');
INSERT INTO `users` VALUES (91, '15611861576', NULL, NULL, 1, '2019-05-30 09:38:34', '2019-05-30 09:38:33', b'0');
INSERT INTO `users` VALUES (92, '18616392909', NULL, NULL, 1, '2019-05-30 17:47:11', '2019-05-30 17:47:11', b'0');
INSERT INTO `users` VALUES (93, '18962222222', NULL, NULL, 1, '2019-05-31 17:10:44', '2019-05-31 17:10:44', b'0');
INSERT INTO `users` VALUES (94, '18701351232', NULL, NULL, 1, '2019-06-01 08:04:57', '2019-06-01 08:04:56', b'0');
INSERT INTO `users` VALUES (95, '18611741231', NULL, NULL, 1, '2019-06-01 10:09:17', '2019-06-01 10:09:16', b'0');
INSERT INTO `users` VALUES (96, '13666120326', NULL, NULL, 1, '2019-06-01 15:58:38', '2019-06-01 15:58:38', b'0');
INSERT INTO `users` VALUES (97, '13167143046', NULL, NULL, 1, '2019-06-01 18:21:57', '2019-06-01 18:21:56', b'0');
INSERT INTO `users` VALUES (98, '13167143040', NULL, NULL, 1, '2019-06-01 18:24:07', '2019-06-01 18:24:06', b'0');
INSERT INTO `users` VALUES (99, '17611060902', NULL, NULL, 1, '2019-06-01 23:56:49', '2019-06-01 23:56:48', b'0');
INSERT INTO `users` VALUES (100, '18613511637', NULL, NULL, 1, '2019-06-02 18:10:33', '2019-06-02 18:10:33', b'0');
INSERT INTO `users` VALUES (101, '17798562099', NULL, NULL, 1, '2019-06-02 22:38:28', '2019-06-02 22:38:27', b'0');
INSERT INTO `users` VALUES (102, '13261631500', NULL, NULL, 1, '2019-06-03 17:12:47', '2019-06-03 17:12:47', b'0');
INSERT INTO `users` VALUES (103, '18814128912', NULL, NULL, 1, '2019-06-04 10:26:05', '2019-06-04 10:26:05', b'0');
INSERT INTO `users` VALUES (104, '13458745582', NULL, NULL, 1, '2019-06-04 12:41:14', '2019-06-04 12:41:13', b'0');
INSERT INTO `users` VALUES (105, '17866624796', NULL, NULL, 1, '2019-06-04 16:31:46', '2019-06-04 16:31:46', b'0');
INSERT INTO `users` VALUES (106, '13223454312', NULL, NULL, 1, '2019-06-04 20:26:23', '2019-06-04 20:26:22', b'0');
INSERT INTO `users` VALUES (107, '15757179782', NULL, NULL, 1, '2019-06-04 21:14:13', '2019-06-04 21:14:13', b'0');
INSERT INTO `users` VALUES (108, '12345678909', NULL, NULL, 1, '2019-06-05 09:31:39', '2019-06-05 09:31:39', b'0');
INSERT INTO `users` VALUES (109, '13516565388', NULL, NULL, 1, '2019-06-05 17:42:21', '2019-06-05 17:42:20', b'0');
INSERT INTO `users` VALUES (110, '18123920907', NULL, NULL, 1, '2019-06-06 14:11:53', '2019-06-06 14:11:52', b'0');
INSERT INTO `users` VALUES (111, '13902223331', NULL, NULL, 1, '2019-06-07 13:49:30', '2019-06-07 13:49:30', b'0');
INSERT INTO `users` VALUES (112, '17879283741', NULL, NULL, 1, '2019-06-07 14:30:31', '2019-06-07 14:30:31', b'0');
INSERT INTO `users` VALUES (113, '15011566666', '222', NULL, 1, '2019-06-08 22:20:00', '2019-06-08 22:21:03', b'0');
INSERT INTO `users` VALUES (114, '15555555555', NULL, NULL, 1, '2019-06-08 22:25:01', '2019-06-08 22:25:01', b'0');
INSERT INTO `users` VALUES (115, '15510086451', NULL, NULL, 1, '2019-06-09 20:15:18', '2019-06-09 20:15:17', b'0');
INSERT INTO `users` VALUES (116, '18311112222', '各回各家', NULL, 1, '2019-06-09 22:56:12', '2019-06-09 22:56:33', b'0');
INSERT INTO `users` VALUES (117, '11569586325', NULL, NULL, 1, '2019-06-11 14:58:04', '2019-06-11 14:58:04', b'0');
INSERT INTO `users` VALUES (118, '15556906631', '123', NULL, 1, '2019-06-11 15:52:55', '2019-06-11 15:53:01', b'0');
INSERT INTO `users` VALUES (119, '15965412563', NULL, NULL, 1, '2019-06-11 17:28:11', '2019-06-11 17:28:10', b'0');
INSERT INTO `users` VALUES (120, '17700000000', NULL, NULL, 1, '2019-06-11 19:30:48', '2019-06-11 19:30:13', b'0');
INSERT INTO `users` VALUES (121, '13516451223', NULL, NULL, 1, '2019-06-11 20:13:58', '2019-06-11 20:13:58', b'0');
INSERT INTO `users` VALUES (122, '18827007445', NULL, NULL, 1, '2019-06-12 16:00:27', '2019-06-12 16:00:27', b'0');
INSERT INTO `users` VALUES (123, '13667909756', NULL, NULL, 1, '2019-06-12 16:32:42', '2019-06-12 16:32:41', b'0');
INSERT INTO `users` VALUES (124, '13629583007', NULL, NULL, 1, '2019-06-14 14:33:18', '2019-06-14 14:33:18', b'0');
INSERT INTO `users` VALUES (125, '17758710030', NULL, NULL, 1, '2019-06-14 19:00:09', '2019-06-14 19:00:09', b'0');
INSERT INTO `users` VALUES (126, '18588858554', NULL, NULL, 1, '2019-06-18 15:32:21', '2019-06-18 15:32:20', b'0');
INSERT INTO `users` VALUES (127, '13122616189', NULL, NULL, 1, '2019-06-19 14:30:45', '2019-06-19 14:30:44', b'0');
INSERT INTO `users` VALUES (128, '11111111111', NULL, NULL, 1, '2019-06-19 14:35:26', '2019-06-19 14:35:26', b'0');
INSERT INTO `users` VALUES (129, '18761424986', NULL, NULL, 1, '2019-06-20 07:46:15', '2019-06-20 07:46:14', b'0');
INSERT INTO `users` VALUES (130, '15921563201', NULL, NULL, 1, '2019-06-21 11:51:25', '2019-06-21 11:51:24', b'0');
INSERT INTO `users` VALUES (131, '18526043842', 'aaa', NULL, 1, '2019-06-21 14:10:56', '2019-06-21 14:11:10', b'0');
INSERT INTO `users` VALUES (132, '18105822099', NULL, NULL, 1, '2019-06-21 14:43:20', '2019-06-21 14:43:20', b'0');
INSERT INTO `users` VALUES (133, '18669418671', NULL, NULL, 1, '2019-06-21 15:39:05', '2019-06-21 15:39:04', b'0');
INSERT INTO `users` VALUES (134, '18181108112', NULL, NULL, 1, '2019-06-23 19:01:58', '2019-06-23 19:01:57', b'0');
INSERT INTO `users` VALUES (135, '15575752952', NULL, NULL, 1, '2019-06-23 22:24:30', '2019-06-23 22:24:29', b'0');
INSERT INTO `users` VALUES (136, '18682256725', NULL, NULL, 1, '2019-06-24 14:10:39', '2019-06-24 14:10:39', b'0');
INSERT INTO `users` VALUES (137, '18408221234', NULL, NULL, 1, '2019-06-24 15:08:54', '2019-06-24 15:08:54', b'0');
INSERT INTO `users` VALUES (138, '17621432283', NULL, NULL, 1, '2019-06-24 17:39:36', '2019-06-24 17:39:35', b'0');
INSERT INTO `users` VALUES (139, '13141186997', NULL, NULL, 1, '2019-06-25 09:54:06', '2019-06-25 09:54:06', b'0');
INSERT INTO `users` VALUES (140, '13720895280', NULL, NULL, 1, '2019-06-25 11:27:30', '2019-06-25 11:27:30', b'0');
INSERT INTO `users` VALUES (141, '18709823333', NULL, NULL, 1, '2019-06-26 14:55:31', '2019-06-26 14:55:30', b'0');
INSERT INTO `users` VALUES (142, '12341234122', NULL, NULL, 1, '2019-06-27 14:27:14', '2019-06-27 14:27:13', b'0');
INSERT INTO `users` VALUES (143, '13818938640', NULL, NULL, 1, '2019-06-30 20:28:12', '2019-06-30 20:28:12', b'0');
INSERT INTO `users` VALUES (144, '18512345678', NULL, NULL, 1, '2019-07-01 16:46:04', '2019-07-01 16:46:03', b'0');
INSERT INTO `users` VALUES (145, '13775579730', NULL, NULL, 1, '2019-07-01 18:37:09', '2019-07-01 18:37:09', b'0');
INSERT INTO `users` VALUES (146, '13701501490', NULL, NULL, 1, '2019-07-01 19:05:10', '2019-07-01 19:05:09', b'0');
INSERT INTO `users` VALUES (147, '15820459220', NULL, NULL, 1, '2019-07-01 21:43:34', '2019-07-01 21:43:33', b'0');
INSERT INTO `users` VALUES (148, '13825809474', NULL, NULL, 1, '2019-07-01 23:04:13', '2019-07-01 23:04:12', b'0');
INSERT INTO `users` VALUES (149, '15111111111', '哈哈哈', NULL, 1, '2019-07-02 10:09:14', '2019-07-02 10:10:26', b'0');
INSERT INTO `users` VALUES (150, '13612345678', NULL, NULL, 1, '2019-07-02 11:14:08', '2019-07-02 11:14:08', b'0');
INSERT INTO `users` VALUES (151, '18611966723', NULL, NULL, 1, '2019-07-02 11:58:04', '2019-07-02 11:58:04', b'0');
INSERT INTO `users` VALUES (152, '15221507213', NULL, NULL, 1, '2019-07-02 13:27:55', '2019-07-02 13:27:55', b'0');
INSERT INTO `users` VALUES (153, '12345678911', NULL, NULL, 1, '2019-07-02 16:10:07', '2019-07-02 16:10:06', b'0');
INSERT INTO `users` VALUES (154, '12331231231', NULL, NULL, 1, '2019-07-02 20:25:00', '2019-07-02 20:25:00', b'0');
INSERT INTO `users` VALUES (155, '15992086969', NULL, NULL, 1, '2019-07-03 11:15:39', '2019-07-03 11:15:39', b'0');
INSERT INTO `users` VALUES (156, '16625582773', NULL, NULL, 1, '2019-07-03 11:37:02', '2019-07-03 11:37:01', b'0');
INSERT INTO `users` VALUES (157, '18058448853', NULL, NULL, 1, '2019-07-05 15:23:13', '2019-07-05 15:23:12', b'0');
INSERT INTO `users` VALUES (158, '15119669623', NULL, NULL, 1, '2019-07-06 11:32:23', '2019-07-06 11:32:23', b'0');
INSERT INTO `users` VALUES (159, '18621093656', NULL, NULL, 1, '2019-07-07 17:57:20', '2019-07-07 17:57:20', b'0');
INSERT INTO `users` VALUES (160, '18758051658', 'AA', NULL, 1, '2019-07-08 16:53:50', '2019-07-08 17:45:09', b'0');
INSERT INTO `users` VALUES (161, '18268252687', NULL, NULL, 1, '2019-07-08 22:37:08', '2019-07-08 22:37:08', b'0');
INSERT INTO `users` VALUES (162, '18516602911', NULL, NULL, 1, '2019-07-09 14:35:46', '2019-07-09 14:35:46', b'0');
INSERT INTO `users` VALUES (163, '18611899696', NULL, NULL, 1, '2019-07-09 17:57:59', '2019-07-09 17:57:59', b'0');
INSERT INTO `users` VALUES (164, '13501831986', NULL, NULL, 1, '2019-07-09 20:49:21', '2019-07-09 20:49:21', b'0');
INSERT INTO `users` VALUES (165, '18296874638', NULL, NULL, 1, '2019-07-10 19:42:32', '2019-07-10 19:42:32', b'0');
INSERT INTO `users` VALUES (166, '13422129567', NULL, NULL, 1, '2019-07-11 09:04:59', '2019-07-11 09:04:59', b'0');
INSERT INTO `users` VALUES (167, '18608715600', NULL, NULL, 1, '2019-07-11 10:57:27', '2019-07-11 10:57:26', b'0');
INSERT INTO `users` VALUES (168, '13464832222', NULL, NULL, 1, '2019-07-11 11:07:21', '2019-07-11 11:07:20', b'0');
INSERT INTO `users` VALUES (169, '15324490545', NULL, NULL, 1, '2019-07-11 12:32:56', '2019-07-11 12:32:55', b'0');
INSERT INTO `users` VALUES (170, '13870418040', NULL, NULL, 1, '2019-07-16 09:52:56', '2019-07-16 09:52:56', b'0');
INSERT INTO `users` VALUES (171, '15978905836', NULL, NULL, 1, '2019-07-16 15:04:37', '2019-07-16 15:04:36', b'0');
INSERT INTO `users` VALUES (172, '19901637004', NULL, NULL, 1, '2019-07-16 18:14:40', '2019-07-16 18:14:39', b'0');
INSERT INTO `users` VALUES (173, '13256189181', NULL, NULL, 1, '2019-07-17 07:29:40', '2019-07-17 07:29:40', b'0');
INSERT INTO `users` VALUES (174, '17665163825', NULL, NULL, 1, '2019-07-17 13:14:09', '2019-07-17 13:14:08', b'0');
INSERT INTO `users` VALUES (175, '13333333330', NULL, NULL, 1, '2019-07-18 09:41:55', '2019-07-18 09:41:54', b'0');
INSERT INTO `users` VALUES (176, '13222222222', NULL, NULL, 1, '2019-07-18 15:36:29', '2019-07-18 15:36:29', b'0');
INSERT INTO `users` VALUES (177, '17774007125', NULL, NULL, 1, '2019-07-19 20:08:56', '2019-07-19 20:08:55', b'0');
INSERT INTO `users` VALUES (178, '17521167506', NULL, NULL, 1, '2019-07-20 09:41:00', '2019-07-20 09:41:00', b'0');
INSERT INTO `users` VALUES (179, '15978903456', NULL, NULL, 1, '2019-07-20 23:56:28', '2019-07-20 23:56:27', b'0');
INSERT INTO `users` VALUES (180, '13838389438', NULL, NULL, 1, '2019-07-23 14:42:38', '2019-07-23 14:42:38', b'0');
INSERT INTO `users` VALUES (181, '18510344250', NULL, NULL, 1, '2019-07-26 11:47:54', '2019-07-26 11:47:53', b'0');
INSERT INTO `users` VALUES (182, '15766501707', NULL, NULL, 1, '2019-07-27 00:45:27', '2019-07-27 00:45:26', b'0');
INSERT INTO `users` VALUES (183, '13422294047', NULL, NULL, 1, '2019-07-27 23:48:06', '2019-07-27 23:48:06', b'0');
INSERT INTO `users` VALUES (184, '13800000000', NULL, NULL, 1, '2019-07-30 22:30:36', '2019-07-30 22:30:36', b'0');
INSERT INTO `users` VALUES (185, '15666618888', NULL, NULL, 1, '2019-07-31 10:41:00', '2019-07-31 10:41:00', b'0');
INSERT INTO `users` VALUES (186, '16666666666', NULL, NULL, 1, '2019-07-31 16:40:21', '2019-07-31 16:40:20', b'0');
INSERT INTO `users` VALUES (187, '17136373243', NULL, NULL, 1, '2019-08-01 15:41:15', '2019-08-01 15:41:14', b'0');
INSERT INTO `users` VALUES (188, '18373353229', NULL, NULL, 1, '2019-08-01 22:17:42', '2019-08-01 22:17:41', b'0');
INSERT INTO `users` VALUES (189, '15600391790', NULL, NULL, 1, '2019-08-02 16:08:24', '2019-08-02 16:08:23', b'0');
INSERT INTO `users` VALUES (190, '13138570323', NULL, NULL, 1, '2019-08-02 16:19:46', '2019-08-02 16:19:45', b'0');
INSERT INTO `users` VALUES (191, '17521698619', NULL, NULL, 1, '2019-08-02 19:28:21', '2019-08-02 19:28:21', b'0');
INSERT INTO `users` VALUES (192, '13225080352', NULL, NULL, 1, '2019-08-05 13:29:43', '2019-08-05 13:29:42', b'0');
INSERT INTO `users` VALUES (193, '18622636558', NULL, NULL, 1, '2019-08-07 13:40:20', '2019-08-07 13:40:19', b'0');
INSERT INTO `users` VALUES (194, '18826277525', NULL, NULL, 1, '2019-08-08 17:34:25', '2019-08-08 17:34:25', b'0');
INSERT INTO `users` VALUES (195, '15858248641', NULL, NULL, 1, '2019-08-10 15:36:16', '2019-08-10 15:36:17', b'0');
INSERT INTO `users` VALUES (196, '18621592340', NULL, NULL, 1, '2019-08-12 15:35:59', '2019-08-12 15:35:58', b'0');
INSERT INTO `users` VALUES (197, '18856655656', NULL, NULL, 1, '2019-08-12 17:28:19', '2019-08-12 17:28:19', b'0');
INSERT INTO `users` VALUES (198, '13693100472', NULL, NULL, 1, '2019-08-13 15:38:55', '2019-08-13 15:38:55', b'0');
INSERT INTO `users` VALUES (199, '18538373863', NULL, NULL, 1, '2019-08-13 18:08:35', '2019-08-13 18:08:34', b'0');
INSERT INTO `users` VALUES (200, '18578638326', NULL, NULL, 1, '2019-08-14 09:44:26', '2019-08-14 09:44:25', b'0');
INSERT INTO `users` VALUES (201, '13569516290', NULL, NULL, 1, '2019-08-14 11:44:44', '2019-08-14 11:44:43', b'0');
INSERT INTO `users` VALUES (202, '18467546854', NULL, NULL, 1, '2019-08-14 15:48:47', '2019-08-14 15:48:46', b'0');
INSERT INTO `users` VALUES (203, '18566763798', NULL, NULL, 1, '2019-08-14 23:01:33', '2019-08-14 23:01:32', b'0');
INSERT INTO `users` VALUES (204, '15158059581', NULL, NULL, 1, '2019-08-17 10:40:19', '2019-08-17 10:40:18', b'0');
INSERT INTO `users` VALUES (205, '13786160975', NULL, NULL, 1, '2019-08-17 15:02:01', '2019-08-17 15:02:00', b'0');
INSERT INTO `users` VALUES (206, '17358671342', NULL, NULL, 1, '2019-08-18 01:07:01', '2019-08-18 01:07:00', b'0');
INSERT INTO `users` VALUES (207, '18555556666', NULL, NULL, 1, '2019-08-20 12:53:59', '2019-08-20 12:53:58', b'0');
INSERT INTO `users` VALUES (208, '17621638086', NULL, NULL, 1, '2019-08-20 17:51:36', '2019-08-20 17:51:36', b'0');
INSERT INTO `users` VALUES (209, '15579872216', NULL, NULL, 1, '2019-08-20 19:15:43', '2019-08-20 19:15:43', b'0');
INSERT INTO `users` VALUES (210, '17350332369', NULL, NULL, 1, '2019-08-23 09:59:34', '2019-08-23 09:59:33', b'0');
INSERT INTO `users` VALUES (211, '16882662887', NULL, NULL, 1, '2019-08-24 06:54:18', '2019-08-24 06:54:18', b'0');
INSERT INTO `users` VALUES (212, '17602176290', NULL, NULL, 1, '2019-08-26 10:24:28', '2019-08-26 10:24:25', b'0');
INSERT INTO `users` VALUES (213, '15521277446', NULL, NULL, 1, '2019-08-27 15:07:39', '2019-08-27 15:07:39', b'0');
INSERT INTO `users` VALUES (214, '15668618898', NULL, NULL, 1, '2019-08-27 15:58:02', '2019-08-27 15:58:01', b'0');
INSERT INTO `users` VALUES (215, '18703813750', NULL, NULL, 1, '2019-08-30 09:13:12', '2019-08-30 09:13:11', b'0');
INSERT INTO `users` VALUES (216, '15279514680', NULL, NULL, 1, '2019-08-30 11:35:59', '2019-08-30 11:35:59', b'0');
INSERT INTO `users` VALUES (217, '13567871123', NULL, NULL, 1, '2019-08-30 15:09:01', '2019-08-30 15:09:00', b'0');
INSERT INTO `users` VALUES (218, '13774153793', NULL, NULL, 1, '2019-09-03 15:41:56', '2019-09-03 15:41:56', b'0');
INSERT INTO `users` VALUES (219, '18319431325', '123', NULL, 1, '2019-09-04 17:46:39', '2019-09-04 17:47:15', b'0');
INSERT INTO `users` VALUES (220, '18812345678', 'hai', NULL, 1, '2019-09-05 10:18:07', '2019-09-05 10:18:22', b'0');
INSERT INTO `users` VALUES (221, '16596969632', NULL, NULL, 1, '2019-09-05 15:12:28', '2019-09-05 15:12:27', b'0');
INSERT INTO `users` VALUES (222, '16969693232', NULL, NULL, 1, '2019-09-05 15:13:54', '2019-09-05 15:13:53', b'0');
INSERT INTO `users` VALUES (223, '15039141227', 'nicheng', NULL, 1, '2019-09-05 17:16:11', '2019-09-05 17:18:38', b'0');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
