/*
 Navicat Premium Data Transfer

 Source Server         : onemall
 Source Server Type    : MySQL
 Source Server Version : 50726
 Source Host           : 192.168.88.14:3306
 Source Schema         : mall_order

 Target Server Type    : MySQL
 Target Server Version : 50726
 File Encoding         : 65001

 Date: 13/03/2020 07:36:38
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for cart_item
-- ----------------------------
DROP TABLE IF EXISTS `cart_item`;
CREATE TABLE `cart_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号，唯一自增。',
  `status` tinyint(4) NOT NULL DEFAULT '-1' COMMENT '状态\n     *\n     * 1-正常\n     * 2-主动删除\n     * 3-下单删除',
  `delete_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '商品在购物车中的删除时间',
  `selected` bit(1) NOT NULL COMMENT '是否选中',
  `user_id` int(11) NOT NULL COMMENT '用户编号',
  `spu_id` int(11) NOT NULL COMMENT '商品 SPU 编号',
  `sku_id` int(11) NOT NULL COMMENT '商品 SKU 编号',
  `quantity` int(11) NOT NULL COMMENT '商品购买数量',
  `order_id` int(11) DEFAULT NULL COMMENT '订单编号',
  `order_create_time` timestamp NULL DEFAULT NULL COMMENT '订单创建时间',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COMMENT='cart_item';

-- ----------------------------
-- Records of cart_item
-- ----------------------------
BEGIN;
INSERT INTO `cart_item` VALUES (1, 2, '2019-04-17 20:45:25', b'1', 1, 29, 33, 6, NULL, '2019-04-11 17:00:37', '2019-04-11 17:00:37', '2019-04-17 20:45:25');
INSERT INTO `cart_item` VALUES (2, 2, '2019-04-14 01:27:15', b'1', 1, 28, 32, 1, NULL, '2019-04-13 21:28:36', '2019-04-13 21:28:37', '2019-04-14 01:27:15');
INSERT INTO `cart_item` VALUES (3, 2, '2019-04-20 19:57:31', b'1', 1, 29, 33, 3, NULL, '2019-04-14 01:37:45', '2019-04-14 01:37:45', '2019-04-20 19:57:31');
INSERT INTO `cart_item` VALUES (4, 2, '2019-04-20 19:57:31', b'1', 1, 32, 34, 1, NULL, '2019-04-17 10:23:55', '2019-04-17 10:23:56', '2019-04-20 19:57:31');
INSERT INTO `cart_item` VALUES (5, 1, '2019-04-19 20:35:36', b'1', 29, 32, 34, 1, NULL, '2019-04-19 20:35:36', '2019-04-19 20:35:37', '2019-04-19 20:35:36');
INSERT INTO `cart_item` VALUES (6, 1, '2019-04-19 20:35:46', b'1', 29, 28, 31, 4, NULL, '2019-04-19 20:35:46', '2019-04-19 20:35:46', '2019-04-19 20:35:46');
INSERT INTO `cart_item` VALUES (7, 1, '2019-05-05 16:00:18', b'1', 57, 33, 36, 1, NULL, '2019-05-05 16:00:18', '2019-05-05 16:00:19', '2019-05-05 16:00:18');
INSERT INTO `cart_item` VALUES (8, 1, '2019-05-07 18:14:26', b'1', 62, 41, 50, 1, NULL, '2019-05-07 18:14:26', '2019-05-07 18:14:26', '2019-05-07 18:14:26');
INSERT INTO `cart_item` VALUES (9, 1, '2019-05-08 16:38:51', b'1', 64, 33, 37, 1, NULL, '2019-05-08 16:38:51', '2019-05-08 16:38:51', '2019-05-08 16:38:51');
INSERT INTO `cart_item` VALUES (10, 1, '2019-05-08 20:16:26', b'1', 65, 29, 33, 1, NULL, '2019-05-08 20:16:26', '2019-05-08 20:16:26', '2019-05-08 20:16:26');
INSERT INTO `cart_item` VALUES (11, 1, '2019-05-09 19:37:04', b'1', 66, 32, 34, 1, NULL, NULL, '2019-05-09 19:37:04', '2019-05-09 19:37:04');
INSERT INTO `cart_item` VALUES (12, 1, '2019-05-09 19:38:22', b'1', 66, 29, 33, 1, NULL, NULL, '2019-05-09 19:38:23', '2019-05-09 19:38:22');
INSERT INTO `cart_item` VALUES (13, 1, '2019-05-09 19:38:26', b'1', 66, 29, 51, 8, NULL, NULL, '2019-05-09 19:38:27', '2019-05-09 19:38:26');
INSERT INTO `cart_item` VALUES (14, 2, '2019-05-17 13:51:10', b'1', 1, 35, 40, 1, NULL, NULL, '2019-05-17 13:47:05', '2019-05-17 13:51:10');
INSERT INTO `cart_item` VALUES (15, 2, '2019-05-17 13:51:10', b'1', 1, 28, 31, 1, NULL, NULL, '2019-05-17 13:47:15', '2019-05-17 13:51:10');
INSERT INTO `cart_item` VALUES (16, 1, '2019-05-17 17:49:48', b'1', 73, 33, 36, 1, NULL, NULL, '2019-05-17 17:49:48', '2019-05-17 17:49:48');
INSERT INTO `cart_item` VALUES (17, 1, '2019-05-17 17:49:53', b'1', 73, 33, 37, 1, NULL, NULL, '2019-05-17 17:49:53', '2019-05-17 17:49:53');
INSERT INTO `cart_item` VALUES (18, 2, '2019-05-17 17:58:51', b'1', 1, 29, 33, 2, NULL, NULL, '2019-05-17 17:58:23', '2019-05-17 17:58:51');
INSERT INTO `cart_item` VALUES (19, 2, '2019-05-17 17:58:51', b'1', 1, 28, 31, 1, NULL, NULL, '2019-05-17 17:58:40', '2019-05-17 17:58:51');
INSERT INTO `cart_item` VALUES (20, 1, '2019-08-10 15:37:17', b'1', 195, 34, 38, 1, NULL, NULL, '2019-08-10 15:37:16', '2019-08-10 15:37:17');
INSERT INTO `cart_item` VALUES (21, 2, '2019-08-12 17:35:07', b'1', 197, 33, 36, 1, NULL, NULL, '2019-08-12 17:29:04', '2019-08-12 17:35:07');
INSERT INTO `cart_item` VALUES (22, 2, '2019-08-12 18:01:38', b'1', 197, 33, 36, 1, NULL, NULL, '2019-08-12 17:58:38', '2019-08-12 18:01:38');
INSERT INTO `cart_item` VALUES (23, 1, '2019-08-12 18:29:58', b'1', 197, 33, 36, 1, NULL, NULL, '2019-08-12 18:29:59', '2019-08-12 18:29:58');
COMMIT;

-- ----------------------------
-- Table structure for order_cancel
-- ----------------------------
DROP TABLE IF EXISTS `order_cancel`;
CREATE TABLE `order_cancel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL COMMENT '订单id',
  `order_no` varchar(50) NOT NULL COMMENT '订单编号',
  `reason` int(2) NOT NULL,
  `other_reason` varchar(100) DEFAULT NULL COMMENT '其他原因',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of order_cancel
-- ----------------------------
BEGIN;
INSERT INTO `order_cancel` VALUES (5, 11, 'd31a7b9e2bb2483787dc601127f94c4d', 2, NULL, '2019-03-30 17:48:17', NULL);
INSERT INTO `order_cancel` VALUES (6, 47, '29635cff9cc8419', 7, NULL, '2019-04-12 19:55:50', NULL);
INSERT INTO `order_cancel` VALUES (7, 48, '8472c75db7794b', 6, NULL, '2019-04-12 19:56:07', NULL);
INSERT INTO `order_cancel` VALUES (8, 95, '7aa0c5558746431b', 2, NULL, '2019-05-05 19:44:31', NULL);
INSERT INTO `order_cancel` VALUES (9, 49, '00be8f5971c24b', 1, NULL, '2019-05-17 13:34:14', NULL);
COMMIT;

-- ----------------------------
-- Table structure for order_exchange
-- ----------------------------
DROP TABLE IF EXISTS `order_exchange`;
CREATE TABLE `order_exchange` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `order_no` varchar(50) NOT NULL,
  `sku_id` int(11) NOT NULL,
  `exchange_sku_id` int(11) NOT NULL COMMENT '换货商品id',
  `exchange_order_logistics_id` int(11) NOT NULL COMMENT '换货物流id',
  `receiver_order_logistics_id` int(11) NOT NULL COMMENT '收件地址',
  `order_reason_id` int(11) DEFAULT NULL COMMENT '换货原因',
  `reason` varchar(255) DEFAULT NULL COMMENT '换货原因 (其他的时候)',
  `payment_time` datetime DEFAULT NULL COMMENT '付款时间',
  `delivery_time` datetime DEFAULT NULL COMMENT '发货时间',
  `receiver_time` datetime DEFAULT NULL COMMENT '收货时间',
  `closing_time` datetime DEFAULT NULL COMMENT '成交时间',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `delete` smallint(2) DEFAULT NULL COMMENT '删除状态',
  `order_type` int(2) DEFAULT NULL COMMENT '订单类型 0、为 Order 订单 1、为 OrderItem 订单',
  `status` int(2) DEFAULT NULL COMMENT '状态 申请换货、申请成功、申请失败、换货中、换货成功',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for order_item
-- ----------------------------
DROP TABLE IF EXISTS `order_item`;
CREATE TABLE `order_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id自增长',
  `order_id` int(11) NOT NULL COMMENT '订单编号',
  `order_no` varchar(50) NOT NULL COMMENT '订单号',
  `order_logistics_id` int(11) DEFAULT NULL COMMENT '物流id',
  `sku_id` int(11) NOT NULL COMMENT '商品id',
  `sku_name` varchar(50) NOT NULL COMMENT '商品名字',
  `sku_image` varchar(250) NOT NULL COMMENT '图片名字',
  `quantity` int(3) NOT NULL COMMENT '商品数量',
  `origin_price` int(11) NOT NULL COMMENT '原始单价，单位：分',
  `buy_price` int(11) NOT NULL COMMENT '购买单价，单位：分',
  `present_price` int(11) NOT NULL COMMENT '最终价格，单位：分',
  `buy_total` int(11) NOT NULL COMMENT '购买总金额，单位：分',
  `discount_total` int(11) NOT NULL COMMENT '优惠总金额，单位：分',
  `present_total` int(11) NOT NULL COMMENT '最终总金额，单位：分',
  `payment_time` datetime DEFAULT NULL COMMENT '付款时间',
  `delivery_time` datetime DEFAULT NULL COMMENT '发货时间',
  `receiver_time` datetime DEFAULT NULL COMMENT '收货时间',
  `closing_time` datetime DEFAULT NULL,
  `has_return_exchange` int(11) DEFAULT NULL COMMENT '是否退换货',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(250) DEFAULT NULL COMMENT '备注',
  `delivery_type` int(2) NOT NULL COMMENT '发送方式',
  `status` smallint(2) NOT NULL COMMENT '状态：0、代发货 1、已发货 2、已收货 20、换货中 21、换货成功 40、退货中 41、已退货',
  `deleted` smallint(2) NOT NULL COMMENT '删除状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of order_item
-- ----------------------------
BEGIN;
INSERT INTO `order_item` VALUES (19, 47, '29635cff9cc841948ef3c2cfc3fb7911', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 1, '2019-04-11 22:15:32', NULL, NULL, 1, 5, 0);
INSERT INTO `order_item` VALUES (20, 48, '8472c75db7794b158ce9c3146fbb4e02', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 1, '2019-04-11 22:16:03', NULL, NULL, 1, 5, 0);
INSERT INTO `order_item` VALUES (21, 49, '00be8f5971c24bbcbddf9014bb0d2310', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 1, '2019-04-11 22:19:17', NULL, NULL, 1, 5, 0);
INSERT INTO `order_item` VALUES (22, 50, 'b4e42922b2634c1a94f01b2d66eeb8bf', 34, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 0, 0, 0, 0, NULL, NULL, '2019-04-12 21:27:14', '2019-05-09 22:44:34', 1, '2019-04-11 22:19:42', NULL, NULL, 1, 4, 0);
INSERT INTO `order_item` VALUES (23, 51, '76c163c61ffb465f', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 6, 10, 60, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 1, '2019-04-14 01:27:15', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (24, 51, '76c163c61ffb465f', NULL, 32, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 2, 2, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 1, '2019-04-14 01:27:15', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (25, 74, '2186b8b4ca32442c', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 3, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-20 19:57:27', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (26, 74, '2186b8b4ca32442c', NULL, 34, '农夫山泉', 'https://img.1000.com/qm-a-img/prod/000000/68635d48f57444c8a5ffd47a257dc3d7.jpg', 1, 125, 50, 50, 1000, 0, 1000, NULL, NULL, NULL, NULL, 1, '2019-04-20 19:57:27', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (27, 75, '0668f5a6d168471c', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 1, 1, 1, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-04-20 19:58:10', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (28, 76, '6f465f43b2f34a3f', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-20 22:19:28', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (41, 89, 'd4867f5320bb4d07', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-20 23:42:56', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (42, 90, '2667b89fbb5e49d9', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-20 23:44:43', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (47, 95, '7aa0c5558746431b', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 02:17:24', NULL, NULL, 1, 5, 0);
INSERT INTO `order_item` VALUES (49, 97, '2dd9173348c94047', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 14:22:49', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (50, 98, '5987e77245064f5c', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 15:01:50', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (51, 99, '0aa0ff0bb2a74180', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 15:05:21', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (53, 101, 'e7f4804c54774747', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 15:06:30', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (54, 102, 'cdff09a25c724c02', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 1, 1, 1, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-04-21 15:10:39', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (55, 103, '7de9b6251e434807', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 1, 1, 1, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-04-21 15:14:17', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (56, 104, '80475d74fc1f4a56', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 1, 1, 1, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-04-21 15:19:19', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (57, 105, 'ce4966bed7104dd5', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 18:59:24', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (58, 106, 'a72347c6571f4f74', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 19:08:18', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (59, 107, '7dedc1e8c6484530', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 19:22:19', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (61, 109, '0635a03e4ad8439d', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 1, 1, 1, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-04-21 19:57:14', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (62, 110, '8cfb63d2f17445bb', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 1, 1, 1, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-04-21 20:17:04', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (63, 111, '11e64862f6d94ceb', NULL, 34, '农夫山泉', 'https://img.1000.com/qm-a-img/prod/000000/68635d48f57444c8a5ffd47a257dc3d7.jpg', 1, 125, 50, 50, 1000, 0, 1000, NULL, NULL, NULL, NULL, 1, '2019-04-21 20:24:05', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (64, 112, '472994edfd90458d', NULL, 34, '农夫山泉', 'https://img.1000.com/qm-a-img/prod/000000/68635d48f57444c8a5ffd47a257dc3d7.jpg', 1, 125, 50, 50, 1000, 0, 1000, NULL, NULL, '2019-04-22 19:32:42', NULL, 1, '2019-04-21 20:37:45', NULL, NULL, 1, 4, 0);
INSERT INTO `order_item` VALUES (65, 113, 'aee52dfc8bef4603', NULL, 34, '农夫山泉', 'https://img.1000.com/qm-a-img/prod/000000/68635d48f57444c8a5ffd47a257dc3d7.jpg', 1, 125, 50, 50, 1000, 0, 1000, NULL, NULL, NULL, NULL, 1, '2019-04-21 20:51:38', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (66, 114, '2da845ff0da74b8b', NULL, 34, '农夫山泉', 'https://img.1000.com/qm-a-img/prod/000000/68635d48f57444c8a5ffd47a257dc3d7.jpg', 1, 125, 50, 50, 1000, 0, 1000, NULL, NULL, NULL, NULL, 1, '2019-04-21 22:38:24', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (67, 115, '23ce74ee3cbc49d8', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-21 23:29:21', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (70, 118, '6d73bb4e01c349d6', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-22 17:06:00', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (72, 120, '6377703d238e4b88', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-22 19:31:55', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (73, 121, '3dc33dcaf4b24724', NULL, 41, 'Oracle', 'https://static.oschina.net/img/logo/oracle.gif', 1, 2000, 2000, 2000, 44000, 0, 44000, NULL, NULL, NULL, NULL, 1, '2019-04-22 19:35:45', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (74, 122, '6074931dc45541f9', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-22 20:51:39', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (76, 124, 'fc6c662e66a24a86', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-22 22:19:58', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (77, 125, '0c17c9bc441645f2', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 8, 200, 40, 160, NULL, NULL, NULL, NULL, 1, '2019-04-22 22:21:26', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (79, 127, 'af5c4f40bc9c478d', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 10, 10, 0, 10, NULL, NULL, NULL, NULL, 1, '2019-04-22 22:28:21', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (80, 128, '53cd76bff19242e8', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 10, 10, 0, 10, NULL, NULL, NULL, NULL, 1, '2019-04-22 22:29:16', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (81, 129, 'a8a40abdb2cc430b', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 10, 10, 0, 10, NULL, NULL, NULL, NULL, 1, '2019-04-22 22:37:18', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (82, 130, 'e6d4fe973a404508', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 10, 10, 0, 10, NULL, NULL, NULL, NULL, 1, '2019-04-22 22:37:23', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (83, 131, 'e2edc556fff847c5', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 10, 10, 0, 10, NULL, NULL, NULL, NULL, 1, '2019-04-23 00:22:22', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (84, 132, 'a6d7da64863c499e', NULL, 33, 'kafka 实战', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10, 10, 10, 10, 0, 10, NULL, NULL, NULL, NULL, 1, '2019-04-23 10:03:50', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (85, 133, 'e815710ad0014f35', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 10000, 10000, 0, 10000, NULL, NULL, NULL, NULL, 1, '2019-04-27 00:02:20', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (86, 134, 'a624ad4406554db5', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 10000, 10000, 0, 10000, NULL, NULL, NULL, NULL, 1, '2019-04-27 00:43:06', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (87, 135, 'ffff6dd443a844ee', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 10000, 10000, 0, 10000, NULL, NULL, NULL, NULL, 1, '2019-04-27 00:44:09', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (107, 159, '2a5a8df629764732', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-09 01:10:40', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (108, 160, 'c1775cdb254d4700', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-09 01:15:01', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (112, 164, 'c75d9c0abc264f53', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-09 01:47:25', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (113, 165, 'afd122fa875549de', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-09 16:52:09', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (121, 173, '45c90cf80f904cf8', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-09 20:36:10', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (122, 174, 'b646bca1a2f84226', NULL, 38, 'MySQL', 'https://static.oschina.net/img/logo/mysql.png', 1, 2000, 2000, 2000, 2000, 0, 2000, NULL, NULL, NULL, NULL, 1, '2019-05-10 01:16:45', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (124, 176, '56d8e004a4ce4aaa', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 10000, 10000, 0, 10000, NULL, NULL, NULL, NULL, 1, '2019-05-10 21:06:10', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (125, 178, 'bd01be1ea05a4113', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-11 21:38:14', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (126, 179, '06bd26225a7a45b8', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-12 00:06:47', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (132, 193, 'f547cf1a19d84702', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-12 00:33:04', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (133, 194, '3bc06d86646c4624', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-12 00:44:16', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (134, 195, 'e3adfabd987340cb', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-12 00:45:14', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (135, 196, 'f2ab67d45fb444c3', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 10000000, 10000000, 8000000, 10000000, 2000000, 8000000, NULL, NULL, NULL, NULL, 1, '2019-05-12 00:45:50', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (136, 197, 'd43d4a25052842bf', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 9000, 10000, 1000, 9000, NULL, NULL, NULL, NULL, 1, '2019-05-12 18:38:32', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (158, 216, 'b8300a8bd1084815', NULL, 40, 'Oracle', 'https://static.oschina.net/img/logo/oracle.gif', 1, 5000, 5000, 5000, 5000, 0, 5000, NULL, NULL, NULL, NULL, 1, '2019-05-17 13:51:10', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (159, 216, 'b8300a8bd1084815', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 100, 100, 100, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-05-17 13:51:10', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (160, 217, '1ee223bca4ae4ab6', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 100, 100, 100, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-05-17 14:11:15', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (161, 218, '4f88cd5b7f5a4654', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 100, 100, 49, 100, 51, 49, NULL, NULL, NULL, NULL, 1, '2019-05-17 14:21:18', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (162, 219, '7373c33d88d24c62', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 100, 100, 100, 100, 0, 100, NULL, NULL, NULL, NULL, 1, '2019-05-17 15:18:22', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (163, 220, '06cafeb1b5504289', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 9000, 10000, 1000, 9000, NULL, NULL, NULL, NULL, 1, '2019-05-17 17:46:31', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (164, 221, '44fed72a246d4b94', NULL, 33, 'kafka 实战第一版', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694ae392047b?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 2, 10000000, 10000000, 7999996, 20000000, 4000008, 15999992, NULL, NULL, NULL, NULL, 1, '2019-05-17 17:58:51', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (165, 221, '44fed72a246d4b94', NULL, 31, '测试商品', 'https://user-gold-cdn.xitu.io/2019/4/1/169d694b02ef0df7?imageView2/0/w/1280/h/960/format/jpeg/ignore-error/1', 1, 100, 100, 99, 100, 1, 99, NULL, NULL, NULL, NULL, 1, '2019-05-17 17:58:51', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (167, 223, 'fc6625e45ee54930', NULL, 42, 'Java', 'https://static.oschina.net/img/logo/java.png', 1, 5100, 5100, 5100, 5100, 0, 5100, NULL, NULL, NULL, NULL, 1, '2019-05-18 20:26:59', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (168, 224, 'dd6191439a0e431f', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 10000, 10000, 0, 10000, NULL, NULL, NULL, NULL, 1, '2019-08-12 17:35:06', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (169, 225, '96d14ff467ef40e7', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 10000, 10000, 0, 10000, NULL, NULL, NULL, NULL, 1, '2019-08-12 17:35:08', NULL, NULL, 1, 1, 0);
INSERT INTO `order_item` VALUES (170, 226, 'fb6602459e1c48bd', NULL, 36, 'Kafka 书籍汇总', 'http://static.iocoder.cn/kafka.png', 1, 10000, 10000, 10000, 10000, 0, 10000, NULL, NULL, NULL, NULL, 1, '2019-08-12 18:01:38', NULL, NULL, 1, 1, 0);
COMMIT;

-- ----------------------------
-- Table structure for order_logistics
-- ----------------------------
DROP TABLE IF EXISTS `order_logistics`;
CREATE TABLE `order_logistics` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id自增长',
  `area_no` varchar(10) NOT NULL COMMENT '地区编号',
  `name` varchar(20) NOT NULL COMMENT '名称',
  `mobile` varchar(20) NOT NULL COMMENT '手机号',
  `address` varchar(255) NOT NULL COMMENT '详细地址',
  `logistics` int(2) NOT NULL COMMENT '物流商家',
  `logistics_no` varchar(20) NOT NULL COMMENT '物流单号',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of order_logistics
-- ----------------------------
BEGIN;
INSERT INTO `order_logistics` VALUES (24, '110101', 'Andy', '13302925934', '中二环，光电大厦11F 前台收', 1, '23123124123', '2019-04-11 22:50:31', NULL);
INSERT INTO `order_logistics` VALUES (34, '110101', 'Andy', '13302925934', '中二环，光电大厦11F 前台收', 1, '314123123123', '2019-04-12 19:23:42', NULL);
COMMIT;

-- ----------------------------
-- Table structure for order_logistics_detail
-- ----------------------------
DROP TABLE IF EXISTS `order_logistics_detail`;
CREATE TABLE `order_logistics_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id自增长',
  `order_logistics_id` int(11) NOT NULL COMMENT '物流编号',
  `logistics_time` datetime NOT NULL COMMENT '物流时间',
  `logistics_information` varchar(20) NOT NULL COMMENT '物流信息',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of order_logistics_detail
-- ----------------------------
BEGIN;
INSERT INTO `order_logistics_detail` VALUES (1, 34, '2019-04-12 22:46:15', '已经到上海总部', '2019-04-12 22:46:27', NULL);
INSERT INTO `order_logistics_detail` VALUES (2, 24, '2019-04-12 22:46:42', '一道成都，正在发往长沙', '2019-04-12 22:46:58', NULL);
COMMIT;

-- ----------------------------
-- Table structure for order_recipient
-- ----------------------------
DROP TABLE IF EXISTS `order_recipient`;
CREATE TABLE `order_recipient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL COMMENT '订单id',
  `area_no` varchar(20) NOT NULL COMMENT '区域编号',
  `name` varchar(20) NOT NULL COMMENT '收件人名称',
  `mobile` varchar(20) NOT NULL COMMENT '手机号',
  `type` int(2) NOT NULL COMMENT '快递方式',
  `address` varchar(250) NOT NULL COMMENT '地址详细',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of order_recipient
-- ----------------------------
BEGIN;
INSERT INTO `order_recipient` VALUES (22, 47, '110101', 'Andy', '13302925934', 1, '中二环，光电大厦11F 前台收', '2019-04-11 22:15:32', NULL);
INSERT INTO `order_recipient` VALUES (23, 48, '110101', 'Andy', '13302925934', 1, '中二环，光电大厦11F 前台收', '2019-04-11 22:16:03', NULL);
INSERT INTO `order_recipient` VALUES (24, 49, '110101', 'Andy', '13302925934', 1, '中二环，光电大厦11F 前台收', '2019-04-11 22:19:17', NULL);
INSERT INTO `order_recipient` VALUES (25, 50, '110101', 'Andy', '13302925934', 1, '中二环，光电大厦11F 前台收', '2019-04-11 22:19:42', NULL);
INSERT INTO `order_recipient` VALUES (26, 51, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-14 01:27:15', NULL);
INSERT INTO `order_recipient` VALUES (49, 74, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-20 19:57:27', NULL);
INSERT INTO `order_recipient` VALUES (50, 75, '22033', 'sin', '18132019023', 1, '湖南省深圳市北京3环56号', '2019-04-20 19:58:10', NULL);
INSERT INTO `order_recipient` VALUES (51, 76, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-20 22:19:28', NULL);
INSERT INTO `order_recipient` VALUES (64, 89, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-20 23:42:56', NULL);
INSERT INTO `order_recipient` VALUES (65, 90, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-20 23:44:43', NULL);
INSERT INTO `order_recipient` VALUES (70, 95, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 02:17:24', NULL);
INSERT INTO `order_recipient` VALUES (72, 97, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 14:22:49', NULL);
INSERT INTO `order_recipient` VALUES (73, 98, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 15:01:50', NULL);
INSERT INTO `order_recipient` VALUES (74, 99, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 15:05:21', NULL);
INSERT INTO `order_recipient` VALUES (76, 101, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 15:06:30', NULL);
INSERT INTO `order_recipient` VALUES (77, 102, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 15:10:39', NULL);
INSERT INTO `order_recipient` VALUES (78, 103, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 15:14:17', NULL);
INSERT INTO `order_recipient` VALUES (79, 104, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 15:19:19', NULL);
INSERT INTO `order_recipient` VALUES (80, 105, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 18:59:24', NULL);
INSERT INTO `order_recipient` VALUES (81, 106, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 19:08:18', NULL);
INSERT INTO `order_recipient` VALUES (82, 107, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 19:22:19', NULL);
INSERT INTO `order_recipient` VALUES (84, 109, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 19:57:14', NULL);
INSERT INTO `order_recipient` VALUES (85, 110, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 20:17:04', NULL);
INSERT INTO `order_recipient` VALUES (86, 111, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 20:24:05', NULL);
INSERT INTO `order_recipient` VALUES (87, 112, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 20:37:45', NULL);
INSERT INTO `order_recipient` VALUES (88, 113, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 20:51:38', NULL);
INSERT INTO `order_recipient` VALUES (89, 114, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 22:38:24', NULL);
INSERT INTO `order_recipient` VALUES (90, 115, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-21 23:29:21', NULL);
INSERT INTO `order_recipient` VALUES (93, 118, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 17:06:00', NULL);
INSERT INTO `order_recipient` VALUES (95, 120, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 19:31:55', NULL);
INSERT INTO `order_recipient` VALUES (96, 121, '22033', 'sin', '18132019023', 1, '湖南省深圳市北京3环56号', '2019-04-22 19:35:45', NULL);
INSERT INTO `order_recipient` VALUES (97, 122, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 20:51:39', NULL);
INSERT INTO `order_recipient` VALUES (99, 124, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 22:19:58', NULL);
INSERT INTO `order_recipient` VALUES (100, 125, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 22:21:26', NULL);
INSERT INTO `order_recipient` VALUES (102, 127, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 22:28:21', NULL);
INSERT INTO `order_recipient` VALUES (103, 128, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 22:29:16', NULL);
INSERT INTO `order_recipient` VALUES (104, 129, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 22:37:18', NULL);
INSERT INTO `order_recipient` VALUES (105, 130, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-22 22:37:23', NULL);
INSERT INTO `order_recipient` VALUES (106, 131, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-23 00:22:22', NULL);
INSERT INTO `order_recipient` VALUES (107, 132, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-23 10:03:50', NULL);
INSERT INTO `order_recipient` VALUES (108, 133, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-27 00:02:20', NULL);
INSERT INTO `order_recipient` VALUES (109, 134, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-27 00:43:06', NULL);
INSERT INTO `order_recipient` VALUES (110, 135, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-04-27 00:44:09', NULL);
INSERT INTO `order_recipient` VALUES (130, 159, '22033', 'sin', '18132019023', 1, '湖南省深圳市北京3环56号', '2019-05-09 01:10:40', NULL);
INSERT INTO `order_recipient` VALUES (131, 160, '22033', 'sin', '18132019023', 1, '湖南省深圳市北京3环56号', '2019-05-09 01:15:01', NULL);
INSERT INTO `order_recipient` VALUES (135, 164, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-09 01:47:25', NULL);
INSERT INTO `order_recipient` VALUES (136, 165, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-09 16:52:09', NULL);
INSERT INTO `order_recipient` VALUES (144, 173, '22033', 'sin', '18132019023', 1, '湖南省深圳市北京3环56号', '2019-05-09 20:36:10', NULL);
INSERT INTO `order_recipient` VALUES (145, 174, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-10 01:16:45', NULL);
INSERT INTO `order_recipient` VALUES (147, 176, '120101', 'xxx', '18670071886', 1, '2`121`2`12', '2019-05-10 21:06:10', NULL);
INSERT INTO `order_recipient` VALUES (148, 178, '22033', 'sin', '18132019023', 1, '湖南省深圳市北京3环56号', '2019-05-11 21:38:09', NULL);
INSERT INTO `order_recipient` VALUES (149, 179, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-12 00:06:47', NULL);
INSERT INTO `order_recipient` VALUES (155, 193, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-12 00:33:04', NULL);
INSERT INTO `order_recipient` VALUES (156, 194, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-12 00:44:16', NULL);
INSERT INTO `order_recipient` VALUES (157, 195, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-12 00:45:14', NULL);
INSERT INTO `order_recipient` VALUES (158, 196, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-12 00:45:50', NULL);
INSERT INTO `order_recipient` VALUES (159, 197, '22033', 'sin', '18132019023', 1, '湖南省深圳市北京3环56号', '2019-05-12 18:38:32', NULL);
INSERT INTO `order_recipient` VALUES (178, 216, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-17 13:51:10', NULL);
INSERT INTO `order_recipient` VALUES (179, 217, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-17 14:11:14', NULL);
INSERT INTO `order_recipient` VALUES (180, 218, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-17 14:21:18', NULL);
INSERT INTO `order_recipient` VALUES (181, 219, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-17 15:18:22', NULL);
INSERT INTO `order_recipient` VALUES (182, 220, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-17 17:46:31', NULL);
INSERT INTO `order_recipient` VALUES (183, 221, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-17 17:58:51', NULL);
INSERT INTO `order_recipient` VALUES (185, 223, '230102', 'mi', '13302926050', 1, '湖南省深圳市北京去3环', '2019-05-18 20:26:59', NULL);
INSERT INTO `order_recipient` VALUES (186, 224, '110101', '胡家明', '18856655656', 1, '44444444444', '2019-08-12 17:35:06', NULL);
INSERT INTO `order_recipient` VALUES (187, 225, '110101', '胡家明', '18856655656', 1, '44444444444', '2019-08-12 17:35:08', NULL);
INSERT INTO `order_recipient` VALUES (188, 226, '110101', '胡家明', '18856655656', 1, '44444444444', '2019-08-12 18:01:38', NULL);
COMMIT;

-- ----------------------------
-- Table structure for order_return
-- ----------------------------
DROP TABLE IF EXISTS `order_return`;
CREATE TABLE `order_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id自增长',
  `service_number` varchar(50) NOT NULL COMMENT '服务号',
  `order_id` int(11) NOT NULL COMMENT '订单编号',
  `order_no` varchar(50) NOT NULL COMMENT '订单号',
  `order_logistics_id` int(11) DEFAULT NULL COMMENT '物流 id',
  `refund_price` int(11) NOT NULL COMMENT '退回金额',
  `reason` int(11) NOT NULL COMMENT '退货原因',
  `describe` varchar(255) DEFAULT NULL COMMENT '换货原因 (其他的时候)',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `approval_time` datetime DEFAULT NULL COMMENT '同意时间',
  `refuse_time` datetime DEFAULT NULL COMMENT '拒绝时间',
  `logistics_time` datetime DEFAULT NULL COMMENT '物流时间（填写物流单号时间）',
  `receiver_time` datetime DEFAULT NULL COMMENT '收货时间',
  `closing_time` datetime DEFAULT NULL COMMENT '成交时间',
  `service_type` int(2) DEFAULT NULL COMMENT ' 1、退货 2、退款',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `status` int(2) NOT NULL COMMENT '状态 申请换货、申请成功、申请失败、退货中、退货成功',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of order_return
-- ----------------------------
BEGIN;
INSERT INTO `order_return` VALUES (1, '1111111', 50, 'b4e42922b2634', 24, 1000, 3, '不要了，不好看', '2019-04-26 00:14:10', '2019-05-09 21:32:31', NULL, NULL, NULL, NULL, 1, NULL, 3);
INSERT INTO `order_return` VALUES (2, '12312312', 50, 'b4e42922b2634', NULL, 1000, 3, '不要了，不好看', '2019-04-26 00:15:29', NULL, NULL, NULL, NULL, NULL, 1, NULL, 3);
INSERT INTO `order_return` VALUES (3, '6754745', 50, 'b4e42922b2634', NULL, 1000, 2, '不要了，不好看', '2019-04-26 00:15:31', '2019-05-09 21:43:56', NULL, NULL, NULL, NULL, 2, NULL, 3);
INSERT INTO `order_return` VALUES (4, '1234124', 50, 'b4e42922b2634', NULL, 1000, 1, '不要了，不好看', '2019-04-26 00:15:33', '2019-05-09 21:45:12', NULL, NULL, NULL, NULL, 2, NULL, 6);
INSERT INTO `order_return` VALUES (5, 'ga12355', 50, 'b4e42922b2634', NULL, 1000, 3, '不要了，不好看', '2019-04-26 00:15:34', '2019-05-09 21:45:36', NULL, NULL, '2019-05-09 22:44:29', '2019-05-09 22:44:33', 1, NULL, 6);
INSERT INTO `order_return` VALUES (6, 'dsgs1241', 50, 'b4e42922b2634', NULL, 1000, 2, '不要了，不好看', '2019-04-26 00:16:21', '2019-05-09 21:41:01', NULL, NULL, '2019-05-09 22:45:20', NULL, 1, NULL, 5);
INSERT INTO `order_return` VALUES (7, 'gad12314', 50, 'b4e42922b2634', NULL, 1000, 2, '不要了，不好看', '2019-04-26 00:16:24', '2019-05-09 22:44:21', NULL, NULL, NULL, NULL, 2, NULL, 2);
INSERT INTO `order_return` VALUES (8, 'ggasd123', 50, 'b4e42922b2634', NULL, 1000, 3, '不要了，不好看', '2019-04-26 00:17:10', '2019-05-09 21:47:20', NULL, NULL, NULL, NULL, 1, NULL, 2);
INSERT INTO `order_return` VALUES (9, 'amsfdl12314', 50, 'b4e42922b2634', NULL, 1000, 1, '不要了，不好看', '2019-04-26 00:17:14', '2019-05-09 21:53:07', NULL, NULL, NULL, NULL, 2, NULL, 2);
INSERT INTO `order_return` VALUES (10, 'lo123', 50, 'b4e42922b2634', NULL, 1000, 3, '不要了，不好看', '2019-04-26 00:17:18', '2019-05-09 21:46:41', NULL, NULL, NULL, NULL, 1, NULL, 2);
INSERT INTO `order_return` VALUES (11, 'sdfan231', 50, 'b4e42922b2634', NULL, 1000, 1, '不要了，不好看', '2019-04-26 00:18:08', '2019-05-09 21:48:29', NULL, NULL, NULL, NULL, 1, NULL, 2);
INSERT INTO `order_return` VALUES (12, 'kdau213j21', 50, 'b4e42922b2634', NULL, 1000, 3, '', '2019-04-26 00:18:59', '2019-05-17 16:35:59', NULL, NULL, NULL, NULL, 2, NULL, 2);
INSERT INTO `order_return` VALUES (13, 'apdamfmn213', 50, 'b4e42922b2634', NULL, 1000, 2, '不要了，不好看', '2019-04-26 00:19:11', '2019-05-09 21:53:11', NULL, NULL, NULL, NULL, 1, NULL, 2);
INSERT INTO `order_return` VALUES (14, 'gi2341', 50, 'b4e42922b2634', NULL, 1000, 1, '123', '2019-04-26 00:22:24', NULL, NULL, NULL, NULL, NULL, 1, NULL, 1);
COMMIT;

-- ----------------------------
-- Table structure for orders
-- ----------------------------
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Id，自增长',
  `user_id` int(11) NOT NULL COMMENT '用户id\n',
  `order_no` varchar(50) NOT NULL COMMENT '订单单号',
  `buy_price` int(11) NOT NULL COMMENT '订单金额(总金额)',
  `discount_price` int(11) NOT NULL COMMENT '优惠总金额，单位：分',
  `logistics_price` int(11) NOT NULL COMMENT '物流金额',
  `present_price` int(11) NOT NULL COMMENT '最终金额，单位：分',
  `pay_amount` int(10) NOT NULL COMMENT '金额(分)',
  `payment_time` datetime DEFAULT NULL COMMENT '付款时间',
  `delivery_time` datetime DEFAULT NULL COMMENT '发货时间',
  `receiver_time` datetime DEFAULT NULL COMMENT '收货时间',
  `closing_time` datetime DEFAULT NULL COMMENT '成交时间',
  `has_return_exchange` smallint(6) NOT NULL COMMENT '是否退换货',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `status` smallint(2) NOT NULL COMMENT '状态(如果有多个商品分开发货需要全部商品发完才会改变状态) 0、待付款 1、待发货 2、待收货 3、已完成 4、已关闭',
  `create_time` datetime DEFAULT NULL COMMENT '订单创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `deleted` smallint(6) NOT NULL COMMENT '删除状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of orders
-- ----------------------------
BEGIN;
INSERT INTO `orders` VALUES (47, 29, '29635cff9cc8419', 10, 0, 0, 0, 10, NULL, NULL, NULL, NULL, 1, '添加一个测试备注', 5, '2019-04-11 22:15:32', NULL, 0);
INSERT INTO `orders` VALUES (48, 29, '8472c75db7794b', 10, 0, 0, 0, 10, NULL, NULL, NULL, NULL, 1, '', 5, '2019-04-11 22:16:03', NULL, 0);
INSERT INTO `orders` VALUES (49, 29, '00be8f5971c24b', 10, 0, 0, 0, 10, NULL, NULL, NULL, NULL, 1, '', 5, '2019-04-11 22:19:17', NULL, 0);
INSERT INTO `orders` VALUES (50, 29, 'b4e42922b2634', 10, 0, 0, 0, 10, NULL, NULL, '2019-04-12 21:27:13', '2019-05-09 22:44:33', 1, '', 4, '2019-04-11 22:19:42', NULL, 0);
INSERT INTO `orders` VALUES (51, -1, '76c163c61ffb465f', 362, 0, 0, 0, 362, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-14 01:27:15', NULL, 0);
INSERT INTO `orders` VALUES (74, -1, '2186b8b4ca32442c', 1200, 40, 0, 1160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-20 19:57:27', NULL, 0);
INSERT INTO `orders` VALUES (75, -1, '0668f5a6d168471c', 100, 0, 0, 100, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-20 19:58:10', NULL, 0);
INSERT INTO `orders` VALUES (76, -1, '6f465f43b2f34a3f', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-20 22:19:28', NULL, 0);
INSERT INTO `orders` VALUES (89, -1, 'd4867f5320bb4d07', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-20 23:42:56', NULL, 0);
INSERT INTO `orders` VALUES (90, -1, '2667b89fbb5e49d9', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-20 23:44:43', NULL, 0);
INSERT INTO `orders` VALUES (95, -1, '7aa0c5558746431b', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 5, '2019-04-21 02:17:24', NULL, 0);
INSERT INTO `orders` VALUES (97, -1, '2dd9173348c94047', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 14:22:49', NULL, 0);
INSERT INTO `orders` VALUES (98, -1, '5987e77245064f5c', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 15:01:50', NULL, 0);
INSERT INTO `orders` VALUES (99, -1, '0aa0ff0bb2a74180', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 15:05:21', NULL, 0);
INSERT INTO `orders` VALUES (101, -1, 'e7f4804c54774747', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 15:06:30', NULL, 0);
INSERT INTO `orders` VALUES (102, -1, 'cdff09a25c724c02', 100, 0, 0, 100, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 15:10:39', NULL, 0);
INSERT INTO `orders` VALUES (103, -1, '7de9b6251e434807', 100, 0, 0, 100, 100, '2019-04-21 15:21:26', NULL, NULL, NULL, 1, '', 1, '2019-04-21 15:14:17', NULL, 0);
INSERT INTO `orders` VALUES (104, -1, '80475d74fc1f4a56', 100, 0, 0, 100, 100, '2019-04-21 15:20:12', NULL, NULL, NULL, 1, '', 1, '2019-04-21 15:19:19', NULL, 0);
INSERT INTO `orders` VALUES (105, -1, 'ce4966bed7104dd5', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 18:59:24', NULL, 0);
INSERT INTO `orders` VALUES (106, -1, 'a72347c6571f4f74', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 19:08:18', NULL, 0);
INSERT INTO `orders` VALUES (107, -1, '7dedc1e8c6484530', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 19:22:19', NULL, 0);
INSERT INTO `orders` VALUES (109, -1, '0635a03e4ad8439d', 100, 0, 0, 100, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 19:57:13', NULL, 0);
INSERT INTO `orders` VALUES (110, -1, '8cfb63d2f17445bb', 100, 0, 0, 100, 100, '2019-04-21 20:17:20', NULL, NULL, NULL, 1, '', 3, '2019-04-21 20:17:04', NULL, 0);
INSERT INTO `orders` VALUES (111, -1, '11e64862f6d94ceb', 1000, 0, 0, 1000, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-21 20:24:05', NULL, 0);
INSERT INTO `orders` VALUES (112, -1, '472994edfd90458d', 1000, 0, 0, 1000, 1000, '2019-04-22 19:32:35', NULL, '2019-04-22 19:32:42', NULL, 1, '', 4, '2019-04-21 20:37:45', NULL, 0);
INSERT INTO `orders` VALUES (113, -1, 'aee52dfc8bef4603', 1000, 0, 0, 1000, 1000, '2019-04-22 19:35:58', NULL, NULL, NULL, 1, '', 3, '2019-04-21 20:51:38', NULL, 0);
INSERT INTO `orders` VALUES (114, -1, '2da845ff0da74b8b', 1000, 0, 0, 1000, 1000, '2019-04-21 22:38:34', NULL, NULL, NULL, 1, '', 3, '2019-04-21 22:38:24', NULL, 0);
INSERT INTO `orders` VALUES (115, -1, '23ce74ee3cbc49d8', 200, 40, 0, 160, 160, '2019-04-22 19:36:16', NULL, NULL, NULL, 1, '', 3, '2019-04-21 23:29:21', NULL, 0);
INSERT INTO `orders` VALUES (118, -1, '6d73bb4e01c349d6', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-22 17:05:59', NULL, 0);
INSERT INTO `orders` VALUES (120, -1, '6377703d238e4b88', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-22 19:31:55', NULL, 0);
INSERT INTO `orders` VALUES (121, -1, '3dc33dcaf4b24724', 44000, 0, 0, 44000, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-22 19:35:45', NULL, 0);
INSERT INTO `orders` VALUES (122, -1, '6074931dc45541f9', 200, 40, 0, 160, 160, '2019-04-22 20:51:46', NULL, NULL, NULL, 1, '', 3, '2019-04-22 20:51:39', NULL, 0);
INSERT INTO `orders` VALUES (124, -1, 'fc6c662e66a24a86', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-22 22:19:58', NULL, 0);
INSERT INTO `orders` VALUES (125, -1, '0c17c9bc441645f2', 200, 40, 0, 160, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-22 22:21:26', NULL, 0);
INSERT INTO `orders` VALUES (127, -1, 'af5c4f40bc9c478d', 10, 0, 0, 10, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-22 22:28:21', NULL, 0);
INSERT INTO `orders` VALUES (128, 1, '53cd76bff19242e8', 10, 0, 0, 10, 10, '2019-05-09 20:36:53', NULL, NULL, NULL, 1, '', 2, '2019-04-22 22:29:16', NULL, 0);
INSERT INTO `orders` VALUES (129, 1, 'a8a40abdb2cc430b', 10, 0, 0, 10, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-04-22 22:37:18', NULL, 0);
INSERT INTO `orders` VALUES (130, 1, 'e6d4fe973a404508', 10, 0, 0, 10, 10, '2019-04-22 22:37:27', NULL, NULL, NULL, 1, '', 3, '2019-04-22 22:37:23', NULL, 0);
INSERT INTO `orders` VALUES (131, 1, 'e2edc556fff847c5', 10, 0, 0, 10, 10, '2019-04-23 00:22:28', NULL, NULL, NULL, 1, '', 2, '2019-04-23 00:22:22', NULL, 0);
INSERT INTO `orders` VALUES (132, 1, 'a6d7da64863c499e', 10, 0, 0, 10, 10, '2019-04-23 10:03:55', NULL, NULL, NULL, 1, '', 2, '2019-04-23 10:03:50', NULL, 0);
INSERT INTO `orders` VALUES (133, 1, 'e815710ad0014f35', 10000, 0, 0, 10000, 10000, '2019-04-27 00:43:50', NULL, NULL, NULL, 1, '', 2, '2019-04-27 00:02:20', NULL, 0);
INSERT INTO `orders` VALUES (134, 1, 'a624ad4406554db5', 10000, 0, 0, 10000, 10000, '2019-04-27 00:43:17', NULL, NULL, NULL, 1, '', 2, '2019-04-27 00:43:06', NULL, 0);
INSERT INTO `orders` VALUES (135, 1, 'ffff6dd443a844ee', 10000, 0, 0, 10000, 10000, '2019-04-27 00:44:12', NULL, NULL, NULL, 1, '', 2, '2019-04-27 00:44:09', NULL, 0);
INSERT INTO `orders` VALUES (159, 1, '2a5a8df629764732', 10000000, 2000000, 0, 8000000, 8000000, '2019-05-09 01:11:27', NULL, NULL, NULL, 1, '', 2, '2019-05-09 01:10:40', NULL, 0);
INSERT INTO `orders` VALUES (160, 1, 'c1775cdb254d4700', 10000000, 2000000, 0, 8000000, 8000000, '2019-05-09 01:15:22', NULL, NULL, NULL, 1, '', 2, '2019-05-09 01:15:01', NULL, 0);
INSERT INTO `orders` VALUES (164, 1, 'c75d9c0abc264f53', 10000000, 2000000, 0, 8000000, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-05-09 01:47:25', NULL, 0);
INSERT INTO `orders` VALUES (165, 1, 'afd122fa875549de', 10000000, 2000000, 0, 8000000, 0, NULL, NULL, NULL, NULL, 1, '', 1, '2019-05-09 16:52:09', NULL, 0);
INSERT INTO `orders` VALUES (173, 1, '45c90cf80f904cf8', 10000000, 2000000, 0, 8000000, 8000000, '2019-05-09 20:36:33', NULL, NULL, NULL, 1, '', 2, '2019-05-09 20:36:10', NULL, 0);
INSERT INTO `orders` VALUES (174, 1, 'b646bca1a2f84226', 2000, 0, 0, 2000, 2000, '2019-05-10 01:16:50', NULL, NULL, NULL, 1, '', 2, '2019-05-10 01:16:45', NULL, 0);
INSERT INTO `orders` VALUES (176, 67, '56d8e004a4ce4aaa', 10000, 0, 0, 10000, 10000, '2019-05-10 21:06:16', NULL, NULL, NULL, 1, '', 2, '2019-05-10 21:06:10', NULL, 0);
INSERT INTO `orders` VALUES (178, 1, 'bd01be1ea05a4113', 10000000, 2000000, 0, 8000000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (179, 1, '06bd26225a7a45b8', 10000000, 2000000, 0, 8000000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (193, 1, 'f547cf1a19d84702', 10000000, 2000000, 0, 8000000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (194, 1, '3bc06d86646c4624', 10000000, 2000000, 0, 8000000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (195, 1, 'e3adfabd987340cb', 10000000, 2000000, 0, 8000000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (196, 1, 'f2ab67d45fb444c3', 10000000, 2000000, 0, 8000000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (197, 1, 'd43d4a25052842bf', 10000, 1000, 0, 9000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (216, 1, 'b8300a8bd1084815', 5100, 0, 0, 5100, 5100, '2019-05-17 14:21:43', NULL, NULL, NULL, 1, '', 2, NULL, NULL, 0);
INSERT INTO `orders` VALUES (217, 1, '1ee223bca4ae4ab6', 100, 0, 0, 100, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (218, 1, '4f88cd5b7f5a4654', 100, 51, 0, 49, 49, '2019-05-17 14:21:36', NULL, NULL, NULL, 1, '', 2, NULL, NULL, 0);
INSERT INTO `orders` VALUES (219, 1, '7373c33d88d24c62', 100, 0, 0, 100, 100, '2019-05-17 15:18:31', NULL, NULL, NULL, 1, '', 2, NULL, NULL, 0);
INSERT INTO `orders` VALUES (220, 1, '06cafeb1b5504289', 10000, 1000, 0, 9000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (221, 1, '44fed72a246d4b94', 20000100, 4000009, 0, 16000091, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (223, 1, 'fc6625e45ee54930', 5100, 0, 0, 5100, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (224, 197, 'dd6191439a0e431f', 10000, 0, 0, 10000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (225, 197, '96d14ff467ef40e7', 10000, 0, 0, 10000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
INSERT INTO `orders` VALUES (226, 197, 'fb6602459e1c48bd', 10000, 0, 0, 10000, 0, NULL, NULL, NULL, NULL, 1, '', 1, NULL, NULL, 0);
COMMIT;

-- ----------------------------
-- Table structure for undo_log
-- ----------------------------
DROP TABLE IF EXISTS `undo_log`;
CREATE TABLE `undo_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `branch_id` bigint(20) NOT NULL,
  `xid` varchar(100) NOT NULL,
  `rollback_info` longblob NOT NULL,
  `log_status` int(11) NOT NULL,
  `log_created` datetime NOT NULL,
  `log_modified` datetime NOT NULL,
  `ext` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ux_undo_log` (`xid`,`branch_id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of undo_log
-- ----------------------------
BEGIN;
INSERT INTO `undo_log` VALUES (15, 2011489622, '192.168.88.14:8091:2011489621', 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
INSERT INTO `undo_log` VALUES (16, 2011489623, '192.168.88.14:8091:2011489621', 0x7B226272616E63684964223A323031313438393632332C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3137387D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3231367D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22323330313032227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A226D69227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223133333032393236303530227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A22E6B996E58D97E79C81E6B7B1E59CB3E5B882E58C97E4BAACE58EBB33E78EAF227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30352D31372031333A35313A3130227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363231227D, 0, '2019-05-17 13:51:10', '2019-05-17 13:51:10', NULL);
INSERT INTO `undo_log` VALUES (17, 2011489624, '192.168.88.14:8091:2011489621', 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
INSERT INTO `undo_log` VALUES (18, 2011489627, '192.168.88.14:8091:2011489626', 0x7B226272616E63684964223A323031313438393632372C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3231377D2C7B226B657954797065223A224E554C4C222C226E616D65223A22757365725F6964222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6E6F222C2274797065223A31322C2276616C7565223A2231656532323362636134616534616236227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226275795F7072696365222C2274797065223A342C2276616C7565223A3130307D2C7B226B657954797065223A224E554C4C222C226E616D65223A22646973636F756E745F7072696365222C2274797065223A342C2276616C7565223A307D2C7B226B657954797065223A224E554C4C222C226E616D65223A226C6F676973746963735F7072696365222C2274797065223A342C2276616C7565223A307D2C7B226B657954797065223A224E554C4C222C226E616D65223A2270726573656E745F7072696365222C2274797065223A342C2276616C7565223A3130307D2C7B226B657954797065223A224E554C4C222C226E616D65223A227061795F616D6F756E74222C2274797065223A342C2276616C7565223A307D2C7B226B657954797065223A224E554C4C222C226E616D65223A227061796D656E745F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2264656C69766572795F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2272656365697665725F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A22636C6F73696E675F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A226861735F72657475726E5F65786368616E6765222C2274797065223A352C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2272656D61726B222C2274797065223A31322C2276616C7565223A22227D2C7B226B657954797065223A224E554C4C222C226E616D65223A22737461747573222C2274797065223A352C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2264656C65746564222C2274797065223A352C2276616C7565223A307D5D7D5D2C227461626C654E616D65223A226F7264657273227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A226F7264657273227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A226F7264657273227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363236227D, 0, '2019-05-17 14:11:14', '2019-05-17 14:11:14', NULL);
INSERT INTO `undo_log` VALUES (19, 2011489628, '192.168.88.14:8091:2011489626', 0x7B226272616E63684964223A323031313438393632382C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3137397D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3231377D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22323330313032227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A226D69227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223133333032393236303530227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A22E6B996E58D97E79C81E6B7B1E59CB3E5B882E58C97E4BAACE58EBB33E78EAF227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30352D31372031343A31313A3134227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363236227D, 0, '2019-05-17 14:11:14', '2019-05-17 14:11:14', NULL);
INSERT INTO `undo_log` VALUES (20, 2011489629, '192.168.88.14:8091:2011489626', 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
INSERT INTO `undo_log` VALUES (21, 2011489633, '192.168.88.14:8091:2011489631', 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
INSERT INTO `undo_log` VALUES (22, 2011489634, '192.168.88.14:8091:2011489631', 0x7B226272616E63684964223A323031313438393633342C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3138307D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3231387D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22323330313032227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A226D69227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223133333032393236303530227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A22E6B996E58D97E79C81E6B7B1E59CB3E5B882E58C97E4BAACE58EBB33E78EAF227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30352D31372031343A32313A3138227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363331227D, 0, '2019-05-17 14:21:17', '2019-05-17 14:21:17', NULL);
INSERT INTO `undo_log` VALUES (23, 2011489635, '192.168.88.14:8091:2011489631', 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
INSERT INTO `undo_log` VALUES (24, 2011489638, '192.168.88.14:8091:2011489637', 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
INSERT INTO `undo_log` VALUES (25, 2011489639, '192.168.88.14:8091:2011489637', 0x7B226272616E63684964223A323031313438393633392C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3138317D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3231397D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22323330313032227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A226D69227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223133333032393236303530227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A22E6B996E58D97E79C81E6B7B1E59CB3E5B882E58C97E4BAACE58EBB33E78EAF227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30352D31372031353A31383A3232227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363337227D, 0, '2019-05-17 15:18:21', '2019-05-17 15:18:21', NULL);
INSERT INTO `undo_log` VALUES (26, 2011489640, '192.168.88.14:8091:2011489637', 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
INSERT INTO `undo_log` VALUES (27, 2011489644, '192.168.88.14:8091:2011489642', 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
INSERT INTO `undo_log` VALUES (28, 2011489645, '192.168.88.14:8091:2011489642', 0x7B226272616E63684964223A323031313438393634352C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3138327D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3232307D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22323330313032227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A226D69227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223133333032393236303530227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A22E6B996E58D97E79C81E6B7B1E59CB3E5B882E58C97E4BAACE58EBB33E78EAF227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30352D31372031373A34363A3331227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363432227D, 0, '2019-05-17 17:46:30', '2019-05-17 17:46:30', NULL);
INSERT INTO `undo_log` VALUES (29, 2011489646, '192.168.88.14:8091:2011489642', 0x7B226272616E63684964223A323031313438393634362C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3136337D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3232307D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6E6F222C2274797065223A31322C2276616C7565223A2230366361666562316235353034323839227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6C6F676973746963735F6964222C2274797065223A347D2C7B226B657954797065223A224E554C4C222C226E616D65223A22736B755F6964222C2274797065223A342C2276616C7565223A33367D2C7B226B657954797065223A224E554C4C222C226E616D65223A22736B755F6E616D65222C2274797065223A31322C2276616C7565223A224B61666B6120E4B9A6E7B18DE6B187E680BB227D2C7B226B657954797065223A224E554C4C222C226E616D65223A22736B755F696D616765222C2274797065223A31322C2276616C7565223A22687474703A2F2F7374617469632E696F636F6465722E636E2F6B61666B612E706E67227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227175616E74697479222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726967696E5F7072696365222C2274797065223A342C2276616C7565223A31303030307D2C7B226B657954797065223A224E554C4C222C226E616D65223A226275795F7072696365222C2274797065223A342C2276616C7565223A31303030307D2C7B226B657954797065223A224E554C4C222C226E616D65223A2270726573656E745F7072696365222C2274797065223A342C2276616C7565223A393030307D2C7B226B657954797065223A224E554C4C222C226E616D65223A226275795F746F74616C222C2274797065223A342C2276616C7565223A31303030307D2C7B226B657954797065223A224E554C4C222C226E616D65223A22646973636F756E745F746F74616C222C2274797065223A342C2276616C7565223A313030307D2C7B226B657954797065223A224E554C4C222C226E616D65223A2270726573656E745F746F74616C222C2274797065223A342C2276616C7565223A393030307D2C7B226B657954797065223A224E554C4C222C226E616D65223A227061796D656E745F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2264656C69766572795F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2272656365697665725F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A22636C6F73696E675F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A226861735F72657475726E5F65786368616E6765222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30352D31372031373A34363A3331227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2272656D61726B222C2274797065223A31327D2C7B226B657954797065223A224E554C4C222C226E616D65223A2264656C69766572795F74797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A22737461747573222C2274797065223A352C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2264656C65746564222C2274797065223A352C2276616C7565223A307D5D7D5D2C227461626C654E616D65223A22606F726465725F6974656D60227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F6974656D60227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F6974656D60227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363432227D, 0, '2019-05-17 17:46:30', '2019-05-17 17:46:30', NULL);
INSERT INTO `undo_log` VALUES (30, 2011489650, '192.168.88.14:8091:2011489648', 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
INSERT INTO `undo_log` VALUES (31, 2011489651, '192.168.88.14:8091:2011489648', 0x7B226272616E63684964223A323031313438393635312C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3138337D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3232317D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22323330313032227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A226D69227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223133333032393236303530227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A22E6B996E58D97E79C81E6B7B1E59CB3E5B882E58C97E4BAACE58EBB33E78EAF227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30352D31372031373A35383A3531227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363438227D, 0, '2019-05-17 17:58:50', '2019-05-17 17:58:50', NULL);
INSERT INTO `undo_log` VALUES (32, 2011489652, '192.168.88.14:8091:2011489648', 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
INSERT INTO `undo_log` VALUES (33, 2011489656, '192.168.88.14:8091:2011489655', 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
INSERT INTO `undo_log` VALUES (35, 2011489659, '192.168.88.14:8091:2011489655', 0x7B226272616E63684964223A323031313438393635392C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3138357D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3232337D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22323330313032227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A226D69227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223133333032393236303530227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A22E6B996E58D97E79C81E6B7B1E59CB3E5B882E58C97E4BAACE58EBB33E78EAF227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30352D31382032303A32363A3539227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839363535227D, 0, '2019-05-18 20:26:58', '2019-05-18 20:26:58', NULL);
INSERT INTO `undo_log` VALUES (37, 2011489660, '192.168.88.14:8091:2011489655', 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
INSERT INTO `undo_log` VALUES (38, 2011489731, '192.168.88.14:8091:2011489730', 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
INSERT INTO `undo_log` VALUES (39, 2011489732, '192.168.88.14:8091:2011489730', 0x7B226272616E63684964223A323031313438393733322C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3138367D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3232347D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22313130313031227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A22E883A1E5AEB6E6988E227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223138383536363535363536227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A223434343434343434343434227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30382D31322031373A33353A3036227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839373330227D, 0, '2019-08-12 17:35:06', '2019-08-12 17:35:06', NULL);
INSERT INTO `undo_log` VALUES (40, 2011489733, '192.168.88.14:8091:2011489730', 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
INSERT INTO `undo_log` VALUES (41, 2011489736, '192.168.88.14:8091:2011489734', 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
INSERT INTO `undo_log` VALUES (42, 2011489737, '192.168.88.14:8091:2011489734', 0x7B226272616E63684964223A323031313438393733372C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3138377D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3232357D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22313130313031227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A22E883A1E5AEB6E6988E227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223138383536363535363536227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A223434343434343434343434227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30382D31322031373A33353A3038227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839373334227D, 0, '2019-08-12 17:35:07', '2019-08-12 17:35:07', NULL);
INSERT INTO `undo_log` VALUES (43, 2011489738, '192.168.88.14:8091:2011489734', 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
INSERT INTO `undo_log` VALUES (44, 2011489741, '192.168.88.14:8091:2011489740', 0x7B226272616E63684964223A323031313438393734312C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3232367D2C7B226B657954797065223A224E554C4C222C226E616D65223A22757365725F6964222C2274797065223A342C2276616C7565223A3139377D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6E6F222C2274797065223A31322C2276616C7565223A2266623636303234353965316334386264227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226275795F7072696365222C2274797065223A342C2276616C7565223A31303030307D2C7B226B657954797065223A224E554C4C222C226E616D65223A22646973636F756E745F7072696365222C2274797065223A342C2276616C7565223A307D2C7B226B657954797065223A224E554C4C222C226E616D65223A226C6F676973746963735F7072696365222C2274797065223A342C2276616C7565223A307D2C7B226B657954797065223A224E554C4C222C226E616D65223A2270726573656E745F7072696365222C2274797065223A342C2276616C7565223A31303030307D2C7B226B657954797065223A224E554C4C222C226E616D65223A227061795F616D6F756E74222C2274797065223A342C2276616C7565223A307D2C7B226B657954797065223A224E554C4C222C226E616D65223A227061796D656E745F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2264656C69766572795F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2272656365697665725F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A22636C6F73696E675F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A226861735F72657475726E5F65786368616E6765222C2274797065223A352C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2272656D61726B222C2274797065223A31322C2276616C7565223A22227D2C7B226B657954797065223A224E554C4C222C226E616D65223A22737461747573222C2274797065223A352C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D2C7B226B657954797065223A224E554C4C222C226E616D65223A2264656C65746564222C2274797065223A352C2276616C7565223A307D5D7D5D2C227461626C654E616D65223A226F7264657273227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A226F7264657273227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A226F7264657273227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839373430227D, 0, '2019-08-12 18:01:37', '2019-08-12 18:01:37', NULL);
INSERT INTO `undo_log` VALUES (45, 2011489742, '192.168.88.14:8091:2011489740', 0x7B226272616E63684964223A323031313438393734322C2273716C556E646F4C6F6773223A5B7B226166746572496D616765223A7B22726F7773223A5B7B226669656C6473223A5B7B226B657954797065223A225072696D6172794B6579222C226E616D65223A226964222C2274797065223A342C2276616C7565223A3138387D2C7B226B657954797065223A224E554C4C222C226E616D65223A226F726465725F6964222C2274797065223A342C2276616C7565223A3232367D2C7B226B657954797065223A224E554C4C222C226E616D65223A22617265615F6E6F222C2274797065223A31322C2276616C7565223A22313130313031227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226E616D65222C2274797065223A31322C2276616C7565223A22E883A1E5AEB6E6988E227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226D6F62696C65222C2274797065223A31322C2276616C7565223A223138383536363535363536227D2C7B226B657954797065223A224E554C4C222C226E616D65223A2274797065222C2274797065223A342C2276616C7565223A317D2C7B226B657954797065223A224E554C4C222C226E616D65223A2261646472657373222C2274797065223A31322C2276616C7565223A223434343434343434343434227D2C7B226B657954797065223A224E554C4C222C226E616D65223A226372656174655F74696D65222C2274797065223A39332C2276616C7565223A22323031392D30382D31322031383A30313A3338227D2C7B226B657954797065223A224E554C4C222C226E616D65223A227570646174655F74696D65222C2274797065223A39337D5D7D5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C226265666F7265496D616765223A7B22726F7773223A5B5D2C227461626C654E616D65223A22606F726465725F726563697069656E7460227D2C2273716C54797065223A22494E53455254222C227461626C654E616D65223A22606F726465725F726563697069656E7460227D5D2C22786964223A223139322E3136382E38382E31343A383039313A32303131343839373430227D, 0, '2019-08-12 18:01:37', '2019-08-12 18:01:37', NULL);
INSERT INTO `undo_log` VALUES (46, 2011489743, '192.168.88.14:8091:2011489740', 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
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
