package cn.iocoder.mall.systemservice.rpc.errorcode;

import cn.iocoder.common.framework.vo.CommonResult;
import cn.iocoder.common.framework.vo.PageResult;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeAutoGenerateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeCreateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodePageDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeUpdateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.vo.ErrorCodeVO;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

public interface ErrorCodeRpc {

    /**
     * 获得指定分组下的错误码列表
     *
     * @param group 错误码分组
     * @param minUpdateTime 最小更新时间，允许为空。
     *                      通过该参数，我们可以增量获取超过 minUpdateTime 时间的错误码
     * @return 错误码列表
     */
    CommonResult<List<ErrorCodeVO>> listErrorCodes(@NotNull(message = "错误码分组不能为空") String group, Date minUpdateTime);

    /**
     * 自动生成错误码
     *
     * @param autoGenerateDTOs 自动生成信息 DTO
     */
    CommonResult<Boolean> autoGenerateErrorCodes(List<ErrorCodeAutoGenerateDTO> autoGenerateDTOs);

    /**
     * 创建错误码
     *
     * @param createDTO 创建错误码 DTO
     * @return 错误码编号
     */
    CommonResult<Integer> createErrorCode(ErrorCodeCreateDTO createDTO);

    /**
     * 更新错误码
     *
     * @param updateDTO 更新错误码 DTO
     */
    CommonResult<Boolean> updateErrorCode(ErrorCodeUpdateDTO updateDTO);

    /**
     * 删除错误码
     *
     * @param errorCodeId 错误码编号
     */
    CommonResult<Boolean> deleteErrorCode(Integer errorCodeId);

    /**
     * 获得错误码
     *
     * @param errorCodeId 错误码编号
     * @return 错误码
     */
    CommonResult<ErrorCodeVO> getErrorCode(Integer errorCodeId);

    /**
     * 获得错误码列表
     *
     * @param errorCodeIds 错误码编号列表
     * @return 错误码列表
     */
    CommonResult<List<ErrorCodeVO>> listErrorCodes(List<Integer> errorCodeIds);

    /**
     * 获得错误码分页
     *
     * @param pageDTO 错误码分页查询
     * @return 错误码分页结果
     */
    CommonResult<PageResult<ErrorCodeVO>> pageErrorCode(ErrorCodePageDTO pageDTO);

}
