package cn.iocoder.mall.promotion.biz.dataobject;

import cn.iocoder.common.framework.dataobject.BaseDO;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 优惠码
 */
@Data
@Accessors(chain = true)
public class CouponCodeDO extends BaseDO {

    /**
     * 编号
     */
    private Integer id;
    /**
     * 模板编号 {@link CouponTemplateDO} 的 id
     */
    private Integer templateId;
    /**
     * 优惠码
     */
    private Integer code;
    /**
     * 领取时间
     */
    private Date takeTime;
    /**
     * 领取用户编号
     */
    private Integer userId;
    /**
     * 领取的优惠劵编号
     */
    private Integer couponId;

}
