package cn.iocoder.mall.systemservice.rpc.errorcode;

import cn.iocoder.common.framework.vo.CommonResult;
import cn.iocoder.common.framework.vo.PageResult;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeAutoGenerateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeCreateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodePageDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeUpdateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.vo.ErrorCodeVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;

/**
* 部门 Rpc 接口
*/
@FeignClient("system-service")
public interface ErrorCodeFeign {

    @GetMapping("/system/errorcode/listErrorCodes")
    public CommonResult<List<ErrorCodeVO>> listErrorCodes(@RequestParam("group") String group, @RequestParam("minUpdateTime") Date minUpdateTime) ;

    @PostMapping("/system/errorcode/autoGenerateErrorCodes")
    public CommonResult<Boolean> autoGenerateErrorCodes(@RequestBody List<ErrorCodeAutoGenerateDTO> autoGenerateDTOs);

    @PostMapping("/system/errorcode/createErrorCode")
    public CommonResult<Integer> createErrorCode(@RequestBody ErrorCodeCreateDTO createDTO) ;

    @PostMapping("/system/errorcode/updateErrorCode")
    public CommonResult<Boolean> updateErrorCode(@RequestBody ErrorCodeUpdateDTO updateDTO) ;

    @GetMapping("/system/errorcode/deleteErrorCode")
    public CommonResult<Boolean> deleteErrorCode(@RequestParam("errorCodeId")Integer errorCodeId) ;

    @GetMapping("/system/errorcode/getErrorCode")
    public CommonResult<ErrorCodeVO> getErrorCode(@RequestParam("errorCodeId")Integer errorCodeId) ;

    @GetMapping("/system/errorcode/listErrorCodesByIds")
    public CommonResult<List<ErrorCodeVO>> listErrorCodes(@RequestParam("errorCodeIds")List<Integer> errorCodeIds) ;

    @PostMapping("/system/errorcode/pageErrorCode")
    public CommonResult<PageResult<ErrorCodeVO>> pageErrorCode(@RequestBody ErrorCodePageDTO pageDTO);

}
