package cn.iocoder.mall.systemservice.rpc.errorcode;

import cn.iocoder.common.framework.vo.CommonResult;
import cn.iocoder.common.framework.vo.PageResult;
import cn.iocoder.mall.systemservice.manager.errorcode.ErrorCodeManager;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeAutoGenerateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeCreateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodePageDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.dto.ErrorCodeUpdateDTO;
import cn.iocoder.mall.systemservice.rpc.errorcode.vo.ErrorCodeVO;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

import static cn.iocoder.common.framework.vo.CommonResult.success;

@Service(version = "${dubbo.provider.ErrorCodeRpc.version}")
public class ErrorCodeRpcImpl implements ErrorCodeRpc {

    @Autowired
    private ErrorCodeManager errorCodeManager;

    @Override
    public CommonResult<List<ErrorCodeVO>> listErrorCodes(String group, Date minUpdateTime) {
        return success(errorCodeManager.listErrorCodes(group, minUpdateTime));
    }

    @Override
    public CommonResult<Boolean> autoGenerateErrorCodes(List<ErrorCodeAutoGenerateDTO> autoGenerateDTOs) {
        errorCodeManager.autoGenerateErrorCodes(autoGenerateDTOs);
        return success(true);
    }

    @Override
    public CommonResult<Integer> createErrorCode(ErrorCodeCreateDTO createDTO) {
        return success(errorCodeManager.createErrorCode(createDTO));
    }

    @Override
    public CommonResult<Boolean> updateErrorCode(ErrorCodeUpdateDTO updateDTO) {
        errorCodeManager.updateErrorCode(updateDTO);
        return success(true);
    }

    @Override
    public CommonResult<Boolean> deleteErrorCode(Integer errorCodeId) {
        errorCodeManager.deleteErrorCode(errorCodeId);
        return success(true);
    }

    @Override
    public CommonResult<ErrorCodeVO> getErrorCode(Integer errorCodeId) {
        return success(errorCodeManager.getErrorCode(errorCodeId));
    }

    @Override
    public CommonResult<List<ErrorCodeVO>> listErrorCodes(List<Integer> errorCodeIds) {
        return success(errorCodeManager.listErrorCodes(errorCodeIds));
    }

    @Override
    public CommonResult<PageResult<ErrorCodeVO>> pageErrorCode(ErrorCodePageDTO pageDTO) {
        return success(errorCodeManager.pageErrorCode(pageDTO));
    }

}
