/**todo cancelType 设置默认值 0?*/
DROP TABLE IF EXISTS `trade_order`;
CREATE TABLE `trade_order`
(
    `id`                      bigint          NOT NULL AUTO_INCREMENT COMMENT '用户ID',
    `sn`                      varchar(32)     NOT NULL COMMENT '订单流水号',
    `type`                    int             NOT NULL DEFAULT '0' COMMENT '订单类型：[0:普通订单 1:秒杀订单 2:拼团订单 3:砍价订单]',
    `terminal`                int             NOT NULL COMMENT '订单来源终端：[1:小程序 2:H5 3:iOS 4:安卓]',
    `user_id`                 bigint unsigned NOT NULL COMMENT '用户编号',
    `user_ip`                 varchar(30)     NOT NULL DEFAULT '' COMMENT '用户 IP',
    `user_remark`             varchar(200)             DEFAULT NULL COMMENT '用户备注',
    `status`                  int             NOT NULL DEFAULT '0' COMMENT '订单状态：[0:待付款 1:待发货 2:待收货 3:已完成 4:已关闭]',
    `product_count`           int             NOT NULL COMMENT '购买的商品数量',
    `cancel_type`             int             DEFAULT NULL COMMENT '取消类型：[10:超时未支付 20:退款关闭 30:买家取消 40:已通过货到付款交易]',
    `remark`                  varchar(200)             DEFAULT NULL COMMENT '商家备注',
    `payed`                   bit(1)          NOT NULL DEFAULT b'0' COMMENT '是否已支付：[0:未支付 1:已经支付过]',
    `pay_time`                datetime                 DEFAULT NULL COMMENT '订单支付时间',
    `finish_time`             datetime                 DEFAULT NULL COMMENT '订单完成时间',
    `cancel_time`             datetime                 DEFAULT NULL COMMENT '订单取消时间',
    `sku_original_price`      int             NOT NULL DEFAULT '0' COMMENT '商品原价（总），单位：分',
    `sku_promotion_price`     int             NOT NULL DEFAULT '0' COMMENT '商品优惠（总），单位：分',
    `order_promotion_price`   int             NOT NULL DEFAULT '0' COMMENT '订单优惠（总），单位：分',
    `delivery_price`          int             NOT NULL DEFAULT '0' COMMENT '运费金额，单位：分',
    `pay_price`               int             NOT NULL DEFAULT '0' COMMENT '应付金额（总），单位：分',
    `pay_order_id`            int             DEFAULT NULL COMMENT '支付订单编号',
    `pay_channel`             int             DEFAULT NULL COMMENT '支付成功的支付渠道',
    `delivery_type`           int             DEFAULT NULL DEFAULT '1' COMMENT '配送方式:[1:快递发货 2:自提]',
    `actual_delivery_type`    int             DEFAULT NULL DEFAULT '1' COMMENT '实际的配送方式:[1:快递发货 2:自提]',
    `delivery_template_id`     int                      DEFAULT NULL COMMENT '配置模板的编号',
    `express_no`              int                      DEFAULT NULL COMMENT '物流公司单号',
    `delivery_status`         bit(1)          NOT NULL DEFAULT b'0' COMMENT '发货状态[0:未发货 1:已发货]',
    `delivery_time`           datetime                 DEFAULT NULL COMMENT '发货时间',
    `receive_time`            datetime                 DEFAULT NULL COMMENT '收货时间',
    `receiver_name`           varchar(20)     NOT NULL COMMENT '收件人名称',
    `receiver_mobile`         varchar(20)     NOT NULL COMMENT '收件人手机',
    `receiver_area_id`        int             NOT NULL COMMENT '收件人地区编号',
    `receiver_post_code`      int                      DEFAULT NULL COMMENT '收件人邮编',
    `receiver_detail_address` varchar(255)    NOT NULL COMMENT '收件人详细地址',
    `refund_status`           int             NOT NULL DEFAULT '0' COMMENT '订单状态：[0:未退款 1:部分退款 2:全部退款]',
    `refund_price`            int             NOT NULL DEFAULT '0' COMMENT '退款金额，单位：分',
    `coupon_id`               bigint unsigned NOT NULL COMMENT '优惠劵编号',
    `creator`                 varchar(64)              DEFAULT '' COMMENT '创建者',
    `create_time`             datetime        NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updater`                 varchar(64)              DEFAULT '' COMMENT '更新者',
    `update_time`             datetime        NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    `deleted`                 bit(1)          NOT NULL DEFAULT b'0' COMMENT '是否删除',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB COMMENT ='交易订单表';


DROP TABLE IF EXISTS `trade_order_item`;
CREATE TABLE `trade_order_item`
(
    `id`                    bigint          NOT NULL AUTO_INCREMENT COMMENT '用户ID',
    `user_id`               bigint unsigned NOT NULL COMMENT '用户编号',
    `order_Id`              bigint unsigned NOT NULL COMMENT '订单编号',
    `spu_id`                bigint unsigned NOT NULL COMMENT '商品 SPU 编号',
    `sku_id`                bigint unsigned NOT NULL COMMENT '商品 SKU 编号',
    `properties`            json                     DEFAULT NULL COMMENT '规格值数组，JSON 格式',
    `name`                  varchar(128)    NOT NULL DEFAULT '' COMMENT '商品名称',
    `pic_url`               varchar(200)             DEFAULT NULL COMMENT '商品图片',
    `count`                 int             NOT NULL COMMENT '购买数量',
    `commented`             bit(1)          NOT NULL DEFAULT b'0' COMMENT '是否评论：[0:未评论 1:已评论]',
    `original_price`        int             NOT NULL DEFAULT '0' COMMENT '商品原价（单），单位：分',
    `total_original_price`  int             NOT NULL DEFAULT '0' COMMENT '商品原价（总），单位：分',
    `total_promotion_price` int             NOT NULL DEFAULT '0' COMMENT '商品级优惠（总），单位：分',
    `present_price`         int             NOT NULL DEFAULT '0' COMMENT '最终购买金额（单），单位：分。',
    `total_present_price`   int             NOT NULL DEFAULT '0' COMMENT '最终购买金额（总），单位：分。',
    `total_pay_price`       int             NOT NULL DEFAULT '0' COMMENT '应付金额（总），单位：分',
    `refund_status`         int             NOT NULL DEFAULT '0' COMMENT '退款状态:[0:未申请退款 1:申请退款 2:等待退款 3:退款成功]',
    `refund_total`          int             NOT NULL DEFAULT '0' COMMENT '退款总金额，单位：分',
    `creator`               varchar(64)              DEFAULT '' COMMENT '创建者',
    `create_time`           datetime        NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updater`               varchar(64)              DEFAULT '' COMMENT '更新者',
    `update_time`           datetime        NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    `deleted`               bit(1)          NOT NULL DEFAULT b'0' COMMENT '是否删除',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB COMMENT ='交易订单明细表';
